/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.basicforms;

import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.PrintHTMLTextPane;
import com.appframework.components.htmleditor.RTFDocument;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.basicforms.GWItemFormController;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.preview.RtfPreview;
import com.novell.gw.jclient.application.printing.printingitem.ItemChecksPanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageBody;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.View;
import org.apache.log4j.Logger;

public class GWItemForm
extends PrintForm
implements MVCView {
    private static Logger logger = Logger.getLogger(ApplicationFrame.class);
    private GWItemFormController controller;
    protected ItemChecksPanel itemChecksPanel;
    private HTMLTextPane textPane;
    private RtfPreview rtfPreview;
    private AbstractItem<IMessage> item;
    protected String itemType = "";
    public static int DONT_PRINT_ATTACHMENT_LIST = 0;
    public static int PRINT_ATTACHMENT_LIST = 1;
    protected int printAttachmentList;
    private static int LEFT_TEXT_INSET = 80;

    public GWItemForm(AbstractItem theItem, MVCController theParentController) {
        this(theItem, DONT_PRINT_ATTACHMENT_LIST, theParentController);
    }

    public GWItemForm(AbstractItem theItem, int printAttachmentList, MVCController theParentController) {
        this.controller = new GWItemFormController(this, theParentController);
        this.item = theItem;
        this.printAttachmentList = printAttachmentList;
    }

    public void onPrintBegin() {
        MessageBody message;
        this.textPane = new PrintHTMLTextPane();
        this.textPane.setEditable(false);
        this.textPane.setIgnoreDefaultFontAttributes(true);
        this.textPane.setMode(2);
        if (this.item != null && (message = this.item.getMessage()) != null) {
            if (this.printAttachmentList == PRINT_ATTACHMENT_LIST) {
                this.prepareAttachmentsList(message);
            } else if (message.isRtfMessage()) {
                this.textPane.setStyledText(message.getRtfText());
            } else {
                this.textPane.setText(message.getMessage());
            }
        }
    }

    private void prepareAttachmentsList(MessageBody theMessage) {
        String attach = "\n\n" + StringResources.ATTACHMENTS_C + '\n';
        StringBuilder stringBuilder = new StringBuilder();
        for (GWAttachment attachment : this.item.getAttachments()) {
            stringBuilder.append(attachment);
            stringBuilder.append("\n");
        }
        if (theMessage.isRtfMessage()) {
            this.textPane.setStyledText(theMessage.getRtfText());
            try {
                AttributeSet a = ((RTFDocument)this.textPane.getDocument()).getCharacterElement(0).getAttributes();
                this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), attach + stringBuilder, a);
            }
            catch (BadLocationException e) {
                logger.error((Object)StringResources.ERROR_COULD_NOT_INSERT_ATTACHMENTS_LIST, (Throwable)e);
            }
        } else {
            this.textPane.setText(theMessage.getMessage() + attach + stringBuilder);
        }
    }

    public void setMessage(String theMessage) {
        this.textPane.setText(theMessage);
    }

    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int headerH;
        pg.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        this.pageWidth = (int)pageFormat.getImageableWidth();
        this.pageHeight = (int)pageFormat.getImageableHeight();
        pg.setColor(Color.black);
        pg.setClip(0, 0, this.pageWidth, this.pageHeight);
        if (ApplicationOptions.getInstance().getBoolean("PRINT_HEADER", true)) {
            this.commonHeaderH = this.printCommonHeader(pg, pageIndex, this.pageWidth);
            pg.translate(0, this.commonHeaderH);
        }
        if (pageIndex == 0) {
            headerH = this.printHeader(pg);
            pg.translate(0, headerH);
        } else {
            headerH = 0;
        }
        if (this.rtfPreview == null) {
            TextUI btui = this.textPane.getUI();
            View root = btui.getRootView(this.textPane);
            this.rtfPreview = new RtfPreview(this.textPane.getDocument().getDefaultRootElement(), root, this.pageWidth, this.pageHeight - headerH - this.commonHeaderH);
        }
        boolean bContinue = this.rtfPreview.paintPage(pg, this.pageHeight - headerH - this.commonHeaderH, pageIndex);
        System.gc();
        if (bContinue) {
            return 0;
        }
        this.rtfPreview = null;
        return 1;
    }

    protected int printHeader(Graphics graphics) {
        int y = graphics.getFontMetrics().getAscent();
        Font bold = FNT_SUB_HEADER;
        Font plain = FNT_PLAIN;
        if (this.itemChecksPanel.isFromSelected()) {
            graphics.setFont(FNT_SUB_HEADER);
            this.paintHeaderRow(graphics, StringResources.FROM_C, this.item.getSender().getRecipient().getAddressable().getDisplayName(), y, bold, plain);
            y += graphics.getFontMetrics().getHeight();
        }
        if (this.itemChecksPanel.isToSelected()) {
            String cc;
            int x;
            graphics.setFont(FNT_SUB_HEADER);
            String to = this.item.getTo();
            if (to != null && to.length() > 0) {
                x = (int)graphics.getFontMetrics().getStringBounds(StringResources.TO_C, graphics).getWidth();
                graphics.drawString(StringResources.TO_C, this.getTitleX(x), y);
                LEFT_TEXT_INSET = x + 5;
                y = GWItemForm.drawStringIntoRect(graphics, to, y, this.pageWidth - LEFT_TEXT_INSET, this.getValueX(x));
                y += graphics.getFontMetrics().getHeight();
            }
            if ((cc = this.item.getCc()) != null && cc.length() > 0) {
                x = (int)graphics.getFontMetrics().getStringBounds(StringResources.CC_C, graphics).getWidth();
                graphics.drawString(StringResources.CC_C, this.getTitleX(x), y);
                LEFT_TEXT_INSET = x + 5;
                y = GWItemForm.drawStringIntoRect(graphics, cc, y, this.pageWidth - LEFT_TEXT_INSET, this.getValueX(x));
                y += graphics.getFontMetrics().getHeight();
            }
        }
        return y;
    }

    private int getValueX(int titleWidth) {
        int result = UIUtils.getComponentOrientation().isLeftToRight() ? titleWidth + 5 : this.pageWidth - titleWidth;
        return result;
    }

    protected int getTitleX(int x) {
        int top = UIUtils.getComponentOrientation().isLeftToRight() ? 0 : this.pageWidth - x;
        return top;
    }

    protected int printCommonHeader(Graphics pg, int pageIndex, int wPage) {
        pg.setFont(FNT_PLAIN);
        FontMetrics fm = pg.getFontMetrics();
        int x = 0;
        int y = 0;
        y += fm.getAscent();
        String userGuid = ControlsUtils.getUserGuid(this.controller);
        String userName = GWCommandManager.getInstance(userGuid).getUserFields().getUserName();
        if (this.item != null) {
            userName = userName + " - " + this.item.getSubject();
        }
        boolean printPageNumber = this.itemChecksPanel.isPageNumberSelected();
        String pageNumber = "";
        int pageNumberWidth = 0;
        if (printPageNumber) {
            pageNumber = StringResources.PAGE + ' ' + (pageIndex + 1);
            pageNumberWidth = SwingUtilities.computeStringWidth(fm, pageNumber);
        }
        String date = OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(GWCalendarUtils.getToday().getTime());
        int dateWidth = (int)pg.getFontMetrics().getStringBounds(date, pg).getWidth();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            int dateStart = this.pageWidth - dateWidth + x;
            int userNameWidth = this.pageWidth - dateWidth - 10 + x;
            if (printPageNumber) {
                pg.drawString(pageNumber, this.pageWidth - pageNumberWidth + x, y);
                dateStart = dateStart - pageNumberWidth - 10;
                userNameWidth = userNameWidth - pageNumberWidth - 10;
            }
            pg.drawString(date, dateStart, y);
            pg.drawString(UIUtils.cutStringToWidth(userName, fm, userNameWidth), x, y);
        } else {
            int datePos = x;
            int userNameMaxWdth = this.pageWidth - x - dateWidth - 10;
            if (printPageNumber) {
                pg.drawString(pageNumber, x, y);
                datePos = datePos + pageNumberWidth + 10;
                userNameMaxWdth = userNameMaxWdth - pageNumberWidth - 10;
            }
            pg.drawString(date, datePos, y);
            String cut = UIUtils.cutStringToWidth(userName, fm, userNameMaxWdth);
            int cutPos = this.pageWidth - SwingUtilities.computeStringWidth(fm, cut);
            pg.drawString(cut, cutPos, y);
        }
        pg.drawLine(0, y + 5, wPage, y + 5);
        return y += fm.getHeight() + 5;
    }

    private static int drawStringIntoRect(Graphics g, String theString, int theUpperMargin, int theWidth, int theX) {
        int y = theUpperMargin;
        int x = theX;
        int charW = g.getFontMetrics().charWidth(' ');
        StringTokenizer st = new StringTokenizer(theString);
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            int strW = g.getFontMetrics().stringWidth(str);
            if (!UIUtils.getComponentOrientation().isLeftToRight()) {
                if ((x -= strW + charW) < 0) {
                    x = theX - (strW + charW);
                    y += g.getFontMetrics().getHeight();
                }
            } else if (x + strW >= theWidth) {
                x = theX;
                y += g.getFontMetrics().getHeight();
            }
            g.drawString(str, x, y);
            if (!UIUtils.getComponentOrientation().isLeftToRight()) continue;
            x += strW + charW;
        }
        return y;
    }

    public ImageIcon getIcon() {
        if (this.printAttachmentList == PRINT_ATTACHMENT_LIST) {
            return ImageResources.PRINT_FRM_MAIL_ATTACH;
        }
        return ImageResources.PRINT_FRM_MAIL;
    }

    public void setController(MVCController theController) {
        this.controller = (GWItemFormController)theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof ItemChecksPanel) {
            this.itemChecksPanel = (ItemChecksPanel)theModel;
        }
    }

    public Object getMVCModel() {
        return null;
    }
}

