/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.preview;

import com.appframework.ActionList;
import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.PrintInformation;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarFormBox;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class PrintUtils {
    private static final int DEFAULT_RESOLUTION = 72;
    private static Logger logger = Logger.getLogger(PrintUtils.class);
    public static final float[] DEFAULT_PRINTING_ATTRIBUTES = new float[]{210.0f, 297.0f, 25.4f, 25.4f, 159.2f, 246.2f, 1.0f};
    public static final float[] DEFAULT_PRINTING_ATTRIBUTES_US = new float[]{215.9f, 279.4f, 25.4f, 25.4f, 165.1f, 228.6f, 1.0f};

    public static HashPrintRequestAttributeSet getAttributeFromArray(float[] data) {
        HashPrintRequestAttributeSet printingAttributes = new HashPrintRequestAttributeSet();
        double width = data[0];
        double height = data[1];
        double imageX = data[2];
        double imageY = data[3];
        double imageWidth = data[4];
        double imageHeight = data[5];
        if (width <= 0.0 || height <= 0.0 || imageWidth > width || imageHeight > height || imageX < 0.0 || imageY < 0.0 || imageX + imageWidth > width || imageY + imageHeight > height) {
            float[] defaultAttributes = "US".equalsIgnoreCase(EngineCommandManager.getLocale().getCountry()) ? DEFAULT_PRINTING_ATTRIBUTES_US : DEFAULT_PRINTING_ATTRIBUTES;
            width = defaultAttributes[0];
            height = defaultAttributes[1];
            imageX = defaultAttributes[2];
            imageY = defaultAttributes[3];
            imageWidth = defaultAttributes[4];
            imageHeight = defaultAttributes[5];
            logger.warn((Object)StringResources.INVALID_PRINTING_ATTRIBUTES);
        }
        OrientationRequested orientation = OrientationRequested.PORTRAIT;
        if ((int)data[6] == OrientationRequested.LANDSCAPE.getValue()) {
            orientation = OrientationRequested.LANDSCAPE;
        } else if ((int)data[6] == OrientationRequested.REVERSE_LANDSCAPE.getValue()) {
            orientation = OrientationRequested.REVERSE_LANDSCAPE;
        }
        printingAttributes.add(orientation);
        MediaSizeName mediaSizeName = MediaSize.findMedia((float)width, (float)height, 1000);
        if (mediaSizeName == null) {
            mediaSizeName = MediaSizeName.NA_LETTER;
        }
        printingAttributes.add(mediaSizeName);
        MediaPrintableArea mediaPrintableArea = new MediaPrintableArea((float)imageX, (float)imageY, (float)imageWidth, (float)imageHeight, 1000);
        printingAttributes.add(mediaPrintableArea);
        return printingAttributes;
    }

    public static PageFormat getPageFormatFromPrintAttributes(PrintRequestAttributeSet theAttr) {
        return PrintUtils.getPageFormatFromPrintAttributes(theAttr, 72);
    }

    public static PageFormat getScreenPageFormatFromPrintAttributes(PrintRequestAttributeSet theAttr) {
        return PrintUtils.getPageFormatFromPrintAttributes(theAttr, Toolkit.getDefaultToolkit().getScreenResolution());
    }

    private static PageFormat getPageFormatFromPrintAttributes(PrintRequestAttributeSet theAttr, int pixelsPerInch) {
        OrientationRequested orient;
        MediaPrintableArea mpa;
        PageFormat pf = new PageFormat();
        Paper paper = new Paper();
        Media msn = (Media)theAttr.get(Media.class);
        if (msn instanceof MediaSizeName) {
            MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)msn);
            if (ms != null) {
                paper.setSize((double)pixelsPerInch * (double)ms.getX(25400), (double)pixelsPerInch * (double)ms.getY(25400));
            } else {
                logger.debug((Object)("Invalid MediaSizeName detected: [" + msn + "]. Default media size will be used."));
            }
        }
        if ((mpa = (MediaPrintableArea)theAttr.get(MediaPrintableArea.class)) != null) {
            paper.setImageableArea((float)pixelsPerInch * mpa.getX(25400), (float)pixelsPerInch * mpa.getY(25400), (float)pixelsPerInch * mpa.getWidth(25400), (float)pixelsPerInch * mpa.getHeight(25400));
        }
        if ((orient = (OrientationRequested)theAttr.get(OrientationRequested.class)) != null) {
            if (orient == OrientationRequested.PORTRAIT) {
                pf.setOrientation(1);
            } else if (orient == OrientationRequested.LANDSCAPE) {
                pf.setOrientation(0);
            } else if (orient == OrientationRequested.REVERSE_LANDSCAPE) {
                pf.setOrientation(2);
            }
        }
        pf.setPaper(paper);
        return pf;
    }

    public static boolean canPrintingToFile(PrintRequestAttributeSet theAttr) {
        Attribute[] attr = theAttr.toArray();
        int n = attr.length;
        for (int i = 0; i < n; ++i) {
            File file;
            Destination destination;
            if (!(attr[i] instanceof Destination) || !(destination = (Destination)attr[i]).getURI().getScheme().equals("file") || (file = new File(destination.getURI().getPath())).getParentFile().canWrite()) continue;
            return false;
        }
        return true;
    }

    public static float[] getValuesFromPrintAttributes(HashPrintRequestAttributeSet theAttr) {
        float[] data = new float[7];
        Attribute[] attr = theAttr.toArray();
        int n = attr.length;
        for (int i = 0; i < n; ++i) {
            if (attr[i] instanceof MediaSizeName) {
                MediaSizeName msn = (MediaSizeName)attr[i];
                if (msn == null) continue;
                MediaSize ms = MediaSize.getMediaSizeForName(msn);
                data[0] = ms.getX(1000);
                data[1] = ms.getY(1000);
                continue;
            }
            if (attr[i] instanceof MediaPrintableArea) {
                MediaPrintableArea mpa = (MediaPrintableArea)attr[i];
                data[2] = mpa.getX(1000);
                data[3] = mpa.getY(1000);
                data[4] = mpa.getWidth(1000);
                data[5] = mpa.getHeight(1000);
                continue;
            }
            if (!(attr[i] instanceof OrientationRequested)) continue;
            OrientationRequested orient = (OrientationRequested)attr[i];
            data[6] = orient.getValue();
        }
        return data;
    }

    public static void print(PrintInformation thePrintInformation, ActionList theActionList) {
        try {
            Object printObject;
            PrintRequestAttributeSet printAttributes;
            PrintForm printForm = thePrintInformation.getPrintForm();
            if (printForm == null) {
                logger.debug((Object)"Print form is not set");
                return;
            }
            PrinterJob printJob = thePrintInformation.getPrinterJob();
            if (printJob == null) {
                logger.debug((Object)"Print job is not set. Creating default print job.");
                printJob = PrinterJob.getPrinterJob();
            }
            if ((printAttributes = thePrintInformation.getPrintAttributes()) == null) {
                printAttributes = OptionManager.getInstance().getPrintingOptions().getPrintAttributeSet();
            }
            if (!PrintUtils.canPrintingToFile(printAttributes)) {
                JOptionPane.showMessageDialog(theActionList.getOwnerComponent(), StringResources.YOU_HAVE_NO_RIGHT);
                return;
            }
            if (OS.isMacOS()) {
                if (printJob.printDialog()) {
                    printForm.onPrintBegin();
                    printJob.setPrintable(PrintUtils.getPrintable(printForm));
                    printJob.print();
                }
            } else {
                if (printJob.getPrintService() == null) {
                    throw new PrinterException(StringResources.PRINTER_IS_NOT_CONFIGURED);
                }
                printForm.onPrintBegin();
                printJob.setPrintable(PrintUtils.getPrintable(printForm));
                printJob.print(printAttributes);
            }
            if ((printObject = thePrintInformation.getPrintObject()) instanceof AbstractItem) {
                ((AbstractItem)printObject).markOpen();
            }
            theActionList.processCommand(new Command(295, printObject));
        }
        catch (PrinterException pe) {
            logger.debug((Object)"printer exception! ");
            JOptionPane.showMessageDialog(theActionList.getOwnerComponent(), StringResources.PROBLEM_WITH_PRINTERK__PRINTING_FAI);
        }
        catch (EngineException e1) {
            logger.error((Object)e1);
        }
    }

    private static Printable getPrintable(PrintForm form) {
        if (form instanceof CalendarForm) {
            return new CalendarFormBox((CalendarForm)form);
        }
        return form;
    }

    public static PrintService getDefaultPrintService() {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
        if (defaultPrintService == null && printServices != null && printServices.length > 0) {
            defaultPrintService = printServices[0];
        }
        return defaultPrintService;
    }

    public static boolean showPrintDialog(PrinterJob printerJob, PrintRequestAttributeSet attributeSet, boolean savePrintAttributeSet) {
        boolean printConfirmed = false;
        if (printerJob == null) {
            printerJob = PrinterJob.getPrinterJob();
        }
        if (printerJob.getPrintService() == null) {
            PrintService defaultPrintService = PrintUtils.getDefaultPrintService();
            try {
                if (defaultPrintService == null) {
                    throw new PrinterException(StringResources.PRINTER_IS_NOT_CONFIGURED);
                }
                printerJob.setPrintService(defaultPrintService);
            }
            catch (PrinterException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
                JOptionPane.showMessageDialog(null, StringResources.PROBLEM_WITH_PRINTERK__PRINTING_FAI);
                return false;
            }
        }
        if (attributeSet == null) {
            attributeSet = new HashPrintRequestAttributeSet(OptionManager.getInstance().getPrintingOptions().getPrintAttributeSet());
        }
        if ((printConfirmed = printerJob.printDialog(attributeSet)) && savePrintAttributeSet) {
            PrintingOptions printingOptions = OptionManager.getInstance().getPrintingOptions();
            printingOptions.setPrintAttributeSet(new HashPrintRequestAttributeSet(attributeSet));
            OptionManager.getInstance().setPrintingOptions(printingOptions);
        }
        return printConfirmed;
    }

    public static int getPrintCellHeight(Graphics canvas, Font font) {
        Stroke stroke;
        int printCellHeight = canvas.getFontMetrics(font).getHeight();
        if (canvas instanceof Graphics2D && (stroke = ((Graphics2D)canvas).getStroke()) instanceof BasicStroke) {
            printCellHeight = (int)((float)printCellHeight + ((BasicStroke)stroke).getLineWidth());
        }
        return printCellHeight;
    }
}

