/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingaddressbook.printforms;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.basicforms.AddressBookForm;
import com.novell.gw.jclient.application.printing.preview.PrintUtils;
import com.novell.gw.jclient.application.printing.printingaddressbook.ABItem;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleItems
extends AddressBookForm {
    private static Logger logger = Logger.getLogger(MultipleItems.class);
    protected boolean isPrintFirstTime = true;
    protected int entryPageIndex = -1;
    protected int firstEntryOnPage = 0;
    private int firstEntryOnPageCopy = 0;
    protected int lastEntryOnPage = -1;
    protected boolean isPrintingEntryFinished = true;
    protected boolean isPrintingEntryFinishedCopy = true;
    protected boolean isPrintingLastEntry = false;
    protected int entriesCount = 0;
    protected int firstItemOnPage = 0;
    private int firstItemOnPageCopy = 0;
    protected int lastItemOnPage = -1;
    private int lastItemOnPageCopy = -1;
    protected ArrayList alPrintingItems;
    protected int printingY = 0;
    protected int printingX = 50;
    private IContact contact;
    protected IItemList entries;
    private boolean isOneItemPerPage = false;

    public MultipleItems(List<IAddressable> selectedContacts, MVCController theParentController) {
        super(selectedContacts, theParentController);
    }

    public MultipleItems(List<IAddressable> selectedContacts, boolean isOneItemPerPage, MVCController theParentController) {
        super(selectedContacts, theParentController);
        this.isOneItemPerPage = isOneItemPerPage;
    }

    @Override
    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        super.print(pg, pageFormat, pageIndex);
        boolean bContinue = false;
        if (pageIndex > this.entryPageIndex && this.isPrintingEntryFinished) {
            this.firstEntryOnPage = this.lastEntryOnPage + 1;
            if (this.firstEntryOnPage >= this.entriesCount) {
                this.isPrintFirstTime = true;
                System.gc();
                return 1;
            }
        }
        this.refreshPrint(pageIndex);
        if (!this.isPrintingEntryFinished && this.firstEntryOnPage == this.entriesCount) {
            --this.firstEntryOnPage;
            this.isPrintingLastEntry = true;
        }
        int i = this.firstEntryOnPage;
        while (i < this.entriesCount) {
            if (this.isPrintingEntryFinished) {
                this.contact = (IContact)this.selectedContacts.get(i);
                this.lastEntryOnPage = i++;
                this.firstEntryOnPage = this.lastEntryOnPage + 1;
                this.isPrintingEntryFinished = false;
                this.lastItemOnPage = -1;
                this.firstItemOnPage = 0;
            }
            if (this.isPrintingLastEntry) {
                i = ++this.firstEntryOnPage;
            }
            if ((bContinue = this.printEntry(pg, this.contact)) && !this.isPrintingEntryFinished) {
                return 0;
            }
            if (!this.isOneItemPerPage || !this.isPrintingEntryFinished) continue;
            return 0;
        }
        this.isPrintingEntryFinished = true;
        return 0;
    }

    @Override
    public void onPrintBegin() {
        this.entriesCount = this.selectedContacts.size();
        this.alPrintingItems = this.addressBookChecksPanel.getCheckedItems();
        this.findMaxKeyLength();
        this.entryPageIndex = -1;
        this.firstEntryOnPage = -1;
        this.lastEntryOnPage = -1;
        this.firstItemOnPage = -1;
        this.lastItemOnPage = -1;
        this.isPrintingEntryFinished = true;
        this.isPrintingLastEntry = false;
        this.isPrintFirstTime = false;
    }

    protected void findMaxKeyLength() {
        this.printingX = 0;
        int width = 0;
        PageFormat pageFormat = PrintUtils.getPageFormatFromPrintAttributes(OptionManager.getInstance().getPrintingOptions().getPrintAttributeSet());
        BufferedImage bi = new BufferedImage((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), 2);
        Graphics g = bi.getGraphics();
        g.setFont(FNT_PLAIN);
        FontMetrics fm = g.getFontMetrics();
        int size = this.alPrintingItems.size();
        for (int i = 0; i < size; ++i) {
            ABItem di = (ABItem)this.alPrintingItems.get(i);
            if (di == null || this.printingX >= (width = (int)fm.getStringBounds(di.toString(), g).getWidth())) continue;
            this.printingX = width;
        }
        this.printingX += (int)fm.getStringBounds("ww", g).getWidth();
        bi = null;
    }

    protected void refreshPrint(int thePageIndex) {
        this.printingY = 0;
        if (thePageIndex > this.entryPageIndex) {
            this.entryPageIndex = thePageIndex;
            this.firstEntryOnPageCopy = this.firstEntryOnPage;
            this.isPrintingEntryFinishedCopy = this.isPrintingEntryFinished;
            if (this.isPrintingEntryFinished) {
                this.firstItemOnPage = 0;
                this.lastItemOnPage = -1;
            } else {
                this.firstItemOnPage = this.lastItemOnPage + 1;
            }
            this.firstItemOnPageCopy = this.firstItemOnPage;
            this.lastItemOnPageCopy = this.lastItemOnPage;
        } else {
            this.firstEntryOnPage = this.firstEntryOnPageCopy;
            this.isPrintingEntryFinished = this.isPrintingEntryFinishedCopy;
            this.firstItemOnPage = this.firstItemOnPageCopy;
            this.lastItemOnPage = this.lastItemOnPageCopy;
        }
    }

    protected boolean printEntry(Graphics pg, IContact theEntry) {
        pg.setFont(FNT_HEADER);
        FontMetrics fm = pg.getFontMetrics();
        int fontH = fm.getHeight();
        int yMax = this.pageHeight - this.commonHeaderH;
        if (this.isPrintingEntryFinished) {
            return false;
        }
        if (this.printingY + fontH * 3 > yMax) {
            this.printingY = 0;
            return true;
        }
        pg.setFont(FNT_PLAIN);
        int size = this.alPrintingItems.size();
        for (int k = this.firstItemOnPage; k < size; ++k) {
            if (this.printingY + fontH > yMax) {
                this.printingY = 0;
                break;
            }
            this.lastItemOnPage = k;
            ABItem key = (ABItem)this.alPrintingItems.get(k);
            int x = isLeftToRight ? 0 : this.pageWidth - this.printingX;
            this.drawAlignedString(pg, key.toString(), x, this.printingY, this.printingX);
            String value = theEntry.getStringValue(key.getAbConst());
            x = isLeftToRight ? this.printingX : 0;
            this.drawAlignedString(pg, value, x, this.printingY, this.pageWidth - this.printingX);
            this.printingY += fontH;
        }
        if (this.lastItemOnPage >= size - 1) {
            this.isPrintingEntryFinished = true;
        }
        this.printingY += 12;
        return true;
    }

    @Override
    public String toString() {
        if (this.isOneItemPerPage) {
            return StringResources.ONE_ITEM_PER_PAGE;
        }
        return StringResources.MULTIPLE_ITEMS_PER_PAGE;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.isOneItemPerPage) {
            return ImageResources.PRINT_FRM_ONE_ITEM;
        }
        return ImageResources.PRINT_FRM_MULTIPLE_ITEM;
    }
}

