/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.TitledPanel;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.printingcalendar.CalendarOptionsPanelController;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class CalendarOptionsPanel
extends OrientablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger(CalendarOptionsPanel.class);
    private static int DEFAULT_INSET = 3;
    private static Insets DEFAULT_INSETS = new Insets(DEFAULT_INSET, DEFAULT_INSET, DEFAULT_INSET, DEFAULT_INSET);
    private MVCController controller;
    private boolean changed = false;
    private ChangeDetectorListener changeDetectorListener = new ChangeDetectorListener(false);
    private OrientablePanel pnlHeader;
    private OrientablePanel pnlFooter;
    private OrientablePanel pnlItems;
    private OrientablePanel pnlOptions;
    private GWTextField tfHeader;
    private OrientableCheckBox cbName;
    private OrientableCheckBox cbPageNumber;
    private OrientableCheckBox cbDateAndTime;
    private OrientableRadioButton rbAllItems;
    private OrientableRadioButton rbSelectedFolderItems;
    private OrientableCheckBox cbExtraTextToNextPage;
    private OrientableCheckBox cbUseShading;
    private OrientableCheckBox cbPrintSeparatorLines;
    private OrientableCheckBox cbInsertBlankPage;
    private OrientableCheckBox cbUseCategoryColor;

    public CalendarOptionsPanel(MVCController parentController) {
        this.controller = new CalendarOptionsPanelController(this, parentController);
        this.buildUI();
    }

    private void buildUI() {
        this.buildHeaderPanel();
        this.buildFooterPanel();
        this.buildItemsPanel();
        this.buildOptionsPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = DEFAULT_INSETS;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.add((Component)this.pnlHeader, c);
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)this.pnlFooter, c);
        c.gridy = 2;
        this.add((Component)this.pnlItems, c);
        c.gridy = 1;
        c.gridx = 1;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.pnlOptions, c);
    }

    private void buildHeaderPanel() {
        this.tfHeader = new GWTextField();
        this.tfHeader.getDocument().addDocumentListener(this.changeDetectorListener);
        OrientableLabel lbHeader = new OrientableLabel(StringResources.HEADER_C);
        this.pnlHeader = new OrientablePanel();
        this.pnlHeader.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = DEFAULT_INSETS;
        c.gridx = 0;
        c.gridy = 0;
        this.pnlHeader.add((Component)lbHeader, c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.pnlHeader.add((Component)this.tfHeader, c);
    }

    private void buildFooterPanel() {
        this.cbName = new ChangeReportingCheckBox(StringResources.NAME);
        this.cbPageNumber = new ChangeReportingCheckBox(StringResources.PAGE_NUMBER);
        this.cbDateAndTime = new ChangeReportingCheckBox(StringResources.DATE_AND_TIME);
        this.pnlFooter = new TitledPanel(BorderFactory.createEtchedBorder(), StringResources.FOOTER);
        this.pnlFooter.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        this.pnlFooter.add((Component)this.cbName, c);
        c.gridy = 1;
        this.pnlFooter.add((Component)this.cbPageNumber, c);
        c.gridy = 2;
        this.pnlFooter.add((Component)this.cbDateAndTime, c);
    }

    private void buildItemsPanel() {
        this.rbAllItems = new OrientableRadioButton(StringResources.ALL);
        this.rbAllItems.addItemListener(this.changeDetectorListener);
        this.rbSelectedFolderItems = new OrientableRadioButton(StringResources.SELECTED_FOLDER);
        this.rbSelectedFolderItems.addItemListener(this.changeDetectorListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbAllItems);
        buttonGroup.add(this.rbSelectedFolderItems);
        this.rbAllItems.setSelected(true);
        this.pnlItems = new TitledPanel(BorderFactory.createEtchedBorder(), StringResources.PRINT_ITEMS);
        this.pnlItems.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        this.pnlItems.add((Component)this.rbAllItems, c);
        c.gridy = 1;
        c.weighty = 1.0;
        this.pnlItems.add((Component)this.rbSelectedFolderItems, c);
    }

    private void buildOptionsPanel() {
        this.cbExtraTextToNextPage = new ChangeReportingCheckBox(StringResources.OVERFLOW_EXTRA_TEXT_TO_FOLLOWING_PAGES);
        this.cbUseShading = new ChangeReportingCheckBox(StringResources.USE_SHADING);
        this.cbPrintSeparatorLines = new ChangeReportingCheckBox(StringResources.PRINT_SEPARATOR_LINES_BETWEEN_ITEMS);
        this.cbInsertBlankPage = new ChangeReportingCheckBox(StringResources.INSERT_BLANK_PAGE_AT_BEGINNING_OF_PRINT_JOB);
        this.cbUseCategoryColor = new ChangeReportingCheckBox(StringResources.USE_CATEGORY_COLOR);
        this.pnlOptions = new OrientablePanel();
        this.pnlOptions.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StringResources.OPTIONS));
        this.pnlOptions.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.pnlOptions.add((Component)this.cbExtraTextToNextPage, c);
        ++c.gridy;
        this.pnlOptions.add((Component)this.cbUseShading, c);
        ++c.gridy;
        this.pnlOptions.add((Component)this.cbPrintSeparatorLines, c);
        ++c.gridy;
        this.pnlOptions.add((Component)this.cbInsertBlankPage, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.pnlOptions.add((Component)this.cbUseCategoryColor, c);
    }

    public boolean isAllItemsPrint() {
        return this.rbAllItems.isSelected();
    }

    public boolean isSelectedFolderPrint() {
        return this.rbSelectedFolderItems.isSelected();
    }

    public MVCController getController() {
        return this.controller;
    }

    public Object getMVCModel() {
        return null;
    }

    public void setController(MVCController controller) {
        if (controller instanceof CalendarOptionsPanelController) {
            this.controller = controller;
        } else assert (false) : "illegal controller passed: " + controller;
    }

    public void setMVCModel(Object model) {
    }

    public boolean hasFooterPageNumber() {
        return this.cbPageNumber.isSelected();
    }

    public boolean hasFooterName() {
        return this.cbName.isSelected();
    }

    public boolean hasFooterDateAndTime() {
        return this.cbDateAndTime.isSelected();
    }

    public String getCalendarHeader() {
        return this.tfHeader.getText();
    }

    public void loadOptions() {
        logger.debug((Object)"loading options...");
        this.changeDetectorListener.setEnabled(false);
        PrintingOptions options = OptionManager.getInstance().getPrintingOptions();
        String headerText = options.getCalendarHeader();
        this.tfHeader.setText(headerText == null ? "" : headerText);
        this.cbName.setSelected(options.isCalendarFooterNamePrinted());
        this.cbDateAndTime.setSelected(options.isCalendarFooterDateAndTimePrinted());
        this.cbPageNumber.setSelected(options.isCalendarFooterPageNumberPrinted());
        this.rbSelectedFolderItems.setSelected(options.isSelectedFolderPrinted());
        this.cbExtraTextToNextPage.setSelected(options.isExtraTextPrintedOnNextPage());
        this.cbUseShading.setSelected(options.isShadingUsed());
        this.cbPrintSeparatorLines.setSelected(options.isSeparatorLinePrinted());
        this.cbInsertBlankPage.setSelected(options.isBlankPageInserted());
        this.cbUseCategoryColor.setSelected(options.isCategoryColorUsed());
        this.changeDetectorListener.setEnabled(true);
    }

    public void saveOptions() {
        if (!this.changed) {
            return;
        }
        PrintingOptions options = OptionManager.getInstance().getPrintingOptions();
        options.setCalendarHeader(this.getCalendarHeader());
        options.setCalendarFooterNamePrinted(this.cbName.isSelected());
        options.setCalendarFooterDateAndTimePrinted(this.cbDateAndTime.isSelected());
        options.setCalendarFooterPageNumberPrinted(this.cbPageNumber.isSelected());
        options.setSelectedFolderPrinted(this.rbSelectedFolderItems.isSelected());
        options.setExtraTextPrintedOnNextPage(this.cbExtraTextToNextPage.isSelected());
        options.setShadingUsed(this.cbUseShading.isSelected());
        options.setSeparatorLinePrinted(this.cbPrintSeparatorLines.isSelected());
        options.setBlankPageInserted(this.cbInsertBlankPage.isSelected());
        options.setCategoryColorUsed(this.cbUseCategoryColor.isSelected());
        OptionManager.getInstance().setPrintingOptions(options);
        this.changed = false;
    }

    public boolean isUseCategoryColor() {
        return this.cbUseCategoryColor.isSelected();
    }

    public boolean isUseShading() {
        return this.cbUseShading.isSelected();
    }

    public boolean isInsertBlankPage() {
        return this.cbInsertBlankPage.isSelected();
    }

    public boolean isUseExtraTextToNextPage() {
        return this.cbExtraTextToNextPage.isSelected();
    }

    private class ChangeReportingCheckBox
    extends OrientableCheckBox {
        public ChangeReportingCheckBox() {
            assert (CalendarOptionsPanel.this.changeDetectorListener != null) : "changeDetectorItemListener not initialized";
            this.addItemListener(CalendarOptionsPanel.this.changeDetectorListener);
        }

        public ChangeReportingCheckBox(Action a) {
            super(a);
            assert (CalendarOptionsPanel.this.changeDetectorListener != null) : "changeDetectorItemListener not initialized";
            this.addItemListener(CalendarOptionsPanel.this.changeDetectorListener);
        }

        public ChangeReportingCheckBox(String text) {
            super(text);
            assert (CalendarOptionsPanel.this.changeDetectorListener != null) : "changeDetectorItemListener not initialized";
            this.addItemListener(CalendarOptionsPanel.this.changeDetectorListener);
        }
    }

    private class ChangeDetectorListener
    implements ItemListener,
    ChangeListener,
    DocumentListener {
        private boolean enabled = false;

        public ChangeDetectorListener(boolean enabled) {
            this.enabled = enabled;
        }

        private void processChange() {
            if (this.enabled) {
                CalendarOptionsPanel.this.changed = true;
            }
        }

        public void stateChanged(ChangeEvent e) {
            this.processChange();
        }

        public void itemStateChanged(ItemEvent e) {
            this.processChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

