/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingCalendarPanel;
import com.novell.gw.jclient.application.printing.BasicPrintManager;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.printingcalendar.CalendarOptionsPanel;
import com.novell.gw.jclient.application.printing.printingcalendar.CalendarPrintManagerController;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.DayOrganizerForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.RollingMonthForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.WeekTrifold;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.WeekTwoPageForm;
import com.novell.gw.jclient.application.resources.StringResources;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class CalendarPrintManager
extends BasicPrintManager {
    private static Logger logger = Logger.getLogger(CalendarPrintManager.class);
    public static final int DAILY_PRINTING = 0;
    public static final int WEEKLY_PRINTING = 1;
    public static final int MONTHLY_PRINTING = 2;
    private PrintingCalendarPanel printingCalendarPanel;
    private CalendarOptionsPanel calendarOptionsPanel;
    private int printingType = 0;

    public CalendarPrintManager(MVCController theParentController) {
        this.setController(new CalendarPrintManagerController(this, theParentController));
        this.buildUI();
    }

    private void buildUI() {
        this.buildSelectionPanel();
        this.buildContentPanel();
        this.buildOptionsPanel();
        this.lstPrintingItems.addListSelectionListener(new ListPrintingItemsChanged());
        this.lstPrintingForms.addListSelectionListener(new LstPrintingFormsChanged());
    }

    protected void buildContentPanel() {
        this.printingCalendarPanel = new PrintingCalendarPanel(this.getController());
        this.add(StringResources.CONTENT, this.printingCalendarPanel);
    }

    private void buildOptionsPanel() {
        this.calendarOptionsPanel = new CalendarOptionsPanel(this.getController());
        this.calendarOptionsPanel.loadOptions();
        this.add(StringResources.OPTIONS, this.calendarOptionsPanel);
    }

    private void refreshCalendarSelector() {
        this.vPrintingItems = new Vector();
        this.vPrintingItems.add(StringResources.DAILY);
        this.vPrintingItems.add(StringResources.WEEKLY);
        this.vPrintingItems.add(StringResources.MONTHLY);
        this.lstPrintingItems.setListData(this.vPrintingItems);
        this.lstPrintingItems.setSelectedIndex(0);
        this.printingType = 0;
        this.lstPrintingForms.setListData(this.getPrintForms());
        this.lstPrintingForms.setSelectedIndex(0);
        this.pnlListSelection.validate();
        int x = this.lstPrintingForms.getSelectedIndex();
        if (x < 0) {
            x = 0;
        }
        this.selectedForm = (PrintForm)this.lstPrintingForms.getModel().getElementAt(x);
        this.lbPreview.setIcon(this.selectedForm.getIcon());
    }

    private Vector getPrintForms() {
        HashMap<Class, OrientablePanel> model = new HashMap<Class, OrientablePanel>();
        model.put(PrintingCalendarPanel.class, this.printingCalendarPanel);
        model.put(CalendarOptionsPanel.class, this.calendarOptionsPanel);
        Vector<CalendarForm> v = new Vector<CalendarForm>();
        if (this.printingType == 0) {
            DayOrganizerForm dayOrganizerForm = new DayOrganizerForm(this.getController());
            dayOrganizerForm.setMVCModel(model);
            v.add(dayOrganizerForm);
        } else if (this.printingType == 1) {
            WeekTwoPageForm weekTwoPage = new WeekTwoPageForm(this.getController());
            weekTwoPage.setMVCModel(model);
            v.add(weekTwoPage);
            WeekTrifold weekTrifold = new WeekTrifold(this.getController());
            weekTrifold.setMVCModel(model);
            v.add(weekTrifold);
        } else if (this.printingType == 2) {
            RollingMonthForm rollingMonthForm = new RollingMonthForm(this.getController());
            rollingMonthForm.setMVCModel(model);
            v.add(rollingMonthForm);
        }
        return v;
    }

    private int getSelectedPrintingType() {
        int x = this.lstPrintingItems.getSelectedIndex();
        if (x == 0) {
            return 0;
        }
        if (x == 1) {
            return 1;
        }
        if (x == 2) {
            return 2;
        }
        return -1;
    }

    public PrintForm getSelectedForm() {
        CalendarForm selectedForm = null;
        HashMap<Class, OrientablePanel> model = new HashMap<Class, OrientablePanel>();
        model.put(PrintingCalendarPanel.class, this.printingCalendarPanel);
        model.put(CalendarOptionsPanel.class, this.calendarOptionsPanel);
        this.printingType = this.getSelectedPrintingType();
        if (this.printingType == 0) {
            DayOrganizerForm dayOrganizerForm = new DayOrganizerForm(this.getController());
            dayOrganizerForm.setMVCModel(model);
            selectedForm = dayOrganizerForm;
        } else if (this.printingType == 1) {
            Object value = this.lstPrintingForms.getSelectedValue();
            if (value instanceof WeekTwoPageForm) {
                WeekTwoPageForm weekTwoPage = new WeekTwoPageForm(this.getController());
                weekTwoPage.setMVCModel(model);
                selectedForm = weekTwoPage;
            } else if (value instanceof WeekTrifold) {
                WeekTrifold weekTrifold = new WeekTrifold(this.getController());
                weekTrifold.setMVCModel(model);
                selectedForm = weekTrifold;
            }
        } else if (this.printingType == 2) {
            RollingMonthForm rollingMonthForm = new RollingMonthForm(this.getController());
            rollingMonthForm.setMVCModel(model);
            selectedForm = rollingMonthForm;
        }
        return selectedForm;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof Calendar) {
            Calendar gc = (Calendar)theModel;
            this.printingCalendarPanel.setMVCModel(gc);
            this.refreshCalendarSelector();
        }
    }

    public void saveOptions() {
        this.printingCalendarPanel.saveOptions();
        this.calendarOptionsPanel.saveOptions();
    }

    public PrintingCalendarPanel getPrintingCalendarPanel() {
        return this.printingCalendarPanel;
    }

    class LstPrintingFormsChanged
    implements ListSelectionListener {
        LstPrintingFormsChanged() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int x = CalendarPrintManager.this.lstPrintingForms.getSelectedIndex();
                if (x < 0) {
                    return;
                }
                CalendarPrintManager.this.selectedForm = (PrintForm)CalendarPrintManager.this.lstPrintingForms.getModel().getElementAt(x);
                CalendarPrintManager.this.lbPreview.setIcon(CalendarPrintManager.this.selectedForm.getIcon());
                Command com = new Command(290, CalendarPrintManager.this.selectedForm);
                CalendarPrintManager.this.getController().processCommand(com);
            }
        }
    }

    class ListPrintingItemsChanged
    implements ListSelectionListener {
        ListPrintingItemsChanged() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                CalendarPrintManager.this.printingType = CalendarPrintManager.this.getSelectedPrintingType();
                CalendarPrintManager.this.lstPrintingForms.setListData(CalendarPrintManager.this.getPrintForms());
                CalendarPrintManager.this.lstPrintingForms.setSelectedIndex(0);
                Command com = new Command(300, new Integer(CalendarPrintManager.this.printingType));
                CalendarPrintManager.this.controller.processCommand(com);
            }
        }
    }
}

