/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.RollingMonthForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.WeekAndDayForm;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.Calendar;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DayOrganizerForm
extends WeekAndDayForm {
    private static Logger logger = Logger.getLogger(RollingMonthForm.class);
    private int additionalPages = 0;
    private int y = 0;
    private int countOfAppointments = 0;

    public DayOrganizerForm(MVCController theParentController) {
        super(theParentController);
    }

    public String toString() {
        return StringResources.DAY_ORGANIZER;
    }

    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_DAY_ORGANIZER;
    }

    private void excludeWeekendDays(Calendar date, boolean include) {
        if (!include) {
            if (date.get(7) == 7) {
                date.add(5, 2);
            }
            if (date.get(7) == 1) {
                date.add(5, 1);
            }
        }
    }

    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        super.print(pg, pageFormat, pageIndex);
        if (this.calendarOptionsPanel.isInsertBlankPage() && pageIndex == 0) {
            return 0;
        }
        if (this.calendarOptionsPanel.isInsertBlankPage()) {
            --pageIndex;
        }
        if (pageIndex == 0) {
            this.additionalPages = 0;
        }
        if (pageIndex > this.getPrintingCalendarPanel().getDaysForPrinting() + this.additionalPages - 1) {
            this.currPrintDay = (Calendar)this.startingDay.clone();
            return 1;
        }
        boolean weekendDays = this.getPrintingCalendarPanel().hasWeekendDays();
        if (pageIndex == 0) {
            this.currPrintDay = (Calendar)this.startingDay.clone();
            this.excludeWeekendDays(this.currPrintDay, weekendDays);
            this.changeDateValues(this.currPrintDay);
        }
        this.y = this.printDateHeader(pg);
        int notesTasksHeight = (this.pageHeight - this.y - 50 - monthlyCalendarFontAttributes.calculateMonthlyCalendarHeight()) / 2;
        int notesTasksWidth = this.pageWidth / 2 - 10;
        CalendarForm.RTLOffset = 0;
        pg.setColor(BORDER_COLOR);
        pg.translate(CalendarForm.isLeftToRight ? 0 : this.pageWidth - notesTasksWidth - 2, this.y + 30);
        this.translateX += CalendarForm.isLeftToRight ? 0 : this.pageWidth - notesTasksWidth - 2;
        this.translateY += this.y + 30;
        int countOfTasks = 0;
        List<AbstractItem> remainedTasks = this.printTasks(pg, notesTasksHeight - this.footerHeight, notesTasksWidth, this.extraPagesExists, true);
        if (remainedTasks != null) {
            countOfTasks = remainedTasks.size();
        }
        pg.translate(0, notesTasksHeight + 30);
        this.translateY += notesTasksHeight + 30;
        int countOfNotes = 0;
        List<AbstractCalendarItem> remainedNotes = this.printNotes(pg, notesTasksHeight - this.footerHeight, notesTasksWidth, this.extraPagesExists);
        if (remainedNotes != null) {
            countOfNotes = remainedNotes.size();
        }
        pg.translate(CalendarForm.isLeftToRight ? notesTasksWidth - monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth() : 0, -(this.y + notesTasksHeight + 80));
        this.translateY += -(this.y + notesTasksHeight + 80);
        this.translateX += CalendarForm.isLeftToRight ? notesTasksWidth - monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth() : 0;
        this.printCurrMonthCalendar(pg);
        pg.drawRect(0, 0, 2, 2);
        pg.translate(CalendarForm.isLeftToRight ? monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth() + 18 : -notesTasksWidth - 18, 0);
        this.translateX += CalendarForm.isLeftToRight ? monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth() + 18 : -notesTasksWidth - 18;
        int countOfDayEvents = 0;
        List<AbstractCalendarItem> remainedDayEvents = this.printAllDayEvents(pg, this.y, notesTasksWidth, this.extraPagesExists);
        if (remainedDayEvents != null) {
            countOfDayEvents = remainedDayEvents.size();
        }
        pg.translate(0, this.y + 20);
        this.translateY += this.y + 20;
        if (!this.extraPagesExists || this.extraPagesExists && this.countOfAppointments > 0) {
            int appointmentLength = SwingUtilities.computeStringWidth(pg.getFontMetrics(), StringResources.APPOINTMENTS);
            pg.drawString(StringResources.APPOINTMENTS, notesTasksWidth / 2 - appointmentLength / 2, 0);
        }
        pg.translate(0, 10);
        this.translateY += 10;
        List<WeekAndDayForm.AppointmentWrapper> remainedAppWrapper = this.printAppointment(pg, notesTasksWidth, this.pageHeight - this.translateY, this.extraPagesExists);
        if (remainedAppWrapper != null) {
            this.countOfAppointments = remainedAppWrapper.size();
        }
        if (this.isReplaceExtraText()) {
            if (countOfNotes > 0 || countOfTasks > 0 || countOfDayEvents > 0 || this.countOfAppointments > 0) {
                this.extraPagesExists = true;
                ++this.additionalPages;
            } else {
                this.extraPagesExists = false;
                this.currPrintDay.add(5, 1);
                this.excludeWeekendDays(this.currPrintDay, weekendDays);
                this.changeDateValues(this.currPrintDay);
            }
        } else {
            this.currPrintDay.add(5, 1);
            this.excludeWeekendDays(this.currPrintDay, weekendDays);
            this.changeDateValues(this.currPrintDay);
        }
        return 0;
    }

    private int printDateHeader(Graphics pg) {
        int y = 5;
        pg.setFont(this.dateDayFont);
        pg.drawString(this.dateDay, this.getDateDayX(pg, this.dateDay), y);
        pg.setFont(this.dateDayOfWeekFont);
        pg.drawString(this.dateDayOfWeek, this.getDateDayX(pg, this.dateDayOfWeek), y += pg.getFontMetrics().getHeight() + 10);
        pg.setFont(this.dateMonthYearFont);
        pg.drawString(this.dateMonth, this.getDateDayX(pg, this.dateMonth), y += pg.getFontMetrics().getHeight());
        pg.drawString(this.dateYear, this.getDateDayX(pg, this.dateYear), y += pg.getFontMetrics().getHeight());
        return y += pg.getFontMetrics().getHeight();
    }

    private void printCurrMonthCalendar(Graphics pg) {
        String monthYear = this.dateMonth + " " + this.dateYear;
        this.drawMonth(pg, monthYear, 0, this.currLabelCells, this.currDayCells, this.getCurrentPrintDay());
    }

    private int getDateDayX(Graphics pg, String s) {
        return CalendarForm.isLeftToRight ? 0 : this.pageWidth - this.getDateDayWidth(pg, s);
    }

    private int getDateDayWidth(Graphics pg, String s) {
        return SwingUtilities.computeStringWidth(pg.getFontMetrics(), s);
    }

    protected void changeDateValues(Calendar day) {
        this.dateDay = String.valueOf(day.get(5));
        this.dateDayOfWeek = GWCalendarUtils.dayNames[day.get(7) - 1];
        this.dateMonth = GWCalendarUtils.monthNames[day.get(2)];
        this.dateYear = String.valueOf(day.get(1));
    }

    boolean pageExists(int pageIndex) {
        boolean pageExist = true;
        int pseudoPageIndex = pageIndex;
        if (this.calendarOptionsPanel.isInsertBlankPage()) {
            --pseudoPageIndex;
        }
        int addPages = this.additionalPages;
        if (pseudoPageIndex == 0) {
            addPages = 0;
        }
        if (pseudoPageIndex > this.getPrintingCalendarPanel().getDaysForPrinting() + addPages - 1) {
            if (addPages == 0) {
                this.additionalPages = addPages;
            }
            this.currPrintDay = (Calendar)this.startingDay.clone();
            pageExist = false;
        }
        return pageExist;
    }
}

