/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.utils.UIUtils;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DayCell;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.AbstarctItemBean;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.PageModel;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintCalendarUtils {
    private static final String HOUR_IN_AM_PM = "h";
    private static final String HOUR_IN_DAY = "H";
    private static final String AM_PM_Marker = "a";
    private static final float DEFAULT_STROKE_LINEWIDTH = 1.0f;
    private static Logger logger = Logger.getLogger(PrintCalendarUtils.class);
    private CalendarForm calendarForm;
    Dimension dayOfMonthDimension;
    private List<AbstarctItemBean> remainedBeans = new ArrayList<AbstarctItemBean>();
    private static final int VERTICAL_INSET = 3;
    private static final int HORIZONTAL_INSET = 3;
    private static final int DASH_LENGTH = 5;
    private final Font dayOfMonthFont = new Font(PrintForm.FNT_PLAIN.getFontName(), 0, 9);

    public void printDay(Graphics pg, PageModel pageModel, Calendar day, Rectangle rectangle, CalendarForm calendarForm, boolean printOnlyAppointment) {
        this.calendarForm = calendarForm;
        Dimension dimension = this.getDayOfMonthDimension(pg);
        logger.debug((Object)("dimension: " + dimension));
        int y = rectangle.y + dimension.height;
        int cellEndY = (int)((double)rectangle.y + rectangle.getHeight());
        int cellEndX = (int)((double)rectangle.x + rectangle.getWidth());
        int startX = CalendarForm.isLeftToRight ? rectangle.x : rectangle.x + rectangle.width - dimension.width;
        int endX = CalendarForm.isLeftToRight ? startX + dimension.width : startX + dimension.width;
        pg.drawLine(startX, y, endX, y);
        int x = CalendarForm.isLeftToRight ? endX : startX;
        pg.drawLine(x, rectangle.y, x, y);
        Font previousFont = pg.getFont();
        pg.setFont(this.dayOfMonthFont);
        String text = Integer.toString(day.get(5));
        int descent = pg.getFontMetrics().getDescent();
        int ascent = pg.getFontMetrics().getAscent();
        int stringWidth = pg.getFontMetrics().stringWidth(text);
        x = startX + (dimension.width - stringWidth) / 2;
        int textHeight = (int)pg.getFontMetrics().getStringBounds(text, pg).getHeight();
        logger.debug((Object)("y: " + y));
        logger.debug((Object)("descent: " + descent));
        logger.debug((Object)("ascent: " + ascent));
        logger.debug((Object)("textHeight: " + textHeight));
        int endY = y - (dimension.height - textHeight) / 2 - descent - 3;
        pg.drawString(text, x, endY);
        x = rectangle.x;
        pg.setFont(previousFont);
        y = this.printCellStrings(pageModel.getAllDayEvents(day), pg, x, y, cellEndX, cellEndY);
        y = this.printCellStrings(pageModel.getAppointments(day), pg, x, y, cellEndX, cellEndY);
        if (!printOnlyAppointment) {
            y = this.printCellStrings(pageModel.getTasks(day), pg, x, y, cellEndX, cellEndY);
            this.printCellStrings(pageModel.getNotes(day), pg, x, y, cellEndX, cellEndY);
        }
    }

    private Dimension getDayOfMonthDimension(Graphics pg) {
        if (this.dayOfMonthDimension != null) {
            return this.dayOfMonthDimension;
        }
        int maxWidth = 0;
        FontMetrics metrics = pg.getFontMetrics(this.dayOfMonthFont);
        int height = metrics.getAscent() + metrics.getDescent();
        for (int i = 1; i <= 31; ++i) {
            Rectangle2D rectangle = metrics.getStringBounds(Integer.toString(i), pg);
            maxWidth = Math.max(maxWidth, (int)rectangle.getWidth());
        }
        this.dayOfMonthDimension = new Dimension(maxWidth + 6, height + 6);
        return this.dayOfMonthDimension;
    }

    private int printCellStrings(List<AbstarctItemBean> list, Graphics pg, int x, int y, int cellEndX, int cellEndY) {
        this.remainedBeans.addAll(list);
        int cellY = y;
        if (cellY > 0) {
            for (AbstarctItemBean bean : list) {
                cellY = this.drawSubStrings(bean, pg, x, cellY, cellEndX, cellEndY);
                if (cellY > cellEndY) {
                    return cellEndY - cellY;
                }
                this.remainedBeans.remove(bean);
            }
        }
        return cellY;
    }

    private int drawSubStrings(AbstarctItemBean bean, Graphics pg, int x, int y, int cellEndX, int cellEndY) {
        int fontMetricsHeight = pg.getFontMetrics().getHeight();
        int descent = pg.getFontMetrics().getDescent();
        AbstractItem item = bean.getItem();
        String string = bean.getDescription();
        string = CalendarForm.isLeftToRight ? "   " + string : string + "   ";
        List<String> subStrings = UIUtils.breakStringIntoSubstrings(string, pg.getFontMetrics(), cellEndX - x);
        int dashLineWidth = 0;
        if (subStrings.size() > 0 && y + subStrings.size() * fontMetricsHeight <= cellEndY) {
            this.calendarForm.fillFramedRectangle(pg, bean.getItem().getCalendarDisplayColor(), new Rectangle(x, y, cellEndX - x, subStrings.size() * fontMetricsHeight));
            boolean firstLine = true;
            for (String subString : subStrings) {
                int endY = y + fontMetricsHeight;
                if (endY > cellEndY) {
                    logger.debug((Object)"end of cell reached > skippng the rest of items");
                    return endY;
                }
                this.calendarForm.setColorItem(pg, item);
                if (firstLine) {
                    int iconStartX = CalendarForm.isLeftToRight ? x + 1 : cellEndX - fontMetricsHeight - 1;
                    int iconStartY = y + 1;
                    logger.debug((Object)("iconStartX: " + iconStartX + ", iconStartY: " + iconStartY + ", fontMetricsHeight: " + fontMetricsHeight));
                    logger.debug((Object)("iconEndX: " + (iconStartX + fontMetricsHeight - 2) + ", iconEndY: " + (iconStartY + fontMetricsHeight - 2)));
                    this.calendarForm.printItemIcon(item, pg, iconStartX, iconStartY, iconStartX + fontMetricsHeight - 2, iconStartY + fontMetricsHeight - 2);
                    firstLine = false;
                }
                int startX = CalendarForm.isLeftToRight ? x + 3 : cellEndX - pg.getFontMetrics().stringWidth(subString);
                pg.drawString(subString, startX, endY -= descent);
                this.calendarForm.setOldColor(pg);
                y += fontMetricsHeight;
            }
        } else {
            return y + subStrings.size() * fontMetricsHeight;
        }
        dashLineWidth = this.drawHorizontalDashedLine(pg, 5, x, y, cellEndX);
        return y + dashLineWidth;
    }

    private int drawHorizontalDashedLine(Graphics pg, int dashLength, int startX, int y, int endX) {
        boolean draw = true;
        while (startX + dashLength <= endX) {
            if (draw) {
                pg.drawLine(startX, y, startX + dashLength, y);
            }
            draw = !draw;
            startX += dashLength;
        }
        return (int)PrintCalendarUtils.getBasicStrokeLineWidth(pg);
    }

    public void drawMonthCalendar(Graphics pg, PageFormat pageFormat, Calendar startingDay, CalendarForm calendarForm) {
        this.calendarForm = calendarForm;
        Calendar dateMonthYear = this.calendarForm.getCurrentPrintDay();
        this.calendarForm.changeDateValues(dateMonthYear);
        String monthYear = this.calendarForm.dateMonth + " " + this.calendarForm.dateYear;
        pg.setFont(CalendarForm.monthlyCalendarFontAttributes.getFont());
        int remX = (int)pg.getClipBounds().getWidth() - CalendarForm.monthlyCalendarFontAttributes.calculateMonthlyCalendarWidth();
        DayCell[] prevCalLabelCells = new DayCell[7];
        DayCell[] prevCalDayCells = new DayCell[42];
        this.calendarForm.drawMonth(pg, monthYear, CalendarForm.isLeftToRight ? 0 : remX, prevCalLabelCells, prevCalDayCells, dateMonthYear);
        dateMonthYear.add(2, 1);
        this.calendarForm.changeDateValues(dateMonthYear);
        monthYear = this.calendarForm.dateMonth + " " + this.calendarForm.dateYear;
        this.calendarForm.drawMonth(pg, monthYear, CalendarForm.isLeftToRight ? remX : 0, prevCalLabelCells, prevCalDayCells, dateMonthYear);
    }

    public PageModel getPageModel(int pageIndex, int numOfWeeks, CalendarForm calendarForm) {
        if (pageIndex >= numOfWeeks) {
            return null;
        }
        Calendar startingDay = CalendarForm.printingCalendarPanel.getStartingDay();
        logger.debug((Object)("start: " + DateFormat.getDateInstance(0).format(startingDay.getTime())));
        Calendar firstDay = (Calendar)startingDay.clone();
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        int firstDayOfWeek = (Integer)dataStoreSettings.getMonthCalendarFirstDay().getValue() + 1;
        firstDay.set(7, firstDayOfWeek);
        if (firstDay.getTimeInMillis() > startingDay.getTimeInMillis()) {
            firstDay.add(5, -7);
        }
        return new PageModel(firstDay, calendarForm);
    }

    public List<AbstarctItemBean> getRemainedBeans() {
        return this.remainedBeans;
    }

    public static String getCorrectTimeString(Calendar calendar) {
        String format = OptionManager.getInstance().getDateTimeOptions().getTimeFormat();
        return DateAndTimeFormattingUtils.formatDate(calendar.getTime(), format);
    }

    public static String getCorrectTimeStringWithoutMinutes(Calendar calendar) {
        String pattern;
        String timeString = PrintCalendarUtils.getCorrectTimeString(calendar);
        String string = pattern = DateAndTimeFormattingUtils.is24HourFormat() ? HOUR_IN_DAY : String.format("%s %s", HOUR_IN_AM_PM, AM_PM_Marker);
        if (DateAndTimeFormattingUtils.isFormatValid(pattern)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            timeString = simpleDateFormat.format(calendar.getTime());
        }
        return timeString;
    }

    public static float getBasicStrokeLineWidth(Graphics pg) {
        Graphics2D canvas;
        float linewidth = 1.0f;
        if (pg instanceof Graphics2D && (canvas = (Graphics2D)pg).getStroke() instanceof BasicStroke) {
            BasicStroke stroke = (BasicStroke)canvas.getStroke();
            linewidth = stroke.getLineWidth();
        }
        return linewidth;
    }
}

