/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.mvc.MVCController;
import com.appframework.utils.Day;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DayCell;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingCalendarPanel;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.PrintCalendarUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WeekAndDayForm
extends CalendarForm {
    private static Logger logger = Logger.getLogger(CalendarForm.class);
    protected String dateDay;
    protected String dateDayOfWeek;
    static final long THIRTY_MINUTES = 1800000L;
    static final int MINUTES_IN_HOUR = 60;
    static final int ALWAYS_AVAILABLE_START_HOUR = 0;
    static final int ALWAYS_AVAILABLE_END_HOUR = 23;
    static final int DEFAULT_START_HOUR = 8;
    static final int DEFAULT_START_MINUTE = 0;
    static final int DEFAULT_END_HOUR = 17;
    static final int DEFAULT_END_MINUTE = 0;
    protected static final int NOTE_TASK_HEIGHT = 16;
    protected static final int APPOINTMENT_HEIGHT = 32;
    protected final Font dateDayFont = new Font(FNT_PLAIN.getFontName(), 0, 22);
    protected final Font dateDayOfWeekFont = new Font(FNT_PLAIN.getFontName(), 0, 14);
    protected final Font dateMonthYearFont = new Font(FNT_PLAIN.getFontName(), 0, 12);
    protected int noteTaskSubheaderHeight;
    protected DayCell[] currDayCells = new DayCell[42];
    protected DayCell[] currLabelCells = new DayCell[7];
    protected int taskSubjectColumnStartX;
    protected int taskPriorityColumnStartX;
    protected int taskStartColumnStartX;
    protected int taskDueColumnStartX;
    protected int taskCompletedColumnStartX;
    protected int tasksAditionalColumnsStartX;
    protected int sectionSubjectWidth;
    protected int sectionPriorityWidth;
    protected int sectionStartDateWidth;
    protected int sectionDueDateWidth;
    protected int sectionCompletedWidth;
    protected int maxTimeStringWidth;
    protected String tasksTableDateFormat = "(00.00)";
    private List<AbstractCalendarItem> notes = new ArrayList<AbstractCalendarItem>();
    private List<AbstractItem> tasks = new ArrayList<AbstractItem>();
    private List<AbstractCalendarItem> appointments = new ArrayList<AbstractCalendarItem>();
    private List<AbstractCalendarItem> allDayEvents = new ArrayList<AbstractCalendarItem>();
    private List<AppointmentWrapper> remainedAppWrapper = null;
    protected boolean extraPagesExists = false;

    public WeekAndDayForm(MVCController theParentController) {
        super(theParentController);
    }

    @Override
    protected void changeDateValues(Calendar day) {
    }

    protected int getMaxTimeStringWidth() {
        return this.maxTimeStringWidth;
    }

    protected void setMaxTimeStringWidth(int newWidth) {
        this.maxTimeStringWidth = newWidth;
    }

    protected List<AbstractCalendarItem> printAllDayEvents(Graphics pg, int notesTasksHeight, int notesTasksWidth, boolean extraPagesExists) {
        if (extraPagesExists && this.allDayEvents != null && this.allDayEvents.size() == 0) {
            return null;
        }
        return this.printAllDayEvent(pg, notesTasksHeight, notesTasksWidth, extraPagesExists);
    }

    protected List<AbstractCalendarItem> printAllDayEvent(Graphics pg, int notesTasksHeight, int notesTasksWidth, boolean extraPagesExists) {
        ArrayList<AppointmentItem> remainedDayEvents = new ArrayList<AppointmentItem>();
        pg.setFont(this.dateMonthYearFont);
        int alldayEventLength = SwingUtilities.computeStringWidth(pg.getFontMetrics(), StringResources.ALL_DAY_EVENTS);
        pg.drawString(StringResources.ALL_DAY_EVENTS, notesTasksWidth / 2 - alldayEventLength / 2, 0);
        this.printNotesTable(pg, notesTasksHeight, notesTasksWidth, false);
        PrintingCalendarPanel optionPanel = CalendarForm.printingCalendarPanel;
        if (optionPanel.hasAllDayEvents()) {
            if (!extraPagesExists) {
                this.allDayEvents.clear();
                this.getItems();
                for (IItemList itemList : this.listOfItems) {
                    this.allDayEvents.addAll(GWCalendarUtils.getAllDayEvents(itemList, this.currPrintDay.getTime()));
                }
            }
            Iterator<AbstractCalendarItem> iterator = this.allDayEvents.iterator();
            int y = this.noteTaskSubheaderHeight;
            while (y + CalendarForm.chosenFontCellHeight <= notesTasksHeight) {
                if (iterator.hasNext()) {
                    AppointmentItem t = (AppointmentItem)iterator.next();
                    remainedDayEvents.add(t);
                    String text = t.getSubject();
                    if (t.getPlace().length() != 0) {
                        text = text + " (" + t.getPlace() + ")";
                    }
                    text = UIUtils.getShortCutText(text, notesTasksWidth);
                    int startX = CalendarForm.isLeftToRight ? 0 : notesTasksWidth - SwingUtilities.computeStringWidth(pg.getFontMetrics(CalendarForm.chosenFont), text);
                    this.printBoxedString(pg, text, CalendarForm.chosenFont, startX, y, notesTasksWidth, CalendarForm.chosenFontCellHeight, CategoryUtils.getPrimaryTextColor(t.getCategories()), t.getCalendarDisplayColor());
                }
                y += CalendarForm.chosenFontCellHeight;
            }
        }
        if (this.allDayEvents != null) {
            this.allDayEvents.removeAll(remainedDayEvents);
        }
        return this.allDayEvents;
    }

    protected List<AppointmentWrapper> printAppointment_my(Graphics pg, int notesTasksWidth, int notesTasksHeight, boolean isFirst, boolean extraPagesExists) {
        if (!extraPagesExists) {
            return this.printAppointment(pg, notesTasksWidth, notesTasksHeight, isFirst, false);
        }
        return null;
    }

    protected List<AppointmentWrapper> printAppointment(Graphics pg, int notesTasksWidth, int notesTasksHeight, boolean extraPagesExists) {
        if (!extraPagesExists) {
            return this.printAppointment(pg, notesTasksWidth, notesTasksHeight, true, false);
        }
        if (this.remainedAppWrapper != null && this.remainedAppWrapper.size() == 0) {
            return null;
        }
        return this.printAdditionalAppointments(pg, notesTasksWidth, notesTasksHeight, true, false);
    }

    protected void constractTimeFormatDepedencies(Graphics canvas) {
        Calendar calendar = this.getStartTime();
        String correctTimeString = String.format(" %s ", PrintCalendarUtils.getCorrectTimeStringWithoutMinutes(calendar));
        this.setMaxTimeStringWidth(SwingUtilities.computeStringWidth(canvas.getFontMetrics(), correctTimeString));
        int endHour = this.getEndHour();
        while (calendar.get(11) < endHour) {
            calendar.add(11, 1);
            correctTimeString = String.format(" %s ", PrintCalendarUtils.getCorrectTimeStringWithoutMinutes(calendar));
            this.setMaxTimeStringWidth(Math.max(this.getMaxTimeStringWidth(), SwingUtilities.computeStringWidth(canvas.getFontMetrics(), correctTimeString)));
        }
    }

    protected List<AppointmentWrapper> printAppointment(Graphics pg, int notesTasksWidth, int notesTasksHeight, boolean isFirst, boolean isWeek) {
        pg.setFont(this.dateMonthYearFont);
        int y = 0;
        pg.setColor(BORDER_COLOR);
        int startHour = this.getStartHour();
        int endHour = this.getEndHour();
        if (startHour == endHour && startHour == 0) {
            endHour = 23;
        }
        int appointmentHeight = 32;
        if (Math.abs(endHour - startHour + 1) > 0) {
            appointmentHeight = Math.round((float)notesTasksHeight / (float)(endHour - startHour + 1));
        }
        Calendar calendar = this.getStartTime();
        String time = String.format(" %s ", PrintCalendarUtils.getCorrectTimeStringWithoutMinutes(calendar));
        ArrayList<String> times = new ArrayList<String>();
        times.add(time);
        this.setMaxTimeStringWidth(Math.max(this.getMaxTimeStringWidth(), SwingUtilities.computeStringWidth(pg.getFontMetrics(), time)));
        while (calendar.get(11) < endHour) {
            calendar.add(11, 1);
            time = String.format(" %s ", PrintCalendarUtils.getCorrectTimeStringWithoutMinutes(calendar));
            times.add(time);
            this.setMaxTimeStringWidth(Math.max(this.getMaxTimeStringWidth(), SwingUtilities.computeStringWidth(pg.getFontMetrics(), time)));
        }
        int startX = CalendarForm.isLeftToRight ? 0 : notesTasksWidth - this.getMaxTimeStringWidth();
        Iterator timesIterator = times.iterator();
        while (y < notesTasksHeight && timesIterator.hasNext()) {
            pg.drawRect(1, y, notesTasksWidth, appointmentHeight);
            if (isFirst) {
                pg.drawString((String)timesIterator.next(), startX, y + appointmentHeight / 2);
            }
            y += appointmentHeight;
        }
        Graphics2D canvas = (Graphics2D)pg;
        Stroke strokeprev = canvas.getStroke();
        y = 0;
        calendar = this.getStartTime();
        y = this.drawTimeMarking(canvas, y, notesTasksWidth, appointmentHeight, isFirst);
        while (y < notesTasksHeight && calendar.get(11) < endHour) {
            y = this.drawTimeMarking(canvas, y, notesTasksWidth, appointmentHeight, isFirst);
            calendar.add(11, 1);
        }
        canvas.setStroke(strokeprev);
        if (isFirst) {
            startX = CalendarForm.isLeftToRight ? this.getMaxTimeStringWidth() : notesTasksWidth - this.getMaxTimeStringWidth();
            pg.drawLine(startX, 0, startX, y);
        }
        this.appointments.clear();
        this.getItems();
        for (IItemList itemList : this.listOfItems) {
            this.appointments.addAll(GWCalendarUtils.getAppointments(itemList, new Day(this.currPrintDay)));
        }
        int size = this.appointments.size();
        AppointmentWrapper[] appWrapper = new AppointmentWrapper[size];
        for (int i = 0; i < size; ++i) {
            AppointmentItem appointment = (AppointmentItem)this.appointments.get(i);
            appWrapper[i] = new AppointmentWrapper(appointment.getStartGregorianCalendar(), appointment.getEndGregorianCalendar(), appointment.getSubject(), appointment.getSenderID(), appointment.getPlace(), appointment.getMessage().getPlainText(), appointment.isPrivate(), CategoryUtils.getPrimaryTextColor(this.appointments.get(i).getCategories()), this.appointments.get(i).getCalendarDisplayColor(), appointment.getDate());
        }
        int cellWidth = isFirst ? notesTasksWidth - this.getMaxTimeStringWidth() : notesTasksWidth;
        AppointmentWrapperCont appWrapperContainer = new AppointmentWrapperCont(appWrapper, cellWidth, appointmentHeight);
        if (isFirst) {
            pg.translate((CalendarForm.isLeftToRight ? 1 : 0) * this.getMaxTimeStringWidth(), 0);
        }
        this.remainedAppWrapper = new ArrayList<AppointmentWrapper>();
        pg.setFont(CalendarForm.chosenFont);
        for (int j = 0; j < appWrapper.length; ++j) {
            if (this.printAppWrapperContItem(appWrapper[j], endHour, appWrapperContainer.getRectApp(j), appWrapperContainer.getSubject(j), pg)) continue;
            this.remainedAppWrapper.add(appWrapper[j]);
        }
        pg.setFont(this.dateMonthYearFont);
        if (isFirst) {
            pg.translate((CalendarForm.isLeftToRight ? -1 : 0) * this.getMaxTimeStringWidth(), 0);
        }
        return this.remainedAppWrapper;
    }

    private int drawTimeMarking(Graphics2D canvas, int y, int width, int height, boolean isFirst) {
        for (int j = 1; j < 4; ++j) {
            if (j == 2) {
                canvas.setStroke(HALF_HOUR_LINE);
            } else {
                canvas.setStroke(QUARTER_HOUR_LINE);
            }
            if (isFirst) {
                canvas.drawLine((CalendarForm.isLeftToRight ? 1 : 0) * this.getMaxTimeStringWidth(), y + j * height / 4, CalendarForm.isLeftToRight ? width : width - this.getMaxTimeStringWidth(), y + j * height / 4);
                continue;
            }
            canvas.drawLine(0, y + j * height / 4, width, y + j * height / 4);
        }
        return y + height;
    }

    @Override
    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.noteTaskSubheaderHeight = pg.getFontMetrics(this.dateMonthYearFont).getHeight();
        return super.print(pg, pageFormat, pageIndex);
    }

    protected List<AppointmentWrapper> printAdditionalAppointments(Graphics pg, int notesTasksWidth, int notesTasksHeight, boolean isFirst, boolean isWeek) {
        ArrayList<AppointmentWrapper> remaindedAppointments = new ArrayList<AppointmentWrapper>();
        int y = 0;
        pg.setColor(BORDER_COLOR);
        pg.drawRect(0, y, notesTasksWidth, notesTasksHeight);
        y = CalendarForm.chosenFontCellHeight;
        for (int j = 0; j < this.remainedAppWrapper.size(); ++j) {
            AppointmentWrapper appWrapper = this.remainedAppWrapper.get(j);
            remaindedAppointments.add(appWrapper);
            PrintingCalendarPanel optionPanel = CalendarForm.printingCalendarPanel;
            String string = "";
            if (optionPanel.hasAppointmentsStart() && optionPanel.hasAppointmentsEnd()) {
                string = string + "(" + PrintCalendarUtils.getCorrectTimeString(appWrapper.dateStart) + "-" + PrintCalendarUtils.getCorrectTimeString(appWrapper.dateEnd) + ") ";
            } else {
                if (optionPanel.hasAppointmentsEnd()) {
                    string = string + "(" + PrintCalendarUtils.getCorrectTimeString(appWrapper.dateEnd) + ") ";
                }
                if (optionPanel.hasAppointmentsStart()) {
                    string = string + "(" + PrintCalendarUtils.getCorrectTimeString(appWrapper.dateStart) + ") ";
                }
            }
            string = string + appWrapper.subject + "; ";
            if (optionPanel.hasAppointmentsMessage()) {
                string = string + appWrapper.message;
            }
            pg.setFont(CalendarForm.chosenFont);
            y = this.printStringLineByLine(pg, string, 0, y, notesTasksWidth, appWrapper.getAppointmentsColor(), appWrapper.getAppointmentsBackgroundColor());
            pg.setFont(this.dateMonthYearFont);
            if ((y += CalendarForm.chosenFontCellHeight) >= notesTasksHeight) break;
        }
        if (this.remainedAppWrapper != null) {
            this.remainedAppWrapper.removeAll(remaindedAppointments);
        }
        return this.remainedAppWrapper;
    }

    protected boolean printAppWrapperContItem(AppointmentWrapper appWrapper, Integer lastHour, Rectangle rectApp, String subject, Graphics pg) {
        if (appWrapper.dateStart.get(11) >= this.getStartHour() && appWrapper.dateEnd.get(11) <= lastHour) {
            PrintingCalendarPanel optionPanel = CalendarForm.printingCalendarPanel;
            if (pg.getFontMetrics().getHeight() < rectApp.height && optionPanel.hasAppointments() && (optionPanel.hasPrivateCalendarItems() || !appWrapper.isPrivate)) {
                String string = "";
                if (optionPanel.hasAppointmentsStart() && optionPanel.hasAppointmentsEnd()) {
                    string = string + "(" + PrintCalendarUtils.getCorrectTimeString(appWrapper.dateStart) + "-" + PrintCalendarUtils.getCorrectTimeString(appWrapper.dateEnd) + ") ";
                } else {
                    if (optionPanel.hasAppointmentsEnd()) {
                        string = string + "(" + PrintCalendarUtils.getCorrectTimeString(appWrapper.dateEnd) + ") ";
                    }
                    if (optionPanel.hasAppointmentsStart()) {
                        string = string + "(" + PrintCalendarUtils.getCorrectTimeString(appWrapper.dateStart) + ") ";
                    }
                }
                string = string + subject + " ";
                if (optionPanel.hasAppointmentsPlace()) {
                    string = string + StringResources.PLACE_C + appWrapper.place + " ";
                }
                if (optionPanel.hasAppointmentsFrom()) {
                    string = string + StringResources.FROM_C + appWrapper.senderID + " ";
                }
                if (optionPanel.hasAppointmentsMessage()) {
                    string = string + appWrapper.message;
                }
                this.printBoxedString(pg, string, CalendarForm.chosenFont, rectApp.x, rectApp.y, rectApp.width, rectApp.height, appWrapper.getAppointmentsColor(), appWrapper.getAppointmentsBackgroundColor());
            }
            return true;
        }
        return false;
    }

    protected List<AbstractCalendarItem> printNotes(Graphics pg, int notesTasksHeight, int notesTasksWidth, boolean extraPagesExists) {
        if (extraPagesExists && this.notes != null && this.notes.size() == 0) {
            return null;
        }
        return this.printNotes(pg, notesTasksHeight, notesTasksWidth, false, extraPagesExists);
    }

    protected List<AbstractCalendarItem> printNotes(Graphics pg, int notesTasksHeight, int notesTasksWidth, boolean isWeek, boolean extraPagesExists) {
        ArrayList<ReminderNote> remainedNotes = new ArrayList<ReminderNote>();
        pg.setFont(this.dateMonthYearFont);
        int notesLength = SwingUtilities.computeStringWidth(pg.getFontMetrics(), StringResources.NOTES);
        int x = notesTasksWidth / 2 - notesLength / 2;
        pg.drawString(StringResources.NOTES, x, 0);
        this.printNotesTable(pg, notesTasksHeight, notesTasksWidth, true);
        PrintingCalendarPanel optionPanel = CalendarForm.printingCalendarPanel;
        this.initialiseNotes(isWeek, extraPagesExists, optionPanel.hasNotes());
        if (optionPanel.hasNotes()) {
            Iterator<AbstractCalendarItem> it = this.notes.iterator();
            int y = this.noteTaskSubheaderHeight;
            while (y + CalendarForm.chosenFontCellHeight <= notesTasksHeight) {
                if (it.hasNext()) {
                    Calendar calendar;
                    ReminderNote t = (ReminderNote)it.next();
                    remainedNotes.add(t);
                    String string = "";
                    String message = "";
                    boolean secondLine = false;
                    if (CalendarForm.isLeftToRight) {
                        string = string + t.getSubject() + " ";
                        if (optionPanel.hasNotesFrom()) {
                            string = string + StringResources.FROM_C + " " + t.getSenderID() + " ";
                        }
                        if (optionPanel.hasNotesStart()) {
                            calendar = Calendar.getInstance();
                            calendar.setTime(t.getStartDate());
                            string = string + StringResources.START_C + " " + calendar.get(5) + "." + calendar.get(2) + "." + Integer.valueOf(calendar.get(1)).toString().substring(2) + " ";
                        }
                        if (optionPanel.hasNotesMessage() && t.getMessage().getMessage().length() != 0) {
                            message = message + UIUtils.getShortCutText(t.getMessage().getPlainText(), 50);
                            secondLine = true;
                        }
                    } else {
                        if (optionPanel.hasNotesMessage() && t.getMessage().getMessage().length() != 0) {
                            message = message + UIUtils.getShortCutText(t.getMessage().getPlainText(), 50);
                            secondLine = true;
                        }
                        if (optionPanel.hasNotesStart()) {
                            calendar = Calendar.getInstance();
                            calendar.setTime(t.getStartDate());
                            string = string + StringResources.START_C + " " + calendar.get(5) + "." + calendar.get(2) + "." + Integer.valueOf(calendar.get(1)).toString().substring(2) + " ";
                        }
                        if (optionPanel.hasNotesFrom()) {
                            string = string + StringResources.FROM_C + " " + t.getSenderID() + " ";
                        }
                        string = string + t.getSubject();
                    }
                    this.printBoxedString(pg, this.composeNoteSubject(string), CalendarForm.chosenFont, 0, y, notesTasksWidth, CalendarForm.chosenFontCellHeight, CategoryUtils.getPrimaryTextColor(t.getCategories()), t.getCalendarDisplayColor());
                    if (secondLine) {
                        this.printBoxedString(pg, message, CalendarForm.chosenFont, 0, y += CalendarForm.chosenFontCellHeight, notesTasksWidth, CalendarForm.chosenFontCellHeight, CategoryUtils.getPrimaryTextColor(t.getCategories()), t.getCalendarDisplayColor());
                    }
                }
                y += CalendarForm.chosenFontCellHeight;
            }
        }
        if (this.notes != null) {
            this.notes.removeAll(remainedNotes);
        }
        return this.notes;
    }

    private void initialiseNotes(boolean isWeek, boolean extraPagesExists, boolean hasNotes) {
        block5: {
            block6: {
                if (extraPagesExists) break block5;
                this.getItems();
                this.notes.clear();
                if (!isWeek) break block6;
                for (IItemList itemList : this.listOfItems) {
                    this.notes.addAll(GWCalendarUtils.getNotes(itemList, new Day(this.currPrintDay)));
                }
                if (!hasNotes) break block5;
                for (int i = 1; i < 7; ++i) {
                    for (IItemList itemList : this.listOfItems) {
                        Calendar temporaryCalendar = (Calendar)this.currPrintDay.clone();
                        temporaryCalendar.add(5, i);
                        this.notes.addAll(GWCalendarUtils.getNotes(itemList, new Day(temporaryCalendar)));
                    }
                }
                break block5;
            }
            if (hasNotes) {
                for (IItemList itemList : this.listOfItems) {
                    this.notes.addAll(GWCalendarUtils.getNotes(itemList, new Day(this.currPrintDay)));
                }
            }
        }
    }

    protected void printNotesTable(Graphics pg, int notesTasksHeight, int notesTasksWidth, boolean isAdditionalLine) {
        pg.translate(0, 10);
        this.printBoxedString(pg, StringResources.SUBJECT, this.dateMonthYearFont, 0, 0, notesTasksWidth, this.noteTaskSubheaderHeight, BORDER_COLOR, this.calendarOptionsPanel.isUseShading() ? FILL_COLOR : Color.WHITE);
        int y = this.noteTaskSubheaderHeight;
        while (y + CalendarForm.chosenFontCellHeight <= notesTasksHeight) {
            pg.drawRect(0, y, notesTasksWidth, CalendarForm.chosenFontCellHeight);
            y += CalendarForm.chosenFontCellHeight;
        }
        if (isAdditionalLine) {
            pg.drawRect(0, y, notesTasksWidth, CalendarForm.chosenFontCellHeight);
        }
    }

    protected List<AbstractItem> printTasks(Graphics pg, int notesTasksHeight, int notesTasksWidth, boolean extraPagesExists, boolean isAdditionalLine) {
        if (extraPagesExists && this.tasks != null && this.tasks.size() == 0) {
            return null;
        }
        return this.printTasks(pg, notesTasksHeight, notesTasksWidth, false, extraPagesExists, isAdditionalLine);
    }

    protected List<AbstractItem> printTasks(Graphics pg, int notesTasksHeight, int notesTasksWidth, boolean isWeek, boolean extraPagesExists, boolean isAdditionalLine) {
        ArrayList<AbstractItem> remaindedTasks = new ArrayList<AbstractItem>();
        PrintingCalendarPanel optionPanel = CalendarForm.printingCalendarPanel;
        pg.setFont(this.dateMonthYearFont);
        int tasksLength = SwingUtilities.computeStringWidth(pg.getFontMetrics(), StringResources.TASKS);
        pg.drawString(StringResources.TASKS, notesTasksWidth / 2 - tasksLength / 2, 0);
        this.printTasksTable(pg, notesTasksHeight, notesTasksWidth, isAdditionalLine);
        this.initialiseTasks(isWeek, extraPagesExists, optionPanel.hasTasks());
        if (optionPanel.hasTasks()) {
            Iterator<AbstractItem> it = this.tasks.iterator();
            int y = this.noteTaskSubheaderHeight;
            while (y + CalendarForm.chosenFontCellHeight <= notesTasksHeight) {
                boolean hasSecondLine = false;
                if (it.hasNext()) {
                    AbstractItem item = it.next();
                    remaindedTasks.add(item);
                    String secondLine = "";
                    if (optionPanel.hasTasks()) {
                        if (!optionPanel.hasPrivateCalendarItems() && item.isPrivate() || !optionPanel.hasCompletedTasks() && item.isStatusCompleted()) continue;
                        if (optionPanel.hasTasksFrom() && item.getSenderID().length() != 0) {
                            secondLine = secondLine + StringResources.FROM_C + item.getSenderID() + " ";
                            hasSecondLine = true;
                        }
                        if (optionPanel.hasTasksMessage() && item.getMessage().getMessage().length() != 0) {
                            secondLine = secondLine + UIUtils.getShortCutText(item.getMessage().getPlainText(), 50) + " ";
                            hasSecondLine = true;
                        }
                        if (optionPanel.hasTasksPriority() && this.sectionPriorityWidth > 0) {
                            String priority = "";
                            if (item.getPriority() == 4) {
                                priority = StringResources.HIGH;
                            }
                            if (item.getPriority() == 1) {
                                priority = StringResources.LOW;
                            }
                            if (item.getPriority() == 2) {
                                priority = StringResources.STANDARD_SHORT;
                            }
                            this.printBoxedString(pg, priority, CalendarForm.chosenFont, this.taskPriorityColumnStartX, y, this.sectionPriorityWidth, CalendarForm.chosenFontCellHeight, CategoryUtils.getPrimaryTextColor(item.getCategories()), item.getCalendarDisplayColor());
                        }
                        String subject = item.getSubject();
                        this.printBoxedString(pg, this.composeTaskSubject(subject), CalendarForm.chosenFont, this.taskSubjectColumnStartX, y, this.sectionSubjectWidth, CalendarForm.chosenFontCellHeight, CategoryUtils.getPrimaryTextColor(item.getCategories()), item.getCalendarDisplayColor());
                        Calendar calendar = Calendar.getInstance();
                        if (optionPanel.hasTasksStart() && this.sectionStartDateWidth > 0) {
                            calendar.setTime(item.getDate());
                            this.printDateCellString(calendar, pg, this.taskStartColumnStartX, y, this.sectionStartDateWidth, item);
                        }
                        if (optionPanel.hasTasksDue() && this.sectionDueDateWidth > 0) {
                            calendar.setTime(new Date(item.getDueDate()));
                            this.printDateCellString(calendar, pg, this.taskDueColumnStartX, y, this.sectionDueDateWidth, item);
                        }
                        if (optionPanel.hasTasksCompletionDate() && this.sectionCompletedWidth > 0) {
                            this.printBoxedString(pg, "", CalendarForm.chosenFont, this.taskCompletedColumnStartX, y, this.sectionCompletedWidth, CalendarForm.chosenFontCellHeight, CategoryUtils.getPrimaryTextColor(item.getCategories()), item.getCalendarDisplayColor());
                        }
                    }
                    if (hasSecondLine) {
                        this.printBoxedString(pg, secondLine, CalendarForm.chosenFont, 0, y += CalendarForm.chosenFontCellHeight, notesTasksWidth, CalendarForm.chosenFontCellHeight, CategoryUtils.getPrimaryTextColor(item.getCategories()), item.getCalendarDisplayColor());
                    }
                }
                y += CalendarForm.chosenFontCellHeight;
            }
        }
        if (this.tasks != null) {
            this.tasks.removeAll(remaindedTasks);
        }
        return this.tasks;
    }

    private void initialiseTasks(boolean isWeek, boolean extraPagesExists, boolean hasTasks) {
        block5: {
            block6: {
                if (extraPagesExists) break block5;
                this.getItems();
                this.tasks.clear();
                if (!isWeek) break block6;
                this.tasks = new ArrayList<AbstractItem>();
                for (IItemList itemList : this.listOfItems) {
                    this.tasks.addAll(GWCalendarUtils.getTasks(itemList, new Day(this.currPrintDay)));
                }
                if (!hasTasks) break block5;
                for (int i = 1; i < 7; ++i) {
                    for (IItemList itemList : this.listOfItems) {
                        Calendar temporaryCalendar = (Calendar)this.currPrintDay.clone();
                        temporaryCalendar.add(5, i);
                        this.tasks.addAll(GWCalendarUtils.getTasks(itemList, new Day(temporaryCalendar)));
                    }
                }
                break block5;
            }
            if (hasTasks) {
                this.tasks = new ArrayList<AbstractItem>();
                for (IItemList itemList : this.listOfItems) {
                    this.tasks.addAll(GWCalendarUtils.getTasks(itemList, new Day(this.currPrintDay)));
                }
            }
        }
    }

    private int getStartHour() {
        return this.getStartTime().get(11);
    }

    private int getEndHour() {
        return this.getEndTime().get(11);
    }

    private Calendar getStartTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, 8);
        calendar.set(12, 0);
        DataStoreSettings settings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        if (settings != null) {
            int timeInminutes = (Integer)settings.getCalendarWorkDayStartTime().getValue();
            calendar.set(11, timeInminutes / 60);
            calendar.set(12, timeInminutes % 60);
        }
        return calendar;
    }

    private Calendar getEndTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, 17);
        calendar.set(12, 0);
        DataStoreSettings settings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        if (settings != null) {
            int timeInminutes = (Integer)settings.getCalendarWorkDayEndTime().getValue();
            if (timeInminutes == 0) {
                timeInminutes = 1440;
            }
            calendar.set(11, timeInminutes / 60);
            calendar.set(12, timeInminutes % 60);
        }
        return calendar;
    }

    private void printDateCellString(Calendar calendar, Graphics pg, int startX, int y, int width, AbstractItem item) {
        String string = "";
        if (this.tasksTableDateFormat.equals("(00.00)")) {
            string = "(" + calendar.get(5) + "." + calendar.get(2) + ")";
        }
        if (this.tasksTableDateFormat.equals("(00.00.00)")) {
            string = "(" + calendar.get(5) + "." + calendar.get(2) + "." + Integer.valueOf(calendar.get(1)).toString().substring(2) + ")";
        }
        this.printBoxedString(pg, string, CalendarForm.chosenFont, startX, y, width, CalendarForm.chosenFontCellHeight, CategoryUtils.getPrimaryTextColor(item.getCategories()), item.getCalendarDisplayColor());
    }

    private int getAdditionalColumnCount() {
        int additionalColumnCount = CalendarForm.printingCalendarPanel.hasTasksPriority() ? 1 : 0;
        additionalColumnCount += CalendarForm.printingCalendarPanel.hasTasksStart() ? 1 : 0;
        additionalColumnCount += CalendarForm.printingCalendarPanel.hasTasksDue() ? 1 : 0;
        return additionalColumnCount += CalendarForm.printingCalendarPanel.hasTasksCompletionDate() ? 1 : 0;
    }

    private int getTasksTableColumnHeaderWidth(Graphics canvas, String caption, Font font, int sectionStart, int spaceLeft, int proposedWidth) {
        int headerWidth = SwingUtilities.computeStringWidth(canvas.getFontMetrics(font), String.format(" %s ", caption));
        if (spaceLeft < (headerWidth = Math.max(headerWidth, proposedWidth))) {
            headerWidth = spaceLeft;
        }
        return headerWidth;
    }

    private void printTasksTable(Graphics pg, int notesTasksHeight, int notesTasksWidth, boolean isAdditionalLine) {
        int HALF_WIDTH = notesTasksWidth / 2 + notesTasksWidth % 2;
        int ADDITIONAL_COLUMN_COUNT = this.getAdditionalColumnCount();
        int ADDITIONAL_COLUMN_WIDTH = ADDITIONAL_COLUMN_COUNT > 0 ? HALF_WIDTH / ADDITIONAL_COLUMN_COUNT : 0;
        PrintingCalendarPanel optionPanel = CalendarForm.printingCalendarPanel;
        pg.translate(0, 10);
        int x = 0;
        int y = this.noteTaskSubheaderHeight;
        while (y + CalendarForm.chosenFontCellHeight <= notesTasksHeight) {
            pg.drawRect(x, y, notesTasksWidth, CalendarForm.chosenFontCellHeight);
            y += CalendarForm.chosenFontCellHeight;
        }
        if (isAdditionalLine) {
            pg.drawRect(x, y, notesTasksWidth, CalendarForm.chosenFontCellHeight);
        }
        int sectionStart = ADDITIONAL_COLUMN_COUNT > 0 ? notesTasksWidth / 2 : 0;
        int spaceLeft = ADDITIONAL_COLUMN_COUNT > 0 ? HALF_WIDTH : 0;
        int n = this.sectionSubjectWidth = ADDITIONAL_COLUMN_COUNT > 0 ? HALF_WIDTH : notesTasksWidth;
        this.taskSubjectColumnStartX = CalendarForm.isLeftToRight ? 0 : notesTasksWidth - (ADDITIONAL_COLUMN_COUNT > 0 ? notesTasksWidth / 2 : 0);
        this.printBoxedString(pg, StringResources.SUBJECT, this.dateMonthYearFont, this.taskSubjectColumnStartX, 0, this.sectionSubjectWidth, this.noteTaskSubheaderHeight, BORDER_COLOR, this.calendarOptionsPanel.isUseShading() ? FILL_COLOR : Color.WHITE);
        int n2 = CalendarForm.isLeftToRight ? sectionStart : (this.tasksAditionalColumnsStartX = ADDITIONAL_COLUMN_COUNT > 0 ? notesTasksWidth / 2 : 0);
        if (optionPanel.hasTasksPriority() && spaceLeft > 0) {
            this.sectionPriorityWidth = this.getTasksTableColumnHeaderWidth(pg, StringResources.PRIOR, this.dateMonthYearFont, sectionStart, spaceLeft, ADDITIONAL_COLUMN_WIDTH);
            this.taskPriorityColumnStartX = CalendarForm.isLeftToRight ? sectionStart : notesTasksWidth - sectionStart - this.sectionPriorityWidth;
            this.printBoxedString(pg, StringResources.PRIOR, this.dateMonthYearFont, this.taskPriorityColumnStartX, 0, this.sectionPriorityWidth, this.noteTaskSubheaderHeight, BORDER_COLOR, this.calendarOptionsPanel.isUseShading() ? FILL_COLOR : Color.WHITE);
            spaceLeft -= this.sectionPriorityWidth;
            sectionStart += this.sectionPriorityWidth;
        }
        int dateFormatWidth = SwingUtilities.computeStringWidth(pg.getFontMetrics(CalendarForm.chosenFont), this.tasksTableDateFormat);
        if (optionPanel.hasTasksStart() && spaceLeft > 0) {
            this.sectionStartDateWidth = this.getTasksTableColumnHeaderWidth(pg, StringResources.START, this.dateMonthYearFont, sectionStart, spaceLeft, Math.max(dateFormatWidth, ADDITIONAL_COLUMN_WIDTH));
            this.taskStartColumnStartX = CalendarForm.isLeftToRight ? sectionStart : notesTasksWidth - sectionStart - this.sectionStartDateWidth;
            this.printBoxedString(pg, StringResources.START, this.dateMonthYearFont, this.taskStartColumnStartX, 0, this.sectionStartDateWidth, this.noteTaskSubheaderHeight, BORDER_COLOR, this.calendarOptionsPanel.isUseShading() ? FILL_COLOR : Color.WHITE);
            spaceLeft -= this.sectionStartDateWidth;
            sectionStart += this.sectionStartDateWidth;
        }
        if (optionPanel.hasTasksDue() && spaceLeft > 0) {
            this.sectionDueDateWidth = this.getTasksTableColumnHeaderWidth(pg, StringResources.DUE, this.dateMonthYearFont, sectionStart, spaceLeft, Math.max(dateFormatWidth, ADDITIONAL_COLUMN_WIDTH));
            this.taskDueColumnStartX = CalendarForm.isLeftToRight ? sectionStart : notesTasksWidth - sectionStart - this.sectionDueDateWidth;
            this.printBoxedString(pg, StringResources.DUE, this.dateMonthYearFont, this.taskDueColumnStartX, 0, this.sectionDueDateWidth, this.noteTaskSubheaderHeight, BORDER_COLOR, this.calendarOptionsPanel.isUseShading() ? FILL_COLOR : Color.WHITE);
            spaceLeft -= this.sectionDueDateWidth;
            sectionStart += this.sectionDueDateWidth;
        }
        if (optionPanel.hasTasksCompletionDate() && spaceLeft > 0) {
            this.sectionCompletedWidth = this.getTasksTableColumnHeaderWidth(pg, StringResources.COMPLETE, this.dateMonthYearFont, sectionStart, spaceLeft, ADDITIONAL_COLUMN_WIDTH);
            this.taskCompletedColumnStartX = CalendarForm.isLeftToRight ? sectionStart : notesTasksWidth - sectionStart - this.sectionCompletedWidth;
            this.printBoxedString(pg, StringResources.COMPLETE, this.dateMonthYearFont, this.taskCompletedColumnStartX, 0, this.sectionCompletedWidth, this.noteTaskSubheaderHeight, BORDER_COLOR, this.calendarOptionsPanel.isUseShading() ? FILL_COLOR : Color.WHITE);
            spaceLeft -= this.sectionCompletedWidth;
            sectionStart += this.sectionCompletedWidth;
        }
    }

    protected List<AbstractCalendarItem> getNotesForCurrentDate() {
        return this.notes;
    }

    private class AppointmentWrapperCont {
        private AppointmentWrapper[] arrApp;
        private Rectangle[] arrRect;

        public AppointmentWrapperCont(AppointmentWrapper[] app, int cellWidth, int cellHeight) {
            Arrays.sort(app);
            this.arrApp = app;
            this.initPoint(cellWidth, cellHeight);
        }

        private int maxCross() {
            int max = 0;
            for (int i = 0; i < this.arrApp.length; ++i) {
                int cross = 0;
                for (int j = 0; j < this.arrApp.length; ++j) {
                    if (!this.arrApp[i].isCross(this.arrApp[j])) continue;
                    ++cross;
                }
                if (max >= cross) continue;
                max = cross;
            }
            return max;
        }

        private void initPoint(int cellWidth, int cellHeight) {
            if (this.arrApp.length > 0) {
                int maxCross = this.maxCross();
                int oneLenth = cellWidth / (maxCross + 1);
                this.arrRect = new Rectangle[this.arrApp.length];
                int h = this.arrApp[0].dateStart.get(11) - WeekAndDayForm.this.getStartHour();
                int min = this.arrApp[0].dateStart.get(12);
                int py = h * cellHeight + cellHeight * min / 60;
                long differ = this.arrApp[0].dateEnd.getTimeInMillis() - this.arrApp[0].dateStart.getTimeInMillis();
                if (differ < 1800000L) {
                    differ = 1800000L;
                }
                this.arrRect[0] = new Rectangle(1, py + 1, oneLenth - 2, (int)((long)cellHeight * differ / 1000L / 3600L) - 2);
                this.arrApp[0].col = 0;
                int colactiv = 0;
                for (int i = 1; i < this.arrApp.length; ++i) {
                    h = this.arrApp[i].dateStart.get(11) - WeekAndDayForm.this.getStartHour();
                    min = this.arrApp[i].dateStart.get(12);
                    py = h * cellHeight + cellHeight * min / 60;
                    for (int icol = 0; icol < maxCross + 1; ++icol) {
                        boolean canadd = true;
                        for (int j = 0; j < i; ++j) {
                            if (this.arrApp[j].col != icol || !this.arrApp[j].isCrossAll(this.arrApp[i]) && !this.arrApp[i].isCrossAll(this.arrApp[j])) continue;
                            canadd = false;
                        }
                        if (!canadd) continue;
                        colactiv = icol;
                        break;
                    }
                    int px = oneLenth * colactiv;
                    this.arrApp[i].col = colactiv;
                    differ = this.arrApp[i].dateEnd.getTimeInMillis() - this.arrApp[i].dateStart.getTimeInMillis();
                    if (differ < 1800000L) {
                        differ = 1800000L;
                    }
                    this.arrRect[i] = new Rectangle(px + 1, py + 1, oneLenth - 1, (int)((long)cellHeight * differ / 1000L / 3600L) - 2);
                }
                for (int i = 0; i < this.arrApp.length; ++i) {
                    boolean crossExist = false;
                    for (int j = 0; j < this.arrApp.length; ++j) {
                        if (i == j || !this.arrApp[i].isCross(this.arrApp[j]) && !this.arrApp[j].isCross(this.arrApp[i])) continue;
                        crossExist = true;
                    }
                    if (crossExist) continue;
                    this.arrRect[i].setSize(cellWidth, this.arrRect[i].height);
                }
            }
        }

        public Rectangle getRectApp(int index) {
            return this.arrRect[index];
        }

        public String getSubject(int index) {
            return this.arrApp[index].subject;
        }
    }

    class AppointmentWrapper
    implements Comparable {
        private Calendar dateStart;
        private Calendar dateEnd;
        private int col = -1;
        private String subject;
        private String message;
        private String senderID;
        private String place;
        private boolean isPrivate;
        private Color appointmentsColor;
        private Color appointmentsBackgroundColor;
        private Date date;

        public Calendar getDateStart() {
            return this.dateStart;
        }

        public Calendar getDateEnd() {
            return this.dateEnd;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getMessage() {
            return this.message;
        }

        public String getPlace() {
            return this.place;
        }

        public Date getDate() {
            return this.date;
        }

        public AppointmentWrapper(Calendar st, Calendar end, String subject, String senderID, String place, String message, boolean isPrivate, Color color, Color backgroundColor) {
            this.dateStart = st;
            this.dateEnd = end;
            this.subject = subject;
            this.senderID = senderID;
            this.place = place;
            this.message = message;
            this.isPrivate = isPrivate;
            this.appointmentsColor = color;
            this.appointmentsBackgroundColor = backgroundColor;
        }

        public AppointmentWrapper(Calendar st, Calendar end, String subject, String senderID, String place, String message, boolean isPrivate, Color color, Color backgroundColor, Date date) {
            this(st, end, subject, senderID, place, message, isPrivate, color, backgroundColor);
            this.date = date;
        }

        public int compareTo(Object o) {
            if (o instanceof AppointmentWrapper) {
                AppointmentWrapper app = (AppointmentWrapper)o;
                return this.dateStart.compareTo(app.dateStart);
            }
            return -1;
        }

        public Color getAppointmentsBackgroundColor() {
            return this.appointmentsBackgroundColor;
        }

        public Color getAppointmentsColor() {
            return this.appointmentsColor;
        }

        private boolean isCross(AppointmentWrapper app) {
            if (this == app) {
                return false;
            }
            if (this.dateEnd.compareTo(app.dateStart) > 0 && this.dateEnd.compareTo(app.dateEnd) < 0) {
                return true;
            }
            return this.dateEnd.compareTo(app.dateEnd) == 0;
        }

        private boolean isCrossAll(AppointmentWrapper app) {
            if (this.dateStart.compareTo(app.dateStart) > 0 && this.dateStart.compareTo(app.dateEnd) < 0) {
                return true;
            }
            return this.isCross(app);
        }
    }
}

