/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingCalendarPanel;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.PrintCalendarUtils;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.WeekAndDayForm;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeekTwoPageForm
extends WeekAndDayForm {
    private boolean extraAppointmentPagesExists = false;
    private boolean extraOtherPagesExists = false;
    private boolean isOtherDataPrinting = false;
    private boolean isAppointmentsPrinting = true;
    private boolean printNotes = true;
    private boolean printTasks = true;
    private boolean startToPrintNextPage = false;
    private int weeksForPrinting;
    private int additionalAppointmentsPages = 0;
    private int additionalOtherPages = 0;
    private int countOfTasks = 0;
    private int numberOfWeek = 1;
    private List<WeekAndDayForm.AppointmentWrapper> remainedAppointments;

    public WeekTwoPageForm(MVCController parentController) {
        super(parentController);
        this.changeDateValues(this.startingDay);
    }

    @Override
    public String toString() {
        return StringResources.TWO_PAGE_WEEK_CALENDAR_PORTRAIT;
    }

    @Override
    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_WEEK_TWO_PAGE;
    }

    @Override
    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.weeksForPrinting = this.getPrintingCalendarPanel().getDaysForPrinting();
        int h = super.print(pg, pageFormat, pageIndex);
        if (this.calendarOptionsPanel.isInsertBlankPage() && pageIndex == 0) {
            return 0;
        }
        if (this.calendarOptionsPanel.isInsertBlankPage()) {
            --pageIndex;
        }
        if (pageIndex > this.additionalAppointmentsPages + this.additionalOtherPages + 2 * this.weeksForPrinting - 1) {
            this.extraAppointmentPagesExists = false;
            this.extraOtherPagesExists = false;
            this.isAppointmentsPrinting = true;
            this.isOtherDataPrinting = false;
            this.printNotes = true;
            this.printTasks = true;
            this.additionalAppointmentsPages = 0;
            this.additionalOtherPages = 0;
            this.numberOfWeek = 1;
            return 1;
        }
        this.currPrintDay = this.getPrintingCalendarPanel().getStartingDay();
        this.currPrintDay.setTimeInMillis(this.currPrintDay.getTime().getTime() + WEEK_IN_MILLISECONDS * (long)(this.numberOfWeek - 1));
        int countOfAppointments = 0;
        if (this.isAppointmentsPrinting) {
            if (!this.extraAppointmentPagesExists) {
                this.remainedAppointments = this.printAppointments(pg, pageFormat, 0, h);
                if (this.remainedAppointments != null) {
                    countOfAppointments = this.remainedAppointments.size();
                }
            } else {
                this.printAdditionalAppointments(pg, pageFormat, h);
                if (this.remainedAppointments != null) {
                    countOfAppointments = this.remainedAppointments.size();
                }
            }
        }
        if (this.isOtherDataPrinting) {
            this.printOtherData(pg);
        }
        if (this.isReplaceExtraText()) {
            if (this.isOtherDataPrinting) {
                if (this.extraOtherPagesExists) {
                    ++this.additionalOtherPages;
                } else {
                    this.isOtherDataPrinting = false;
                }
            }
            if (this.isAppointmentsPrinting) {
                if (countOfAppointments > 0) {
                    ++this.additionalAppointmentsPages;
                    this.extraAppointmentPagesExists = true;
                } else {
                    this.extraAppointmentPagesExists = false;
                    this.isAppointmentsPrinting = false;
                    this.isOtherDataPrinting = true;
                }
            }
        } else {
            if (this.isOtherDataPrinting) {
                this.isOtherDataPrinting = false;
                this.extraOtherPagesExists = false;
                this.additionalOtherPages = 0;
                if (this.numberOfWeek < this.weeksForPrinting) {
                    this.startToPrintNextPage = true;
                }
            }
            if (this.isAppointmentsPrinting) {
                this.isAppointmentsPrinting = false;
                this.isOtherDataPrinting = true;
                this.extraAppointmentPagesExists = false;
                this.additionalAppointmentsPages = 0;
            }
        }
        if (this.startToPrintNextPage) {
            this.isAppointmentsPrinting = true;
            this.isOtherDataPrinting = false;
            this.startToPrintNextPage = false;
            this.printTasks = true;
            this.printNotes = true;
            if (this.numberOfWeek < this.weeksForPrinting) {
                ++this.numberOfWeek;
            }
        }
        return 0;
    }

    private List<WeekAndDayForm.AppointmentWrapper> printAppointments(Graphics pg, PageFormat pageFormat, int weekNumber, int h) {
        this.constractTimeFormatDepedencies(pg);
        int appointmentFirstWith = this.getMaxTimeStringWidth();
        ArrayList<WeekAndDayForm.AppointmentWrapper> remainedAppWrapper = new ArrayList<WeekAndDayForm.AppointmentWrapper>();
        PrintCalendarUtils util = new PrintCalendarUtils();
        util.drawMonthCalendar(pg, pageFormat, this.currPrintDay, this);
        int y = monthlyCalendarFontAttributes.calculateMonthlyCalendarHeight();
        int oneColumn = (this.pageWidth - appointmentFirstWith) / 7;
        pg.translate(0, y + h + 20);
        Calendar old = (Calendar)this.currPrintDay.clone();
        int heightFont = pg.getFontMetrics().getHeight();
        String month = GWCalendarUtils.monthNames[this.currPrintDay.get(2)];
        int monthWidth = SwingUtilities.computeStringWidth(pg.getFontMetrics(), month);
        pg.drawString(month, this.pageWidth / 2 - monthWidth / 2, -heightFont / 2);
        pg.translate(isLeftToRight ? 0 : this.pageWidth - oneColumn - appointmentFirstWith, 0);
        pg.translate(0, heightFont);
        int appHeight = this.pageHeight - (y + h + this.footerHeight + this.translateY);
        for (int i = 0; i < 7; ++i) {
            List<WeekAndDayForm.AppointmentWrapper> raw;
            if (i == 0) {
                this.printAppHeader(pg, oneColumn + appointmentFirstWith, true);
                raw = this.printAppointment(pg, oneColumn + appointmentFirstWith, appHeight, true, true);
                pg.translate((isLeftToRight ? 1 : -1) * oneColumn + (isLeftToRight ? 1 : 0) * appointmentFirstWith, 0);
            } else {
                this.printAppHeader(pg, oneColumn, false);
                raw = this.printAppointment(pg, oneColumn, appHeight, false, true);
                pg.translate((isLeftToRight ? 1 : -1) * oneColumn, 0);
            }
            if (raw != null && raw.size() != 0) {
                remainedAppWrapper.addAll(raw);
            }
            this.currPrintDay.setTimeInMillis(this.currPrintDay.getTime().getTime() + DAY_IN_MILLISECONS);
        }
        this.currPrintDay = old;
        return remainedAppWrapper;
    }

    private void printAdditionalAppointments(Graphics pg, PageFormat pageFormat, int h) {
        ArrayList<WeekAndDayForm.AppointmentWrapper> ra = new ArrayList<WeekAndDayForm.AppointmentWrapper>();
        PrintCalendarUtils util = new PrintCalendarUtils();
        util.drawMonthCalendar(pg, pageFormat, this.currPrintDay, this);
        int y = monthlyCalendarFontAttributes.calculateMonthlyCalendarHeight();
        int oneColumn = (int)((float)this.pageWidth / 7.0f);
        pg.translate(0, y + h + 20);
        int heightFont = pg.getFontMetrics().getHeight();
        String month = GWCalendarUtils.monthNames[this.currPrintDay.get(2)];
        int monthWidth = SwingUtilities.computeStringWidth(pg.getFontMetrics(), month);
        pg.drawString(month, this.pageWidth / 2 - monthWidth / 2, -heightFont / 2);
        pg.translate(0, heightFont);
        int appointmentsHeight = this.pageHeight / 2 + monthlyCalendarFontAttributes.calculateMonthlyCalendarHeight() + 50;
        int STROKE_LINE_WIDTH = (int)PrintCalendarUtils.getBasicStrokeLineWidth(pg);
        pg.drawRect(STROKE_LINE_WIDTH, -heightFont / 2, this.pageWidth - 2 * STROKE_LINE_WIDTH, appointmentsHeight);
        Date dateForPrinting = new Date();
        String strDateForPrinting = new SimpleDateFormat("dd MMMM").format(dateForPrinting);
        y = CalendarForm.chosenFontCellHeight;
        Font previousFont = pg.getFont();
        pg.setFont(CalendarForm.chosenFont);
        for (int j = 0; j < this.remainedAppointments.size(); ++j) {
            WeekAndDayForm.AppointmentWrapper appWrapper = this.remainedAppointments.get(j);
            ra.add(appWrapper);
            PrintingCalendarPanel optionPanel = CalendarForm.printingCalendarPanel;
            String date = new SimpleDateFormat("dd MMMM").format(appWrapper.getDate());
            if (!strDateForPrinting.equals(date)) {
                strDateForPrinting = date;
                pg.drawString(strDateForPrinting, 10, y);
                y += CalendarForm.chosenFontCellHeight;
            }
            String string = "";
            if (optionPanel.hasAppointmentsStart() && optionPanel.hasAppointmentsEnd()) {
                string = string + "(" + PrintCalendarUtils.getCorrectTimeString(appWrapper.getDateStart()) + "-" + PrintCalendarUtils.getCorrectTimeString(appWrapper.getDateEnd()) + ") ";
            } else {
                if (optionPanel.hasAppointmentsEnd()) {
                    string = string + "(" + PrintCalendarUtils.getCorrectTimeString(appWrapper.getDateEnd()) + ") ";
                }
                if (optionPanel.hasAppointmentsStart()) {
                    string = string + "(" + PrintCalendarUtils.getCorrectTimeString(appWrapper.getDateStart()) + ") ";
                }
            }
            String subject = appWrapper.getSubject();
            if (!"".equals(subject)) {
                string = string + " " + subject;
            }
            if (optionPanel.hasAppointmentsPlace()) {
                string = string + " (" + appWrapper.getPlace() + ") ";
            }
            y = this.printStringLineByLine(pg, string, 0, y, this.pageWidth, appWrapper.getAppointmentsColor(), appWrapper.getAppointmentsBackgroundColor());
            if (optionPanel.hasAppointmentsMessage()) {
                y = this.printStringLineByLine(pg, appWrapper.getMessage(), 0, y, this.pageWidth, appWrapper.getAppointmentsColor(), appWrapper.getAppointmentsBackgroundColor());
            }
            if ((y += CalendarForm.chosenFontCellHeight) >= appointmentsHeight) break;
        }
        pg.setFont(previousFont);
        if (this.remainedAppointments != null) {
            this.remainedAppointments.removeAll(ra);
        }
    }

    private void printOtherData(Graphics pg) {
        Calendar n = Calendar.getInstance();
        n.setTimeInMillis(((Calendar)this.currPrintDay.clone()).getTime().getTime() + WEEK_IN_MILLISECONDS);
        String dateRange = StringResources.formatString(StringResources.DATE_RANGE_FOR_PRINT, String.valueOf(this.currPrintDay.get(5)), GWCalendarUtils.monthNames[this.currPrintDay.get(2)], String.valueOf(n.get(5)), GWCalendarUtils.monthNames[n.get(2)]);
        pg.drawString(dateRange, this.pageWidth / 2 - SwingUtilities.computeStringWidth(pg.getFontMetrics(), dateRange) / 2, 0);
        pg.translate(0, 20);
        int taskHeight = (this.pageHeight - this.footerHeight - this.translateY) / 2;
        if (this.printTasks) {
            this.countOfTasks = this.printTasks(pg, taskHeight, this.pageWidth - 2, true, this.extraOtherPagesExists, false).size();
        }
        if (this.countOfTasks == 0) {
            this.printTasks = false;
        }
        pg.translate(0, taskHeight + 30);
        int countOfNotes = 0;
        if (this.printNotes) {
            countOfNotes = this.printNotes(pg, taskHeight - 30, this.pageWidth - 2, true, this.extraOtherPagesExists).size();
        }
        if (this.countOfTasks > 0 || countOfNotes > 0) {
            this.extraOtherPagesExists = true;
        }
        if (countOfNotes == 0) {
            this.printNotes = false;
        }
        if (this.countOfTasks == 0 && countOfNotes == 0) {
            this.extraOtherPagesExists = false;
            if (this.numberOfWeek < this.weeksForPrinting) {
                this.startToPrintNextPage = true;
            }
        }
    }

    private void printAppHeader(Graphics pg, int notesTasksWidth, boolean isFirst) {
        pg.setFont(this.dateMonthYearFont);
        int appointmentFirstWith = this.getMaxTimeStringWidth();
        int heightFont = pg.getFontMetrics().getHeight();
        String day = GWCalendarUtils.dayNames[this.currPrintDay.get(7) - 1];
        pg.drawRect(1, -heightFont - 2, notesTasksWidth, heightFont + 2);
        int dateWidth = SwingUtilities.computeStringWidth(pg.getFontMetrics(), "30") + 3;
        String date = String.valueOf(this.currPrintDay.get(5));
        if (isLeftToRight) {
            if (isFirst) {
                pg.drawLine(dateWidth + appointmentFirstWith, -heightFont - 2, dateWidth + appointmentFirstWith, 0);
                pg.drawLine(appointmentFirstWith, -heightFont - 2, appointmentFirstWith, 0);
                pg.drawString(date, 2 + appointmentFirstWith, -2);
            } else {
                pg.drawLine(dateWidth, -heightFont - 2, dateWidth, 0);
                pg.drawString(date, 2, -2);
            }
            day = UIUtils.breakStringIntoSubstrings(day, pg.getFontMetrics(), notesTasksWidth - 2 - (isFirst ? appointmentFirstWith : 0) - dateWidth).get(0);
            int length = SwingUtilities.computeStringWidth(pg.getFontMetrics(), day);
            pg.drawString(day, notesTasksWidth / 2 - length / 2 + (isFirst ? appointmentFirstWith / 2 : 0) + dateWidth / 2, -2);
        } else {
            if (isFirst) {
                pg.drawLine(notesTasksWidth - dateWidth - appointmentFirstWith, -heightFont - 2, notesTasksWidth - dateWidth - appointmentFirstWith, 0);
                int widthFirst = notesTasksWidth - appointmentFirstWith;
                pg.drawLine(widthFirst, -heightFont - 2, widthFirst, 0);
                pg.drawString(date, widthFirst - dateWidth + 2, -2);
            } else {
                pg.drawLine(notesTasksWidth - dateWidth, -heightFont - 2, notesTasksWidth - dateWidth, 0);
                pg.drawString(date, notesTasksWidth - dateWidth + 2, -2);
            }
            day = UIUtils.breakStringIntoSubstrings(day, pg.getFontMetrics(), notesTasksWidth - 2 - (isFirst ? appointmentFirstWith : 0) - dateWidth).get(0);
            int length = SwingUtilities.computeStringWidth(pg.getFontMetrics(), day);
            int x = notesTasksWidth / 2 - length / 2 - (isFirst ? appointmentFirstWith / 2 : 0) - dateWidth / 2;
            pg.drawString(day, x, -2);
        }
    }

    @Override
    protected void changeDateValues(Calendar day) {
        this.dateMonth = GWCalendarUtils.monthNames[day.get(2)];
        this.dateYear = String.valueOf(day.get(1));
    }

    @Override
    boolean pageExists(int pageIndex) {
        boolean pageExist = true;
        int pseudoPageIndex = pageIndex;
        int weeks = this.getPrintingCalendarPanel().getDaysForPrinting();
        if (this.calendarOptionsPanel.isInsertBlankPage()) {
            --pseudoPageIndex;
        }
        if (pseudoPageIndex > this.additionalAppointmentsPages + this.additionalOtherPages + 2 * weeks - 1) {
            this.extraAppointmentPagesExists = false;
            this.extraOtherPagesExists = false;
            this.isAppointmentsPrinting = true;
            this.isOtherDataPrinting = false;
            this.printNotes = true;
            this.printTasks = true;
            this.additionalAppointmentsPages = 0;
            this.additionalOtherPages = 0;
            this.numberOfWeek = 1;
            pageExist = false;
        }
        return pageExist;
    }
}

