/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingitem.printforms;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.basicforms.GWItemForm;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.MailItem;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class MailForm
extends GWItemForm {
    private MailItem item;

    public MailForm(MailItem theItem, int printAttachmentList, MVCController theParentController) {
        super(theItem, printAttachmentList, theParentController);
        this.item = theItem;
        this.itemType = StringResources.MAIL;
    }

    protected int printHeader(Graphics pg) {
        int y = super.printHeader(pg);
        Font bold = FNT_SUB_HEADER;
        Font plain = FNT_PLAIN;
        FontMetrics fm = pg.getFontMetrics();
        if (this.itemChecksPanel.isDateSelected()) {
            String date = this.item.getDate() == null ? "" : OptionManager.getInstance().getDateTimeOptions().getPropertiesString(this.item.getDate());
            this.paintHeaderRow(pg, StringResources.DATE_C, date, y, bold, plain);
            y += fm.getHeight();
        }
        if (this.itemChecksPanel.isSubjectSelected()) {
            this.paintHeaderRow(pg, StringResources.SUBJECT_C, this.item.getSubject(), y, bold, plain);
            y += fm.getHeight();
        }
        return y;
    }

    public String toString() {
        String s = StringResources.SIMPLE_MAIL_FORM;
        if (this.printAttachmentList == GWItemForm.PRINT_ATTACHMENT_LIST) {
            s = s + ' ' + StringResources.L_WITH_LIST_OF_ATTACHMENTS;
        }
        return s;
    }
}

