/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl;

import com.appframework.Application;
import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.CertificatesUtils;
import com.appframework.utils.MultilineOptionPane;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.engine.AccountPasswordInfo;
import com.novell.gw.engine.AuthInfo;
import com.novell.gw.engine.BackupToInfo;
import com.novell.gw.engine.ChangePasswordInfo;
import com.novell.gw.engine.DefaultFontInfo;
import com.novell.gw.engine.DeleteRetractInfo;
import com.novell.gw.engine.EngineCallback;
import com.novell.gw.engine.EngineInputStream;
import com.novell.gw.engine.JunkMailAddParams;
import com.novell.gw.engine.LoginParameters;
import com.novell.gw.engine.RestoreFromInfo;
import com.novell.gw.engine.SharedFolderNotificationInfo;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.AutodatePrompt;
import com.novell.gw.jclient.application.actions.item.RetractDialog;
import com.novell.gw.jclient.application.actions.item.RetractFromCalendarDialog;
import com.novell.gw.jclient.application.dialogs.CallBackRenameFolderDialog;
import com.novell.gw.jclient.application.dialogs.backup.BackupMailBoxDialog;
import com.novell.gw.jclient.application.dialogs.backup.BackupProgressDialog;
import com.novell.gw.jclient.application.dialogs.backup.RestorePathDialog;
import com.novell.gw.jclient.application.dialogs.certificate.AcceptCertificateDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.ShareFolderNotificationDialog;
import com.novell.gw.jclient.application.dialogs.junkmail.JunkMailAddDialog;
import com.novell.gw.jclient.application.dialogs.login.GWLoginDialogImproved2;
import com.novell.gw.jclient.application.dialogs.login.MailServerLoginDialog;
import com.novell.gw.jclient.application.dialogs.passworddialog.PasswordChangeDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.PasswordDialog;
import com.novell.gw.jclient.bl.eng_impl.SpecifyCachingDirectoryDialog;
import com.novell.gw.jclient.bl.eng_impl.StatusWindowFrame;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import com.novell.gw.jclient.bl.om.options.LoginOptions;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.TimeZone;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EngineCallBackListener
implements EngineCallback {
    private static Logger logger = Logger.getLogger(EngineCallBackListener.class);
    private volatile StatusWindowFrame modeSwitchFrame = new StatusWindowFrame();
    EngineMode currentSwitchingMode;
    int promtRetractMode = -1;
    private BackupProgressDialog progressDialog;

    public void setPromtRetractMode(int thePromtRetractMode) {
        this.promtRetractMode = thePromtRetractMode;
    }

    public int promptJunkMailAdd(final JunkMailAddParams params) {
        final int[] result = new int[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = EngineCallBackListener.doPromptJunkMailAdd(params);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.doPromptJunkMailAdd(params);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    private static int doPromptJunkMailAdd(JunkMailAddParams params) {
        JunkMailAddDialog dialog = new JunkMailAddDialog(null, params);
        dialog.showMe();
        boolean result = dialog.isActionCompleteSuccessfully();
        return result ? 1 : 2;
    }

    public DeleteRetractInfo promptRetract(final int itemType) {
        final DeleteRetractInfo[] result = new DeleteRetractInfo[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = this.doPromptRetract(itemType);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.this.doPromptRetract(itemType);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    private DeleteRetractInfo doPromptRetract(int itemType) {
        if (this.promtRetractMode > 0 && this.promtRetractMode < 4) {
            DeleteRetractInfo retractInfo = new DeleteRetractInfo(this.promtRetractMode, "");
            this.promtRetractMode = -1;
            return retractInfo;
        }
        RetractDialog.Result result = RetractDialog.showDialog(null);
        int resultID = result.getResultID();
        DeleteRetractInfo retractInfo = null;
        if (resultID == 2) {
            retractInfo = new DeleteRetractInfo(3, result.getComment());
        } else if (resultID == 1) {
            retractInfo = new DeleteRetractInfo(2, result.getComment());
        } else if (resultID == 0) {
            retractInfo = new DeleteRetractInfo(1, result.getComment());
        }
        return retractInfo;
    }

    public DeleteRetractInfo promptRetractFromCalendar(final String itemType, final String subject, final boolean bDeleteRecipients) {
        final DeleteRetractInfo[] result = new DeleteRetractInfo[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = EngineCallBackListener.doPromptRetractFromCalendar(itemType, subject, bDeleteRecipients);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.doPromptRetractFromCalendar(itemType, subject, bDeleteRecipients);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    private static DeleteRetractInfo doPromptRetractFromCalendar(String itemType, String subject, boolean bDeleteRecipients) {
        RetractFromCalendarDialog.Result result = RetractFromCalendarDialog.showDialog(null, itemType, subject, bDeleteRecipients);
        int resultID = result.getResultID();
        DeleteRetractInfo retractInfo = null;
        if (resultID == 1) {
            retractInfo = new DeleteRetractInfo(3, result.getComment());
        } else if (resultID == 0) {
            retractInfo = new DeleteRetractInfo(1, result.getComment());
        }
        return retractInfo;
    }

    public SharedFolderNotificationInfo promptSharedFolderNotification(final boolean isCalendar, final DistributionList newParticipants, final String newSubject, final String newMessage, final DistributionList modifiedParticipants, final String modifiedSubject, final String modifiedMessage, final DistributionList deletedParticipants, final String deletedSubject, final String deletedMessage) {
        final SharedFolderNotificationInfo[] result = new SharedFolderNotificationInfo[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = EngineCallBackListener.doPromptSharedFolderNotification(isCalendar, newParticipants, newSubject, newMessage, modifiedParticipants, modifiedSubject, modifiedMessage, deletedParticipants, deletedSubject, deletedMessage);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.doPromptSharedFolderNotification(isCalendar, newParticipants, newSubject, newMessage, modifiedParticipants, modifiedSubject, modifiedMessage, deletedParticipants, deletedSubject, deletedMessage);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    private static SharedFolderNotificationInfo doPromptSharedFolderNotification(boolean isCalendar, DistributionList newParticipants, String newSubject, String newMessage, DistributionList modifiedParticipants, String modifiedSubject, String modifiedMessage, DistributionList deletedParticipants, String deletedSubject, String deletedMessage) {
        SharedFolderNotificationInfo sharedFolderNotificationInfo = null;
        Window parent = Application.getParentForModalDialogs();
        ShareFolderNotificationDialog dialog = parent instanceof Frame ? new ShareFolderNotificationDialog((Frame)parent, isCalendar, newParticipants, modifiedParticipants, deletedParticipants) : new ShareFolderNotificationDialog((Dialog)parent, isCalendar, newParticipants, modifiedParticipants, deletedParticipants);
        dialog.setSubjectForNewParticipants(newSubject);
        dialog.setMessageForNewParticipants(newMessage);
        dialog.setSubjectForModifiedParticipants(modifiedSubject);
        dialog.setMessageForModifiedParticipants(modifiedMessage);
        dialog.setSubjectForDeletedParticipants(deletedSubject);
        dialog.setMessageForDeleteParticipants(deletedMessage);
        dialog.setVisible(true);
        if (dialog.isOkActionProcessed()) {
            sharedFolderNotificationInfo = dialog.getSharedFolderNotificationInfo();
        }
        return sharedFolderNotificationInfo;
    }

    public AuthInfo getPassword(final String msg, final boolean bShowCASASingleSignOnOption, final boolean bConfirmNewPwd) {
        final AuthInfo[] result = new AuthInfo[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = EngineCallBackListener.doGetPassword(msg, bShowCASASingleSignOnOption, bConfirmNewPwd);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.doGetPassword(msg, bShowCASASingleSignOnOption, bConfirmNewPwd);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    private static AuthInfo doGetPassword(String msg, boolean bShowCASASingleSignOnOption, boolean bConfirmNewPwd) {
        logger.debug((Object)("getPassword entered " + msg));
        AuthInfo result = PasswordDialog.getPassword(msg, bShowCASASingleSignOnOption, bConfirmNewPwd);
        logger.debug((Object)"getPassword exited");
        return result;
    }

    public ChangePasswordInfo promptToChangePassword(final String msg, final boolean ignoreOldPass) {
        final ChangePasswordInfo[] result = new ChangePasswordInfo[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = EngineCallBackListener.doPromptToChangePassword(msg, ignoreOldPass);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.doPromptToChangePassword(msg, ignoreOldPass);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    private static ChangePasswordInfo doPromptToChangePassword(String msg, boolean ignoreOldPass) {
        logger.debug((Object)("promptToChangePassword entered " + msg));
        if (SwingUtilities.isEventDispatchThread()) {
            logger.debug((Object)"isEventDispatchThread");
        } else {
            logger.debug((Object)"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            logger.debug((Object)"WARNING is NOT EventDispatchThread!!!");
            logger.debug((Object)"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        ChangePasswordInfo info = null;
        ApplicationFrame parent = Application.getActiveFrame();
        PasswordChangeDialog dlg = new PasswordChangeDialog(parent, msg, false, ignoreOldPass);
        UIUtils.centerWindowOnScreen(dlg);
        dlg.setVisible(true);
        if (!dlg.wasCancelled()) {
            info = new ChangePasswordInfo(dlg.getOldPass(), dlg.getNewPass());
        }
        logger.debug((Object)"promptToChangePassword exited");
        return info;
    }

    public int getLoginInfo(final LoginParameters params, final int defaultMode, final boolean remoteOnly, final String errorMessage) {
        final int[] result = new int[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = this.doGetLoginInfo(params, EngineMode.getEnum(defaultMode), remoteOnly, errorMessage).getValue();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.this.doGetLoginInfo(params, EngineMode.getEnum(defaultMode), remoteOnly, errorMessage).getValue();
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    private EngineMode doGetLoginInfo(LoginParameters params, EngineMode defaultMode, boolean remoteOnly, String errorMessage) {
        logger.debug((Object)"getLoginInfo entered");
        EngineCallBackListener.initLoginOptions(params, defaultMode);
        EngineMode mode = EngineMode.NONE;
        GWLoginDialogImproved2 dlgLogin = new GWLoginDialogImproved2(StringResources.NOVELL_GROUPWISE_STARTUP, false, errorMessage);
        if (SwingUtilities.isEventDispatchThread()) {
            logger.debug((Object)"isEventDispatchThread");
        } else {
            logger.debug((Object)"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            logger.debug((Object)"WARNING is NOT EventDispatchThread!!!");
            logger.debug((Object)"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        dlgLogin.setModal(true);
        UIUtils.centerWindowOnScreen(dlgLogin);
        dlgLogin.setVisible(true);
        if (dlgLogin.isActionCompleteSuccessfully()) {
            mode = dlgLogin.getMode();
            String userName = dlgLogin.getUserName();
            String userPassword = dlgLogin.getUserPassword();
            String serverAddress = dlgLogin.getServerAddress();
            String cachingPath = dlgLogin.getCachingPath();
            int serverPort = 1677;
            try {
                serverPort = Integer.parseInt(dlgLogin.getServerPort());
            }
            catch (NumberFormatException e) {
                logger.error((Object)e, (Throwable)e);
            }
            dlgLogin.dispose();
            params.setUserId(userName);
            params.setPassword(userPassword);
            params.setPathToCache(cachingPath);
            params.setIpAddress(serverAddress);
            params.setPort(serverPort);
        }
        logger.debug((Object)"getLoginInfo exited");
        return mode;
    }

    private static void initLoginOptions(LoginParameters params, EngineMode defaultMode) {
        if (params.getPathToCache() != null) {
            OptionManager.getInstance().setCashingPath(params.getPathToCache());
        }
        LoginOptions loginOptions = OptionManager.getInstance().getLoginOptions();
        if (params.getIpAddress() != null) {
            loginOptions.setServerName(params.getIpAddress());
        }
        if (params.getUserId() != null) {
            loginOptions.setUserName(params.getUserId());
        }
        if (params.getPathToRemote() != null) {
            loginOptions.setRemotePath(params.getPathToRemote());
        }
        if (params.getPort() != 0) {
            loginOptions.setServerPort(params.getPort());
        }
        loginOptions.setMode(defaultMode);
        OptionManager.getInstance().setLoginOptions(loginOptions);
    }

    public String getPath(final String msg, final String path) {
        final String[] result = new String[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = EngineCallBackListener.doGetPath(msg, path);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.doGetPath(msg, path);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    private static String doGetPath(String msg, String path) {
        logger.debug((Object)"getPath entered");
        String usePath = path != null && path.length() > 0 ? path : OptionManager.getInstance().getCachingPath();
        SpecifyCachingDirectoryDialog dialog = new SpecifyCachingDirectoryDialog(usePath);
        dialog.setVisible(true);
        String cachingPath = null;
        if (dialog.isOkActionProcessed() && !Utils.isNullOrEmpty(cachingPath = dialog.getPath())) {
            OptionManager.getInstance().setCashingPath(cachingPath);
        }
        logger.debug((Object)"getPath exited");
        return cachingPath;
    }

    public void loginStarted() {
        logger.debug((Object)"loginStarted entered");
        logger.debug((Object)"loginStarted exited");
    }

    public void loginFinished() {
        logger.debug((Object)"loginFinished entered");
        logger.debug((Object)"loginFinished exited");
    }

    public synchronized void syncStarted() {
        logger.debug((Object)"syncStarted entered");
        this.startSync();
        GWClient.setInSync(true);
        logger.debug((Object)"syncStarted exited");
    }

    private void startSync() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doStartSync();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EngineCallBackListener.this.doStartSync();
                }
            });
        }
    }

    private void doStartSync() {
        this.modeSwitchFrame.setSyncStarted(true);
        GWClient.getApplication().processCommand(new GlobalCommand(830));
        if (EngineCommandManager.getAccountSettings().isSyncStatusWindowEnabled()) {
            this.modeSwitchFrame.show();
        }
        String message = StringResources.SEND_RETRIEVE_NOVELL_GROUPWISE;
        this.show(message);
        this.modeSwitchFrame.setStatus(message);
        this.modeSwitchFrame.startTimer();
    }

    public void syncFinished(int errCode, String errMsg) {
        logger.debug((Object)"syncFinished entered");
        this.finishSync(errCode, errMsg);
        GWClient.setInSync(false);
        logger.debug((Object)"syncFinished exited");
    }

    private void finishSync(final int errCode, final String errMsg) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doFinishSync(errCode, errMsg);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EngineCallBackListener.this.doFinishSync(errCode, errMsg);
                }
            });
        }
    }

    private void doFinishSync(int errCode, String errMsg) {
        this.modeSwitchFrame.setSyncStarted(false);
        GWClient.getApplication().processCommand(new GlobalCommand(840, errCode == 0));
        this.modeSwitchFrame.stopTimer();
        String message = StringResources.GROUPWISE_REQUESTS_FINISHED;
        if (errCode != 0) {
            message = errMsg;
        } else if (this.modeSwitchFrame.showDuringSendReceive()) {
            this.modeSwitchFrame.dispose();
        }
        this.show(message + '\n');
        this.modeSwitchFrame.setStatus(message);
    }

    public void restartApp(int restartMode) {
        logger.debug((Object)"restartApp entered");
        this.modeSwitchFrame.dispose();
        LoginOptions loginOptions = OptionManager.getInstance().getLoginOptions();
        loginOptions.setMode(this.currentSwitchingMode);
        OptionManager.getInstance().setLoginOptions(loginOptions);
        new ReloginThread(Thread.currentThread()).start();
        logger.debug((Object)"restartApp exited");
    }

    public void shutdownApp() {
        logger.debug((Object)"shutdownApp entered");
        GWClient.exitAll();
        logger.debug((Object)"shutdownApp exited");
    }

    private static int getResult(JOptionPane theOptionPane) {
        int result = -1;
        Object selectedValue = theOptionPane.getValue();
        Object[] options = theOptionPane.getOptions();
        if (selectedValue != null) {
            if (options == null) {
                if (selectedValue instanceof Integer) {
                    result = (Integer)selectedValue;
                }
            } else {
                int maxCounter = options.length;
                for (int counter = 0; counter < maxCounter; ++counter) {
                    if (!options[counter].equals(selectedValue)) continue;
                    result = counter;
                }
            }
        }
        return result;
    }

    public int prompt(final String msg, final String caption, final int flags) {
        final int[] result = new int[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = this.doPrompt(msg, caption, flags);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.this.doPrompt(msg, caption, flags);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    public int promptError(int errorCode, final String msg, final String caption, final int flags) {
        final int[] result = new int[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = this.doPrompt(msg, caption, flags);
        } else {
            try {
                Runnable doPromptRunnable = new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.this.doPrompt(msg, caption, flags);
                    }
                };
                if ((flags & 0xF) == 0 && errorCode != 0) {
                    SwingUtilities.invokeLater(doPromptRunnable);
                } else {
                    SwingUtilities.invokeAndWait(doPromptRunnable);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    private int doPrompt(String msg, String caption, int flags) {
        int optionType;
        int messageType;
        logger.debug((Object)"doPrompt entered");
        int result = 0;
        int prompt = flags & 0xF;
        switch (flags & 0xF0) {
            case 16: {
                messageType = 0;
                break;
            }
            case 32: {
                messageType = 3;
                break;
            }
            case 48: {
                messageType = 2;
                break;
            }
            case 64: {
                messageType = 1;
                break;
            }
            default: {
                messageType = -1;
            }
        }
        if (messageType == 0) {
            logger.warn((Object)("caption: " + caption));
            logger.warn((Object)("message: " + msg));
        } else {
            logger.debug((Object)("caption: " + caption));
            logger.debug((Object)("message: " + msg));
        }
        switch (prompt) {
            case 1: {
                optionType = 2;
                break;
            }
            case 3: {
                optionType = 1;
                break;
            }
            case 4: {
                optionType = 0;
                break;
            }
            default: {
                optionType = -1;
                prompt = 0;
            }
        }
        JOptionPane optionPane = new JOptionPane(msg, messageType, optionType){

            public int getMaxCharactersPerLineCount() {
                return 100;
            }
        };
        optionPane.setComponentOrientation(UIUtils.getComponentOrientation());
        JDialog dialog = optionPane.createDialog(Application.getParentForModalDialogs(), caption);
        dialog.pack();
        dialog.setVisible(true);
        int selOption = EngineCallBackListener.getResult(optionPane);
        block11 : switch (selOption) {
            case 2: {
                result = 2;
                break;
            }
            case 0: {
                switch (prompt) {
                    case 0: 
                    case 1: {
                        result = 1;
                        break;
                    }
                    case 3: 
                    case 4: {
                        result = 6;
                    }
                }
                break;
            }
            case 1: {
                result = 7;
                break;
            }
            default: {
                switch (prompt) {
                    case 0: {
                        result = 1;
                        break block11;
                    }
                    case 1: 
                    case 3: {
                        result = 2;
                        break block11;
                    }
                    case 4: {
                        result = 7;
                    }
                }
            }
        }
        if (OS.isMacOS()) {
            dialog.dispose();
        }
        logger.debug((Object)"doPrompt exited");
        return result;
    }

    public int promptAutodate(final String msg, final String caption, final boolean askThisForward) {
        final int[] result = new int[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = EngineCallBackListener.doPromptAutodate(msg, caption, askThisForward);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.doPromptAutodate(msg, caption, askThisForward);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    public static int doPromptAutodate(String msg, String caption, boolean askThisForward) {
        AutodatePrompt.Result autodatePromptResult = AutodatePrompt.showDialog(null, caption, msg, askThisForward);
        int result = 1 == autodatePromptResult.getResultID() ? 6 : (0 == autodatePromptResult.getResultID() ? 7 : (2 == autodatePromptResult.getResultID() ? 8 : 2));
        return result;
    }

    public AccountPasswordInfo promptForAccountPassword(final String accountName, final String servername, final String userName, final String password, final boolean save) {
        final AccountPasswordInfo[] result = new AccountPasswordInfo[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = EngineCallBackListener.doPromptForAccountPassword(accountName, servername, userName, password, save);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.doPromptForAccountPassword(accountName, servername, userName, password, save);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                result[0] = null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                result[0] = null;
            }
        }
        return result[0];
    }

    private static AccountPasswordInfo doPromptForAccountPassword(String accountName, String servername, String userName, String password, boolean save) {
        MailServerLoginDialog dialog = new MailServerLoginDialog(GWClient.getActiveFrame(), userName, password, save, servername, accountName);
        dialog.showMe();
        if (dialog.isActionCompleteSuccessfully()) {
            return new AccountPasswordInfo(dialog.getUserName(), String.valueOf(dialog.getUserPassword()), dialog.isSavePassword());
        }
        return null;
    }

    public void syncStatus(String msg, int msgId, int actionId, int current, int total) {
        if (msgId != 0 && msgId != 11) {
            if (actionId == 4 || actionId == 1) {
                this.showBegin(msg, current, total);
            } else if (actionId == 5 || actionId == 2) {
                this.showUpdate(msg, current, total);
            } else if (actionId == 6 || actionId == 3) {
                this.showEnd(msg, current, total);
            } else {
                this.show(msg);
            }
            if (msgId == 9 && actionId == 6) {
                GWClient.getApplication().processCommand(new GlobalCommand(330));
            }
        }
    }

    private void showBegin(String theMessage, int theCurrent, int theTotal) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doBegin(theMessage, theCurrent, theTotal);
        } else {
            SwingUtilities.invokeLater(new BeginRunner(theMessage, theCurrent, theTotal));
        }
    }

    private void doBegin(String theMessage, int theCurrent, int theTotal) {
        GWClient.getApplication().processCommand(new GlobalCommand(1220, theMessage));
        this.modeSwitchFrame.setStatus(theMessage);
        this.modeSwitchFrame.setProgressMax(theTotal);
        this.modeSwitchFrame.setProgressCurrect(theCurrent);
    }

    private void showUpdate(String theMessage, int theCurrent, int theTotal) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdate(theMessage, theCurrent, theTotal);
        } else {
            SwingUtilities.invokeLater(new UpdateRunner(theMessage, theCurrent, theTotal));
        }
    }

    private void doUpdate(String theMessage, int theCurrent, int theTotal) {
        GWClient.getApplication().processCommand(new GlobalCommand(1220, theMessage));
        this.modeSwitchFrame.setStatus(theMessage);
        this.modeSwitchFrame.setProgressMax(theTotal);
        this.modeSwitchFrame.setProgressCurrect(theCurrent);
    }

    private void showEnd(String theMessage, int theCurrent, int theTotal) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doEnd(theMessage, theCurrent, theTotal);
        } else {
            SwingUtilities.invokeLater(new EndRunner(theMessage, theCurrent, theTotal));
        }
    }

    private void doEnd(String theMessage, int theCurrent, int theTotal) {
        GWClient.getApplication().processCommand(new GlobalCommand(1220, theMessage));
        this.modeSwitchFrame.setStatus(theMessage);
        this.modeSwitchFrame.setProgressMax(theTotal);
        this.modeSwitchFrame.setProgressCurrect(theCurrent);
        this.modeSwitchFrame.updateLog(theMessage);
    }

    private synchronized void show(String theMessage) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doShow(theMessage);
        } else {
            SwingUtilities.invokeLater(new ShowRunner(theMessage));
        }
    }

    private void doShow(String theMessage) {
        this.modeSwitchFrame.updateLog(theMessage);
    }

    public void setCurrentSwitchingMode(EngineMode theCurrentSwitchingMode) {
        this.currentSwitchingMode = theCurrentSwitchingMode;
    }

    public StatusWindowFrame getSyncFrame() {
        return this.modeSwitchFrame;
    }

    public RestoreFromInfo getRestoreFromPath(final String defaultPath) {
        final RestoreFromInfo[] result = new RestoreFromInfo[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = EngineCallBackListener.doGetRestoreFromPath(defaultPath);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.doGetRestoreFromPath(defaultPath);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                result[0] = null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                result[0] = null;
            }
        }
        return result[0];
    }

    private static RestoreFromInfo doGetRestoreFromPath(String defaultPath) {
        RestorePathDialog restorePathDialog = new RestorePathDialog(defaultPath);
        restorePathDialog.showMe();
        if (restorePathDialog.isActionCompleteSuccessfully()) {
            String filePath = restorePathDialog.getFilePath();
            String password = restorePathDialog.getPassword();
            RestoreFromInfo restoreFromInfo = new RestoreFromInfo();
            restoreFromInfo.sRestoreFromPath = filePath;
            restoreFromInfo.sPassword = password;
            return restoreFromInfo;
        }
        return null;
    }

    public BackupToInfo getBackupToPath(final String defaultPath) {
        final BackupToInfo[] result = new BackupToInfo[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = EngineCallBackListener.doGetBackupToPath(defaultPath);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.doGetBackupToPath(defaultPath);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                result[0] = null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                result[0] = null;
            }
        }
        return result[0];
    }

    private static BackupToInfo doGetBackupToPath(String defaultPath) {
        BackupMailBoxDialog backupMailBoxDialog = new BackupMailBoxDialog(null, defaultPath);
        backupMailBoxDialog.showMe();
        if (backupMailBoxDialog.isActionCompleteSuccessfully()) {
            return new BackupToInfo(backupMailBoxDialog.getBackupToPath(), backupMailBoxDialog.doNotPrompt());
        }
        return null;
    }

    public int reportBackupError(String errorMsg, String fileLabel, String file) {
        int result;
        Object[] error = new String[]{errorMsg, fileLabel + System.getProperty("line.separator") + file};
        int pressedButton = MultilineOptionPane.showConfirmDialog(null, error, StringResources.GROUPWISE_MAILBOX_BACKUP);
        switch (pressedButton) {
            case 0: {
                result = 3;
                break;
            }
            case 1: {
                result = 4;
                break;
            }
            case 2: {
                result = 5;
                break;
            }
            default: {
                result = 3;
            }
        }
        return result;
    }

    public int updateBackupProgress(final String progressString, final int percentDone, final boolean bDismissDialog) {
        final int[] result = new int[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = this.doUpdateBackupProgress(progressString, percentDone, bDismissDialog);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.this.doUpdateBackupProgress(progressString, percentDone, bDismissDialog);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    private int doUpdateBackupProgress(String progressString, int percentDone, boolean bDismissDialog) {
        logger.debug((Object)("updateBackupProgress entered: " + progressString + percentDone + bDismissDialog));
        int result = 0;
        if (bDismissDialog) {
            this.dissmissProgressDialog();
        } else if (this.getProgressDialog().isCancelPressed()) {
            this.dissmissProgressDialog();
            result = 2;
        } else {
            this.getProgressDialog().setProgress(percentDone);
            this.getProgressDialog().setProgressString(progressString);
        }
        return result;
    }

    private BackupProgressDialog getProgressDialog() {
        if (this.progressDialog == null) {
            this.progressDialog = new BackupProgressDialog();
            this.progressDialog.showMe();
        }
        return this.progressDialog;
    }

    private void dissmissProgressDialog() {
        if (this.progressDialog != null) {
            this.progressDialog.hideMe();
            this.progressDialog.dispose();
            this.progressDialog = null;
        }
    }

    public String renameFolderDialog(final String currentName) {
        final String[] result = new String[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = EngineCallBackListener.doRenameFolderDialog(currentName);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = EngineCallBackListener.doRenameFolderDialog(currentName);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                result[0] = null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                result[0] = null;
            }
        }
        return result[0];
    }

    private static String doRenameFolderDialog(String currentName) {
        return CallBackRenameFolderDialog.getFolderName(currentName);
    }

    public DefaultFontInfo getSystemDefaultFont() {
        return new DefaultFontInfo(HTMLConstants.getDefaultFontName(-1), HTMLConstants.getDefaultFontSize(-1));
    }

    public void systemTimeZoneChanged(String newTimeZoneID) {
        logger.debug((Object)("newTimeZoneID arrived: " + newTimeZoneID));
        TimeZone osTimeZone = TimeZone.getTimeZone(newTimeZoneID);
        DateTimeOptions dateTimeOptions = OptionManager.getInstance().getDateTimeOptions();
        if (!osTimeZone.equals(dateTimeOptions.getTimeZone())) {
            logger.debug((Object)("Switching the Client to OS TimeZone: " + osTimeZone));
            dateTimeOptions.setTimeZone(osTimeZone);
            OptionManager.getInstance().setDateTimeOptions(dateTimeOptions);
            GWClient.getApplication().processCommand(new GlobalCommand(87, osTimeZone));
        }
    }

    public synchronized int verifyServerCertificates(EngineInputStream certStream) {
        block11: {
            try {
                Certificate[] storedCertificates;
                InputStream inputStream = CertificatesUtils.convertEngineInputStream(certStream);
                final Certificate[] certificates = CertificatesUtils.extractCertificates(inputStream);
                if (certificates == null || certificates.length == 0) {
                    return 1;
                }
                boolean alreadyStored = false;
                for (Certificate storedCertificate : storedCertificates = CertificatesUtils.getStoredCertificates()) {
                    if (certificates[0] == null || !certificates[0].equals(storedCertificate)) continue;
                    alreadyStored = true;
                    break;
                }
                if (alreadyStored) break block11;
                final int[] result = new int[1];
                if (SwingUtilities.isEventDispatchThread()) {
                    result[0] = this.doVerifyServerCertificates(certificates);
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                result[0] = EngineCallBackListener.this.doVerifyServerCertificates(certificates);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        logger.debug((Object)e, (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        logger.debug((Object)e, (Throwable)e);
                    }
                }
                return result[0];
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            catch (CertificateException e) {
                logger.error((Object)e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 1;
    }

    private int doVerifyServerCertificates(final Certificate[] certificates) {
        Window window = Application.getParentForModalDialogs();
        AcceptCertificateDialog certificateDialog = window instanceof Dialog ? new AcceptCertificateDialog((Dialog)window, certificates) : new AcceptCertificateDialog((Frame)window, certificates);
        certificateDialog.setVisible(true);
        if (!certificateDialog.isOkActionProcessed()) {
            return 2;
        }
        new Thread(){

            public void run() {
                for (Certificate certificate : certificates) {
                    CertificatesUtils.storeCertificate(certificate);
                }
            }
        }.start();
        return 1;
    }

    private class ShowRunner
    implements Runnable {
        private String message;

        public ShowRunner(String theMessage) {
            this.message = theMessage;
        }

        public void run() {
            EngineCallBackListener.this.doShow(this.message);
        }
    }

    private class EndRunner
    implements Runnable {
        private String message;
        private int current;
        private int total;

        public EndRunner(String theMessage, int theCurrent, int theTotal) {
            this.message = theMessage;
            this.current = theCurrent;
            this.total = theTotal;
        }

        public void run() {
            EngineCallBackListener.this.doEnd(this.message, this.current, this.total);
        }
    }

    private class UpdateRunner
    implements Runnable {
        private String message;
        private int current;
        private int total;

        public UpdateRunner(String theMessage, int theCurrent, int theTotal) {
            this.message = theMessage;
            this.current = theCurrent;
            this.total = theTotal;
        }

        public void run() {
            EngineCallBackListener.this.doUpdate(this.message, this.current, this.total);
        }
    }

    private class BeginRunner
    implements Runnable {
        private String message;
        private int current;
        private int total;

        public BeginRunner(String theMessage, int theTotal, int theCurrent) {
            this.message = theMessage;
            this.current = theCurrent;
            this.total = theTotal;
        }

        public void run() {
            EngineCallBackListener.this.doBegin(this.message, this.current, this.total);
        }
    }

    private class ReloginThread
    extends Thread {
        private Thread waitTarget;

        public ReloginThread(Thread theWaitTarget) {
            this.waitTarget = theWaitTarget;
        }

        public void run() {
            if (this.waitTarget.isAlive()) {
                this.waitTarget.interrupt();
            }
            GWClient.relogin();
        }
    }
}

