/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.AuthInfo;
import com.novell.gw.jclient.application.GWSplash;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePasswordField;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class PasswordDialog
extends BasicDialog {
    private static Logger logger = Logger.getLogger(PasswordDialog.class);
    private JButton btnOK;
    private boolean wasCancelled;
    private JPasswordField tfPassword;
    private JPasswordField tfConfirmPassword;
    private JTextArea taMessage;
    private JLabel lblPassword;
    private JLabel lblConfirmPassword;
    private JButton btnCancel;
    private String message;
    private boolean casaSupported = false;
    private boolean confirmNewPwd = false;
    private JCheckBox cbUseCasa;

    public PasswordDialog(Frame theOwner, String theMessage, boolean bShowCASASingleSignOnOption, boolean bConfirmNewPwd) {
        super(theOwner);
        this.setTitle(!bConfirmNewPwd ? StringResources.GROUPWISE_CLIENT : StringResources.GROUPWISE_CHANGE_PASSWORD);
        this.message = theMessage;
        this.casaSupported = bShowCASASingleSignOnOption;
        logger.debug((Object)("CASA = " + bShowCASASingleSignOnOption));
        this.confirmNewPwd = bConfirmNewPwd;
        logger.debug((Object)("confirmPwd = " + bConfirmNewPwd));
        this.build();
        this.getRootPane().setDefaultButton(this.btnOK);
    }

    private void build() {
        this.tfPassword = new OrientablePasswordField(30);
        this.tfPassword.enableInputMethods(true);
        this.tfPassword.setComponentOrientation(UIUtils.getComponentOrientation());
        this.tfPassword.setName("PasswordDialog_tfPassword");
        if (!this.confirmNewPwd) {
            this.lblPassword = new OrientableLabel(StringResources.PASSWORD_C);
        } else {
            this.lblPassword = new OrientableLabel(StringResources.NEW_PASSWORD_C);
            this.tfConfirmPassword = new OrientablePasswordField(30);
            this.tfConfirmPassword.enableInputMethods(true);
            this.tfConfirmPassword.setComponentOrientation(UIUtils.getComponentOrientation());
            this.tfConfirmPassword.setName("PasswordDialog_tfConfirmPassword");
            this.lblConfirmPassword = new OrientableLabel(StringResources.CONFIRM_NEW_PASSWORD_C);
            this.lblConfirmPassword.setLabelFor(this.tfConfirmPassword);
        }
        this.lblPassword.setLabelFor(this.tfPassword);
        if (this.casaSupported) {
            this.cbUseCasa = new JCheckBox(StringResources.USE_COLLABORATION_SINGLE_SIGN_ON_CASA);
        }
        this.btnOK = new OrientableButton(new ButtonOkAction());
        this.btnCancel = new JButton(new ButtonCancelAction());
        OrientablePanel buttonPanel = new OrientablePanel(new FlowLayout(4));
        OS.addButtons(buttonPanel, this.btnOK, this.btnCancel);
        Container content = this.getContentPane();
        content.setComponentOrientation(UIUtils.getComponentOrientation());
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        if (this.message != null && this.message.length() > 0) {
            this.taMessage = new GWTextArea();
            this.taMessage.setBorder(null);
            this.taMessage.setEditable(false);
            this.taMessage.setFocusable(false);
            this.taMessage.setOpaque(true);
            this.taMessage.setBackground(new Color(UIManager.getColor("Panel.background").darker().getRGB()));
            this.taMessage.setText(this.message);
            c.gridwidth = 0;
            c.insets = new Insets(10, 10, 5, 10);
            c.anchor = 21;
            c.fill = 2;
            content.add((Component)this.taMessage, c);
        }
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.insets = new Insets(10, 10, 5, 10);
        c.weightx = 0.0;
        content.add((Component)this.lblPassword, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 10, 0, 10);
        content.add((Component)this.tfPassword, c);
        if (this.confirmNewPwd) {
            c.fill = 0;
            c.gridx = 0;
            c.insets = new Insets(10, 10, 5, 10);
            c.weightx = 0.0;
            content.add((Component)this.lblConfirmPassword, c);
            c.fill = 2;
            c.weightx = 1.0;
            c.insets = new Insets(0, 10, 0, 10);
            content.add((Component)this.tfConfirmPassword, c);
        }
        if (this.casaSupported) {
            content.add((Component)this.cbUseCasa, c);
        }
        c.insets = new Insets(5, 10, 0, 10);
        content.add((Component)buttonPanel, c);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PasswordDialog.this.cancelActionPerformed();
            }

            public void windowOpened(WindowEvent e) {
                PasswordDialog.this.toFront();
            }
        });
        if (SwingUtilities.isEventDispatchThread()) {
            logger.debug((Object)"isEventDispatchThread");
        } else {
            logger.debug((Object)"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            logger.debug((Object)"is NOT EventDispatchThread");
            logger.debug((Object)"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        this.setModal(true);
        this.setDefaultButton(this.btnOK);
        this.setCancelButton(this.btnCancel);
        this.pack();
    }

    private void cancelActionPerformed() {
        this.wasCancelled = true;
        this.setVisible(false);
    }

    private void oKActionPerformed() {
        this.wasCancelled = false;
        this.setVisible(false);
    }

    public static AuthInfo getPassword(String message, boolean bShowCASASingleSignOnOption, boolean bConfirmNewPwd) {
        AuthInfo authInfo = null;
        logger.debug((Object)("casaSupported = " + bShowCASASingleSignOnOption));
        logger.debug((Object)("confirmNewPassword = " + bConfirmNewPwd));
        PasswordDialog dlg = new PasswordDialog((Frame)GWSplash.getInstance(), message, bShowCASASingleSignOnOption, bConfirmNewPwd);
        UIUtils.centerWindowOnScreen(dlg);
        dlg.pack();
        dlg.setVisible(true);
        if (dlg.confirmNewPwd) {
            boolean newPwdVerified = false;
            while (!newPwdVerified && !dlg.wasCancelled) {
                String newPwdConfirm;
                String newPwd = new String(dlg.tfPassword.getPassword());
                if (newPwd.equals(newPwdConfirm = new String(dlg.tfConfirmPassword.getPassword()))) {
                    newPwdVerified = true;
                    continue;
                }
                dlg.taMessage.setText(StringResources.SAME_PASSWORD_REQUIRED);
                dlg.setVisible(true);
            }
        }
        if (!dlg.wasCancelled) {
            boolean casaEnabled = false;
            if (dlg.casaSupported && dlg.cbUseCasa.isSelected()) {
                casaEnabled = true;
            }
            authInfo = new AuthInfo(new String(dlg.tfPassword.getPassword()), casaEnabled);
        } else {
            authInfo = null;
        }
        try {
            dlg.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        dlg.dispose();
        return authInfo;
    }

    private class ButtonCancelAction
    extends AbstractAction {
        public ButtonCancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            PasswordDialog.this.cancelActionPerformed();
        }
    }

    private class ButtonOkAction
    extends AbstractAction {
        public ButtonOkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            PasswordDialog.this.oKActionPerformed();
        }
    }
}

