/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl.displaysettings;

import com.novell.gw.jclient.api.impl.DisplaySettingsImpl;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.application.dialogs.folderproperties.DisplaySettingsMode;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfos;
import com.novell.gw.jclient.bl.om.folders.UserFolder;
import org.apache.log4j.Logger;

public class FolderDisplaySettings {
    private static Logger logger = Logger.getLogger(FolderDisplaySettings.class);
    private static final int MIN_PANEL_WIDTH = 20;
    private static final int MIN_PANEL_HEIGHT = 20;
    private DisplaySettingsImpl nativeDisplaySettings;
    private ColumnInfos columnInfos;
    private boolean isDefault;
    protected int id;
    protected int boxType;
    protected int contactType;
    protected String description;
    protected int itemType;
    protected String name;
    protected int viewMode;
    protected int calendarWeekColumnCount;
    protected boolean mainMenuVisible;
    protected boolean hideNonChecklist;
    protected boolean folderTreeVisible;
    protected boolean folderTreeApplyPerFolder;
    protected boolean quickViewerVisible;
    protected boolean quickViewerApplyPerFolder;
    protected boolean summaryView;
    protected boolean groupLabelVisible;
    protected boolean msgPreview;
    protected boolean showCalendarToolBar;
    protected boolean showCalendarMonthPicker;
    protected int filterDaysForward;
    protected int filterDaysBackward;
    private DisplaySettingsMode settingsMode = DisplaySettingsMode.FOLDER;

    public boolean isShowCalendarToolBar() {
        return this.showCalendarToolBar;
    }

    public void setShowCalendarToolBar(boolean showCalendarToolBar) {
        this.showCalendarToolBar = showCalendarToolBar;
    }

    public boolean isShowCalendarMonthPicker() {
        return this.showCalendarMonthPicker;
    }

    public void setShowCalendarMonthPicker(boolean showCalendarMonthPicker) {
        this.showCalendarMonthPicker = showCalendarMonthPicker;
    }

    FolderDisplaySettings(DisplaySettingsImpl nativeDisplaySettings) {
        this.setNativeDisplaySettings(nativeDisplaySettings);
    }

    FolderDisplaySettings(FolderDisplaySettings displaySettings) {
        this(displaySettings.nativeDisplaySettings);
        this.readSettings(displaySettings, false);
    }

    public DisplaySettingsImpl getNativeDisplaySettings() {
        return this.nativeDisplaySettings;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNativeDisplaySettings(DisplaySettingsImpl nativeDisplaySettings) {
        this.setNativeDisplaySettings(nativeDisplaySettings, true);
    }

    public void setNativeDisplaySettings(DisplaySettingsImpl nativeDisplaySettings, boolean readNativeSettings) {
        this.nativeDisplaySettings = nativeDisplaySettings;
        if (readNativeSettings) {
            this.readNativeSettings();
        }
    }

    public void readSettings(FolderDisplaySettings newSettings, boolean readNativeSettings) {
        if (readNativeSettings) {
            this.setNativeDisplaySettings(newSettings.getNativeDisplaySettings(), true);
        }
        this.setBoxType(newSettings.getBoxType());
        this.setColumnInfos(new ColumnInfos(newSettings.getNativeDisplaySettings()));
        this.getColumnInfos().setSortColumn(newSettings.getColumnInfos().getSorted(), newSettings.getColumnInfos().getSorted().getSortOrder());
        this.setColumnsView(newSettings.isColumnsView());
        this.setContactType(newSettings.getContactType());
        this.setDefault(newSettings.isDefault());
        this.setDescription(newSettings.getDescription());
        this.setMessagePreview(newSettings.isMessagePreview());
        this.setGroupLabelVisible(newSettings.isGroupLabelVisible());
        this.setHideNonChecklist(newSettings.isHideNonChecklist());
        this.setItemType(newSettings.getItemType());
        this.setName(newSettings.getName());
        this.setQuickViewerApplyPerFolder(newSettings.isQuickViewerApplyPerFolder());
        this.setQuickViewerVisible(newSettings.isQuickViewerVisible());
        this.setFolderTreeApplyPerFolder(newSettings.isFolderTreeApplyPerFolder());
        this.setFolderTreeVisible(newSettings.isFolderTreeVisible());
        this.setSummaryView(newSettings.isSummaryView());
        this.setViewMode(newSettings.getViewMode());
        this.setShowCalendarMonthPicker(newSettings.isShowCalendarMonthPicker());
        this.setShowCalendarToolBar(newSettings.isShowCalendarToolBar());
        this.setCalendarWeekColumnCount(newSettings.getCalendarWeekColumnCount());
        this.setFilterDaysBackward(newSettings.getFilterDaysBackward());
        this.setFilterDaysForward(newSettings.getFilterDaysForward());
    }

    void readNativeSettings() {
        this.id = this.nativeDisplaySettings.getId();
        this.boxType = this.nativeDisplaySettings.getBoxType();
        this.contactType = this.nativeDisplaySettings.getContactType();
        this.description = this.nativeDisplaySettings.getDescription();
        this.itemType = this.nativeDisplaySettings.getItemType();
        this.name = this.nativeDisplaySettings.getName();
        this.viewMode = this.nativeDisplaySettings.getViewMode();
        if (this.viewMode == 9) {
            this.viewMode = 1;
            this.nativeDisplaySettings.setViewMode(this.viewMode);
        }
        this.columnInfos = new ColumnInfos(this.nativeDisplaySettings);
        this.mainMenuVisible = this.nativeDisplaySettings.isMainMenuVisible();
        this.hideNonChecklist = this.nativeDisplaySettings.isHideNonChecklist();
        this.quickViewerVisible = this.nativeDisplaySettings.isQuickViewerVisible();
        this.quickViewerApplyPerFolder = this.nativeDisplaySettings.isQuickViewerApplyPerFolder();
        this.folderTreeVisible = this.nativeDisplaySettings.isFolderTreeVisible();
        this.folderTreeApplyPerFolder = this.nativeDisplaySettings.getFolderTreeApplyPerFolder();
        this.summaryView = this.nativeDisplaySettings.isSummaryView();
        this.groupLabelVisible = this.nativeDisplaySettings.showGroupHeaders();
        this.msgPreview = this.nativeDisplaySettings.getMsgPreview();
        this.showCalendarMonthPicker = this.nativeDisplaySettings.showCalSmallMonths();
        this.showCalendarToolBar = this.nativeDisplaySettings.showCalToolbar();
        this.calendarWeekColumnCount = this.nativeDisplaySettings.getCalWeekColumnCount();
        this.filterDaysBackward = this.nativeDisplaySettings.getFilterDaysBackward();
        this.filterDaysForward = this.nativeDisplaySettings.getFilterDaysForward();
    }

    void writeToNativeSettings() {
        this.nativeDisplaySettings.setBoxType(this.boxType);
        this.nativeDisplaySettings.setColumnAndSortInfo(this.columnInfos.getNativeColumnInfos(), this.columnInfos.getNativeSortedColumnInfo());
        this.nativeDisplaySettings.setContactType(this.contactType);
        this.nativeDisplaySettings.setDescription(this.description);
        this.nativeDisplaySettings.setItemType(this.itemType);
        this.nativeDisplaySettings.setName(this.name);
        logger.debug((Object)("panels before the mode change " + this.nativeDisplaySettings.getPanelCount()));
        logger.debug((Object)("mode change " + this.nativeDisplaySettings.getViewMode() + " > " + this.viewMode));
        this.nativeDisplaySettings.setViewMode(this.viewMode);
        logger.debug((Object)("panels after the mode change " + this.nativeDisplaySettings.getPanelCount()));
        this.nativeDisplaySettings.setHideNonChecklist(this.hideNonChecklist);
        this.nativeDisplaySettings.setMainMenuVisible(this.mainMenuVisible);
        logger.debug((Object)"FolderDisplaySettings::writeNativeSettings\nCurrent values");
        logger.debug((Object)("msgPreview: ui=" + this.msgPreview + " -> native=" + this.nativeDisplaySettings.getMsgPreview()));
        logger.debug((Object)("groupLabelVisible: ui=" + this.groupLabelVisible + " -> native=" + this.nativeDisplaySettings.showGroupHeaders()));
        logger.debug((Object)("summaryView: ui=" + this.summaryView + " -> native=" + this.nativeDisplaySettings.isSummaryView()));
        logger.debug((Object)("quickViewerApplyPerFolder: ui=" + this.quickViewerApplyPerFolder + " -> native=" + this.nativeDisplaySettings.isQuickViewerApplyPerFolder()));
        logger.debug((Object)("quickViewerVisible: ui=" + this.quickViewerVisible + " -> native=" + this.nativeDisplaySettings.isQuickViewerVisible()));
        this.nativeDisplaySettings.setMsgPreview(this.msgPreview);
        this.nativeDisplaySettings.setSummaryView(this.summaryView);
        this.nativeDisplaySettings.setShowGroupHeaders(this.groupLabelVisible);
        this.nativeDisplaySettings.setQuickViewerApplyPerFolder(this.quickViewerApplyPerFolder);
        this.nativeDisplaySettings.setQuickViewerVisible(this.quickViewerVisible);
        this.nativeDisplaySettings.setFolderTreeApplyPerFolder(this.folderTreeApplyPerFolder);
        this.nativeDisplaySettings.setFolderTreeVisible(this.folderTreeVisible);
        this.nativeDisplaySettings.setShowCalToolbar(this.showCalendarToolBar);
        this.nativeDisplaySettings.setShowCalSmallMonths(this.showCalendarMonthPicker);
        this.nativeDisplaySettings.setCalWeekColumnCount(this.calendarWeekColumnCount);
        logger.debug((Object)"After setting to native:");
        logger.debug((Object)("msgPreview: ui=" + this.msgPreview + " == native=" + this.nativeDisplaySettings.getMsgPreview() + ": " + (this.msgPreview == this.nativeDisplaySettings.getMsgPreview())));
        logger.debug((Object)("groupLabelVisible: ui=" + this.groupLabelVisible + " == native=" + this.nativeDisplaySettings.showGroupHeaders() + ": " + (this.groupLabelVisible == this.nativeDisplaySettings.showGroupHeaders())));
        logger.debug((Object)("summaryView: ui=" + this.summaryView + " == native=" + this.nativeDisplaySettings.isSummaryView() + ": " + (this.summaryView == this.nativeDisplaySettings.isSummaryView())));
        logger.debug((Object)("quickViewerApplyPerFolder: ui=" + this.quickViewerApplyPerFolder + " == native=" + this.nativeDisplaySettings.isQuickViewerApplyPerFolder() + ": " + (this.quickViewerApplyPerFolder == this.nativeDisplaySettings.isQuickViewerApplyPerFolder())));
        logger.debug((Object)("quickViewerVisible: ui=" + this.quickViewerVisible + " == native=" + this.nativeDisplaySettings.isQuickViewerVisible() + ": " + (this.quickViewerVisible == this.nativeDisplaySettings.isQuickViewerVisible())));
        this.nativeDisplaySettings.setFilterDaysBackward(this.filterDaysBackward);
        this.nativeDisplaySettings.setFilterDaysForward(this.filterDaysForward);
    }

    public int getId() {
        return this.id;
    }

    public int getBoxType() {
        return this.boxType;
    }

    public void setBoxType(int boxTypeMask) {
        this.boxType = boxTypeMask;
    }

    public ColumnInfos getColumnInfos() {
        return this.columnInfos;
    }

    public void setColumnInfos(ColumnInfos columnInfos) {
        this.columnInfos = columnInfos;
        this.nativeDisplaySettings.setColumnAndSortInfo(this.columnInfos.getNativeColumnInfos(), this.columnInfos.getNativeSortedColumnInfo());
    }

    public int getContactType() {
        return this.contactType;
    }

    public void setContactType(int contactTypeMask) {
        this.contactType = contactTypeMask;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public int getItemType() {
        return this.itemType;
    }

    public void setItemType(int itemTypeMask) {
        this.itemType = itemTypeMask;
    }

    public String getName() {
        return this.name;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int viewMode) {
        this.viewMode = viewMode;
    }

    public boolean isMultiPanelViewMode() {
        return this.viewMode == 8;
    }

    public boolean isQuickViewerApplyPerFolder() {
        return this.quickViewerApplyPerFolder;
    }

    public void setQuickViewerApplyPerFolder(boolean quickViewerApplyPerFolder) {
        this.quickViewerApplyPerFolder = quickViewerApplyPerFolder;
    }

    public void setQuickViewerVisible(boolean quickViewerVisible) {
        this.quickViewerVisible = quickViewerVisible;
    }

    public boolean isFolderTreeVisible() {
        return this.folderTreeVisible;
    }

    public void setFolderTreeVisible(boolean folderTreeVisible) {
        this.folderTreeVisible = folderTreeVisible;
    }

    public boolean isFolderTreeApplyPerFolder() {
        return this.folderTreeApplyPerFolder;
    }

    public void setFolderTreeApplyPerFolder(boolean folderTreeApplyPerFolder) {
        this.folderTreeApplyPerFolder = folderTreeApplyPerFolder;
    }

    public void setHideNonChecklist(boolean hideNonChecklist) {
        this.hideNonChecklist = hideNonChecklist;
    }

    public boolean isQuickViewerVisible() {
        return this.quickViewerVisible;
    }

    public boolean isHideNonChecklist() {
        return this.hideNonChecklist;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof FolderDisplaySettings && this.doEquals((FolderDisplaySettings)obj);
    }

    public boolean isGroupLabelVisible() {
        return this.groupLabelVisible;
    }

    public void setGroupLabelVisible(boolean groupLabelVisible) {
        this.groupLabelVisible = groupLabelVisible;
    }

    public boolean isSummaryView() {
        return this.summaryView;
    }

    public void setSummaryView(boolean summaryView) {
        this.summaryView = summaryView;
    }

    public boolean isColumnsView() {
        return !this.summaryView;
    }

    public void setColumnsView(boolean columnsView) {
        this.summaryView = !columnsView;
    }

    public void setColumnsView() {
        this.setColumnsView(true);
    }

    public void setSummaryView() {
        this.summaryView = true;
    }

    public boolean isMessagePreview() {
        return this.msgPreview;
    }

    public void setMessagePreview(boolean msgPreview) {
        this.msgPreview = msgPreview;
    }

    public int getFilterDaysForward() {
        return this.filterDaysForward;
    }

    public void setFilterDaysForward(int filterDaysForward) {
        this.filterDaysForward = filterDaysForward;
    }

    public int getFilterDaysBackward() {
        return this.filterDaysBackward;
    }

    public void setFilterDaysBackward(int filterDaysBackward) {
        this.filterDaysBackward = filterDaysBackward;
    }

    private boolean doEquals(FolderDisplaySettings settings) {
        boolean b = this.name != null && this.name.equals(settings.name) && this.id == settings.id && this.boxType == settings.boxType && this.contactType == settings.contactType && this.itemType == settings.itemType && this.viewMode == settings.viewMode && this.quickViewerApplyPerFolder == settings.quickViewerApplyPerFolder && this.quickViewerVisible == settings.quickViewerVisible && this.folderTreeApplyPerFolder == settings.folderTreeApplyPerFolder && this.folderTreeVisible == settings.folderTreeVisible && this.hideNonChecklist == settings.hideNonChecklist && this.groupLabelVisible == settings.groupLabelVisible && this.mainMenuVisible == settings.mainMenuVisible && this.summaryView == settings.summaryView && this.msgPreview == settings.msgPreview && this.description.equals(settings.description) && this.columnInfos.equals(settings.columnInfos) && this.showCalendarMonthPicker == settings.isShowCalendarMonthPicker() && this.showCalendarToolBar == settings.isShowCalendarToolBar() && this.calendarWeekColumnCount == settings.getCalendarWeekColumnCount() && this.filterDaysForward == settings.getFilterDaysForward() && this.filterDaysBackward == settings.getFilterDaysBackward();
        return b;
    }

    public int getCalendarWeekColumnCount() {
        return this.calendarWeekColumnCount;
    }

    public void setCalendarWeekColumnCount(int calendarWeekColumnCount) {
        this.calendarWeekColumnCount = calendarWeekColumnCount;
    }

    public String toString() {
        return this.name;
    }

    public DisplaySettingsMode getSettingsMode() {
        return this.settingsMode;
    }

    public void setSettingsMode(DisplaySettingsMode settingsMode) {
        this.settingsMode = settingsMode;
    }

    public int getPanelColumnCount() {
        int columnCount = 0;
        int nCount = this.nativeDisplaySettings.getPanelCount();
        for (int i = 0; i < nCount; ++i) {
            IPanelDisplaySettings currentSettings = this.nativeDisplaySettings.getPanelSettings(i);
            int panelColumn = currentSettings.getPanelColumnNum() + 1;
            if (panelColumn <= columnCount) continue;
            columnCount = panelColumn;
        }
        if (columnCount == 0) {
            logger.warn((Object)"column count is 0");
        }
        return columnCount;
    }

    public void initHomeFolder(UserFolder userFolder) {
        logger.debug((Object)"initing Home folder...");
        this.nativeDisplaySettings.initHomeFolder();
        this.setNativeDisplaySettings((DisplaySettingsImpl)userFolder.getNativeFolder().getDisplaySettings());
        int count = this.nativeDisplaySettings.getPanelCount();
        for (int i = 0; i < count; ++i) {
            IPanelDisplaySettings currentSettings = this.nativeDisplaySettings.getPanelSettings(i);
            if (currentSettings.getPanelWidth() == 0) {
                currentSettings.setPanelWidth(20);
            }
            if (currentSettings.getPanelHeight() != 0) continue;
            currentSettings.setPanelHeight(20);
        }
        logger.debug((Object)"... Home folder inited ");
    }
}

