/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om;

import org.apache.log4j.Logger;

public class GWNetworkConfiguration {
    private static Logger logger = Logger.getLogger(GWNetworkConfiguration.class);

    public static void setupProxy(String proxyHost, String proxyPort, boolean useSSL) {
        logger.debug((Object)"Setting up Proxy...");
        if (useSSL) {
            logger.debug((Object)"Enabling SSL");
            System.setProperty("https.proxyHost", proxyHost);
            System.setProperty("https.proxyPort", proxyPort);
        } else {
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", proxyPort);
        }
        logger.debug((Object)"Done.");
    }

    public static void setupProxyWithAuthentication(String proxyHost, String proxyPort, String userName, String userPassword, boolean useSSL) {
        GWNetworkConfiguration.clearProxySettings();
        logger.debug((Object)"Setting up Proxy with Authentication...");
        if (useSSL) {
            logger.debug((Object)"Enabling SSL");
            System.setProperty("https.proxyHost", proxyHost);
            System.setProperty("https.proxyPort", proxyPort);
            System.setProperty("https.proxyUser", userName);
            System.setProperty("https.proxyPassword", userPassword);
        } else {
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", proxyPort);
            System.setProperty("http.proxyUser", userName);
            System.setProperty("http.proxyPassword", userPassword);
        }
        logger.debug((Object)"Done.");
    }

    public static void clearProxySettings() {
        logger.debug((Object)"Clearing Proxy settings...");
        System.getProperties().remove("https.proxyHost");
        System.getProperties().remove("https.proxyPort");
        System.getProperties().remove("https.proxyUser");
        System.getProperties().remove("https.proxyPassword");
        System.getProperties().remove("http.proxyHost");
        System.getProperties().remove("http.proxyPort");
        System.getProperties().remove("http.proxyUser");
        System.getProperties().remove("http.proxyPassword");
        logger.debug((Object)"Done.");
    }
}

