/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.folders;

import com.novell.gw.jclient.api.interfaces.IItemList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class ItemListsCache {
    private static Logger logger = Logger.getLogger(ItemListsCache.class);
    private static volatile Map listsMap = new HashMap();
    private static volatile Map dityListMap = new HashMap();

    public static synchronized void put(String key, IItemList theItemList, String userGuid) {
        ItemListsCache.getItemList(userGuid).put(key, theItemList);
    }

    private static synchronized Cashe getItemList(String userGuid) {
        Cashe itemLists = (Cashe)listsMap.get(userGuid);
        if (itemLists == null) {
            itemLists = new Cashe();
            listsMap.put(userGuid, itemLists);
        }
        return itemLists;
    }

    private static synchronized List getDityItemList(String userGuid) {
        ArrayList itemLists = (ArrayList)dityListMap.get(userGuid);
        if (itemLists == null) {
            itemLists = new ArrayList();
            dityListMap.put(userGuid, itemLists);
        }
        return itemLists;
    }

    public static synchronized IItemList get(String key, String userGuid) {
        return (IItemList)ItemListsCache.getItemList(userGuid).get(key);
    }

    public static synchronized boolean containsKey(String key, String userGuid) {
        return ItemListsCache.getItemList(userGuid).containsKey(key);
    }

    public static synchronized void clear() {
        logger.debug((Object)"CLEARING ITEM LIST CACHE !");
        listsMap.clear();
        dityListMap.clear();
    }

    public static synchronized void clear(String userGuid) {
        logger.debug((Object)"CLEARING ITEM LIST CACHE !");
        ItemListsCache.getItemList(userGuid).clear();
        ItemListsCache.getDityItemList(userGuid).clear();
        listsMap.remove(userGuid);
        dityListMap.remove(userGuid);
    }

    public static void addDirty(IItemList theItemList, String userGuid) {
        if (!ItemListsCache.getDityItemList(userGuid).contains(theItemList)) {
            ItemListsCache.getDityItemList(userGuid).add(theItemList);
        }
    }

    public static void clearDirty(IItemList theItemList, String userGuid) {
        ItemListsCache.getDityItemList(userGuid).remove(theItemList);
    }

    public static boolean containsDirty(IItemList theItemList, String userGuid) {
        return ItemListsCache.getDityItemList(userGuid).contains(theItemList);
    }

    public static synchronized void remove(String key, String userGuid) {
        ItemListsCache.getItemList(userGuid).remove(key);
    }

    private static class Cashe
    extends LinkedHashMap {
        private static final int MAX_COUNT = 5;

        private Cashe() {
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 5;
        }
    }
}

