/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.novell.gw.jclient.api.enums.NoteAutodate;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCalendarItem<T extends INote>
extends AbstractItem<T> {
    protected ArrayList<Calendar> startDates;
    protected Calendar endDate;

    protected AbstractCalendarItem(T theNativeItem) {
        super(theNativeItem);
        this.endDate = GWCalendarUtils.getToday();
        this.startDates = new ArrayList();
        this.startDates.add((Calendar)this.endDate.clone());
    }

    protected AbstractCalendarItem() {
    }

    public boolean isRecurring() {
        return ((INote)this.nativeItem).isAutodate();
    }

    @Override
    public void setNativeItem(T theNativeItem) {
        super.setNativeItem(theNativeItem);
    }

    public Date[] getStartDates() {
        Calendar[] result = new Calendar[this.startDates.size()];
        return GWCalendarUtils.CalendarToDate(this.startDates.toArray(result));
    }

    public Date getEndDate() {
        return this.endDate.getTime();
    }

    public Calendar getEndGregorianCalendar() {
        return this.endDate;
    }

    public boolean isAccepted() {
        return ((INote)this.nativeItem).isAccepted();
    }

    public void changeTimeStart(int theMinutes) {
        for (Calendar date : this.startDates) {
            AbstractCalendarItem.getChangedTimeOnly(date, theMinutes);
        }
    }

    public void changeTimeEnd(int theMinutes) {
        AbstractCalendarItem.getChangedTimeOnly(this.endDate, theMinutes);
    }

    private static void getChangedTimeOnly(Calendar theDate, int theMinutes) {
        theDate.set(11, theMinutes / 60);
        theDate.set(12, theMinutes % 60);
    }

    public void setStartDates(Date[] theDates) {
        this.startDates.clear();
        for (Date date : theDates) {
            Calendar day = GWCalendarUtils.getToday();
            day.setTime(date);
            this.startDates.add(day);
        }
    }

    public void setEndDate(Date theDate) {
        this.endDate.setTime(theDate);
    }

    public boolean isInTimeInterval(TimeInterval theTimeInterval) {
        long startTime = this.getStartDate().getTime();
        long endTime = this.getEndDate().getTime();
        TimeInterval appointmentInterval = new TimeInterval(startTime, endTime);
        if (this instanceof TaskItem) {
            if (theTimeInterval.getEndDate() < startTime || theTimeInterval.getStartDate() > startTime + 60000L) {
                return false;
            }
        } else {
            if (this instanceof AppointmentItem) {
                return theTimeInterval.hasIntersectionWith(appointmentInterval);
            }
            if (theTimeInterval.getEndDate() < startTime || theTimeInterval.getStartDate() > startTime + 60000L) {
                return false;
            }
        }
        return true;
    }

    public Date getStartDate() {
        Calendar start = this.startDates.get(0);
        return start.getTime();
    }

    public Calendar getStartGregorianCalendar() {
        return this.startDates.get(0);
    }

    @Override
    public void setComposeItemSendOptions(ComposeItemSendOptions theOptions) {
        super.setComposeItemSendOptions(theOptions);
        if (theOptions != null) {
            ((INote)this.nativeItem).setNotifyWhenAccepted(theOptions.getRNWhenAccept().getValue());
            ((INote)this.nativeItem).setNotifyWhenDeclined(theOptions.getRNWhenDeclined().getValue());
        }
    }

    @Override
    public ComposeItemSendOptions getComposeItemSendOptions(ComposeItemSendOptions ciso) {
        if ((ciso = super.getComposeItemSendOptions(ciso)) != null && this.getNativeItem() != null) {
            ciso.setRNWhenAccept(AbstractCalendarItem.getNotification(((INote)this.nativeItem).getNotifyWhenAccepted()));
            ciso.setRNWhenDeclined(AbstractCalendarItem.getNotification(((INote)this.nativeItem).getNotifyWhenDeclined()));
        }
        return ciso;
    }

    public long getDuration() {
        return this.endDate.getTime().getTime() - this.getStartDate().getTime();
    }

    public long getDurationInDays() {
        return this.getDuration() / 86400000L;
    }

    public boolean accept() {
        return ((INote)this.nativeItem).accept(NoteAutodate.CALLBACK_PROMPT);
    }

    public boolean accept(String comments) {
        return ((INote)this.nativeItem).accept(comments, NoteAutodate.CALLBACK_PROMPT, null);
    }

    public boolean accept(String comments, AbstractFolder calendarFolder) {
        return ((INote)this.nativeItem).accept(comments, NoteAutodate.CALLBACK_PROMPT, calendarFolder.getNativeFolder());
    }

    public boolean decline() {
        return ((INote)this.nativeItem).decline(NoteAutodate.CALLBACK_PROMPT);
    }

    public boolean decline(String comments) {
        return ((INote)this.nativeItem).decline(comments, NoteAutodate.CALLBACK_PROMPT);
    }
}

