/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.api.enums.NoteAutodate;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import java.awt.Color;
import java.util.Date;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppointmentItem
extends AbstractCalendarItem<IAppointment> {
    private static Logger logger = Logger.getLogger(AppointmentItem.class);
    private String location = "";

    public AppointmentItem(IAppointment theNativeItem) {
        super(theNativeItem);
    }

    @Override
    public String getSubject() {
        return super.getSubject();
    }

    protected AppointmentItem() {
    }

    public String getTimeZoneName() {
        return ((IAppointment)this.nativeItem).getTimeZoneName();
    }

    public String getSubjectWithTimeZone() {
        String result = this.getSubject();
        if (!"".equals(this.getTimeZoneName())) {
            result = result + " (" + this.getTimeZoneName() + ')';
        }
        return result;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String theLocation) {
        this.location = theLocation;
    }

    @Override
    public String getType() {
        return "Appointment";
    }

    public AppointmentAcceptLevel getShowAsLevel() {
        return ((IAppointment)this.nativeItem).getShowAsLevel();
    }

    public void setShowAsLevel(AppointmentAcceptLevel theShowAsLevel, boolean bUpdateDbNow) {
        ((IAppointment)this.nativeItem).setShowAsLevel(theShowAsLevel, bUpdateDbNow);
    }

    public boolean isAllDayEvent() {
        return ((IAppointment)this.nativeItem).isAllDayEvent();
    }

    public void setAllDayEvent(boolean isAllDayEvent) {
        ((IAppointment)this.nativeItem).setAllDayEvent(isAllDayEvent);
    }

    public boolean accept(String comments, AppointmentAcceptLevel acceptLevel) {
        return ((IAppointment)this.nativeItem).accept(comments, NoteAutodate.CALLBACK_PROMPT, acceptLevel, null);
    }

    public boolean accept(String comments, AppointmentAcceptLevel acceptLevel, AbstractFolder calendarFolder) {
        return ((IAppointment)this.nativeItem).accept(comments, NoteAutodate.CALLBACK_PROMPT, acceptLevel, calendarFolder.getNativeFolder());
    }

    public boolean decline(String comments, AppointmentAcceptLevel acceptLevel, boolean keepItem) {
        return ((IAppointment)this.nativeItem).decline(comments, NoteAutodate.CALLBACK_PROMPT, acceptLevel, keepItem);
    }

    public String getPlace() {
        return ((IAppointment)this.nativeItem).getPlace();
    }

    @Override
    public Color getCalendarDisplayColor() {
        Color color = super.getCalendarDisplayColor();
        if (color != Color.WHITE) {
            return color;
        }
        if (this.getShowAsLevel() == AppointmentAcceptLevel.BUSY || this.getShowAsLevel() == AppointmentAcceptLevel.TENTATIVE) {
            color = AppointmentAcceptLevel.BUSY.getColor();
        } else if (this.getShowAsLevel() == AppointmentAcceptLevel.OUT_OF_OFFICE) {
            color = AppointmentAcceptLevel.OUT_OF_OFFICE.getColor();
        }
        return color;
    }

    public boolean canClearAlarm() {
        return ((IAppointment)this.nativeItem).canClearAlarm();
    }

    public boolean canSetAlarm() {
        return ((IAppointment)this.nativeItem).canSetAlarm();
    }

    public boolean clearAlarm() {
        return ((IAppointment)this.nativeItem).clearAlarm();
    }

    public Date getAlarmTime() {
        return ((IAppointment)this.nativeItem).getAlarmTime();
    }

    public boolean isAlarmSet() {
        return ((IAppointment)this.nativeItem).isAlarmSet();
    }

    public boolean setAlarm(int hours, int minutes, String programFile) {
        return ((IAppointment)this.nativeItem).setAlarm(hours, minutes, programFile);
    }

    public String getLaunchProgram() {
        return ((IAppointment)this.nativeItem).getLaunchProgram();
    }
}

