/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.appframework.cache.IdentifiedObject;
import com.novell.gw.jclient.api.enums.AttachmentDownloadState;
import com.novell.gw.jclient.api.interfaces.message.IAttachment;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.IMessageAttachment;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;

public class GWAttachment
implements IdentifiedObject,
Serializable {
    private static Logger logger = Logger.getLogger(GWAttachment.class);
    private String id;
    private String name;
    private String fileName;
    private String category;
    private AbstractItem gwItem;
    private String library;
    private String document;
    private String version;
    private long size;
    private IAttachment nativeAttachment;
    boolean localFile = false;
    String localFilePath = "";
    private boolean isAllowedToView = false;

    public GWAttachment(IAttachment theNativeAttachment) {
        this.nativeAttachment = theNativeAttachment;
        this.id = String.valueOf(this.nativeAttachment.getId());
        this.fileName = this.nativeAttachment.getFileName();
        this.name = this.nativeAttachment.getDisplayName();
        this.size = this.nativeAttachment.getSize();
    }

    public GWAttachment(String theId, String theName) {
        this.id = theId;
        this.name = theName;
    }

    public String getID() {
        return this.id;
    }

    public void setId(String theId) {
        this.id = theId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return this.fileName;
    }

    public AbstractItem getGwItem() {
        return this.gwItem;
    }

    public void setGwItem(AbstractItem theGwItem) {
        this.gwItem = theGwItem;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String theFileName) {
        this.fileName = theFileName;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String theCategory) {
        this.category = theCategory;
    }

    public String getLibrary() {
        return this.library;
    }

    public void setLibrary(String theLibrary) {
        this.library = theLibrary;
    }

    public String getDocument() {
        return this.document;
    }

    public void setDocument(String theDocument) {
        this.document = theDocument;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String theVersion) {
        this.version = theVersion;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long theSize) {
        this.size = theSize;
    }

    public String saveToTempFile() {
        return this.nativeAttachment.saveToTempFile();
    }

    public IAttachment getNativeAttachment() {
        return this.nativeAttachment;
    }

    public boolean isLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(boolean theLocalFile) {
        this.localFile = theLocalFile;
    }

    public String getLocalFilePath() {
        return this.localFilePath;
    }

    public void setLocalFilePath(String theLocalFilePath) {
        this.localFilePath = theLocalFilePath;
    }

    public boolean isHTMLMessageBody() {
        return this.nativeAttachment != null && this.nativeAttachment.isHTMLMessageBodyText();
    }

    public boolean isSystemAttachment() {
        return this.nativeAttachment != null && this.nativeAttachment.isSystemAttachment();
    }

    public boolean canImportAsCalendar() {
        return this.nativeAttachment != null && this.nativeAttachment.canImportAsCalendar();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GWAttachment)) {
            return false;
        }
        GWAttachment object = (GWAttachment)obj;
        return this.id.equals(object.id) && this.name.equals(object.name) && this.fileName.equals(object.fileName);
    }

    public boolean isMessageAttachment() {
        return this.nativeAttachment instanceof IMessageAttachment;
    }

    public Date getModified() {
        if (this.nativeAttachment == null) {
            return new Date();
        }
        return this.nativeAttachment.getDate();
    }

    public AbstractItem getEnclosedItem(String userGuid) {
        AbstractItem item = null;
        if (this.nativeAttachment instanceof IMessageAttachment) {
            IMessage message = ((IMessageAttachment)this.nativeAttachment).getMessage();
            try {
                item = GWCommandManager.getInstance(userGuid).getGWItem(message);
            }
            catch (GWCommandException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return item;
    }

    public AttachmentDownloadState getDownloadState() {
        if (this.nativeAttachment != null) {
            AttachmentDownloadState downloadState = this.nativeAttachment.getDownloadState();
            return downloadState;
        }
        return AttachmentDownloadState.DOWNLOADED;
    }

    public void setAllowedToView(boolean allow) {
        this.isAllowedToView = allow;
    }

    public boolean isAllowedToView() {
        return this.isAllowedToView;
    }
}

