/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.ISharedFolderNotification;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;

public class GWSharedFolderNotification
extends AbstractItem {
    private ISharedFolderNotification item;
    private boolean isSharedCalendarNotification = false;
    private boolean isSharedCalendarNotificationInitialized = false;

    public GWSharedFolderNotification(ISharedFolderNotification theNativeItem) {
        super(theNativeItem);
        this.item = theNativeItem;
        this.setSharedFolderName(theNativeItem.getFolderName());
    }

    public String getTextGrantedRights() {
        StringBuilder result = new StringBuilder();
        if (this.item.isReadAccess()) {
            result.append(StringResources.READ);
            result.append(", ");
        }
        if (this.item.isAddAccess()) {
            result.append(StringResources.ADD);
            result.append(", ");
        }
        if (this.item.isEditAccess()) {
            result.append(StringResources.EDIT);
            result.append(", ");
        }
        if (this.item.isDeleteAccess()) {
            result.append(StringResources.DELETE);
            result.append(", ");
        }
        if (result.length() > 0) {
            result.delete(result.length() - 2, result.length());
        }
        return result.toString();
    }

    public String getType() {
        return "SharedFolderNotification";
    }

    public IFolder accept(String folderName, AbstractFolder folder, int position, String description) {
        return this.item.accept(folderName, folder.getNativeFolder(), position, description);
    }

    public boolean isSharedCalendarNotification() {
        if (!this.isSharedCalendarNotificationInitialized) {
            this.isSharedCalendarNotification = this.item.isSharedCalendarNotification();
            this.isSharedCalendarNotificationInitialized = true;
        }
        return this.isSharedCalendarNotification;
    }
}

