/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items.properties;

import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class CheckListProperties {
    private static Logger logger = Logger.getLogger(CheckListProperties.class);
    private boolean isCompleted;
    private boolean isDueDateActivated;
    private int year;
    private int day;
    private int month;
    private Date dueDate;

    public CheckListProperties(boolean theCompleted) {
        this.isCompleted = theCompleted;
    }

    public CheckListProperties(boolean theCompleted, Date theDueDate) {
        this.isCompleted = theCompleted;
        this.isDueDateActivated = true;
        this.setDueDate(theDueDate);
    }

    public CheckListProperties(boolean theCompleted, long theDueDate) {
        this.isCompleted = theCompleted;
        if (theDueDate != 0L) {
            this.isDueDateActivated = true;
            this.setDueDate(new Date(theDueDate));
        }
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(boolean theCompleted) {
        this.isCompleted = theCompleted;
    }

    public boolean isDueDateActivated() {
        return this.isDueDateActivated;
    }

    public void setDueDateActivated(boolean theDueDateActivated) {
        this.isDueDateActivated = theDueDateActivated;
    }

    public int getYear() {
        return this.year;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public void setDueDate(Date theDueDate) {
        this.dueDate = theDueDate;
        Calendar gregorianCalendar = GWCalendarUtils.getTodayUTC();
        gregorianCalendar.setTime(this.dueDate);
        this.year = gregorianCalendar.get(1);
        this.month = gregorianCalendar.get(2) + 1;
        this.day = gregorianCalendar.get(5);
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CheckListProperties)) {
            return false;
        }
        CheckListProperties prop = (CheckListProperties)obj;
        if (prop.isCompleted == this.isCompleted && prop.isDueDateActivated == this.isDueDateActivated) {
            if (!this.isDueDateActivated) {
                return true;
            }
            if (this.dueDate.equals(prop.dueDate)) {
                return true;
            }
        }
        return false;
    }
}

