/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items.sendoptions;

import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.sendoptions.NameValueEnum;

public final class Notification
extends NameValueEnum {
    private static final int MAIL_NOTIFICATION = 1;
    private static final int NOTIFICATION = 2;
    public static final Notification NONE = new Notification(StringResources.NONE, 0);
    public static final Notification MAIL_RECEIPT = new Notification(StringResources.MAIL_RECEIPT, 1);
    public static final Notification NOTIFY = new Notification(StringResources.NOTIFY, 2);
    public static final Notification NOTIFY_AND_MAIL = new Notification(StringResources.NOTIFY_AND_MAIL, 3);
    public static final Notification[] NOTIFICATION_LIST = new Notification[]{NONE, MAIL_RECEIPT, NOTIFY, NOTIFY_AND_MAIL};
    private boolean locked;

    private Notification(String theName, int theValue) {
        super(theName, theValue);
    }

    private Notification(String theName, int theValue, boolean isLocked) {
        super(theName, theValue);
        this.locked = isLocked;
    }

    public boolean isMailNotify() {
        return (this.getValue() & 1) > 0;
    }

    public boolean isNotify() {
        return (this.getValue() & 2) > 0;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public static Notification getNotification(DataStoreSettings.SendOptionNotification theSendOptionNotification) {
        if (theSendOptionNotification != null) {
            return Notification.getNotification(theSendOptionNotification.isMailNotificationSet(), theSendOptionNotification.isNotificationSet(), theSendOptionNotification.isNotificationLocked());
        }
        return null;
    }

    public static Notification getNotification(boolean isMailNotify, boolean isNotify, boolean isLocked) {
        int value = (isMailNotify ? 1 : 0) | (isNotify ? 2 : 0);
        String name = "";
        if (isMailNotify && isNotify) {
            name = StringResources.NOTIFY_AND_MAIL;
        } else if (!isMailNotify && !isNotify) {
            name = StringResources.NONE;
        } else if (isMailNotify && !isNotify) {
            name = StringResources.MAIL_RECEIPT;
        } else if (!isMailNotify && isNotify) {
            name = StringResources.NOTIFY;
        }
        return new Notification(name, value, isLocked);
    }
}

