/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options.properties;

import com.novell.gw.jclient.bl.om.options.NotifierOptions;
import com.novell.gw.jclient.bl.om.options.Options;
import com.novell.gw.jclient.bl.om.options.properties.OptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.SortedProperties;
import java.awt.Point;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifierOptionsProperties
extends OptionsProperties<NotifierOptions> {
    private static Logger logger = Logger.getLogger(NotifierOptionsProperties.class);
    public static final String PREFIX = "notify.";
    public static final char DOT = '.';
    public static final String NOTIFICATION_ENABLED = "notify.notifications_enabled";
    public static final String SHOW_IN_TRAY = "notify.show_in_tray";
    public static final String NOTIFICATION_DIALOG = "notify.notification_dialog";
    public static final String BOUNDS = "bounds";
    public static final String X = "x";
    public static final String Y = "y";

    @Override
    public Properties createProperties(NotifierOptions options) {
        SortedProperties properties = new SortedProperties();
        properties.put((Object)NOTIFICATION_ENABLED, options.isNotificationEnabled());
        properties.put((Object)SHOW_IN_TRAY, options.isShowInTray());
        Point position = options.getNotificationDialogPosition();
        if (position != null) {
            String prefix = "notify.notification_dialog.bounds.";
            properties.put((Object)(prefix + X), (int)position.getX());
            properties.put((Object)(prefix + Y), (int)position.getY());
        }
        return properties;
    }

    @Override
    public Options readOptions(Properties properties) {
        String prefix;
        String[] values;
        NotifierOptions options = new NotifierOptions();
        String value = properties.getProperty(NOTIFICATION_ENABLED);
        if (value != null) {
            try {
                options.setNotificationEnabled(Boolean.parseBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = properties.getProperty(SHOW_IN_TRAY)) != null) {
            try {
                options.setShowInTray(Boolean.parseBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((values = new String[]{properties.getProperty((prefix = "notify.notification_dialog.bounds.") + X), properties.getProperty(prefix + Y)})[0] != null && values[1] != null) {
            try {
                Point position = new Point(Integer.parseInt(values[0]), Integer.parseInt(values[1]));
                options.setNotificationDialogPosition(position);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return options;
    }
}

