/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.rmi.one_instance.server;

import com.novell.gw.jclient.application.options.RMISettings;
import com.novell.gw.jclient.rmi.one_instance.RMIException;
import com.novell.gw.jclient.rmi.one_instance.server.GWClientRMIImpl;
import java.net.ServerSocket;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.apache.log4j.Logger;

public class GWClientRMIServer {
    private static Logger logger = Logger.getLogger(GWClientRMIServer.class);
    protected int port = 1099;
    boolean started = false;

    public boolean initialise() throws RMIException {
        logger.debug((Object)"Try to load RMI Registry...");
        this.validateNotStartedState();
        try {
            ServerSocket socket = new ServerSocket(0);
            this.port = socket.getLocalPort();
            socket.close();
            logger.debug((Object)("Try to load rmiregistry on port: " + this.port));
            Registry reg = LocateRegistry.createRegistry(this.port);
            GWClientRMIImpl implementation = new GWClientRMIImpl();
            logger.debug((Object)("Perform Bind..." + reg.list()));
            Naming.bind("//localhost:" + this.port + '/' + "GWClientRMIServer", implementation);
            RMISettings.getInstance().storeRMIPort(this.port);
        }
        catch (Exception e) {
            logger.debug((Object)("Unable to initialize RMI server " + e.getMessage()));
            return false;
        }
        this.started = true;
        return true;
    }

    public void validateNotStartedState() throws RMIException {
        if (this.started) {
            throw new RMIException("Sorry, but RMI server is already started");
        }
    }

    public void validateStartedState() throws RMIException {
        if (!this.started) {
            throw new RMIException("Sorry, but RMI server is not started");
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean isStarted() {
        return this.started;
    }
}

