/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ElementTags;
import com.lowagie.text.MarkupAttributes;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class Annotation
implements Element,
MarkupAttributes {
    public static final int TEXT = 0;
    public static final int URL_NET = 1;
    public static final int URL_AS_STRING = 2;
    public static final int FILE_DEST = 3;
    public static final int FILE_PAGE = 4;
    public static final int NAMED_DEST = 5;
    public static final int LAUNCH = 6;
    public static String TITLE = "title";
    public static String CONTENT = "content";
    public static String URL = "url";
    public static String FILE = "file";
    public static String DESTINATION = "destination";
    public static String PAGE = "page";
    public static String NAMED = "named";
    public static String APPLICATION = "application";
    public static String PARAMETERS = "parameters";
    public static String OPERATION = "operation";
    public static String DEFAULTDIR = "defaultdir";
    public static String LLX = "llx";
    public static String LLY = "lly";
    public static String URX = "urx";
    public static String URY = "ury";
    protected int annotationtype;
    protected HashMap annotationAttributes = new HashMap();
    protected Properties markupAttributes = null;
    protected float llx = Float.NaN;
    protected float lly = Float.NaN;
    protected float urx = Float.NaN;
    protected float ury = Float.NaN;

    private Annotation(float f, float f2, float f3, float f4) {
        this.llx = f;
        this.lly = f2;
        this.urx = f3;
        this.ury = f4;
    }

    public Annotation(String string, String string2) {
        this.annotationtype = 0;
        this.annotationAttributes.put(TITLE, string);
        this.annotationAttributes.put(CONTENT, string2);
    }

    public Annotation(String string, String string2, float f, float f2, float f3, float f4) {
        this(f, f2, f3, f4);
        this.annotationtype = 0;
        this.annotationAttributes.put(TITLE, string);
        this.annotationAttributes.put(CONTENT, string2);
    }

    public Annotation(float f, float f2, float f3, float f4, URL uRL) {
        this(f, f2, f3, f4);
        this.annotationtype = 1;
        this.annotationAttributes.put(URL, uRL);
    }

    public Annotation(float f, float f2, float f3, float f4, String string) {
        this(f, f2, f3, f4);
        this.annotationtype = 2;
        this.annotationAttributes.put(FILE, string);
    }

    public Annotation(float f, float f2, float f3, float f4, String string, String string2) {
        this(f, f2, f3, f4);
        this.annotationtype = 3;
        this.annotationAttributes.put(FILE, string);
        this.annotationAttributes.put(DESTINATION, string2);
    }

    public Annotation(float f, float f2, float f3, float f4, String string, int n) {
        this(f, f2, f3, f4);
        this.annotationtype = 4;
        this.annotationAttributes.put(FILE, string);
        this.annotationAttributes.put(PAGE, new Integer(n));
    }

    public Annotation(float f, float f2, float f3, float f4, int n) {
        this(f, f2, f3, f4);
        this.annotationtype = 5;
        this.annotationAttributes.put(NAMED, new Integer(n));
    }

    public Annotation(float f, float f2, float f3, float f4, String string, String string2, String string3, String string4) {
        this(f, f2, f3, f4);
        this.annotationtype = 6;
        this.annotationAttributes.put(APPLICATION, string);
        this.annotationAttributes.put(PARAMETERS, string2);
        this.annotationAttributes.put(OPERATION, string3);
        this.annotationAttributes.put(DEFAULTDIR, string4);
    }

    public Annotation(Properties properties) {
        String string = (String)((Hashtable)properties).remove(ElementTags.LLX);
        if (string != null) {
            this.llx = Float.valueOf(string + "f").floatValue();
        }
        if ((string = (String)((Hashtable)properties).remove(ElementTags.LLY)) != null) {
            this.lly = Float.valueOf(string + "f").floatValue();
        }
        if ((string = (String)((Hashtable)properties).remove(ElementTags.URX)) != null) {
            this.urx = Float.valueOf(string + "f").floatValue();
        }
        if ((string = (String)((Hashtable)properties).remove(ElementTags.URY)) != null) {
            this.ury = Float.valueOf(string + "f").floatValue();
        }
        String string2 = (String)((Hashtable)properties).remove("title");
        String string3 = (String)((Hashtable)properties).remove("content");
        if (string2 != null || string3 != null) {
            this.annotationtype = 0;
        } else {
            string = (String)((Hashtable)properties).remove("url");
            if (string != null) {
                this.annotationtype = 2;
                this.annotationAttributes.put(FILE, string);
            } else {
                string = (String)((Hashtable)properties).remove(ElementTags.NAMED);
                if (string != null) {
                    this.annotationtype = 5;
                    this.annotationAttributes.put(NAMED, Integer.valueOf(string));
                } else {
                    String string4 = (String)((Hashtable)properties).remove(ElementTags.FILE);
                    String string5 = (String)((Hashtable)properties).remove(ElementTags.DESTINATION);
                    String string6 = (String)((Hashtable)properties).remove(ElementTags.PAGE);
                    if (string4 != null) {
                        this.annotationAttributes.put(FILE, string4);
                        if (string5 != null) {
                            this.annotationtype = 3;
                            this.annotationAttributes.put(DESTINATION, string5);
                        } else if (string6 != null) {
                            this.annotationtype = 4;
                            this.annotationAttributes.put(FILE, string4);
                            this.annotationAttributes.put(PAGE, Integer.valueOf(string6));
                        }
                    } else {
                        string = (String)((Hashtable)properties).remove(ElementTags.NAMED);
                        if (string != null) {
                            this.annotationtype = 6;
                            this.annotationAttributes.put(APPLICATION, string);
                            this.annotationAttributes.put(PARAMETERS, (String)((Hashtable)properties).remove(ElementTags.PARAMETERS));
                            this.annotationAttributes.put(OPERATION, (String)((Hashtable)properties).remove(ElementTags.OPERATION));
                            this.annotationAttributes.put(DEFAULTDIR, (String)((Hashtable)properties).remove(ElementTags.DEFAULTDIR));
                        }
                    }
                }
            }
        }
        if (this.annotationtype == 0) {
            if (string2 == null) {
                string2 = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            this.annotationAttributes.put(TITLE, string2);
            this.annotationAttributes.put(CONTENT, string3);
        }
        if (((Hashtable)properties).size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public int type() {
        return 29;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public void setDimensions(float f, float f2, float f3, float f4) {
        this.llx = f;
        this.lly = f2;
        this.urx = f3;
        this.ury = f4;
    }

    public float llx() {
        return this.llx;
    }

    public float lly() {
        return this.lly;
    }

    public float urx() {
        return this.urx;
    }

    public float ury() {
        return this.ury;
    }

    public float llx(float f) {
        if (this.llx == Float.NaN) {
            return f;
        }
        return this.llx;
    }

    public float lly(float f) {
        if (this.lly == Float.NaN) {
            return f;
        }
        return this.lly;
    }

    public float urx(float f) {
        if (this.urx == Float.NaN) {
            return f;
        }
        return this.urx;
    }

    public float ury(float f) {
        if (this.ury == Float.NaN) {
            return f;
        }
        return this.ury;
    }

    public int annotationType() {
        return this.annotationtype;
    }

    public String title() {
        String string = (String)this.annotationAttributes.get(TITLE);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String content() {
        String string = (String)this.annotationAttributes.get(CONTENT);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public HashMap attributes() {
        return this.annotationAttributes;
    }

    public static boolean isTag(String string) {
        return "annotation".equals(string);
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        ((Hashtable)this.markupAttributes).put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(((Hashtable)this.markupAttributes).get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }
}

