/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.macify.eawt;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;

public class DefaultApplication
implements Application {
    private Object application;
    private Class applicationListenerClass;
    Map listenerMap = Collections.synchronizedMap(new HashMap());
    private boolean enabledAboutMenu = true;
    private boolean enabledPreferencesMenu;
    private boolean aboutMenuItemPresent = true;
    private boolean preferencesMenuItemPresent;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$java$net$URLClassLoader;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$org$simplericity$macify$eawt$ApplicationEvent;

    public DefaultApplication() {
        try {
            ClassLoader scl;
            Class<?> clc;
            File file = new File("/System/Library/Java");
            if (file.exists() && (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = DefaultApplication.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).isAssignableFrom(clc = (scl = ClassLoader.getSystemClassLoader()).getClass())) {
                Method addUrl = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = DefaultApplication.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredMethod("addURL", class$java$net$URL == null ? (class$java$net$URL = DefaultApplication.class$("java.net.URL")) : class$java$net$URL);
                ((AccessibleObject)addUrl).setAccessible(true);
                addUrl.invoke((Object)scl, file.toURL());
            }
            Class<?> appClass = Class.forName("com.apple.eawt.Application");
            this.application = appClass.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
            this.applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
        }
        catch (ClassNotFoundException e) {
            this.application = null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isMac() {
        return this.application != null;
    }

    public void addAboutMenuItem() {
        if (this.isMac()) {
            this.callMethod(this.application, "addAboutMenuItem");
        } else {
            this.aboutMenuItemPresent = true;
        }
    }

    public void addApplicationListener(ApplicationListener applicationListener) {
        if (!Modifier.isPublic(applicationListener.getClass().getModifiers())) {
            throw new IllegalArgumentException("ApplicationListener must be a public class");
        }
        if (this.isMac()) {
            Object listener = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.applicationListenerClass}, (InvocationHandler)new ApplicationListenerInvocationHandler(applicationListener));
            this.callMethod(this.application, "addApplicationListener", new Class[]{this.applicationListenerClass}, new Object[]{listener});
            this.listenerMap.put(applicationListener, listener);
        } else {
            this.listenerMap.put(applicationListener, applicationListener);
        }
    }

    public void addPreferencesMenuItem() {
        if (this.isMac()) {
            this.callMethod("addPreferencesMenuItem");
        } else {
            this.preferencesMenuItemPresent = true;
        }
    }

    public boolean getEnabledAboutMenu() {
        if (this.isMac()) {
            return this.callMethod("getEnabledAboutMenu").equals(Boolean.TRUE);
        }
        return this.enabledAboutMenu;
    }

    public boolean getEnabledPreferencesMenu() {
        if (this.isMac()) {
            Object result = this.callMethod("getEnabledPreferencesMenu");
            return result.equals(Boolean.TRUE);
        }
        return this.enabledPreferencesMenu;
    }

    public Point getMouseLocationOnScreen() {
        if (this.isMac()) {
            try {
                Method method = this.application.getClass().getMethod("getMouseLocationOnScreen", new Class[0]);
                return (Point)method.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return new Point(0, 0);
    }

    public boolean isAboutMenuItemPresent() {
        if (this.isMac()) {
            return this.callMethod("isAboutMenuItemPresent").equals(Boolean.TRUE);
        }
        return this.aboutMenuItemPresent;
    }

    public boolean isPreferencesMenuItemPresent() {
        if (this.isMac()) {
            return this.callMethod("isPreferencesMenuItemPresent").equals(Boolean.TRUE);
        }
        return this.preferencesMenuItemPresent;
    }

    public void removeAboutMenuItem() {
        if (this.isMac()) {
            this.callMethod("removeAboutMenuItem");
        } else {
            this.aboutMenuItemPresent = false;
        }
    }

    public synchronized void removeApplicationListener(ApplicationListener applicationListener) {
        if (this.isMac()) {
            Object listener = this.listenerMap.get(applicationListener);
            this.callMethod(this.application, "removeApplicationListener", new Class[]{this.applicationListenerClass}, new Object[]{listener});
        }
        this.listenerMap.remove(applicationListener);
    }

    public void removePreferencesMenuItem() {
        if (this.isMac()) {
            this.callMethod("removeAboutMenuItem");
        } else {
            this.preferencesMenuItemPresent = false;
        }
    }

    public void setEnabledAboutMenu(boolean enabled) {
        if (this.isMac()) {
            this.callMethod(this.application, "setEnabledAboutMenu", new Class[]{Boolean.TYPE}, new Object[]{enabled});
        } else {
            this.enabledAboutMenu = enabled;
        }
    }

    public void setEnabledPreferencesMenu(boolean enabled) {
        if (this.isMac()) {
            this.callMethod(this.application, "setEnabledPreferencesMenu", new Class[]{Boolean.TYPE}, new Object[]{enabled});
        } else {
            this.enabledPreferencesMenu = enabled;
        }
    }

    public int requestUserAttention(int type) {
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("Requested user attention type is not allowed: " + type);
        }
        try {
            Object application = this.getNSApplication();
            Field critical = application.getClass().getField("UserAttentionRequestCritical");
            Field informational = application.getClass().getField("UserAttentionRequestInformational");
            Field actual = type == 1 ? critical : informational;
            return (Integer)application.getClass().getMethod("requestUserAttention", Integer.TYPE).invoke(application, actual.get(null));
        }
        catch (ClassNotFoundException e) {
            return -1;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void cancelUserAttentionRequest(int request) {
        try {
            Object application = this.getNSApplication();
            application.getClass().getMethod("cancelUserAttentionRequest", Integer.TYPE).invoke(application, new Integer(request));
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getNSApplication() throws ClassNotFoundException {
        try {
            Class<?> applicationClass = Class.forName("com.apple.cocoa.application.NSApplication");
            return applicationClass.getMethod("sharedApplication", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void setApplicationIconImage(BufferedImage image) {
        if (this.isMac()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)image, "png", stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                Class<?> nsDataClass = Class.forName("com.apple.cocoa.foundation.NSData");
                Constructor<?> constructor = nsDataClass.getConstructor(new byte[0].getClass());
                Object nsData = constructor.newInstance(new Object[]{stream.toByteArray()});
                Class<?> nsImageClass = Class.forName("com.apple.cocoa.application.NSImage");
                Object nsImage = nsImageClass.getConstructor(nsDataClass).newInstance(nsData);
                Object application = this.getNSApplication();
                application.getClass().getMethod("setApplicationIconImage", nsImageClass).invoke(application, nsImage);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public BufferedImage getApplicationIconImage() {
        if (this.isMac()) {
            try {
                Class<?> nsDataClass = Class.forName("com.apple.cocoa.foundation.NSData");
                Class<?> nsImageClass = Class.forName("com.apple.cocoa.application.NSImage");
                Object application = this.getNSApplication();
                Object nsImage = application.getClass().getMethod("applicationIconImage", new Class[0]).invoke(application, new Object[0]);
                Object nsData = nsImageClass.getMethod("TIFFRepresentation", new Class[0]).invoke(nsImage, new Object[0]);
                Integer length = (Integer)nsDataClass.getMethod("length", new Class[0]).invoke(nsData, new Object[0]);
                byte[] bytes = (byte[])nsDataClass.getMethod("bytes", Integer.TYPE, Integer.TYPE).invoke(nsData, 0, length);
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(bytes));
                return image;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private Object callMethod(String methodname) {
        return this.callMethod(this.application, methodname, new Class[0], new Object[0]);
    }

    private Object callMethod(Object object, String methodname) {
        return this.callMethod(object, methodname, new Class[0], new Object[0]);
    }

    private Object callMethod(Object object, String methodname, Class[] classes, Object[] arguments) {
        try {
            if (classes == null) {
                classes = new Class[arguments.length];
                for (int i = 0; i < classes.length; ++i) {
                    classes[i] = arguments[i].getClass();
                }
            }
            Method addListnerMethod = object.getClass().getMethod(methodname, classes);
            return addListnerMethod.invoke(object, arguments);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private ApplicationEvent createApplicationEvent(final Object appleApplicationEvent) {
        return (ApplicationEvent)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$org$simplericity$macify$eawt$ApplicationEvent == null ? (class$org$simplericity$macify$eawt$ApplicationEvent = DefaultApplication.class$("org.simplericity.macify.eawt.ApplicationEvent")) : class$org$simplericity$macify$eawt$ApplicationEvent}, new InvocationHandler(){

            public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                return appleApplicationEvent.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(appleApplicationEvent, objects);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ApplicationListenerInvocationHandler
    implements InvocationHandler {
        private ApplicationListener applicationListener;

        ApplicationListenerInvocationHandler(ApplicationListener applicationListener) {
            this.applicationListener = applicationListener;
        }

        public Object invoke(Object object, Method appleMethod, Object[] objects) throws Throwable {
            ApplicationEvent event = DefaultApplication.this.createApplicationEvent(objects[0]);
            try {
                Method method = this.applicationListener.getClass().getMethod(appleMethod.getName(), class$org$simplericity$macify$eawt$ApplicationEvent == null ? (class$org$simplericity$macify$eawt$ApplicationEvent = DefaultApplication.class$("org.simplericity.macify.eawt.ApplicationEvent")) : class$org$simplericity$macify$eawt$ApplicationEvent);
                return method.invoke((Object)this.applicationListener, event);
            }
            catch (NoSuchMethodException e) {
                if (appleMethod.getName().equals("equals") && objects.length == 1) {
                    return object == objects[0];
                }
                return null;
            }
        }
    }
}

