/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.ab;

import com.novell.gw.ab.Address;
import com.novell.gw.ab.AddressBookAccessRights;
import com.novell.gw.ab.Addressable;

public class AddressBookSharedEntry {
    private int pGWAddressBookSharedEntry = 0;
    private Addressable addressable;
    private AddressBookAccessRights accessRights;

    private static native int create(int var0, boolean var1);

    private native void dispose(int var1);

    private native boolean getAccessRights(int var1);

    private native int getAddressable(int var1);

    private native String getName(int var1);

    private native String getStatus(int var1);

    public AddressBookSharedEntry() {
        this.addressable = null;
        this.accessRights = null;
    }

    public AddressBookSharedEntry(Addressable addressable, AddressBookAccessRights addressBookAccessRights) {
        this(AddressBookSharedEntry.create(addressable.getAddressablePointer(), addressBookAccessRights.hasAllAccess()));
        if (!(addressable instanceof Address)) {
            this.addressable = addressable;
        }
    }

    AddressBookSharedEntry(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWAddressBookSharedEntry = n;
    }

    public AddressBookAccessRights getAccessRights() {
        if (this.accessRights == null) {
            this.accessRights = new AddressBookAccessRights(this.pGWAddressBookSharedEntry, this.getAccessRights(this.pGWAddressBookSharedEntry));
        }
        return this.accessRights;
    }

    public Addressable getAddressable() {
        if (this.addressable == null) {
            this.addressable = new Address(this.getAddressable(this.pGWAddressBookSharedEntry));
        }
        return this.addressable;
    }

    public String getName() {
        return this.getName(this.pGWAddressBookSharedEntry);
    }

    public int getPointer() {
        return this.pGWAddressBookSharedEntry;
    }

    public String getStatus() {
        return this.getStatus(this.pGWAddressBookSharedEntry);
    }

    public void dispose() {
        if (this.pGWAddressBookSharedEntry != 0) {
            this.dispose(this.pGWAddressBookSharedEntry);
            this.pGWAddressBookSharedEntry = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

