/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.ab;

import com.novell.gw.ab.AddressBook;
import com.novell.gw.ab.AddressBookEvent;
import com.novell.gw.ab.AddressBookEventListener;
import com.novell.gw.ab.AddressBookSharedList;
import com.novell.gw.ab.Contact;
import com.novell.gw.engine.EngineException;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class PersonalAddressBook
extends AddressBook {
    private int pEventSink = 0;
    private EventListenerList listenerList = new EventListenerList();

    private native void destroyEventSink(int var1, int var2);

    private native int registerForEvents(int var1);

    private native int copyContact(int var1, int var2, int var3) throws EngineException;

    private native int createContact(int var1, int var2);

    private native int createUserDefinedField(int var1, String var2) throws EngineException;

    private native void deleteContact(int var1, int var2) throws EngineException;

    private native String getComments(int var1);

    private native int getSharedList(int var1) throws EngineException;

    private native void setComments(int var1, String var2) throws EngineException;

    private native void setName(int var1, String var2) throws EngineException;

    private native boolean setSharedList(int var1, int var2) throws EngineException;

    private native void setNameFormat(int var1, int var2) throws EngineException;

    public PersonalAddressBook() {
    }

    public PersonalAddressBook(int n) {
        super(n);
        this.pEventSink = this.registerForEvents(n);
    }

    public void addAddressBookEventListener(AddressBookEventListener addressBookEventListener) {
        this.listenerList.add(AddressBookEventListener.class, addressBookEventListener);
    }

    public void removeAddressBookEventListener(AddressBookEventListener addressBookEventListener) {
        this.listenerList.remove(AddressBookEventListener.class, addressBookEventListener);
    }

    private void fireEvent(final AddressBookEvent addressBookEvent) {
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PersonalAddressBook.this.doFireEvent(objectArray, addressBookEvent);
                }
            });
        }
    }

    private void doFireEvent(Object[] objectArray, AddressBookEvent addressBookEvent) {
        for (int i = 1; i < objectArray.length; i += 2) {
            AddressBookEventListener addressBookEventListener = (AddressBookEventListener)objectArray[i];
            if (addressBookEvent.isBookEvent()) {
                addressBookEventListener.bookChanged(addressBookEvent);
                continue;
            }
            addressBookEventListener.entryChanged(addressBookEvent);
        }
    }

    private void entryEvent(int n, int n2, int n3) {
        this.fireEvent(new AddressBookEvent(this, n, n2, n3));
    }

    private void udfEvent(int n, int n2, int n3, String string) {
        this.fireEvent(new AddressBookEvent((Object)this, n, n2, n3, string));
    }

    public void setName(String string) throws EngineException {
        this.setName(this.pGWAddressBook, string);
    }

    public String getComments() {
        return this.getComments(this.pGWAddressBook);
    }

    public void setComments(String string) throws EngineException {
        this.setComments(this.pGWAddressBook, string);
    }

    public AddressBookSharedList getSharedList() {
        AddressBookSharedList addressBookSharedList = null;
        try {
            int n = this.getSharedList(this.pGWAddressBook);
            if (n != 0) {
                addressBookSharedList = new AddressBookSharedList(n);
            }
        }
        catch (EngineException engineException) {
            // empty catch block
        }
        return addressBookSharedList;
    }

    public boolean setSharedList(AddressBookSharedList addressBookSharedList) {
        boolean bl = false;
        try {
            bl = this.setSharedList(this.pGWAddressBook, addressBookSharedList != null ? addressBookSharedList.getPointer() : 0);
        }
        catch (EngineException engineException) {
            // empty catch block
        }
        return bl;
    }

    public Contact createContact(int n) {
        Contact contact = null;
        int n2 = this.createContact(this.pGWAddressBook, n);
        if (n2 != 0) {
            contact = Contact.createContact(n2);
        }
        return contact;
    }

    public void deleteContact(Contact contact) throws EngineException {
        if (contact != null) {
            this.deleteContact(this.pGWAddressBook, contact.getPointer());
        }
    }

    public Contact copyContact(Contact contact) throws EngineException {
        return this.copyContact(contact, 0);
    }

    public Contact copyContact(Contact contact, int n) throws EngineException {
        int n2;
        Contact contact2 = null;
        if (contact != null && (n2 = this.copyContact(this.pGWAddressBook, contact.getPointer(), n)) != 0) {
            contact2 = Contact.createContact(n2);
        }
        return contact2;
    }

    public int createUserDefinedField(String string) throws EngineException {
        return this.createUserDefinedField(this.pGWAddressBook, string);
    }

    public void setNameFormat(int n) throws EngineException {
        this.setNameFormat(this.pGWAddressBook, n);
    }

    public void dispose() {
        if (this.pEventSink != 0) {
            this.destroyEventSink(this.pGWAddressBook, this.pEventSink);
            this.pEventSink = 0;
        }
        super.dispose();
    }
}

