/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.account.Account;
import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.engine.SettingsValue;
import java.awt.Color;
import java.io.File;

public class DataStoreSettings {
    public static final int SET_SIG_NO_SIGNATURE = 0;
    public static final int SET_SIG_ALWAYS_ADD = 1;
    public static final int SET_SIG_ALWAYS_PROMPT = 201;
    public static final int SET_CLEANUP_MANUAL = 0;
    public static final int SET_CLEANUP_AUTO_DELETE = 1;
    public static final int SET_CLEANUP_AUTO_PURGE = 1;
    public static final int SET_CLEANUP_AUTO_ARCHIVE = 2;
    public static final int GW_BITMASK_SUNDAY = 1;
    public static final int GW_BITMASK_MONDAY = 2;
    public static final int GW_BITMASK_TUESDAY = 4;
    public static final int GW_BITMASK_WEDNESDAY = 8;
    public static final int GW_BITMASK_THURSDAY = 16;
    public static final int GW_BITMASK_FRIDAY = 32;
    public static final int GW_BITMASK_SATURDAY = 64;
    public static final int GW_SUNDAY = 0;
    public static final int GW_MONDAY = 1;
    public static final int GW_TUESDAY = 2;
    public static final int GW_WEDNESDAY = 3;
    public static final int GW_THURSDAY = 4;
    public static final int GW_FRIDAY = 5;
    public static final int GW_SATURDAY = 6;
    public static final int GW_APPT_MODE_SHOW_LEN_AS_DURATION = 0;
    public static final int GW_APPT_MODE_SHOW_LEN_AS_ENDDATETIME = 1;
    public static final int GW_QV_POSITION_RIGHT = 0;
    public static final int GW_QV_POSITION_BOTTOM = 1;
    private int pGWSettings;
    private int tmpnMailAndPhone;
    private boolean tmpbMailAndPhoneLocked;
    private int tmpnMailAndPhoneDays;
    private boolean tmpbMailAndPhoneDaysLocked;
    private int tmpnCalItem;
    private boolean tmpbCalItemLocked;
    private int tmpnCalItemDays;
    private boolean tmpbCalItemDaysLocked;
    private int tmpnTrash;
    private boolean tmpbTrashLocked;
    private int tmpnTrashDays;
    private boolean tmpbTrashDaysLocked;
    private int tmpSecurity;
    private boolean tmpSecurityLocked;
    private String tmpSecurityDisplayText;
    private int tmpPriority;
    private boolean tmpPriorityLocked;
    private boolean tmpReplyRequest;
    private boolean tmpReplyWhenConvenient;
    private boolean tmpReplyRequestLocked;
    private int tmpReplyWithinDays;
    private boolean tmpMailNotification;
    private boolean tmpNotification;
    private boolean tmpNotificationLocked;
    private boolean tmpSignatureOn;
    private int tmpSignatureStatus;
    private String tmpSignatureText;
    private boolean tmpVCardOn;
    private String tmpVCardFileName;
    private int tmpMimeEncoding;
    private boolean tmpMimeEncodingLocked;
    private boolean tmpbIsCASASSOAvailable;
    private boolean tmpbIsCASASSOSet;
    private boolean tmpbIsCASASSOLocked;
    private boolean tmpbIsRememberPasswordSet;
    private boolean tmpbIsRememberPasswordLocked;
    private boolean tmpbIsLocked;
    private final Object jniSyncLock = new Object();

    private static native void initIds();

    private static native int create(int var0);

    private native void dispose(int var1);

    private native String getArchivePath(int var1);

    private native boolean setArchivePath(int var1, String var2);

    private native boolean getSecurityPasswordOptions(int var1);

    private native boolean setSecurityPasswordOptions(int var1, String var2, String var3, int var4, int var5) throws EngineException;

    private native boolean canClearPassword(int var1);

    private native boolean clearPassword(int var1, String var2) throws EngineException;

    private native boolean isPasswordSet(int var1);

    private native boolean validatePassword(int var1, String var2);

    private native boolean getSignatureAndvCard(int var1, int var2);

    private native boolean setSignatureAndvCard(int var1, int var2, int var3, String var4, int var5, String var6, int var7);

    private native boolean getCleanupOptions(int var1);

    private native boolean setCleanupOptions(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native boolean getSendOptionConcealSubject(int var1);

    private native boolean setSendOptionConcealSubject(int var1, boolean var2);

    private native boolean getSendOptionCreateSentItem(int var1);

    private native boolean setSendOptionCreateSentItem(int var1, boolean var2);

    private native boolean getSendOptionMailAutoDelete(int var1);

    private native boolean setSendOptionMailAutoDelete(int var1, boolean var2);

    private native boolean getSendOptionNotifyRecipients(int var1);

    private native boolean setSendOptionNotifyRecipients(int var1, boolean var2);

    private native int getSendOptionStatusTracking(int var1, int var2);

    private native boolean setSendOptionStatusTracking(int var1, int var2, int var3);

    private native int getSendOptionInternetStatusTracking(int var1);

    private native boolean setSendOptionInternetStatusTracking(int var1, int var2);

    private native int getSendOptionExpireDays(int var1);

    private native boolean setSendOptionExpireDays(int var1, int var2);

    private native int getSendOptionDelayDeliverDays(int var1);

    private native boolean setSendOptionDelayDeliverDays(int var1, int var2);

    private native boolean getSendOptionReturnNotification(int var1, int var2, int var3);

    private native boolean setSendOptionReturnNotification(int var1, int var2, int var3, boolean var4, boolean var5);

    private native boolean setSendOptionReturnNotifications(int var1, int var2, int var3, int[] var4, boolean[] var5, boolean[] var6);

    private native boolean getSendOptionReplyRequest(int var1);

    private native boolean setSendOptionReplyRequest(int var1, boolean var2, boolean var3, int var4);

    private native boolean getSendOptionSecurityClassification(int var1);

    private native boolean setSendOptionSecurityClassification(int var1, int var2, String var3);

    private native boolean getSendOptionPriority(int var1);

    private native boolean setSendOptionPriority(int var1, int var2);

    private native boolean getSendOptionMimeEncoding(int var1);

    private native boolean setSendOptionMimeEncoding(int var1, int var2);

    private native int getMonthCalendarFirstDay(int var1);

    private native boolean setMonthCalendarFirstDay(int var1, int var2);

    private native int getMonthCalendarHighlightDays(int var1);

    private native boolean setMonthCalendarHighlightDays(int var1, int var2);

    private native boolean getMonthCalendarShowWeekNumber(int var1);

    private native boolean setMonthCalendarShowWeekNumber(int var1, boolean var2);

    private native boolean getAppointmentIncludeSelf(int var1);

    private native boolean setAppointmentIncludeSelf(int var1, boolean var2);

    private native boolean getLeaveItemInInboxOnAccept(int var1);

    private native boolean setLeaveItemInInboxOnAccept(int var1, boolean var2);

    private native int getMyAllDayEventAcceptLevel(int var1);

    private native boolean setMyAllDayEventAcceptLevel(int var1, int var2);

    private native int getAppointmentEventMode(int var1);

    private native boolean setAppointmentEventMode(int var1, int var2);

    private native int getAppointmentDefaultLength(int var1);

    private native boolean setAppointmentDefaultLength(int var1, int var2);

    private native boolean getAppointmentAlarmSet(int var1);

    private native boolean setAppointmentAlarmSet(int var1, boolean var2);

    private native int getAppointmentAlarmMinutes(int var1);

    private native boolean setAppointmentAlarmMinutes(int var1, int var2);

    private native boolean getAllDayEventAlarmSet(int var1);

    private native boolean setAllDayEventAlarmSet(int var1, boolean var2);

    private native int getAllDayEventAlarmMinutes(int var1);

    private native boolean setAllDayEventAlarmMinutes(int var1, int var2);

    private native int getCalendarWorkDayStartTime(int var1);

    private native boolean setCalendarWorkDayStartTime(int var1, int var2);

    private native int getCalendarWorkDayEndTime(int var1);

    private native boolean setCalendarWorkDayEndTime(int var1, int var2);

    private native String getCalendarWorkDayTimeZoneID(int var1);

    private native boolean setCalendarWorkDayTimeZoneID(int var1, String var2);

    private native int getCalendarWorkDays(int var1);

    private native boolean setCalendarWorkDays(int var1, int var2);

    private native int getBusySearchRange(int var1);

    private native boolean setBusySearchRange(int var1, int var2);

    private native int getBusySearchStartMinutes(int var1);

    private native boolean setBusySearchStartMinutes(int var1, int var2);

    private native int getBusySearchEndMinutes(int var1);

    private native boolean setBusySearchEndMinutes(int var1, int var2);

    private native int getBusySearchDays(int var1);

    private native boolean setBusySearchDays(int var1, int var2);

    private native boolean getBusySearchPublishFreebusy(int var1);

    private native boolean setBusySearchPublishFreebusy(int var1, boolean var2);

    private native String getBusySearchPublishFreebusyURL(int var1);

    private native String getDateTimeFormatTimeDefault(int var1);

    private native boolean setDateTimeFormatTimeDefault(int var1, String var2);

    private native String getDateTimeFormatDateDefault(int var1);

    private native boolean setDateTimeFormatDateDefault(int var1, String var2);

    private native String getDateTimeFormatMainWindowDefault(int var1);

    private native boolean setDateTimeFormatMainWindowDefault(int var1, String var2);

    private native String getDateTimeFormatPropertiesDefault(int var1);

    private native boolean setDateTimeFormatPropertiesDefault(int var1, String var2);

    private native String getDateTimeFormatFileInfoDefault(int var1);

    private native boolean setDateTimeFormatInfoDefault(int var1, String var2);

    private native void syncWithDatabase(int var1);

    private native int getBackupInterval(int var1);

    private native void setBackupInterval(int var1, int var2);

    private native String getBackupLocation(int var1);

    private native boolean setBackupLocation(int var1, String var2);

    private native int getGWColor(int var1, int var2);

    private native boolean getUseGWColorSchemes(int var1);

    private native boolean setUseGWColorSchemes(int var1, boolean var2);

    private native int getGWColorScheme(int var1);

    private native void setGWColorScheme(int var1, int var2);

    private native void getHeaderSettings(int var1);

    private native void setHeaderSettings(int var1);

    private native boolean getHeaderBackColorSet(int var1);

    private native void setHeaderBackColorSet(int var1, boolean var2);

    private native int getHeaderBackColor(int var1);

    private native void setHeaderBackColor(int var1, int var2);

    private native boolean getHeaderTextColorSet(int var1);

    private native void setHeaderTextColorSet(int var1, boolean var2);

    private native int getHeaderTextColor(int var1);

    private native void setHeaderTextColor(int var1, int var2);

    private native boolean getPanelBackColorSet(int var1);

    private native void setPanelBackColorSet(int var1, boolean var2);

    private native int getPanelBackColor(int var1);

    private native void setPanelBackColor(int var1, int var2);

    private native boolean getPanelTextColorSet(int var1);

    private native void setPanelTextColorSet(int var1, boolean var2);

    private native int getPanelTextColor(int var1);

    private native void setPanelTextColor(int var1, int var2);

    private native boolean getNavBarTextColorSet(int var1);

    private native void setNavBarTextColorSet(int var1, boolean var2);

    private native int getNavBarTextColor(int var1);

    private native void setNavBarTextColor(int var1, int var2);

    private native int getHeaderFontSize(int var1);

    private native void setHeaderFontSize(int var1, int var2);

    private native int getPanelFontSize(int var1);

    private native void setPanelFontSize(int var1, int var2);

    private native int getNavBarFontSize(int var1);

    private native void setNavBarFontSize(int var1, int var2);

    private native int getHeaderParentFontSize(int var1);

    private native void setHeaderParentFontSize(int var1, int var2);

    private native boolean getHeaderParentBackColorSet(int var1);

    private native void setHeaderParentBackColorSet(int var1, boolean var2);

    private native int getHeaderParentBackColor(int var1);

    private native void setHeaderParentBackColor(int var1, int var2);

    private native boolean getHeaderParentTextColorSet(int var1);

    private native void setHeaderParentTextColorSet(int var1, boolean var2);

    private native int getHeaderParentTextColor(int var1);

    private native void setHeaderParentTextColor(int var1, int var2);

    private native boolean getDisableAutoSave(int var1);

    private native boolean setDisableAutoSave(int var1, boolean var2);

    private native boolean getReadNextOnDelete(int var1);

    private native boolean setReadNextOnDelete(int var1, boolean var2);

    private native int getRefreshPollInterval(int var1);

    private native void setRefreshPollInterval(int var1, int var2);

    private native int getNewTasklistItemType(int var1);

    private native boolean setNewTasklistItemType(int var1, int var2);

    private native boolean getShowMainMenu(int var1);

    private native boolean setShowMainMenu(int var1, boolean var2);

    private native boolean getShowNavBar(int var1);

    private native boolean setShowNavBar(int var1, boolean var2);

    private native boolean getShowMainToolBar(int var1);

    private native boolean setShowMainToolBar(int var1, boolean var2);

    private native boolean getShowFolderTree(int var1);

    private native boolean setShowFolderTree(int var1, boolean var2);

    private native boolean getShowFolderTreeLong(int var1);

    private native boolean setShowFolderTreeLong(int var1, boolean var2);

    private native boolean getShowQuickViewer(int var1);

    private native boolean setShowQuickViewer(int var1, boolean var2);

    private native int getQuickViewerPosition(int var1);

    private native boolean setQuickViewerPosition(int var1, int var2);

    private native boolean getCheckSpellingBeforeSend(int var1);

    private native boolean setCheckSpellingBeforeSend(int var1, boolean var2);

    private native boolean getCheckSpellingAsYouType(int var1);

    private native boolean setCheckSpellingAsYouType(int var1, boolean var2);

    public DataStoreSettings() {
    }

    DataStoreSettings(DataStore dataStore) {
        this(DataStoreSettings.create(dataStore.getPointer()));
    }

    DataStoreSettings(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWSettings = n;
        this.getHeaderSettings();
    }

    public synchronized SignatureOptions getSignature(Account account) {
        this.tmpSignatureOn = false;
        this.tmpSignatureStatus = 0;
        this.tmpSignatureText = null;
        this.tmpVCardOn = false;
        this.tmpVCardFileName = null;
        if (this.getSignatureAndvCard(this.pGWSettings, account != null ? account.getPointer() : 0)) {
            return new SignatureOptions(this.tmpSignatureOn, this.tmpSignatureStatus, this.tmpSignatureText, this.tmpVCardOn, this.tmpVCardFileName);
        }
        return null;
    }

    public boolean setSignature(Boolean bl, int n, String string, Boolean bl2, String string2, Account account) {
        int n2 = -1;
        int n3 = -1;
        if (bl != null) {
            int n4 = n2 = bl == true ? 1 : 0;
        }
        if (bl2 != null) {
            n3 = bl2 == true ? 1 : 0;
        }
        return this.setSignatureAndvCard(this.pGWSettings, n2, n, string, n3, string2, account != null ? account.getPointer() : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getSendOptionConcealSubject() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getSendOptionConcealSubject(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setSendOptionConcealSubject(boolean bl) {
        return this.setSendOptionConcealSubject(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getSendOptionCreateSentItem() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getSendOptionCreateSentItem(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setSendOptionCreateSentItem(boolean bl) {
        return this.setSendOptionCreateSentItem(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getSendOptionMailAutoDelete() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getSendOptionMailAutoDelete(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setSendOptionMailAutoDelete(boolean bl) {
        return this.setSendOptionMailAutoDelete(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getSendOptionNotifyRecipients() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getSendOptionNotifyRecipients(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setSendOptionNotifyRecipients(boolean bl) {
        return this.setSendOptionNotifyRecipients(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getSendOptionStatusTracking(int n) {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n2 = this.getSendOptionStatusTracking(this.pGWSettings, n);
            settingsValue = new SettingsValue(n2, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setSendOptionStatusTracking(int n, int n2) {
        return this.setSendOptionStatusTracking(this.pGWSettings, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getSendOptionInternetStatusTracking() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getSendOptionInternetStatusTracking(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setSendOptionInternetStatusTracking(int n) {
        return this.setSendOptionInternetStatusTracking(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getSendOptionExpireDays() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getSendOptionExpireDays(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setSendOptionExpireDays(int n) {
        return this.setSendOptionExpireDays(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getSendOptionDelayDeliverDays() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getSendOptionDelayDeliverDays(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setSendOptionDelayDeliverDays(int n) {
        return this.setSendOptionDelayDeliverDays(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getMonthCalendarFirstDay() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getMonthCalendarFirstDay(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setMonthCalendarFirstDay(int n) {
        return this.setMonthCalendarFirstDay(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getMonthCalendarHighlightDays() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getMonthCalendarHighlightDays(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setMonthCalendarHighlightDays(int n) {
        return this.setMonthCalendarHighlightDays(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getMonthCalendarShowWeekNumber() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getMonthCalendarShowWeekNumber(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setMonthCalendarShowWeekNumber(boolean bl) {
        return this.setMonthCalendarShowWeekNumber(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getAppointmentIncludeSelf() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getAppointmentIncludeSelf(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setAppointmentIncludeSelf(boolean bl) {
        return this.setAppointmentIncludeSelf(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getLeaveItemInInboxOnAccept() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getLeaveItemInInboxOnAccept(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setLeaveItemInInboxOnAccept(boolean bl) {
        return this.setLeaveItemInInboxOnAccept(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getMyAllDayEventAcceptLevel() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getMyAllDayEventAcceptLevel(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setMyAllDayEventAcceptLevel(int n) {
        return this.setMyAllDayEventAcceptLevel(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getAppointmentEventMode() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getAppointmentEventMode(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setAppointmentEventMode(int n) {
        return this.setAppointmentEventMode(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getAppointmentDefaultLength() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getAppointmentDefaultLength(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setAppointmentDefaultLength(int n) {
        return this.setAppointmentDefaultLength(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getAppointmentAlarmSet() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getAppointmentAlarmSet(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setAppointmentAlarmSet(boolean bl) {
        return this.setAppointmentAlarmSet(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getAppointmentAlarmMinutes() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getAppointmentAlarmMinutes(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setAppointmentAlarmMinutes(int n) {
        return this.setAppointmentAlarmMinutes(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getAllDayEventAlarmSet() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getAllDayEventAlarmSet(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setAllDayEventAlarmSet(boolean bl) {
        return this.setAllDayEventAlarmSet(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getAllDayEventAlarmMinutes() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getAllDayEventAlarmMinutes(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setAllDayEventAlarmMinutes(int n) {
        return this.setAllDayEventAlarmMinutes(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getCalendarWorkDayStartTime() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getCalendarWorkDayStartTime(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setCalendarWorkDayStartTime(int n) {
        return this.setCalendarWorkDayStartTime(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getCalendarWorkDayEndTime() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getCalendarWorkDayEndTime(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setCalendarWorkDayEndTime(int n) {
        return this.setCalendarWorkDayEndTime(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getCalendarWorkDayTimeZoneID() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            String string = this.getCalendarWorkDayTimeZoneID(this.pGWSettings);
            settingsValue = new SettingsValue(string, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setCalendarWorkDayTimeZoneID(String string) {
        return this.setCalendarWorkDayTimeZoneID(this.pGWSettings, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getCalendarWorkDays() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getCalendarWorkDays(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setCalendarWorkDays(int n) {
        return this.setCalendarWorkDays(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getBusySearchRange() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getBusySearchRange(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setBusySearchRange(int n) {
        return this.setBusySearchRange(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getBusySearchStartMinutes() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getBusySearchStartMinutes(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setBusySearchStartMinutes(int n) {
        return this.setBusySearchStartMinutes(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getBusySearchEndMinutes() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getBusySearchEndMinutes(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setBusySearchEndMinutes(int n) {
        return this.setBusySearchEndMinutes(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getBusySearchDays() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getBusySearchDays(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setBusySearchDays(int n) {
        return this.setBusySearchDays(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getBusySearchPublishFreebusy() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getBusySearchPublishFreebusy(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setBusySearchPublishFreebusy(boolean bl) {
        return this.setBusySearchPublishFreebusy(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getBusySearchPublishFreebusyURL() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            String string = this.getBusySearchPublishFreebusyURL(this.pGWSettings);
            settingsValue = new SettingsValue(string, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getDateTimeFormatTimeDefault() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            String string = this.getDateTimeFormatTimeDefault(this.pGWSettings);
            settingsValue = new SettingsValue(string, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setDateTimeFormatTimeDefault(String string) {
        return this.setDateTimeFormatTimeDefault(this.pGWSettings, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getDateTimeFormatDateDefault() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            String string = this.getDateTimeFormatDateDefault(this.pGWSettings);
            settingsValue = new SettingsValue(string, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setDateTimeFormatDateDefault(String string) {
        return this.setDateTimeFormatDateDefault(this.pGWSettings, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getDateTimeFormatMainWindowDefault() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            String string = this.getDateTimeFormatMainWindowDefault(this.pGWSettings);
            settingsValue = new SettingsValue(string, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setDateTimeFormatMainWindowDefault(String string) {
        return this.setDateTimeFormatMainWindowDefault(this.pGWSettings, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getDateTimeFormatPropertiesDefault() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            String string = this.getDateTimeFormatPropertiesDefault(this.pGWSettings);
            settingsValue = new SettingsValue(string, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setDateTimeFormatPropertiesDefault(String string) {
        return this.setDateTimeFormatPropertiesDefault(this.pGWSettings, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getDateTimeFormatFileInfoDefault() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            String string = this.getDateTimeFormatFileInfoDefault(this.pGWSettings);
            settingsValue = new SettingsValue(string, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setDateTimeFormatInfoDefault(String string) {
        return this.setDateTimeFormatInfoDefault(this.pGWSettings, string);
    }

    public void syncWithDatabase() {
        this.syncWithDatabase(this.pGWSettings);
    }

    public synchronized SendOptionSecurity getSendOptionSecurityClassification() {
        this.tmpSecurity = 100;
        this.tmpSecurityLocked = false;
        this.tmpSecurityDisplayText = null;
        if (this.getSendOptionSecurityClassification(this.pGWSettings)) {
            return new SendOptionSecurity(this.tmpSecurity, this.tmpSecurityLocked, this.tmpSecurityDisplayText);
        }
        return null;
    }

    public boolean setSendOptionSecurityClassification(int n, String string) {
        return this.setSendOptionSecurityClassification(this.pGWSettings, n, string);
    }

    public synchronized SendOptionPriority getSendOptionPriority() {
        this.tmpPriority = 2;
        this.tmpPriorityLocked = false;
        if (this.getSendOptionPriority(this.pGWSettings)) {
            return new SendOptionPriority(this.tmpPriority, this.tmpPriorityLocked);
        }
        return null;
    }

    public boolean setSendOptionPriority(int n) {
        return this.setSendOptionPriority(this.pGWSettings, n);
    }

    public synchronized SendOptionReplyRequested getSendOptionReplyRequested() {
        this.tmpReplyRequest = false;
        this.tmpReplyRequestLocked = false;
        this.tmpReplyWhenConvenient = false;
        this.tmpReplyWithinDays = 0;
        if (this.getSendOptionReplyRequest(this.pGWSettings)) {
            return new SendOptionReplyRequested(this.tmpReplyRequest, this.tmpReplyRequestLocked, this.tmpReplyWhenConvenient, this.tmpReplyWithinDays);
        }
        return null;
    }

    public boolean setSendOptionReplyRequested(boolean bl, boolean bl2, int n) {
        return this.setSendOptionReplyRequest(this.pGWSettings, bl, bl2, n);
    }

    public boolean setSendOptionMimeEncoding(int n) {
        return this.setSendOptionMimeEncoding(this.pGWSettings, n);
    }

    public synchronized SendOptionMimeEncoding getSendOptionMimeEncoding() {
        this.tmpMimeEncoding = 2;
        this.tmpMimeEncodingLocked = false;
        if (this.getSendOptionMimeEncoding(this.pGWSettings)) {
            return new SendOptionMimeEncoding(this.tmpMimeEncoding, this.tmpMimeEncodingLocked);
        }
        return null;
    }

    public synchronized SendOptionNotification getSendOptionReturnNotification(int n, int n2) {
        this.tmpMailNotification = false;
        this.tmpNotification = false;
        this.tmpNotificationLocked = false;
        if (this.getSendOptionReturnNotification(this.pGWSettings, n, n2)) {
            return new SendOptionNotification(this.tmpMailNotification, this.tmpNotification, this.tmpNotificationLocked);
        }
        return null;
    }

    public boolean setSendOptionReturnNotification(int n, int n2, boolean bl, boolean bl2) {
        return this.setSendOptionReturnNotification(this.pGWSettings, n, n2, bl, bl2);
    }

    public boolean setSendOptionReturnNotification(int n, int[] nArray, boolean[] blArray, boolean[] blArray2) {
        int n2 = nArray.length;
        if (blArray.length < n2) {
            n2 = blArray.length;
        }
        if (blArray2.length < n2) {
            n2 = blArray2.length;
        }
        return this.setSendOptionReturnNotifications(this.pGWSettings, n, n2, nArray, blArray, blArray2);
    }

    public synchronized CleanupOptions getCleanupOption() {
        this.tmpnMailAndPhone = 0;
        this.tmpbMailAndPhoneLocked = false;
        this.tmpnMailAndPhoneDays = 0;
        this.tmpbMailAndPhoneDaysLocked = false;
        this.tmpnCalItem = 0;
        this.tmpbCalItemLocked = false;
        this.tmpnCalItemDays = 0;
        this.tmpbCalItemDaysLocked = false;
        this.tmpnTrash = 0;
        this.tmpbTrashLocked = false;
        this.tmpnTrashDays = 0;
        this.tmpbTrashDaysLocked = false;
        if (this.getCleanupOptions(this.pGWSettings)) {
            return new CleanupOptions(this.tmpnMailAndPhone, this.tmpbMailAndPhoneLocked, this.tmpnMailAndPhoneDays, this.tmpbMailAndPhoneDaysLocked, this.tmpnCalItem, this.tmpbCalItemLocked, this.tmpnCalItemDays, this.tmpbCalItemDaysLocked, this.tmpnTrash, this.tmpbTrashLocked, this.tmpnTrashDays, this.tmpbTrashDaysLocked);
        }
        return null;
    }

    public boolean setCleanupOptions(Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6) {
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        if (n != null) {
            n7 = n;
        }
        if (n2 != null) {
            n8 = n2;
        }
        if (n3 != null) {
            n9 = n3;
        }
        if (n4 != null) {
            n10 = n4;
        }
        if (n5 != null) {
            n11 = n5;
        }
        if (n6 != null) {
            n12 = n6;
        }
        return this.setCleanupOptions(this.pGWSettings, n7, n8, n9, n10, n11, n12);
    }

    public String getArchivePath() {
        String string = this.getArchivePath(this.pGWSettings);
        return string;
    }

    public boolean setArchivePath(File file) {
        if (file == null) {
            return this.setArchivePath(this.pGWSettings, "");
        }
        return this.setArchivePath(file.getPath());
    }

    public boolean setArchivePath(String string) {
        if (string == null) {
            return this.setArchivePath(this.pGWSettings, "");
        }
        return this.setArchivePath(this.pGWSettings, string);
    }

    public synchronized SecurityPasswordOptions getSecurityPasswordOptions() {
        this.tmpbIsCASASSOAvailable = false;
        this.tmpbIsCASASSOSet = false;
        this.tmpbIsCASASSOLocked = false;
        this.tmpbIsRememberPasswordSet = false;
        this.tmpbIsRememberPasswordLocked = false;
        if (this.getSecurityPasswordOptions(this.pGWSettings)) {
            return new SecurityPasswordOptions(this.tmpbIsCASASSOAvailable, this.tmpbIsCASASSOSet, this.tmpbIsCASASSOLocked, this.tmpbIsRememberPasswordSet, this.tmpbIsRememberPasswordLocked);
        }
        return null;
    }

    public boolean setSecurityPasswordOptions(String string, String string2, Boolean bl, Boolean bl2) throws EngineException {
        int n = -1;
        int n2 = -1;
        if (bl != null) {
            int n3 = n = bl == true ? 1 : 0;
        }
        if (bl2 != null) {
            n2 = bl2 == true ? 1 : 0;
        }
        return this.setSecurityPasswordOptions(this.pGWSettings, string, string2, n, n2);
    }

    public boolean canClearPassword() {
        return this.canClearPassword(this.pGWSettings);
    }

    public boolean clearPassword(String string) throws EngineException {
        return this.clearPassword(this.pGWSettings, string);
    }

    public boolean isPasswordSet() {
        boolean bl = this.isPasswordSet(this.pGWSettings);
        return bl;
    }

    public boolean validatePassword(String string) {
        return this.validatePassword(this.pGWSettings, string);
    }

    public int getBackupInterval() {
        return this.getBackupInterval(this.pGWSettings);
    }

    public void setBackupInterval(int n) {
        this.setBackupInterval(this.pGWSettings, n);
    }

    public String getBackupLocation() {
        return this.getBackupLocation(this.pGWSettings);
    }

    public boolean setBackupLocation(String string) {
        return this.setBackupLocation(this.pGWSettings, string);
    }

    public Color getGWColor(int n) {
        int n2 = this.getGWColor(this.pGWSettings, n);
        return EngineUtils.toColor(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SettingsValue getUseGWColorSchemes() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getUseGWColorSchemes(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    private boolean setUseGWColorSchemes(boolean bl) {
        return this.setUseGWColorSchemes(this.pGWSettings, bl);
    }

    public int getGWColorScheme() {
        return this.getGWColorScheme(this.pGWSettings);
    }

    public void setGWColorScheme(int n) {
        this.setUseGWColorSchemes(true);
        this.setGWColorScheme(this.pGWSettings, n);
    }

    public void getHeaderSettings() {
        this.getHeaderSettings(this.pGWSettings);
    }

    public void setHeaderSettings() {
        this.setHeaderSettings(this.pGWSettings);
    }

    public boolean getHeaderBackColorSet() {
        return this.getHeaderBackColorSet(this.pGWSettings);
    }

    public void setHeaderBackColorSet(boolean bl) {
        this.setHeaderBackColorSet(this.pGWSettings, bl);
    }

    public Color getHeaderBackColor() {
        int n = this.getHeaderBackColor(this.pGWSettings);
        return EngineUtils.toColor(n);
    }

    public void setHeaderBackColor(Color color) {
        this.setHeaderBackColor(this.pGWSettings, EngineUtils.toGWRGBColor(color));
    }

    public boolean getHeaderTextColorSet() {
        return this.getHeaderTextColorSet(this.pGWSettings);
    }

    public void setHeaderTextColorSet(boolean bl) {
        this.setHeaderTextColorSet(this.pGWSettings, bl);
    }

    public Color getHeaderTextColor() {
        int n = this.getHeaderTextColor(this.pGWSettings);
        return EngineUtils.toColor(n);
    }

    public void setHeaderTextColor(Color color) {
        this.setHeaderTextColor(this.pGWSettings, EngineUtils.toGWRGBColor(color));
    }

    public boolean getPanelBackColorSet() {
        return this.getPanelBackColorSet(this.pGWSettings);
    }

    public void setPanelBackColorSet(boolean bl) {
        this.setPanelBackColorSet(this.pGWSettings, bl);
    }

    public Color getPanelBackColor() {
        int n = this.getPanelBackColor(this.pGWSettings);
        return EngineUtils.toColor(n);
    }

    public void setPanelBackColor(Color color) {
        this.setPanelBackColor(this.pGWSettings, EngineUtils.toGWRGBColor(color));
    }

    public boolean getPanelTextColorSet() {
        return this.getPanelTextColorSet(this.pGWSettings);
    }

    public void setPanelTextColorSet(boolean bl) {
        this.setPanelTextColorSet(this.pGWSettings, bl);
    }

    public Color getPanelTextColor() {
        int n = this.getPanelTextColor(this.pGWSettings);
        return EngineUtils.toColor(n);
    }

    public void setPanelTextColor(Color color) {
        this.setPanelTextColor(this.pGWSettings, EngineUtils.toGWRGBColor(color));
    }

    public boolean getNavBarTextColorSet() {
        return this.getNavBarTextColorSet(this.pGWSettings);
    }

    public void setNavBarTextColorSet(boolean bl) {
        this.setNavBarTextColorSet(this.pGWSettings, bl);
    }

    public Color getNavBarTextColor() {
        int n = this.getNavBarTextColor(this.pGWSettings);
        return EngineUtils.toColor(n);
    }

    public void setNavBarTextColor(Color color) {
        this.setNavBarTextColor(this.pGWSettings, EngineUtils.toGWRGBColor(color));
    }

    public int getHeaderFontSize() {
        return this.getHeaderFontSize(this.pGWSettings);
    }

    public void setHeaderFontSize(int n) {
        this.setHeaderFontSize(this.pGWSettings, n);
    }

    public int getPanelFontSize() {
        return this.getPanelFontSize(this.pGWSettings);
    }

    public void setPanelFontSize(int n) {
        this.setPanelFontSize(this.pGWSettings, n);
    }

    public int getNavBarFontSize() {
        return this.getNavBarFontSize(this.pGWSettings);
    }

    public void setNavBarFontSize(int n) {
        this.setNavBarFontSize(this.pGWSettings, n);
    }

    public int getHeaderParentFontSize() {
        return this.getHeaderParentFontSize(this.pGWSettings);
    }

    public void setHeaderParentFontSize(int n) {
        this.setHeaderParentFontSize(this.pGWSettings, n);
    }

    public boolean getHeaderParentBackColorSet() {
        return this.getHeaderParentBackColorSet(this.pGWSettings);
    }

    public void setHeaderParentBackColorSet(boolean bl) {
        this.setHeaderParentBackColorSet(this.pGWSettings, bl);
    }

    public Color getHeaderParentBackColor() {
        int n = this.getHeaderParentBackColor(this.pGWSettings);
        return EngineUtils.toColor(n);
    }

    public void setHeaderParentBackColor(Color color) {
        this.setHeaderParentBackColor(this.pGWSettings, EngineUtils.toGWRGBColor(color));
    }

    public boolean getHeaderParentTextColorSet() {
        return this.getHeaderParentTextColorSet(this.pGWSettings);
    }

    public void setHeaderParentTextColorSet(boolean bl) {
        this.setHeaderParentTextColorSet(this.pGWSettings, bl);
    }

    public Color getHeaderParentTextColor() {
        int n = this.getHeaderParentTextColor(this.pGWSettings);
        return EngineUtils.toColor(n);
    }

    public void setHeaderParentTextColor(Color color) {
        this.setHeaderParentTextColor(this.pGWSettings, EngineUtils.toGWRGBColor(color));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getDisableAutoSave() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getDisableAutoSave(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setDisableAutoSave(boolean bl) {
        return this.setDisableAutoSave(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getReadNextOnDelete() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getReadNextOnDelete(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setReadNextOnDelete(boolean bl) {
        return this.setReadNextOnDelete(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getRefreshPollInterval() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getRefreshPollInterval(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public void setRefreshPollInterval(int n) {
        this.setRefreshPollInterval(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getNewTasklistItemType() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getNewTasklistItemType(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setNewTasklistItemType(int n) {
        return this.setNewTasklistItemType(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getShowMainMenu() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getShowMainMenu(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setShowMainMenu(boolean bl) {
        return this.setShowMainMenu(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getShowNavBar() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getShowNavBar(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setShowNavBar(boolean bl) {
        return this.setShowNavBar(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getShowMainToolBar() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getShowMainToolBar(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setShowMainToolBar(boolean bl) {
        return this.setShowMainToolBar(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getShowFolderTree() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getShowFolderTree(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setShowFolderTree(boolean bl) {
        return this.setShowFolderTree(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getShowFolderTreeLong() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getShowFolderTreeLong(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setShowFolderTreeLong(boolean bl) {
        return this.setShowFolderTreeLong(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getShowQuickViewer() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getShowQuickViewer(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setShowQuickViewer(boolean bl) {
        return this.setShowQuickViewer(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getQuickViewerPosition() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            int n = this.getQuickViewerPosition(this.pGWSettings);
            settingsValue = new SettingsValue(n, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setQuickViewerPosition(int n) {
        return this.setQuickViewerPosition(this.pGWSettings, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getCheckSpellingBeforeSend() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getCheckSpellingBeforeSend(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setCheckSpellingBeforeSend(boolean bl) {
        return this.setCheckSpellingBeforeSend(this.pGWSettings, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsValue getCheckSpellingAsYouType() {
        SettingsValue settingsValue;
        Object object = this.jniSyncLock;
        synchronized (object) {
            this.tmpbIsLocked = false;
            boolean bl = this.getCheckSpellingAsYouType(this.pGWSettings);
            settingsValue = new SettingsValue(bl, this.tmpbIsLocked);
        }
        return settingsValue;
    }

    public boolean setCheckSpellingAsYouType(boolean bl) {
        return this.setCheckSpellingAsYouType(this.pGWSettings, bl);
    }

    public void dispose() {
        if (this.pGWSettings != 0) {
            this.dispose(this.pGWSettings);
            this.pGWSettings = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    static {
        DataStoreSettings.initIds();
    }

    public class SecurityPasswordOptions {
        private boolean bIsCASASSOAvailable;
        private boolean bIsCASASSOSet;
        private boolean bIsCASASSOLocked;
        private boolean bIsRememberPasswordSet;
        private boolean bIsRememberPasswordLocked;

        public SecurityPasswordOptions(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            this.bIsCASASSOAvailable = bl;
            this.bIsCASASSOSet = bl2;
            this.bIsCASASSOLocked = bl3;
            this.bIsRememberPasswordSet = bl4;
            this.bIsRememberPasswordLocked = bl5;
        }

        public boolean isCASASSOAvailable() {
            return this.bIsCASASSOAvailable;
        }

        public boolean isCASASSOSet() {
            return this.bIsCASASSOSet;
        }

        public boolean isCASASSOLocked() {
            return this.bIsCASASSOLocked;
        }

        public boolean isRememberPasswordSet() {
            return this.bIsRememberPasswordSet;
        }

        public boolean isRememberPasswordLocked() {
            return this.bIsRememberPasswordLocked;
        }
    }

    public class CleanupOptions {
        private int nMailAndPhone;
        private boolean bMailAndPhoneLocked;
        private int nMailAndPhoneDays;
        private boolean bMailAndPhoneDaysLocked;
        private int nCalItem;
        private boolean bCalItemLocked;
        private int nCalItemDays;
        private boolean bCalItemDaysLocked;
        private int nTrash;
        private boolean bTrashLocked;
        private int nTrashDays;
        private boolean bTrashDaysLocked;

        CleanupOptions(int n, boolean bl, int n2, boolean bl2, int n3, boolean bl3, int n4, boolean bl4, int n5, boolean bl5, int n6, boolean bl6) {
            this.nMailAndPhone = n;
            this.bMailAndPhoneLocked = bl;
            this.nMailAndPhoneDays = n2;
            this.bMailAndPhoneDaysLocked = bl2;
            this.nCalItem = n3;
            this.bCalItemLocked = bl3;
            this.nCalItemDays = n4;
            this.bCalItemDaysLocked = bl4;
            this.nTrash = n5;
            this.bTrashLocked = bl5;
            this.nTrashDays = n6;
            this.bTrashDaysLocked = bl6;
        }

        public int getMailAndPhone() {
            return this.nMailAndPhone;
        }

        public boolean isMailAndPhoneLocked() {
            return this.bMailAndPhoneLocked;
        }

        public int getMailAndPhoneDays() {
            return this.nMailAndPhoneDays;
        }

        public boolean isMailAndPhoneDaysLocked() {
            return this.bMailAndPhoneDaysLocked;
        }

        public int getCalItem() {
            return this.nCalItem;
        }

        public boolean isCalItemLocked() {
            return this.bCalItemLocked;
        }

        public int getCalItemDays() {
            return this.nCalItemDays;
        }

        public boolean isCalItemDaysLocked() {
            return this.bCalItemDaysLocked;
        }

        public int getTrash() {
            return this.nTrash;
        }

        public boolean isTrashLocked() {
            return this.bTrashLocked;
        }

        public int getTrashDays() {
            return this.nTrashDays;
        }

        public boolean isTrashDaysLocked() {
            return this.bTrashDaysLocked;
        }
    }

    public class SendOptionNotification {
        private boolean mailNotification;
        private boolean notification;
        private boolean notificationLocked;

        SendOptionNotification(boolean bl, boolean bl2, boolean bl3) {
            this.mailNotification = bl;
            this.notification = bl2;
            this.notificationLocked = bl3;
        }

        public boolean isMailNotificationSet() {
            return this.mailNotification;
        }

        public boolean isNotificationSet() {
            return this.notification;
        }

        public boolean isNotificationLocked() {
            return this.notificationLocked;
        }
    }

    public class SendOptionReplyRequested {
        private boolean replyRequest;
        private boolean replyRequestLocked;
        private boolean replyWhenConvenient;
        private int replyWithinDays;

        SendOptionReplyRequested(boolean bl, boolean bl2, boolean bl3, int n) {
            this.replyRequest = bl;
            this.replyRequestLocked = bl2;
            this.replyWhenConvenient = bl3;
            this.replyWithinDays = n;
        }

        public boolean isReplyRequested() {
            return this.replyRequest;
        }

        public boolean isReplyRequestedLocked() {
            return this.replyRequestLocked;
        }

        public boolean isReplyWhenConvenient() {
            return this.replyWhenConvenient;
        }

        public int getReplyWithinDays() {
            return this.replyWithinDays;
        }
    }

    public class SendOptionPriority {
        private int priority;
        private boolean priorityLocked;

        SendOptionPriority(int n, boolean bl) {
            this.priority = n;
            this.priorityLocked = bl;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean getPriorityLocked() {
            return this.priorityLocked;
        }
    }

    public class SendOptionSecurity {
        private int security;
        private boolean securityLocked;
        private String securityDisplayText;

        SendOptionSecurity(int n, boolean bl, String string) {
            this.security = n;
            this.securityLocked = bl;
            this.securityDisplayText = string;
        }

        public int getSecurityLevel() {
            return this.security;
        }

        public boolean getSecurityLocked() {
            return this.securityLocked;
        }

        public String getSecurityDisplayText() {
            return this.securityDisplayText;
        }
    }

    public class SignatureOptions {
        private boolean signatureOn;
        private int signatureStatus;
        private String signatureText;
        private boolean vCardOn;
        private String vCardFileName;

        SignatureOptions(boolean bl, int n, String string, boolean bl2, String string2) {
            this.signatureOn = bl;
            this.signatureStatus = n;
            this.signatureText = string;
            this.vCardOn = bl2;
            this.vCardFileName = string2;
        }

        public boolean isSignatureOn() {
            return this.signatureOn;
        }

        public int getSignatureStatus() {
            return this.signatureStatus;
        }

        public String getSignatureText() {
            return this.signatureText;
        }

        public boolean isVCardOn() {
            return this.vCardOn;
        }

        public String getVCardFileName() {
            return this.vCardFileName;
        }
    }

    public class SendOptionMimeEncoding {
        private int mimeEncoding;
        private boolean mimeEncodingLocked;

        SendOptionMimeEncoding(int n, boolean bl) {
            this.mimeEncoding = n;
            this.mimeEncodingLocked = bl;
        }

        public boolean isMimeEncodingLocked() {
            return this.mimeEncodingLocked;
        }

        public int getMimeEncoding() {
            return this.mimeEncoding;
        }
    }
}

