/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.EngineCallback;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.LoginParameters;
import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.util.Debug;
import java.awt.Toolkit;
import java.nio.charset.Charset;
import java.util.EventListener;
import java.util.TimeZone;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class Engine {
    public static final int MODE_NONE = 0;
    public static final int MODE_ONLINE = 1;
    public static final int MODE_CACHING = 6;
    public static final int MODE_REMOTE = 3;
    public static final int LOGIN_PROMPT_IF_NECESSARY = 0;
    public static final int LOGIN_PROMPT_NEVER = 1;
    public static final int LOGIN_PROMPT_PASSWORD = 2;
    private static Engine engine;
    private static int pGWLogin;
    private static EventListenerList urlListeners;
    private static String initUrl;
    private final boolean bigEndian;
    private final Charset charset;
    private String sVersionName;
    private String sJarVersion;
    private int iProductBuildNumber = 0;
    private int pCallback = 0;

    private static native int parseCommandLine(int var0, String var1);

    public static Engine getInstance() {
        if (engine == null) {
            engine = new Engine();
        }
        return engine;
    }

    public static LoginParameters parseCommandLine(String[] stringArray) {
        LoginParameters loginParameters = null;
        if (stringArray != null && stringArray.length > 0) {
            int n;
            String string = stringArray[0];
            for (n = 1; n < stringArray.length; ++n) {
                string = string + " " + stringArray[n];
            }
            n = Engine.parseCommandLine(pGWLogin, string);
            loginParameters = new LoginParameters(n);
        } else {
            loginParameters = new LoginParameters(0);
        }
        return loginParameters;
    }

    static EngineException createException(int n, String string) {
        return EngineException.create(n, string);
    }

    static void openUrl(String string) {
        final Object[] objectArray = urlListeners.getListenerList();
        if (objectArray.length > 0) {
            final String string2 = string;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Engine.doOpenUrl(objectArray, string2);
                }
            });
        } else if (initUrl == null) {
            initUrl = string;
        }
    }

    public static void addUrlListener(UrlListener urlListener) {
        urlListeners.add(UrlListener.class, urlListener);
        if (initUrl != null && initUrl.length() > 0) {
            Engine.openUrl(initUrl);
            initUrl = "";
        }
    }

    public static void removeUrlListener(UrlListener urlListener) {
        urlListeners.remove(UrlListener.class, urlListener);
    }

    private static void doOpenUrl(Object[] objectArray, String string) {
        for (int i = 1; i < objectArray.length; i += 2) {
            UrlListener urlListener = (UrlListener)objectArray[i];
            urlListener.openUrl(string);
        }
    }

    private native void cancelSync(int var1);

    private native boolean canDispose(int var1);

    private native void dispose(int var1);

    private native String getResourceString(int var1, int var2);

    private native int setCallback(int var1, EngineCallback var2);

    private native String getPathToCache(int var1);

    private native String getInstallLibPath(int var1);

    private native void setPathToCache(int var1, String var2);

    private native String getPathToRemote(int var1);

    private native void setPathToRemote(int var1, String var2);

    private native int switchMode(int var1, int var2);

    private native boolean canSwitchMode(int var1, int var2);

    private native void setTimeZoneInfo(String var1, String var2, String var3);

    private native int loginCaching(int var1, String var2, String var3);

    private native int loginOnline(int var1, String var2, int var3, String var4, String var5);

    private native int loginOnline(int var1, String var2, String var3, String var4);

    private native int loginRemote(int var1, String var2, String var3);

    private native int login(int var1, int var2, int var3) throws EngineException;

    private native int relogin(int var1) throws EngineException;

    private native int getProxyDataStore(int var1, String var2, String var3) throws EngineException;

    private native int init();

    private native boolean isBigEndian(int var1);

    private native boolean isSSLActive(int var1);

    private native String getProductVersion(int var1);

    private native String getProductVersionName(int var1);

    private native int getProductBuildNumber(int var1);

    private native void disposeCallback(int var1);

    private Engine() {
        pGWLogin = this.init();
        TimeZone timeZone = TimeZone.getDefault();
        this.setTimeZoneInfo(timeZone.getID(), timeZone.getDisplayName(false, 1), timeZone.getDisplayName(true, 1));
        this.bigEndian = this.isBigEndian(pGWLogin);
        this.charset = this.bigEndian ? Charset.forName("UTF-16BE") : Charset.forName("UTF-16LE");
    }

    public void cancelSync() {
        this.cancelSync(pGWLogin);
    }

    public boolean canDispose() {
        boolean bl = this.canDispose(pGWLogin);
        return bl;
    }

    public void dispose() {
        if (pGWLogin != 0) {
            this.dispose(pGWLogin);
            pGWLogin = 0;
        }
        if (this.pCallback != 0) {
            this.disposeCallback(this.pCallback);
            this.pCallback = 0;
        }
    }

    public String getResourceString(int n) {
        String string = this.getResourceString(pGWLogin, n);
        return string;
    }

    public void setCallback(EngineCallback engineCallback) {
        if (this.pCallback != 0) {
            this.disposeCallback(this.pCallback);
        }
        this.pCallback = this.setCallback(pGWLogin, engineCallback);
    }

    public String getPathToCache() {
        String string = this.getPathToCache(pGWLogin);
        return string;
    }

    public String getInstallLibPath() {
        String string = this.getInstallLibPath(pGWLogin);
        return string;
    }

    public void setPathToCache(String string) {
        this.setPathToCache(pGWLogin, string);
    }

    public String getPathToRemote() {
        String string = this.getPathToRemote(pGWLogin);
        return string;
    }

    public void setPathToRemote(String string) {
        this.setPathToRemote(pGWLogin, string);
    }

    public int switchMode(int n) {
        int n2 = this.switchMode(pGWLogin, n);
        return n2;
    }

    public boolean canSwitchMode(int n) {
        boolean bl = this.canSwitchMode(pGWLogin, n);
        return bl;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isSSLActive() {
        return this.isSSLActive(pGWLogin);
    }

    public String getProductVersionName() {
        if (this.sVersionName == null) {
            this.sVersionName = this.getProductVersionName(pGWLogin);
        }
        return this.sVersionName;
    }

    public String getGWAPIJarVersion() {
        if (this.sJarVersion == null) {
            String string = this.getClass().getPackage().getImplementationVersion();
            this.sJarVersion = string == null || string.equals("") ? "0" : string;
        }
        return this.sJarVersion;
    }

    public int getProductBuildNumber() {
        if (this.iProductBuildNumber == 0) {
            this.iProductBuildNumber = this.getProductBuildNumber(pGWLogin);
        }
        return this.iProductBuildNumber;
    }

    public DataStore loginOnline(String string, String string2, String string3, int n) throws EngineException {
        int n2 = this.loginOnline(pGWLogin, string3, n, string, string2);
        return new DataStore(n2);
    }

    public DataStore loginOnline(String string, String string2, String string3) throws EngineException {
        int n = this.loginOnline(pGWLogin, string3, string, string2);
        return new DataStore(n);
    }

    public DataStore loginCaching(String string, String string2) throws EngineException {
        int n = this.loginCaching(pGWLogin, string, string2);
        return new DataStore(n);
    }

    public DataStore loginRemote(String string, String string2) throws EngineException {
        int n = this.loginRemote(pGWLogin, string, string2);
        return new DataStore(n);
    }

    public DataStore login(LoginParameters loginParameters, int n) throws EngineException {
        DataStore dataStore = null;
        int n2 = loginParameters == null ? 0 : loginParameters.getPointer();
        int n3 = this.login(pGWLogin, n2, n);
        if (n3 != 0) {
            dataStore = new DataStore(n3);
        }
        return dataStore;
    }

    public DataStore relogin() throws EngineException {
        int n = this.relogin(pGWLogin);
        return new DataStore(n);
    }

    public DataStore getProxyDataStore(String string, String string2) throws EngineException {
        int n = this.getProxyDataStore(pGWLogin, string, string2);
        if (n == 0) {
            return null;
        }
        return new DataStore(n);
    }

    public DataStore getProxyDataStore(ProxyHistoryEntry proxyHistoryEntry) throws EngineException {
        return this.getProxyDataStore(proxyHistoryEntry.getEmailAddress(), proxyHistoryEntry.getGuid());
    }

    protected void finalize() throws Throwable {
        Debug.trace("Engine.finalize");
        this.dispose();
        super.finalize();
    }

    static {
        initUrl = null;
        urlListeners = new EventListenerList();
        Debug.trace("loading library: gwapijni");
        System.loadLibrary("gwapijni");
        if (System.getProperty("os.name").equals("Mac OS X")) {
            Toolkit.getDefaultToolkit().getScreenSize();
        }
    }

    public static interface UrlListener
    extends EventListener {
        public void openUrl(String var1);
    }
}

