/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import java.util.Locale;

public class EngineLocale {
    private static final EngineLocale[] suppLocales = new EngineLocale[]{new EngineLocale("en", "en", "US"), new EngineLocale("af", "af"), new EngineLocale("ar", "ar"), new EngineLocale("ca", "ca"), new EngineLocale("hr", "hr"), new EngineLocale("cz", "cs"), new EngineLocale("da", "da"), new EngineLocale("nl", "nl"), new EngineLocale("en", "en", "AU"), new EngineLocale("en", "en", "CA"), new EngineLocale("en", "en", "GB"), new EngineLocale("fa", "fa"), new EngineLocale("fi", "fi"), new EngineLocale("fr", "fr", "FR"), new EngineLocale("fr", "fr", "CA"), new EngineLocale("gl", "gl"), new EngineLocale("de", "de", "DE"), new EngineLocale("de", "de", "CH"), new EngineLocale("el", "el"), new EngineLocale("he", "he"), new EngineLocale("hu", "hu"), new EngineLocale("is", "is"), new EngineLocale("it", "it"), new EngineLocale("no", "no"), new EngineLocale("pl", "pl"), new EngineLocale("pt", "pt", "BR"), new EngineLocale("pt", "pt", "PT"), new EngineLocale("ru", "ru"), new EngineLocale("sk", "sk"), new EngineLocale("es", "es"), new EngineLocale("sv", "sv"), new EngineLocale("uk", "uk"), new EngineLocale("ur", "ur"), new EngineLocale("tr", "tr"), new EngineLocale("ja", "ja"), new EngineLocale("ko", "ko"), new EngineLocale("ct", "zh", "TW"), new EngineLocale("cs", "zh", "CN"), new EngineLocale("en", "en", "US"), new EngineLocale("et", "et"), new EngineLocale("lt", "lt"), new EngineLocale("lv", "lv"), new EngineLocale("th", "th")};
    private static EngineLocale currentLocale;
    private Locale locale;
    private String displayName;
    private String code;

    private static native String getLangCode();

    private static native String getAvailableLangs();

    private static native String getLangDisplayStr(String var0);

    public static EngineLocale[] getAvailableLocales() {
        String string = EngineLocale.getAvailableLangs();
        EngineLocale[] engineLocaleArray = new EngineLocale[string.length() / 2];
        for (int i = 0; i < engineLocaleArray.length; ++i) {
            int n = i * 2;
            String string2 = string.substring(n, n + 2);
            engineLocaleArray[i] = EngineLocale.getLocale(string2);
        }
        return engineLocaleArray;
    }

    public static EngineLocale getCurrent() {
        if (currentLocale == null) {
            String string = EngineLocale.getLangCode();
            currentLocale = EngineLocale.getLocale(string);
        }
        return currentLocale;
    }

    public static EngineLocale getLocale(String string) {
        if (string != null) {
            for (int i = 0; i < suppLocales.length; ++i) {
                EngineLocale engineLocale = suppLocales[i];
                if (!string.equalsIgnoreCase(engineLocale.getCode())) continue;
                return engineLocale;
            }
        }
        return suppLocales[0];
    }

    private EngineLocale(String string, String string2) {
        this(string, string2, "");
    }

    private EngineLocale(String string, String string2, String string3) {
        this.locale = new Locale(string2, string3, "");
        this.code = string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getCode() {
        return this.code;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = EngineLocale.getLangDisplayStr(this.code);
            if (this.displayName == null || this.displayName.length() == 0) {
                this.displayName = this.locale.getDisplayName();
            }
        }
        return this.displayName;
    }
}

