/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.ab.AddressBookItemList;
import com.novell.gw.engine.CategoryList;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.ItemListListener;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.util.Debug;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class ItemList {
    private int pGWItemList;
    private int pEvents = 0;
    private volatile Item[] items;
    private EventListenerList listenerList = new EventListenerList();

    private static native void initIds();

    private static native boolean isAddressBookList(int var0);

    public static ItemList createItemList(int n) {
        ItemList itemList = !ItemList.isAddressBookList(n) ? new ItemList(n) : new AddressBookItemList(n);
        return itemList;
    }

    private native int getThreadDepth(int var1, int var2);

    private native int getThreadDepthAt(int var1, int var2);

    private native boolean hasChildren(int var1, int var2);

    private native boolean hasChildrenAt(int var1, int var2);

    private native boolean hasUnreadItemInThread(int var1, int var2);

    private native boolean hasUnreadItemInThreadAt(int var1, int var2);

    private native boolean isCollapsed(int var1, int var2);

    private native boolean isCollapsedAt(int var1, int var2);

    private native boolean isCollapsedAutoDateItem(int var1, int var2);

    private native boolean isCollapsedAutoDateItemAt(int var1, int var2);

    private native boolean isRecurringEntry(int var1, int var2);

    private native boolean isRecurringEntryAt(int var1, int var2);

    private native boolean isRecurringEntryRoot(int var1, int var2);

    private native boolean isRecurringEntryRootAt(int var1, int var2);

    private native boolean isRootMost(int var1, int var2);

    private native boolean isRootMostAt(int var1, int var2);

    private native void expand(int var1, int var2);

    private native void expandAt(int var1, int var2);

    private native void collapse(int var1, int var2);

    private native void collapseAt(int var1, int var2);

    private native void expandAll(int var1);

    private native void collapseAll(int var1);

    private native boolean canMarkThreadIgnore(int var1);

    private native boolean canMarkThreadRead(int var1);

    private native boolean canMarkThreadWatch(int var1);

    private native boolean isThreadIgnored1(int var1);

    private native boolean isThreadIgnored2(int var1, int var2);

    private native boolean isThreadIgnored3(int var1, int var2);

    private native boolean isThreadWatched1(int var1);

    private native boolean isThreadWatched2(int var1, int var2);

    private native boolean isThreadWatched3(int var1, int var2);

    private native void markThreadIgnore(int var1);

    private native void markThreadRead(int var1);

    private native void markThreadWatch(int var1);

    private native boolean setSelection(int var1, int[] var2);

    private native boolean canDeleteItem(int var1, int var2);

    private native boolean canDeleteSelectedItems(int var1);

    private native boolean canDeleteItemAt(int var1, int var2);

    private native boolean canDeleteAndEmptyItem(int var1, int var2);

    private native boolean canDeleteAndEmptySelectedItems(int var1);

    private native boolean canDeleteAndEmptyItemAt(int var1, int var2);

    private native boolean canMarkItemPrivate(int var1, int var2);

    private native boolean canMarkSelectedItemsPrivate(int var1);

    private native boolean canMarkItemPrivateAt(int var1, int var2);

    private native boolean canMarkItemRead(int var1, int var2);

    private native boolean canMarkSelectedItemsRead(int var1);

    private native boolean canMarkItemReadAt(int var1, int var2);

    private native boolean canMarkItemReadLater(int var1, int var2);

    private native boolean canMarkSelectedItemsReadLater(int var1);

    private native boolean canMarkItemReadLaterAt(int var1, int var2);

    private native boolean canPurgeItem(int var1, int var2);

    private native boolean canPurgeSelectedItems(int var1);

    private native boolean canPurgeItemAt(int var1, int var2);

    private native boolean canRestoreItem(int var1, int var2);

    private native boolean canRestoreSelectedItems(int var1);

    private native boolean canRestoreItemAt(int var1, int var2);

    private native boolean canUndeleteItem(int var1, int var2);

    private native boolean canUndeleteSelectedItems(int var1);

    private native boolean canUndeleteItemAt(int var1, int var2);

    private native boolean deleteItem(int var1, int var2);

    private native boolean deleteSelectedItems(int var1);

    private native boolean deleteItemAt(int var1, int var2);

    private native boolean deleteAndEmptyItem(int var1, int var2);

    private native boolean deleteAndEmptySelectedItems(int var1);

    private native boolean deleteAndEmptyItemAt(int var1, int var2);

    private native boolean undeleteItem(int var1, int var2);

    private native boolean undeleteSelectedItems(int var1);

    private native boolean undeleteItemAt(int var1, int var2);

    private native void markAllItemsRead(int var1);

    private native boolean markItemPrivate(int var1, int var2);

    private native boolean markSelectedItemsPrivate(int var1);

    private native boolean markItemPrivateAt(int var1, int var2);

    private native boolean markItemRead(int var1, int var2);

    private native boolean markSelectedItemsRead(int var1);

    private native boolean markItemReadAt(int var1, int var2);

    private native boolean markItemReadLater(int var1, int var2);

    private native boolean markSelectedItemsReadLater(int var1);

    private native boolean markItemReadLaterAt(int var1, int var2);

    private native boolean purgeItem(int var1, int var2);

    private native boolean purgeSelectedItems(int var1);

    private native boolean purgeItemAt(int var1, int var2);

    private native boolean restoreItem(int var1, int var2);

    private native boolean restoreSelectedItems(int var1);

    private native boolean restoreItemAt(int var1, int var2);

    private native boolean canChecklistMoveDown(int var1, int var2);

    private native boolean canChecklistMoveUp(int var1, int var2);

    private native boolean canChecklistMoveToBottom(int var1, int var2);

    private native boolean canChecklistMoveToTop(int var1, int var2);

    private native boolean canChecklistMoveLeft(int var1, int var2);

    private native boolean canChecklistMoveRight(int var1, int var2);

    private native boolean canCreateChecklistItem(int var1);

    private native boolean canCreateChecklistSubItemAt(int var1, int var2);

    private native boolean canCreateChecklistSubItemAtSelection(int var1);

    private native boolean checklistMoveDown(int var1, int var2);

    private native boolean checklistMoveUp(int var1, int var2);

    private native boolean checklistMoveToBottom(int var1, int var2);

    private native boolean checklistMoveToTop(int var1, int var2);

    private native boolean checklistMoveLeft(int var1, int var2);

    private native boolean checklistMoveRight(int var1, int var2);

    private native boolean checklistMoveTo(int var1, int var2, int var3, boolean var4);

    private native boolean createChecklistItem(int var1, String var2, int var3, int var4, int var5);

    private native int getTransferItems(int var1, int[] var2);

    private native boolean transferToTasklist(int var1, int var2, int var3, boolean var4, boolean var5);

    private native boolean canMoveSelectionToChecklist(int var1);

    private native boolean canShowSelectionInChecklist(int var1);

    private native boolean isSelectionInChecklist(int var1);

    private native boolean moveSelectionToChecklist(int var1);

    private native boolean showSelectionInChecklist(int var1, boolean var2);

    private native int findLastUncompletedChecklistItemIndex(int var1);

    private native boolean hasTaskListItemsOnly(int var1);

    private native int handleJunkMailSelectedItems(int var1, int var2);

    private native int canHandleJunkMailSelectedItems(int var1, int var2);

    private native int[] getCalendarItemsAll(int var1, long var2);

    private native int[] getCalendarItemsAll2(int var1, long var2, long var4);

    private native int[] getCalendarItemsTypes(int var1, long var2, int var4);

    private native int[] getCalendarItemsTypes2(int var1, long var2, long var4, int var6);

    private native int[] getAllDayEvents(int var1, long var2);

    private native int[] getAllDayEvents2(int var1, long var2, long var4);

    private native int[] getAppointments(int var1, long var2);

    private native int[] getAppointments2(int var1, long var2, long var4);

    private native int[] getNotes(int var1, long var2);

    private native int[] getNotes2(int var1, long var2, long var4);

    private native int[] getTasks(int var1, long var2);

    private native int[] getTasks2(int var1, long var2, long var4);

    private native int getMonthBusyDays(int var1, int var2, int var3, int var4);

    private native void dispose(int var1, int var2);

    private native int getFirstUnreadItem(int var1, boolean var2);

    private native int getItemAt(int var1, int var2);

    private native int getDisplayItemCount(int var1);

    private native int getSize(int var1);

    private native int subscribeToEvents(int var1);

    private native boolean queryStop(int var1);

    private native boolean setFilter(int var1, int var2);

    private native void sabPreScrollAction(int var1);

    private native int getSortField(int var1);

    private native boolean isSortAscending(int var1);

    private native boolean sort(int var1, int var2, boolean var3, boolean var4);

    private native int indexOf(int var1, int var2);

    private native int indexOf(int var1, String var2, int var3);

    private native boolean canSetCategoriesOnSelection(int var1);

    private native void setCategories(int var1, int var2, int[] var3);

    protected ItemList(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWItemList = n;
        int n2 = this.getSize(n);
        this.items = new Item[n2];
        this.pEvents = this.subscribeToEvents(n);
    }

    public int getPointer() {
        return this.pGWItemList;
    }

    protected ItemList() {
        this.items = new Item[0];
    }

    public void addItemListListener(ItemListListener itemListListener) {
        this.listenerList.add(ItemListListener.class, itemListListener);
    }

    public void removeItemListListener(ItemListListener itemListListener) {
        this.listenerList.remove(ItemListListener.class, itemListListener);
    }

    public void sort(int n, boolean bl) {
        this.sort(this.pGWItemList, n, bl, false);
    }

    public void sort(int n, boolean bl, boolean bl2) {
        this.sort(this.pGWItemList, n, bl, bl2);
    }

    public int getSortField() {
        return this.getSortField(this.pGWItemList);
    }

    public boolean isSortAscending() {
        return this.isSortAscending(this.pGWItemList);
    }

    public int getDisplayItemCount() {
        return this.getDisplayItemCount(this.pGWItemList);
    }

    public synchronized int getSize() {
        return this.items.length;
    }

    public int getFirstUnreadItemIndex(boolean bl) {
        return this.getFirstUnreadItem(this.pGWItemList, bl);
    }

    protected void sabPreScrollAction() {
        this.sabPreScrollAction(this.pGWItemList);
    }

    public Item getItemAt(int n) {
        Item[] itemArray = this.items;
        Item item = null;
        if (itemArray.length > 0) {
            if (n >= itemArray.length || n < 0) {
                throw new NoSuchElementException("List size: " + itemArray.length + ", Index: " + n);
            }
            item = itemArray[n];
            if (item == null) {
                int n2 = this.getItemAt(this.pGWItemList, n);
                if (n2 == 0) {
                    throw new NoSuchElementException("List size: " + itemArray.length + ", Index: " + n);
                }
                itemArray[n] = item = Item.createItem(n2);
            }
        } else {
            throw new NoSuchElementException("List size: " + itemArray.length + ", Index: " + n);
        }
        return item;
    }

    protected Item createItem(int n) {
        return Item.createItem(n);
    }

    public boolean setSelection(Item[] itemArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            bl = this.setSelection(this.pGWItemList, nArray);
        }
        return bl;
    }

    public int getThreadDepth(Item item) {
        return this.getThreadDepth(this.pGWItemList, item.getPointer());
    }

    public int getThreadDepthAt(int n) {
        return this.getThreadDepthAt(this.pGWItemList, n);
    }

    public boolean hasChildren(Item item) {
        return this.hasChildren(this.pGWItemList, item.getPointer());
    }

    public boolean hasChildrenAt(int n) {
        return this.hasChildrenAt(this.pGWItemList, n);
    }

    public boolean hasUnreadItemInThread(Item item) {
        return this.hasUnreadItemInThread(this.pGWItemList, item.getPointer());
    }

    public boolean hasUnreadItemInThreadAt(int n) {
        return this.hasUnreadItemInThreadAt(this.pGWItemList, n);
    }

    public boolean isCollapsed(Item item) {
        return this.isCollapsed(this.pGWItemList, item.getPointer());
    }

    public boolean isCollapsedAt(int n) {
        return this.isCollapsedAt(this.pGWItemList, n);
    }

    public boolean isCollapsedAutoDateItem(Item item) {
        return this.isCollapsedAutoDateItem(this.pGWItemList, item.getPointer());
    }

    public boolean isCollapsedAutoDateItemAt(int n) {
        return this.isCollapsedAutoDateItemAt(this.pGWItemList, n);
    }

    public boolean isRecurringEntry(Item item) {
        return this.isRecurringEntry(this.pGWItemList, item.getPointer());
    }

    public boolean isRecurringEntryAt(int n) {
        return this.isRecurringEntryAt(this.pGWItemList, n);
    }

    public boolean isRecurringEntryRoot(Item item) {
        return this.isRecurringEntryRoot(this.pGWItemList, item.getPointer());
    }

    public boolean isRecurringEntryRootAt(int n) {
        return this.isRecurringEntryRootAt(this.pGWItemList, n);
    }

    public boolean isRootMost(Item item) {
        return this.isRootMost(this.pGWItemList, item.getPointer());
    }

    public boolean isRootMostAt(int n) {
        return this.isRootMostAt(this.pGWItemList, n);
    }

    public void expand(Item item) {
        this.expand(this.pGWItemList, item.getPointer());
    }

    public void expandAt(int n) {
        this.expandAt(this.pGWItemList, n);
    }

    public void collapse(Item item) {
        this.collapse(this.pGWItemList, item.getPointer());
    }

    public void collapseAt(int n) {
        this.collapseAt(this.pGWItemList, n);
    }

    public void expandAll() {
        this.expandAll(this.pGWItemList);
    }

    public void collapseAll() {
        this.collapseAll(this.pGWItemList);
    }

    public boolean canMarkThreadIgnore() {
        return this.canMarkThreadIgnore(this.pGWItemList);
    }

    public boolean canMarkThreadRead() {
        return this.canMarkThreadRead(this.pGWItemList);
    }

    public boolean canMarkThreadWatch() {
        return this.canMarkThreadWatch(this.pGWItemList);
    }

    public boolean isThreadIgnored() {
        return this.isThreadIgnored1(this.pGWItemList);
    }

    public boolean isThreadIgnored(Item item) {
        return this.isThreadIgnored2(this.pGWItemList, item.getPointer());
    }

    public boolean isThreadIgnored(int n) {
        return this.isThreadIgnored3(this.pGWItemList, n);
    }

    public boolean isThreadWatched() {
        return this.isThreadWatched1(this.pGWItemList);
    }

    public boolean isThreadWatched(Item item) {
        return this.isThreadWatched2(this.pGWItemList, item.getPointer());
    }

    public boolean isThreadWatched(int n) {
        return this.isThreadWatched3(this.pGWItemList, n);
    }

    public void markThreadIgnore() {
        this.markThreadIgnore(this.pGWItemList);
    }

    public void markThreadRead() {
        this.markThreadRead(this.pGWItemList);
    }

    public void markThreadWatch() {
        this.markThreadWatch(this.pGWItemList);
    }

    public boolean canDeleteSelectedItems() {
        return this.canDeleteSelectedItems(this.pGWItemList);
    }

    public boolean canDeleteItem(Item item) {
        return this.canDeleteItem(this.pGWItemList, item.getPointer());
    }

    public boolean canDeleteItemAt(int n) {
        return this.canDeleteItemAt(this.pGWItemList, n);
    }

    public boolean deleteItem(Item item) {
        return this.deleteItem(this.pGWItemList, item.getPointer());
    }

    public static int[] getPointers(Item[] itemArray) {
        int[] nArray = null;
        if (itemArray != null && itemArray.length > 0) {
            nArray = new int[itemArray.length];
            int n = 0;
            for (int i = 0; i < itemArray.length; ++i) {
                Item item = itemArray[i];
                n = item != null ? item.getPointer() : 0;
                nArray[i] = n;
            }
            if (n == 0) {
                nArray = null;
            }
        }
        return nArray;
    }

    public boolean deleteSelectedItems() {
        return this.deleteSelectedItems(this.pGWItemList);
    }

    public boolean deleteItemAt(int n) {
        this.rangeCheck(n);
        return this.deleteItemAt(this.pGWItemList, n);
    }

    public boolean canDeleteAndEmptyItem(Item item) {
        return this.canDeleteAndEmptyItem(this.pGWItemList, item.getPointer());
    }

    public boolean canDeleteAndEmptySelectedItems() {
        return this.canDeleteAndEmptySelectedItems(this.pGWItemList);
    }

    public boolean canDeleteAndEmptyItemAt(int n) {
        return this.canDeleteAndEmptyItemAt(this.pGWItemList, n);
    }

    public boolean deleteAndEmptyItem(Item item) {
        return this.deleteAndEmptyItem(this.pGWItemList, item.getPointer());
    }

    public boolean deleteAndEmptySelectedItems() {
        return this.deleteAndEmptySelectedItems(this.pGWItemList);
    }

    public boolean deleteAndEmptyItemAt(int n) {
        this.rangeCheck(n);
        return this.deleteAndEmptyItemAt(this.pGWItemList, n);
    }

    public boolean canUndeleteItem(Item item) {
        return this.canUndeleteItem(this.pGWItemList, item.getPointer());
    }

    public boolean canUndeleteSelectedItems() {
        return this.canUndeleteSelectedItems(this.pGWItemList);
    }

    public boolean canUndeleteItemAt(int n) {
        return this.canUndeleteItemAt(this.pGWItemList, n);
    }

    public boolean undeleteItem(Item item) {
        return this.undeleteItem(this.pGWItemList, item.getPointer());
    }

    public boolean undeleteSelectedItems() {
        return this.undeleteSelectedItems(this.pGWItemList);
    }

    public boolean undeleteItemAt(int n) {
        this.rangeCheck(n);
        return this.undeleteItemAt(this.pGWItemList, n);
    }

    public boolean canMarkItemPrivate(Item item) {
        return this.canMarkItemPrivate(this.pGWItemList, item.getPointer());
    }

    public boolean canMarkSelectedItemsPrivate() {
        return this.canMarkSelectedItemsPrivate(this.pGWItemList);
    }

    public boolean canMarkItemPrivateAt(int n) {
        return this.canMarkItemPrivateAt(this.pGWItemList, n);
    }

    public void markAllItemsRead() {
        this.markAllItemsRead(this.pGWItemList);
    }

    public boolean markItemPrivate(Item item) {
        return this.markItemPrivate(this.pGWItemList, item.getPointer());
    }

    public boolean markSelectedItemsPrivate() {
        return this.markSelectedItemsPrivate(this.pGWItemList);
    }

    public boolean markItemPrivateAt(int n) {
        return this.markItemPrivateAt(this.pGWItemList, n);
    }

    public boolean canMarkItemRead(Item item) {
        return this.canMarkItemRead(this.pGWItemList, item.getPointer());
    }

    public boolean canMarkSelectedItemsRead() {
        return this.canMarkSelectedItemsRead(this.pGWItemList);
    }

    public boolean canMarkItemReadAt(int n) {
        return this.canMarkItemReadAt(this.pGWItemList, n);
    }

    public boolean markItemRead(Item item) {
        return this.markItemRead(this.pGWItemList, item.getPointer());
    }

    public boolean markSelectedItemsRead() {
        return this.markSelectedItemsRead(this.pGWItemList);
    }

    public boolean markItemReadAt(int n) {
        return this.markItemReadAt(this.pGWItemList, n);
    }

    public boolean canPurgeItem(Item item) {
        return this.canPurgeItem(this.pGWItemList, item.getPointer());
    }

    public boolean canPurgeSelectedItems() {
        return this.canPurgeSelectedItems(this.pGWItemList);
    }

    public boolean canPurgeItemAt(int n) {
        return this.canPurgeItemAt(this.pGWItemList, n);
    }

    public boolean purgeItem(Item item) {
        return this.purgeItem(this.pGWItemList, item.getPointer());
    }

    public boolean purgeSelectedItems() {
        return this.purgeSelectedItems(this.pGWItemList);
    }

    public boolean purgeItemAt(int n) {
        return this.purgeItemAt(this.pGWItemList, n);
    }

    public boolean canRestoreItem(Item item) {
        return this.canRestoreItem(this.pGWItemList, item.getPointer());
    }

    public boolean canRestoreSelectedItems() {
        return this.canRestoreSelectedItems(this.pGWItemList);
    }

    public boolean canRestoreItemAt(int n) {
        return this.canRestoreItemAt(this.pGWItemList, n);
    }

    public boolean restoreItem(Item item) {
        return this.restoreItem(this.pGWItemList, item.getPointer());
    }

    public boolean restoreSelectedItems() {
        return this.restoreSelectedItems(this.pGWItemList);
    }

    public boolean restoreItemAt(int n) {
        return this.restoreItemAt(this.pGWItemList, n);
    }

    public boolean canMarkItemReadLater(Item item) {
        return this.canMarkItemReadLater(this.pGWItemList, item.getPointer());
    }

    public boolean canMarkSelectedItemsReadLater() {
        return this.canMarkSelectedItemsReadLater(this.pGWItemList);
    }

    public boolean canMarkItemReadLaterAt(int n) {
        return this.canMarkItemReadLaterAt(this.pGWItemList, n);
    }

    public boolean markItemReadLater(Item item) {
        return this.markItemReadLater(this.pGWItemList, item.getPointer());
    }

    public boolean markSelectedItemsReadLater() {
        return this.markSelectedItemsReadLater(this.pGWItemList);
    }

    public boolean markItemReadLaterAt(int n) {
        return this.markItemReadLaterAt(this.pGWItemList, n);
    }

    public boolean canMoveSelectionToChecklist() {
        return this.canMoveSelectionToChecklist(this.pGWItemList);
    }

    public boolean canShowSelectionInChecklist() {
        return this.canShowSelectionInChecklist(this.pGWItemList);
    }

    public boolean isSelectionInChecklist() {
        return this.isSelectionInChecklist(this.pGWItemList);
    }

    public boolean moveSelectionToChecklist() {
        return this.moveSelectionToChecklist(this.pGWItemList);
    }

    public boolean showSelectionInChecklist(boolean bl) {
        return this.showSelectionInChecklist(this.pGWItemList, bl);
    }

    public int findLastUncompletedChecklistItemIndex() {
        return this.findLastUncompletedChecklistItemIndex(this.pGWItemList);
    }

    public boolean hasTaskListItemsOnly() {
        return this.hasTaskListItemsOnly(this.pGWItemList);
    }

    public Enumeration getEnumeration() {
        return new ItemEnumeration();
    }

    public void queryStop() {
        this.queryStop(this.pGWItemList);
    }

    public int indexOf(Item item) {
        return this.indexOf(this.pGWItemList, item.getPointer());
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        return this.indexOf(this.pGWItemList, string, n);
    }

    public boolean canChecklistMoveDown(int n) {
        return this.canChecklistMoveDown(this.pGWItemList, n);
    }

    public boolean checklistMoveDown(int n) {
        return this.checklistMoveDown(this.pGWItemList, n);
    }

    public boolean canChecklistMoveUp(int n) {
        return this.canChecklistMoveUp(this.pGWItemList, n);
    }

    public boolean checklistMoveUp(int n) {
        return this.checklistMoveUp(this.pGWItemList, n);
    }

    public boolean canChecklistMoveToBottom(int n) {
        return this.canChecklistMoveToBottom(this.pGWItemList, n);
    }

    public boolean checklistMoveToBottom(int n) {
        return this.checklistMoveToBottom(this.pGWItemList, n);
    }

    public boolean canChecklistMoveToTop(int n) {
        return this.canChecklistMoveToTop(this.pGWItemList, n);
    }

    public boolean checklistMoveToTop(int n) {
        return this.checklistMoveToTop(this.pGWItemList, n);
    }

    public boolean canChecklistMoveLeft(int n) {
        return this.canChecklistMoveLeft(this.pGWItemList, n);
    }

    public boolean checklistMoveLeft(int n) {
        return this.checklistMoveLeft(this.pGWItemList, n);
    }

    public boolean canChecklistMoveRight(int n) {
        return this.canChecklistMoveRight(this.pGWItemList, n);
    }

    public boolean checklistMoveRight(int n) {
        return this.checklistMoveRight(this.pGWItemList, n);
    }

    public boolean checklistMoveTo(int n, int n2) {
        return this.checklistMoveTo(n, n2, false);
    }

    public boolean checklistMoveTo(int n, int n2, boolean bl) {
        return this.checklistMoveTo(this.pGWItemList, n, n2, bl);
    }

    public boolean canCreateChecklistItem() {
        return this.canCreateChecklistItem(this.pGWItemList);
    }

    public boolean canCreateChecklistSubItemAt(int n) {
        return this.canCreateChecklistSubItemAt(this.pGWItemList, n);
    }

    public boolean canCreateChecklistSubItemAtSelection() {
        return this.canCreateChecklistSubItemAtSelection(this.pGWItemList);
    }

    public boolean createChecklistItem(String string, int n, int n2, ItemListFilter itemListFilter) {
        return this.createChecklistItem(this.pGWItemList, string, n, n2, itemListFilter != null ? itemListFilter.getPointer() : 0);
    }

    public boolean createChecklistItem(String string, int n) {
        return this.createChecklistItem(string, n, -1, null);
    }

    public boolean createChecklistSubItem(String string, int n, int n2) {
        return this.createChecklistItem(string, n, n2, null);
    }

    public TransferItems getTransferItems(int[] nArray) {
        TransferItems transferItems = null;
        int n = this.getTransferItems(this.pGWItemList, nArray);
        if (n != 0) {
            transferItems = new TransferItems(n);
        }
        return transferItems;
    }

    public boolean transferToTasklist(TransferItems transferItems, int n, boolean bl, boolean bl2) {
        if (transferItems == null) {
            return false;
        }
        return this.transferToTasklist(this.pGWItemList, transferItems.getHandle(), n, bl, bl2);
    }

    public int handleJunkMailSelectedItems(int n) {
        return this.handleJunkMailSelectedItems(n, this.pGWItemList);
    }

    public boolean canHandleJunkMailSelectedItems(int n) {
        int n2 = this.canHandleJunkMailSelectedItems(n, this.pGWItemList);
        return n2 != 0;
    }

    public int canHandleJunkMailSelectedItems() {
        return this.canHandleJunkMailSelectedItems(0, this.pGWItemList);
    }

    private Item[] createItemArray(int[] nArray) {
        Item[] itemArray = null;
        if (nArray != null) {
            itemArray = new Item[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                itemArray[i] = this.createItem(nArray[i]);
            }
        }
        return itemArray;
    }

    public Item[] getCalendarItems(Date date) {
        Item[] itemArray = this.createItemArray(this.getCalendarItemsAll(this.pGWItemList, EngineUtils.DateToFlaimTime(date)));
        return itemArray;
    }

    public Item[] getCalendarItems(Date date, Date date2) {
        Item[] itemArray = this.createItemArray(this.getCalendarItemsAll2(this.pGWItemList, EngineUtils.DateToFlaimTime(date), EngineUtils.DateToFlaimTime(date2)));
        return itemArray;
    }

    public Item[] getCalendarItems(Date date, int n) {
        Item[] itemArray = this.createItemArray(this.getCalendarItemsTypes(this.pGWItemList, EngineUtils.DateToFlaimTime(date), n));
        return itemArray;
    }

    public Item[] getCalendarItems(Date date, Date date2, int n) {
        Item[] itemArray = this.createItemArray(this.getCalendarItemsTypes2(this.pGWItemList, EngineUtils.DateToFlaimTime(date), EngineUtils.DateToFlaimTime(date2), n));
        return itemArray;
    }

    public Item[] getAllDayEvents(Date date) {
        Item[] itemArray = this.createItemArray(this.getAllDayEvents(this.pGWItemList, EngineUtils.DateToFlaimTime(date)));
        return itemArray;
    }

    public Item[] getAllDayEvents(Date date, Date date2) {
        Item[] itemArray = this.createItemArray(this.getAllDayEvents2(this.pGWItemList, EngineUtils.DateToFlaimTime(date), EngineUtils.DateToFlaimTime(date2)));
        return itemArray;
    }

    public Item[] getAppointments(Date date) {
        Item[] itemArray = this.createItemArray(this.getAppointments(this.pGWItemList, EngineUtils.DateToFlaimTime(date)));
        return itemArray;
    }

    public Item[] getAppointments(Date date, Date date2) {
        Item[] itemArray = this.createItemArray(this.getAppointments2(this.pGWItemList, EngineUtils.DateToFlaimTime(date), EngineUtils.DateToFlaimTime(date2)));
        return itemArray;
    }

    public Item[] getNotes(Date date) {
        Item[] itemArray = this.createItemArray(this.getNotes(this.pGWItemList, EngineUtils.DateToFlaimTime(date)));
        return itemArray;
    }

    public Item[] getNotes(Date date, Date date2) {
        Item[] itemArray = this.createItemArray(this.getNotes2(this.pGWItemList, EngineUtils.DateToFlaimTime(date), EngineUtils.DateToFlaimTime(date2)));
        return itemArray;
    }

    public Item[] getTasks(Date date) {
        Item[] itemArray = this.createItemArray(this.getTasks(this.pGWItemList, EngineUtils.DateToFlaimTime(date)));
        return itemArray;
    }

    public Item[] getTasks(Date date, Date date2) {
        Item[] itemArray = this.createItemArray(this.getTasks2(this.pGWItemList, EngineUtils.DateToFlaimTime(date), EngineUtils.DateToFlaimTime(date2)));
        return itemArray;
    }

    public int getMonthBusyDays(ItemListFilter itemListFilter, int n, int n2) {
        int n3 = 0;
        if (itemListFilter != null) {
            n3 = itemListFilter.getPointer();
        }
        int n4 = this.getMonthBusyDays(this.pGWItemList, n3, n, n2);
        return n4;
    }

    public boolean canSetCategoriesOnSelection() {
        return this.canSetCategoriesOnSelection(this.pGWItemList);
    }

    public static CategoryList getCategories(Item[] itemArray) {
        return new CategoryList(null, itemArray);
    }

    public void setCategories(CategoryList categoryList, Item[] itemArray) {
        int[] nArray = ItemList.getPointers(itemArray);
        if (nArray != null) {
            this.setCategories(this.pGWItemList, categoryList.getPointer(), nArray);
        }
    }

    public boolean setFilter(ItemListFilter itemListFilter) {
        return this.setFilter(this.pGWItemList, itemListFilter != null ? itemListFilter.getPointer() : 0);
    }

    public void dispose() {
        if (this.pGWItemList != 0 || this.pEvents != 0) {
            this.dispose(this.pGWItemList, this.pEvents);
            this.pGWItemList = 0;
            this.pEvents = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void rangeCheck(int n) {
        if (n >= this.items.length || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.items.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void contentsChanged(int n, int n2, int n3, long l, long l2) {
        ItemList itemList = this;
        synchronized (itemList) {
            switch (n) {
                case 0: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].CONTENTS_CHANGED (start/endTime): " + EngineUtils.flaimTimeToDate(l) + ", " + EngineUtils.flaimTimeToDate(l2));
                    this.refreshItemList(l, l2);
                    break;
                }
                case 3: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].ITEM_INSERTED (index): " + n2);
                    this.itemInserted(n2);
                    break;
                }
                case 5: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].ITEM_REMOVED (index): " + n2);
                    this.itemRemoved(n2);
                    break;
                }
                case 4: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].ITEM_MODIFIED (index): " + n2);
                    this.itemModified(n2);
                    break;
                }
                case 7: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].RANGE_INVALIDATED (start/endIndex): " + n2 + ", " + n3);
                    this.redrawItems(n2, n3);
                    break;
                }
                case 9: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].NOTIFY_DELETE_ALL_ITEMS");
                    this.deleteAllItems();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moreResultsAvailable(int n, int n2) {
        ItemList itemList = this;
        synchronized (itemList) {
            switch (n) {
                case 1: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].MORE_RESULTS_AVAILABLE");
                    this.updateQueryResults();
                    break;
                }
                case 6: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].UPDATE_ITEM_COUNT (start): " + n2);
                    this.updateItemCount(n2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyEmptyList(int n, int n2) {
        ItemList itemList = this;
        synchronized (itemList) {
            switch (n) {
                case 8: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].NOTIFY_EMPTY_LIST (promptCode): " + n2);
                    this.notifyEmptyList(n2);
                }
            }
        }
    }

    private void notifyEmptyList(int n) {
        this.fireItemListEvent(8, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryResultsDone(int n) {
        ItemList itemList = this;
        synchronized (itemList) {
            switch (n) {
                case 2: {
                    Debug.trace("ItemListEvent[" + this.pGWItemList + "].QUERY_RESULTS_DONE");
                    this.updateQueryDone();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemCount(int n) {
        ItemList itemList = this;
        synchronized (itemList) {
            Item[] itemArray = new Item[n];
            System.arraycopy(this.items, 0, itemArray, 0, this.items.length);
            this.items = itemArray;
        }
        this.fireItemListEvent(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemInserted(int n) {
        if (n >= 0) {
            ItemList itemList = this;
            synchronized (itemList) {
                int n2 = n > this.items.length ? n - this.items.length : 0;
                Item[] itemArray = new Item[this.items.length + 1 + n2];
                if (n2 == 0) {
                    if (n > 0) {
                        System.arraycopy(this.items, 0, itemArray, 0, n);
                    }
                    itemArray[n] = null;
                    int n3 = this.items.length - n;
                    if (n3 > 0) {
                        System.arraycopy(this.items, n, itemArray, n + 1, n3);
                    }
                } else {
                    if (this.items.length > 0) {
                        System.arraycopy(this.items, 0, itemArray, 0, this.items.length);
                    }
                    int n4 = this.items.length;
                    while (n4 < itemArray.length) {
                        itemArray[n4++] = null;
                    }
                }
                this.items = itemArray;
            }
            this.fireItemListEvent(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemModified(int n) {
        boolean bl = false;
        ItemList itemList = this;
        synchronized (itemList) {
            if (n >= 0 && n < this.items.length) {
                this.items[n] = null;
                bl = true;
            }
        }
        if (bl) {
            this.fireItemListEvent(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemRemoved(int n) {
        boolean bl = false;
        ItemList itemList = this;
        synchronized (itemList) {
            if (this.items.length > 0 && n >= 0 && n < this.items.length) {
                Item[] itemArray = new Item[this.items.length - 1];
                if (itemArray.length > 0) {
                    int n2;
                    if (n > 0) {
                        System.arraycopy(this.items, 0, itemArray, 0, n);
                    }
                    if ((n2 = itemArray.length - n) > 0) {
                        System.arraycopy(this.items, n + 1, itemArray, n, n2);
                    }
                }
                this.items = itemArray;
                bl = true;
            }
        }
        if (bl) {
            this.fireItemListEvent(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redrawItems(int n, int n2) {
        int n3 = n < 0 ? 0 : n;
        int n4 = n2 < 0 || n2 >= this.items.length ? this.items.length : n2 + 1;
        int n5 = this.getSize(this.pGWItemList);
        ItemList itemList = this;
        synchronized (itemList) {
            if (n5 != this.items.length || n == -1 && n2 == -1) {
                this.items = new Item[n5];
            } else {
                for (int i = n3; i < n4; ++i) {
                    this.items[i] = null;
                }
            }
        }
        this.fireItemListEvent(7, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshItemList(long l, long l2) {
        int n = this.getSize(this.pGWItemList);
        ItemList itemList = this;
        synchronized (itemList) {
            this.items = new Item[n];
        }
        this.fireItemListEvent(0, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllItems() {
        int n = this.getSize(this.pGWItemList);
        ItemList itemList = this;
        synchronized (itemList) {
            this.items = new Item[n];
        }
        this.fireItemListEvent(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQueryResults() {
        int n = this.getSize(this.pGWItemList);
        ItemList itemList = this;
        synchronized (itemList) {
            if (n != this.items.length) {
                this.items = new Item[n];
            }
        }
        this.fireItemListEvent(1);
    }

    private void updateQueryDone() {
        this.fireItemListEvent(2);
    }

    private void fireItemListEvent(int n) {
        this.fireItemListEvent(new ItemListEvent(this, n, 0L));
    }

    private void fireItemListEvent(int n, long l) {
        this.fireItemListEvent(new ItemListEvent(this, n, l));
    }

    private void fireItemListEvent(int n, long l, long l2) {
        this.fireItemListEvent(new ItemListEvent(this, n, l, l2));
    }

    private void fireItemListEvent(final ItemListEvent itemListEvent) {
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ItemList.doFireItemListEvent(objectArray, itemListEvent);
                }
            });
        }
    }

    private static void doFireItemListEvent(Object[] objectArray, ItemListEvent itemListEvent) {
        int n = itemListEvent.getType();
        block6: for (int i = 1; i < objectArray.length; i += 2) {
            ItemListListener itemListListener = (ItemListListener)objectArray[i];
            switch (n) {
                case 0: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: {
                    itemListListener.contentsChanged(itemListEvent);
                    continue block6;
                }
                case 1: {
                    itemListListener.moreResultsAvailable(itemListEvent);
                    continue block6;
                }
                case 2: {
                    itemListListener.queryResultsDone(itemListEvent);
                    continue block6;
                }
                case 8: {
                    itemListListener.notifyEmptyList(itemListEvent);
                    continue block6;
                }
            }
        }
    }

    static {
        ItemList.initIds();
    }

    private class ItemEnumeration
    implements Enumeration {
        int index = 0;

        private ItemEnumeration() {
        }

        public boolean hasMoreElements() {
            return this.index < ItemList.this.items.length;
        }

        public Object nextElement() {
            Item item = ItemList.this.getItemAt(this.index);
            ++this.index;
            return item;
        }
    }
}

