/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.ab.Addressable;
import com.novell.gw.engine.ProxyAccessEntry;
import java.util.ArrayList;

public class ProxyAccessList {
    protected ArrayList entryList;
    private int pAccessList = 0;

    private native int add(int var1, String var2, String var3, String var4, String var5, String var6, String var7);

    private native int addAccessEntry(int var1, int var2);

    private native int addAddressable(int var1, int var2);

    private native boolean remove(int var1, int var2);

    private native int get(int var1, int var2);

    private native int getSize(int var1);

    private native void commit(int var1);

    private native void dispose(int var1);

    ProxyAccessList(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pAccessList = n;
        this.readEntries();
    }

    public int size() {
        if (this.entryList == null) {
            return 0;
        }
        return this.entryList.size();
    }

    public int add(ProxyAccessEntry proxyAccessEntry) {
        int n = this.getSize(this.pAccessList);
        int n2 = this.addAccessEntry(this.pAccessList, proxyAccessEntry.getPointer());
        if (n2 >= 0 && this.getSize(this.pAccessList) > n) {
            this.entryList.add(n2, proxyAccessEntry);
        }
        return n2;
    }

    public int add(String string, String string2, String string3, String string4, String string5, String string6) {
        int n = this.getSize(this.pAccessList);
        int n2 = this.add(this.pAccessList, string, string2, string3, string4, string5, string6);
        if (n2 >= 0 && this.getSize(this.pAccessList) > n) {
            int n3 = this.get(this.pAccessList, n2);
            ProxyAccessEntry proxyAccessEntry = new ProxyAccessEntry(n3);
            this.entryList.add(n2, proxyAccessEntry);
        }
        return n2;
    }

    public int add(Addressable addressable) {
        int n = this.getSize(this.pAccessList);
        int n2 = this.addAddressable(this.pAccessList, addressable.getAddressablePointer());
        if (n2 >= 0 && this.getSize(this.pAccessList) > n) {
            int n3 = this.get(this.pAccessList, n2);
            ProxyAccessEntry proxyAccessEntry = new ProxyAccessEntry(n3);
            this.entryList.add(n2, proxyAccessEntry);
        }
        return n2;
    }

    public boolean remove(int n) {
        boolean bl = this.remove(this.pAccessList, n);
        if (bl) {
            this.entryList.remove(n);
        }
        return bl;
    }

    public ProxyAccessEntry get(int n) {
        if (n < this.entryList.size()) {
            return (ProxyAccessEntry)this.entryList.get(n);
        }
        return null;
    }

    private void readEntries() {
        if (this.entryList == null) {
            int n = 0;
            ProxyAccessEntry proxyAccessEntry = null;
            int n2 = this.getSize(this.pAccessList);
            this.entryList = new ArrayList(n2);
            for (int i = 0; i < n2; ++i) {
                n = this.get(this.pAccessList, i);
                proxyAccessEntry = n != 0 ? new ProxyAccessEntry(n) : null;
                this.entryList.add(i, proxyAccessEntry);
            }
        }
    }

    public void commit() {
        this.commit(this.pAccessList);
    }

    public void cancel() {
        this.dispose();
    }

    public void dispose() {
        this.entryList = null;
        this.dispose(this.pAccessList);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

