/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.message;

import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.folder.Folder;
import com.novell.gw.message.Note;
import java.util.Date;

public class Appointment
extends Note {
    public static final int ACCEPT_LEVEL_USE_SEND_VALUE = 0;
    public static final int ACCEPT_LEVEL_FREE = 160;
    public static final int ACCEPT_LEVEL_TENTATIVE = 190;
    public static final int ACCEPT_LEVEL_BUSY = 210;
    public static final int ACCEPT_LEVEL_OUT_OF_OFFICE = 251;

    private static native int createItem(int var0, int var1) throws EngineException;

    private native String getPlace(int var1);

    private native boolean setPlace(int var1, String var2);

    private native boolean hasTimeZone(int var1);

    private native String getTimeZoneName(int var1);

    private native long getEndDate(int var1);

    private native long getDisplayStartDate(int var1);

    private native long getDisplayEndDate(int var1);

    private native boolean setEndDate(int var1, long var2);

    private native long getDuration(int var1);

    private native int getShowAsLevel(int var1);

    private native boolean setShowAsLevel(int var1, int var2, boolean var3);

    private native boolean canClearAlarm(int var1);

    private native boolean canSetAlarm(int var1);

    private native boolean clearAlarm(int var1);

    private native long getAlarmTime(int var1);

    private native String getLaunchProgram(int var1);

    private native boolean isAlarmSet(int var1);

    private native boolean setAlarm(int var1, int var2, int var3, String var4);

    public Appointment() {
    }

    Appointment(int n) {
        super(n);
    }

    public Appointment(DataStore dataStore) throws EngineException {
        this(dataStore, null);
    }

    public Appointment(DataStore dataStore, Folder folder) throws EngineException {
        this(Appointment.createItem(dataStore.getPointer(), folder != null ? folder.getPointer() : 0));
    }

    public boolean accept(int n) {
        return super.accept("", n, this.getShowAsLevel(this.pGWItem), null);
    }

    public boolean accept(String string, int n) {
        return super.accept(string, n, this.getShowAsLevel(this.pGWItem), null);
    }

    public boolean accept(String string, int n, int n2, Folder folder) {
        return super.accept(string, n, n2, folder);
    }

    public boolean decline(int n) {
        return this.decline("", n);
    }

    public boolean decline(String string, int n) {
        return super.decline(string, n, 160, false);
    }

    public boolean decline(String string, int n, int n2, boolean bl) {
        return super.decline(string, n, n2, bl);
    }

    public String getPlace() {
        String string = this.getPlace(this.pGWItem);
        return string;
    }

    public boolean setPlace(String string) {
        boolean bl = this.setPlace(this.pGWItem, string);
        return bl;
    }

    public boolean hasTimeZone() {
        return this.hasTimeZone(this.pGWItem);
    }

    public String getTimeZoneName() {
        return this.getTimeZoneName(this.pGWItem);
    }

    public Date getEndDate() {
        long l = this.getEndDate(this.pGWItem);
        Date date = EngineUtils.flaimTimeToDate(l);
        return date;
    }

    public Date getDisplayStartDate() {
        long l = this.getDisplayStartDate(this.pGWItem);
        return EngineUtils.flaimTimeToDate(l);
    }

    public Date getDisplayEndDate() {
        long l = this.getDisplayEndDate(this.pGWItem);
        return EngineUtils.flaimTimeToDate(l);
    }

    public boolean setEndDate(Date date) {
        long l = EngineUtils.DateToFlaimTime(date);
        boolean bl = this.setEndDate(this.pGWItem, l);
        return bl;
    }

    public long getDuration() {
        long l = this.getDuration(this.pGWItem);
        return l;
    }

    public int getShowAsLevel() {
        int n = this.getShowAsLevel(this.pGWItem);
        return n;
    }

    public boolean setShowAsLevel(int n, boolean bl) {
        boolean bl2 = this.setShowAsLevel(this.pGWItem, n, bl);
        return bl2;
    }

    public boolean setAllDayEvent(boolean bl) {
        return super.setAllDayEvent(bl);
    }

    public boolean canClearAlarm() {
        boolean bl = this.canClearAlarm(this.pGWItem);
        return bl;
    }

    public boolean canSetAlarm() {
        boolean bl = this.canSetAlarm(this.pGWItem);
        return bl;
    }

    public boolean clearAlarm() {
        boolean bl = this.clearAlarm(this.pGWItem);
        return bl;
    }

    public Date getAlarmTime() {
        long l = this.getAlarmTime(this.pGWItem);
        return EngineUtils.flaimTimeToDate(l);
    }

    public String getLaunchProgram() {
        return this.getLaunchProgram(this.pGWItem);
    }

    public boolean isAlarmSet() {
        boolean bl = this.isAlarmSet(this.pGWItem);
        return bl;
    }

    public boolean setAlarm(int n, int n2, String string) {
        boolean bl = this.setAlarm(this.pGWItem, n, n2, string);
        return bl;
    }
}

