/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.CompiledTLex;
import azcheck.engine.DictionaryManager;
import azcheck.engine.SpellException;
import azcheck.engine.TLex;
import azcheck.engine.TLexRules;
import azcheck.util.CLOptions;
import azcheck.util.CharSequence;
import azcheck.util.DataWriter;
import azcheck.util.QuickSort;
import azcheck.util.StringBufferCharSeq;
import azcheck.util.StringCharSeq;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;

public class CompiledTLexBuilder
extends TLex {
    Node tree_;
    DataWriter dataOut_;
    DictionaryManager dman_;
    String line_;
    int lineNum_;
    Suffix[] suffixes_;
    HashMap suffixMap_ = new HashMap();
    StringBuffer suffixBuffer_ = new StringBuffer(100);
    boolean suffixEnabled_ = true;
    int trace_ = 0;
    int wasted_;
    static final byte WORD_SHARED = 4;
    static final int MAX_SUFFIX = 128;
    byte[] encodedWord_ = new byte[256];
    private static String USAGE = "builder <options> <files>.. [ -sub <files>... ]\n  options:\n\t-rules <rule_file>\n\t-freq <frequent_word_file>\n\t-prefixes <prefix_file>\n\t-cs <coding_system>\n\t-dump <dump_file>\n\t-o <output.cdi>\n";

    public CompiledTLexBuilder() {
        super("");
        try {
            this.defineWordChars("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", 0);
            this.defineWordChars("0123456789", 1);
            this.defineWordChars("-.'", 3);
            this.defineWordChars(":", 3);
            this.defineWordChars("@\\", 2);
            this.defineWordChars("_/", 0);
            byte by = 7;
            for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                char c2 = Character.toUpperCase(c);
                this.addCloseCharacter(this.encode(c), this.encode(c2), by);
                this.addCloseCharacter(this.encode(c2), this.encode(c), by);
            }
        }
        catch (SpellException spellException) {
            spellException.printStackTrace();
        }
        this.tree_ = new Node(0);
    }

    boolean addWord(String string) {
        StringCharSeq stringCharSeq = new StringCharSeq(string);
        return this.addWord(stringCharSeq, TLex.capType(stringCharSeq, 0, stringCharSeq.length()));
    }

    boolean addWord(StringBuffer stringBuffer) {
        StringBufferCharSeq stringBufferCharSeq = new StringBufferCharSeq(stringBuffer);
        return this.addWord(stringBufferCharSeq, TLex.capType(stringBufferCharSeq, 0, stringBufferCharSeq.length()));
    }

    boolean addWord(CharSequence charSequence, byte by) {
        boolean bl = by != 3;
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            byte by2 = this.encode(bl ? Character.toLowerCase(c) : c);
            if (by2 == -1) {
                return false;
            }
            this.encodedWord_[i] = by2;
        }
        return this.addWord(this.encodedWord_, n, by);
    }

    private boolean addWord(byte[] byArray, int n, byte by) {
        int n2;
        Node node = this.tree_;
        for (n2 = 0; n2 < n; ++n2) {
            node = node.getChild(byArray[n2], true);
        }
        n2 = CompiledTLexBuilder.wordFlags(by);
        if (node.type_ == 0 || CompiledTLexBuilder.getWordType(node.type_) > by) {
            node.type_ = (byte)n2;
        }
        return true;
    }

    void subtractWord(CharSequence charSequence) {
        int n = charSequence.length();
        boolean bl = TLex.capType(charSequence, 0, n) != 3;
        Node node = this.tree_;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            byte by = this.encode(bl ? Character.toLowerCase(c) : c);
            if (by == -1) {
                return;
            }
            if ((node = node.getChild(by, false)) != null) continue;
            return;
        }
        node.type_ = 0;
    }

    boolean frequentWord(String string) {
        int n = string.length();
        boolean bl = TLex.capType(new StringCharSeq(string), 0, n) != 3;
        Node node = this.tree_;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byte by = this.encode(bl ? Character.toLowerCase(c) : c);
            if (by == -1) {
                return false;
            }
            Node node2 = node;
            if ((node = node.getChild(by, false)) != null) continue;
            return false;
        }
        node.type_ = (byte)(node.type_ | 8);
        return true;
    }

    boolean prefixWord(String string) {
        int n = string.length();
        Node node = this.tree_;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byte by = this.encode(Character.toLowerCase(c));
            if (by == -1) {
                return false;
            }
            node = node.getChild(by, true);
        }
        node.type_ = (byte)(node.type_ | 0x11);
        return true;
    }

    void parseRules(LineNumberReader lineNumberReader) throws IOException, SpellException {
        String[] stringArray = new String[100];
        block0: while (true) {
            byte by;
            int n;
            this.line_ = lineNumberReader.readLine();
            this.lineNum_ = lineNumberReader.getLineNumber();
            if (this.line_ == null) break;
            StringTokenizer stringTokenizer = new StringTokenizer(this.line_);
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2] = stringTokenizer.nextToken();
                if (stringArray[n2].charAt(0) == '#') break;
                ++n2;
            }
            if (n2 == 0) continue;
            if (stringArray[0].equals("%chars")) {
                if (n2 != 2) {
                    this.parseError("expecting one string");
                }
                this.defineWordChars(stringArray[1], 0);
                continue;
            }
            if (stringArray[0].equals("%recode")) {
                if (n2 != 3) {
                    this.parseError("expecting a character and an hexadecimal code");
                }
                this.defineRecoding(stringArray[1].charAt(0), Integer.parseInt(stringArray[2], 16));
                continue;
            }
            if (stringArray[0].equals("%noninitial")) {
                if (n2 != 2) {
                    this.parseError("expecting one string");
                }
                this.defineWordChars(stringArray[1], 1);
                continue;
            }
            if (stringArray[0].equals("%nonfinal")) {
                if (n2 != 2) {
                    this.parseError("expecting one string");
                }
                this.defineWordChars(stringArray[1], 2);
                continue;
            }
            if (stringArray[0].equals("%compoundmin")) {
                if (n2 != 2) {
                    this.parseError("expecting one integer");
                    continue;
                }
                this.compoundMin_ = Integer.parseInt(stringArray[1]);
                continue;
            }
            if (stringArray[0].equals("%kbline")) {
                if (n2 != 2) {
                    this.parseError("expecting one string");
                }
                String string = stringArray[1];
                n = string.length();
                while (true) {
                    if (--n <= 0) continue block0;
                    by = this.encode(string.charAt(n - 1));
                    byte by2 = this.encode(string.charAt(n));
                    if (by == -1 || by2 == -1) {
                        this.parseError("illegal characters");
                    }
                    this.addCloseCharacter(by, by2, (byte)13);
                    this.addCloseCharacter(by2, by, (byte)13);
                }
            }
            if (stringArray[0].equals("%pattern")) {
                if (n2 == 2) continue;
                this.parseError("expecting string");
                continue;
            }
            if (stringArray[0].startsWith("%mistake")) {
                int n3 = this.parseModifiedCost(stringArray[0], 10, 3);
                n = 1;
                while (true) {
                    if (n >= n2) continue block0;
                    for (by = 1; by < n2; ++by) {
                        this.storeMistake(stringArray[n], stringArray[by], n3);
                    }
                    ++n;
                }
            }
            this.parseError("illegal line");
        }
    }

    void generate(String string) throws IOException {
        System.out.println(Node.tcount + " nodes");
        this.shareSuffixes();
        this.dataOut_ = new DataWriter(string);
        this.dataOut_.setLength(0L);
        this.dataOut_.write(new byte[256]);
        int n = this.save();
        this.dataOut_.seek(0L);
        this.dataOut_.write(CompiledTLex.MAGIC);
        this.dataOut_.write(1);
        this.dataOut_.write(3);
        this.dataOut_.fixedInt(n, 4);
        this.dataOut_.fixedInt(this.compoundMin_, 4);
        this.dataOut_.close();
    }

    void dumpWords(Writer writer) {
        this.dumpWords(this.tree_, writer);
    }

    void defineWordChars(String string, int n) throws SpellException {
        for (int i = 0; i < string.length(); ++i) {
            TLexRules.CProps cProps = this.defineWordChar(string.charAt(i));
            cProps.flags = (byte)(cProps.flags | (byte)n);
        }
    }

    private int parseModifiedCost(String string, int n, int n2) {
        int n3 = n;
        int n4 = string.length();
        while (--n4 > 0) {
            if (string.charAt(n4) == '-') {
                n3 += n2;
                continue;
            }
            if (string.charAt(n4) != '+') break;
            n3 -= n2;
        }
        return n3;
    }

    private void storeMistake(String string, String string2, int n) throws SpellException {
        int n2;
        byte[] byArray;
        if (string.equals(string2)) {
            return;
        }
        byte[] byArray2 = this.encode(string, true);
        if (byArray2 == null) {
            this.parseError(" illegal sequence <" + string + ">");
        }
        if ((byArray = this.encode(string2, true)) == null) {
            this.parseError(" illegal sequence <" + string2 + ">");
        }
        if (byArray2.length == 1 && byArray.length == 1) {
            this.addCloseCharacter(byArray2[0], byArray[0], (byte)n);
            return;
        }
        TLexRules.CProps cProps = this.getChar(byArray2[0]);
        TLexRules.MRule mRule = cProps.mistRules;
        TLexRules.MRule mRule2 = null;
        while (!(mRule == null || (n2 = mRule.itemSize(0)) < byArray2.length || n2 == byArray2.length && mRule.itemEquals(0, byArray2))) {
            mRule2 = mRule;
            mRule = mRule.next;
        }
        if (mRule == null || !mRule.itemEquals(0, byArray2)) {
            TLexRules.MRule mRule3 = new TLexRules.MRule(byArray2, mRule);
            if (mRule2 == null) {
                cProps.mistRules = mRule3;
            } else {
                mRule2.next = mRule3;
            }
            mRule = mRule3;
        }
        mRule.addItem(byArray, n);
    }

    private void parseError(String string) throws SpellException {
        throw new SpellException(" [" + this.lineNum_ + "] " + string + " in: " + this.line_, this.lineNum_);
    }

    private int save() throws IOException {
        int n;
        Object object;
        int n2;
        int n3 = (int)this.dataOut_.getFilePointer();
        for (n2 = 0; n2 < 256; ++n2) {
            object = this.charTable_[n2];
            if (object == null) {
                this.dataOut_.fixedInt(0, 2);
                continue;
            }
            this.dataOut_.fixedInt(((TLexRules.CProps)object).xvalue, 2);
            this.dataOut_.write(((TLexRules.CProps)object).code);
            this.dataOut_.write(((TLexRules.CProps)object).flags);
            this.dataOut_.byteArray(((TLexRules.CProps)object).closeFriends);
            int n4 = 0;
            TLexRules.MRule mRule = ((TLexRules.CProps)object).mistRules;
            while (mRule != null) {
                ++n4;
                mRule = mRule.next;
            }
            this.dataOut_.fixedInt(n4, 2);
            mRule = ((TLexRules.CProps)object).mistRules;
            while (mRule != null) {
                this.dataOut_.byteArray(mRule.data);
                mRule = mRule.next;
            }
        }
        this.generateTree(this.tree_);
        this.suffixEnabled_ = false;
        for (n2 = 0; n2 < this.suffixes_.length; ++n2) {
            object = this.suffixes_[n2];
            this.generateTree(((Suffix)object).instance);
            ((Suffix)object).offset = ((Suffix)object).instance.offset_;
        }
        n2 = (int)this.dataOut_.getFilePointer();
        this.dataOut_.fixedInt(this.suffixes_.length, 4);
        for (n = 0; n < this.suffixes_.length; ++n) {
            this.dataOut_.fixedInt(this.suffixes_[n].offset, 4);
        }
        n = (int)this.dataOut_.getFilePointer();
        this.dataOut_.fixedInt(this.tree_.offset_, 4);
        this.dataOut_.fixedInt(n3, 4);
        this.dataOut_.fixedInt(n2, 4);
        return n;
    }

    private void generateTree(Node node) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (node.kids_ == null) {
            return;
        }
        Suffix suffix = null;
        if (this.suffixEnabled_ && node.shareKey != null && (suffix = (Suffix)this.suffixMap_.get(node.shareKey)) != null) {
            return;
        }
        Node node2 = node.kids_;
        while (node2 != null) {
            this.generateTree(node2);
            ++n;
            node2 = node2.next_;
        }
        node.offset_ = (int)this.dataOut_.getFilePointer();
        this.dataOut_.write(n);
        node2 = node.kids_;
        while (node2 != null) {
            int n4;
            this.dataOut_.write(node2.ch_);
            int n5 = this.kidCoding(node2, node);
            int n6 = n5 < 256 ? 1 : (n5 < 65536 ? 2 : (n4 = n5 < 0x1000000 ? 3 : 4));
            if (n4 > n2) {
                n2 = n4;
            }
            n3 += n4;
            node2 = node2.next_;
        }
        this.dataOut_.write((node.type_ << 2) + (n2 - 1));
        node2 = node.kids_;
        while (node2 != null) {
            this.dataOut_.fixedInt(this.kidCoding(node2, node), n2);
            node2 = node2.next_;
        }
        this.wasted_ += n2 * n - n3;
    }

    private int kidCoding(Node node, Node node2) {
        Suffix suffix = null;
        if (this.suffixEnabled_ && node.shareKey != null && (suffix = (Suffix)this.suffixMap_.get(node.shareKey)) != null) {
            if (this.trace_ > 1) {
                System.err.println(" shared node -> " + suffix.code);
                this.dumpWords(node, new BufferedWriter(new OutputStreamWriter(System.err)));
            }
            return (suffix.code << 2) + 3;
        }
        if (node.kids_ == null) {
            return (node.type_ << 2) + 1;
        }
        return node2.offset_ - node.offset_ << 1;
    }

    void dumpWords(Node node, Writer writer) {
        boolean bl = true;
        try {
            Iterator iterator = new Iterator(node);
            byte[] byArray = new byte[200];
            int n = 0;
            while ((n = iterator.getNextWord(byArray)) >= 0) {
                int n2 = CompiledTLexBuilder.getWordType(iterator.getFlags());
                for (int i = 0; i < n; ++i) {
                    char c = this.decode(byArray[i]);
                    if (bl) {
                        writer.write(c);
                        continue;
                    }
                    writer.write(n2 == 2 || n2 == 1 && i == 0 ? Character.toUpperCase(c) : c);
                }
                writer.write(10);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void shareSuffixes() throws IOException {
        Object object;
        this.detectSharing(this.tree_, 0);
        Object[] objectArray = new Suffix[this.suffixMap_.size()];
        int n = 0;
        java.util.Iterator iterator = this.suffixMap_.values().iterator();
        while (iterator.hasNext()) {
            objectArray[n++] = (Suffix)iterator.next();
        }
        QuickSort.Compare compare = new QuickSort.Compare(){

            public int compare(Object object, Object object2) {
                Suffix suffix = (Suffix)object;
                Suffix suffix2 = (Suffix)object2;
                return suffix2.key.length() * (suffix2.frequency - 1) - suffix.key.length() * (suffix.frequency - 1);
            }
        };
        QuickSort.sort(objectArray, compare);
        if (this.trace_ > 0) {
            System.err.println(n + " suffixes found");
        }
        this.suffixes_ = new Suffix[n < 128 ? n : 128];
        int n2 = 0;
        while (n2 < n && n2 < 128) {
            object = objectArray[n2];
            if (this.trace_ > 1) {
                System.out.println(((Suffix)object).key + "\t" + ((Suffix)object).frequency + "\t" + ((Suffix)object).key.length() * (((Suffix)object).frequency - 1));
            }
            this.suffixes_[n2] = object;
            ((Suffix)object).code = n2++;
        }
        for (n2 = 128; n2 < n; ++n2) {
            object = objectArray[n2];
            this.suffixMap_.remove(((Suffix)object).key);
        }
    }

    private int detectSharing(Node node, int n) {
        int n2 = 0;
        if (node.kids_ == null) {
            return 1;
        }
        byte[] byArray = new byte[100];
        Node node2 = node.kids_;
        while (node2 != null) {
            int n3 = this.detectSharing(node2, n + 1);
            n2 += n3;
            if (n3 > 2 && n3 < 50 && n > 0) {
                Iterator iterator = new Iterator(node2);
                this.suffixBuffer_.setLength(0);
                int n4 = 0;
                boolean bl = false;
                while ((n4 = iterator.getNextWord(byArray)) >= 0) {
                    for (int i = 0; i < n4; ++i) {
                        this.suffixBuffer_.append(this.decode(byArray[i]));
                    }
                    this.suffixBuffer_.append((char)(48 + iterator.getFlags()));
                    this.suffixBuffer_.append('/');
                }
                String string = this.suffixBuffer_.toString();
                Suffix suffix = (Suffix)this.suffixMap_.get(string);
                if (suffix != null) {
                    ++suffix.frequency;
                    node2.shareKey = suffix.key;
                } else {
                    suffix = new Suffix();
                    this.suffixMap_.put(string, suffix);
                    suffix.instance = node2;
                    node2.shareKey = suffix.key = string;
                }
            }
            node2 = node2.next_;
        }
        if (CompiledTLexBuilder.actualWord(node.type_)) {
            ++n2;
        }
        return n2;
    }

    static LineNumberReader openFile(String string, String string2) throws IOException {
        InputStreamReader inputStreamReader = string2 != null ? new InputStreamReader((InputStream)new FileInputStream(string), string2) : new FileReader(string);
        return new LineNumberReader(inputStreamReader);
    }

    boolean processCompiledFile(String string, boolean bl) throws SpellException {
        try {
            if (this.dman_ == null) {
                this.dman_ = new DictionaryManager(".");
            }
            if (string.indexOf(58) < 2) {
                string = "file:" + string;
            }
            CompiledTLex compiledTLex = (CompiledTLex)this.dman_.load(new URL(string), null);
            final boolean bl2 = bl;
            try {
                final StringBufferCharSeq stringBufferCharSeq = new StringBufferCharSeq();
                compiledTLex.visit(new TLex.Visitor(){

                    public void getWord(char[] cArray, int n, int n2, int n3) {
                        stringBufferCharSeq.buffer.setLength(0);
                        for (int i = 0; i < n; ++i) {
                            stringBufferCharSeq.buffer.append(cArray[i]);
                        }
                        stringBufferCharSeq.length = n;
                        if (bl2) {
                            CompiledTLexBuilder.this.subtractWord(stringBufferCharSeq);
                        } else if (!CompiledTLexBuilder.this.addWord(stringBufferCharSeq, (byte)n2)) {
                            System.err.println("word rejected: " + stringBufferCharSeq.buffer);
                        }
                    }
                });
            }
            catch (Exception exception) {
                System.err.println("** error while reading compiled dictionary: " + exception.getMessage());
                exception.printStackTrace();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void processTextFile(String string, String string2, boolean bl) throws IOException {
        LineNumberReader lineNumberReader = CompiledTLexBuilder.openFile(string, string2);
        StringBuffer stringBuffer = new StringBuffer();
        int n = ((BufferedReader)lineNumberReader).read();
        while (n > 0) {
            if (Character.isWhitespace((char)n)) {
                n = ((BufferedReader)lineNumberReader).read();
                continue;
            }
            if (n == 35) {
                while (n > 0 && n != 10) {
                    n = ((BufferedReader)lineNumberReader).read();
                }
                continue;
            }
            stringBuffer.setLength(0);
            while (n > 0 && !Character.isWhitespace((char)n)) {
                stringBuffer.append((char)n);
                n = ((BufferedReader)lineNumberReader).read();
            }
            if (bl) {
                this.subtractWord(new StringBufferCharSeq(stringBuffer));
                continue;
            }
            if (this.addWord(stringBuffer)) continue;
            System.err.println("word rejected: " + stringBuffer);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object var1_1 = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            LineNumberReader lineNumberReader = null;
            LineNumberReader lineNumberReader2 = null;
            LineNumberReader lineNumberReader3 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            CLOptions cLOptions = new CLOptions(stringArray, USAGE);
            while (cLOptions.more()) {
                if (cLOptions.withArg("-o")) {
                    string = cLOptions.getArg();
                    continue;
                }
                if (cLOptions.withoutArg("-trace")) {
                    n = 1;
                    continue;
                }
                if (cLOptions.withArg("-verbose")) {
                    n3 = cLOptions.getIntArg();
                    continue;
                }
                if (cLOptions.withArg("-cs")) {
                    string2 = cLOptions.getArg();
                    continue;
                }
                if (cLOptions.withArg("-dump")) {
                    string3 = cLOptions.getArg();
                    continue;
                }
                if (cLOptions.withArg("-hints")) {
                    lineNumberReader = CompiledTLexBuilder.openFile(cLOptions.getArg(), string2);
                    continue;
                }
                if (cLOptions.withArg("-freq")) {
                    lineNumberReader2 = CompiledTLexBuilder.openFile(cLOptions.getArg(), string2);
                    continue;
                }
                if (cLOptions.withArg("-prefixes")) {
                    lineNumberReader3 = CompiledTLexBuilder.openFile(cLOptions.getArg(), string2);
                    continue;
                }
                stringArray[n2++] = cLOptions.next();
            }
            if (n2 == 0) {
                cLOptions.usage();
            }
            CompiledTLexBuilder compiledTLexBuilder = new CompiledTLexBuilder();
            if (lineNumberReader != null) {
                compiledTLexBuilder.parseRules(lineNumberReader);
            }
            compiledTLexBuilder.trace_ = n;
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                if (stringArray[i].equals("-sub")) {
                    bl = true;
                    continue;
                }
                object = stringArray[i];
                if (!compiledTLexBuilder.processCompiledFile((String)object, bl)) {
                    compiledTLexBuilder.processTextFile((String)object, string2, bl);
                }
                System.err.println("file " + (String)object + " read");
            }
            if (lineNumberReader2 != null) {
                String string4;
                while ((string4 = lineNumberReader2.readLine()) != null) {
                    if (compiledTLexBuilder.frequentWord(string4.trim()) || n3 <= 0) continue;
                    System.err.println("unknown frequent word: " + string4 + "|");
                }
            }
            if (lineNumberReader3 != null) {
                String string5;
                while ((string5 = lineNumberReader3.readLine()) != null) {
                    compiledTLexBuilder.prefixWord(string5.trim());
                }
            }
            if (string3 != null) {
                object = new BufferedWriter(string2 != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(string3), string2) : new FileWriter(string3));
                compiledTLexBuilder.dumpWords((Writer)object);
                ((Writer)object).close();
            }
            if (string != null) {
                compiledTLexBuilder.generate(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("** " + exception);
            System.exit(1);
        }
    }

    static class Suffix {
        String key;
        Node instance;
        int frequency = 1;
        int offset;
        int code;

        Suffix() {
        }
    }

    static class Iterator {
        Node[] stack_ = new Node[100];
        int sp_;
        int wtype_;

        Iterator(Node node) {
            this.stack_[0] = node;
            this.sp_ = 0;
        }

        int getNextWord(byte[] byArray) {
            Node node = this.next();
            while (node != null && !TLex.actualWord(node.type_)) {
                node = this.next();
            }
            if (node == null) {
                return -1;
            }
            for (int i = 1; i < this.sp_; ++i) {
                byArray[i - 1] = this.stack_[i].ch_;
            }
            this.wtype_ = node.type_;
            return this.sp_ - 1;
        }

        int getFlags() {
            return this.wtype_;
        }

        Node next() {
            if (this.sp_ == 0) {
                this.sp_ = 1;
                return this.stack_[0];
            }
            Node node = this.stack_[this.sp_ - 1];
            if (node.kids_ != null) {
                Node node2 = node.kids_;
                this.stack_[this.sp_++] = node2;
                return node2;
            }
            if (node.next_ != null) {
                Node node3 = node.next_;
                this.stack_[this.sp_ - 1] = node3;
                return node3;
            }
            while (--this.sp_ > 1) {
                node = this.stack_[this.sp_ - 1];
                if (node.next_ == null) continue;
                Node node4 = node.next_;
                this.stack_[this.sp_ - 1] = node4;
                return node4;
            }
            return null;
        }
    }

    protected static class Node {
        Node next_;
        Node kids_;
        byte ch_;
        byte type_ = 0;
        int offset_ = 0;
        String shareKey;
        static int tcount = 0;

        Node(byte by) {
            this.ch_ = by;
        }

        Node getChild(byte by, boolean bl) {
            Node node = this.kids_;
            Node node2 = null;
            while (node != null) {
                if (node.ch_ == by) {
                    return node;
                }
                if (node.ch_ > by) break;
                node2 = node;
                node = node.next_;
            }
            if (!bl) {
                return null;
            }
            ++tcount;
            Node node3 = new Node(by);
            if (node2 == null) {
                this.kids_ = node3;
            } else {
                node2.next_ = node3;
            }
            node3.next_ = node;
            return node3;
        }
    }
}

