/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.CharChecker;
import azcheck.engine.SpellException;
import azcheck.util.CharSequence;
import azcheck.util.DataReader;

public class TLexRules
implements CharChecker {
    public static final byte CAP_ANY = 0;
    public static final byte CAP_PROPERNAME = 1;
    public static final byte CAP_UP = 2;
    public static final byte CAP_MIXED = 3;
    protected CProps[] charHash_ = new CProps[256];
    protected CProps[] charTable_ = new CProps[256];
    protected int charCount_ = 0;
    static final byte NON_INITIAL = 1;
    static final byte NON_FINAL = 2;
    static final byte SPACE = 4;

    public TLexRules() {
        this.findChar(0, true);
        CProps cProps = this.findChar(32, true);
        cProps.flags = (byte)7;
        this.charTable_[255] = new CProps('^', -1);
        this.charTable_[254] = new CProps('$', -2);
    }

    public void shareRules(TLexRules tLexRules) {
        if (tLexRules != null) {
            this.charHash_ = tLexRules.charHash_;
            this.charTable_ = tLexRules.charTable_;
        } else {
            try {
                char c;
                for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                    this.defineWordChar(c);
                }
                for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                    this.defineWordChar(c);
                }
                for (c = '\ufffd'; c <= '\ufffd'; c = (char)(c + '\u0001')) {
                    this.defineWordChar(c);
                }
                this.defineWordChar('-');
                this.defineWordChar('.');
                this.defineWordChar('\'');
            }
            catch (SpellException spellException) {
                // empty catch block
            }
        }
    }

    public int getSize() {
        return this.charCount_;
    }

    public byte encode(char c) {
        CProps cProps = this.findChar(c, false);
        return cProps == null ? (byte)-1 : (byte)cProps.code;
    }

    public byte[] encode(String string, boolean bl) {
        byte[] byArray = new byte[string.length()];
        int n = byArray.length;
        while (--n >= 0) {
            char c = string.charAt(n);
            if (bl && c == '$') {
                byArray[n] = -2;
                continue;
            }
            if (bl && c == '^') {
                byArray[n] = -1;
                continue;
            }
            byArray[n] = this.encode(c);
            if (byArray[n] != -1) continue;
            return null;
        }
        return byArray;
    }

    public char decode(byte by) {
        return this.getChar((byte)by).xvalue;
    }

    public String decode(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = this.getChar((byte)byArray[n + i]).xvalue;
        }
        return new String(cArray);
    }

    public CProps defineWordChar(char c) throws SpellException {
        if (this.charCount_ >= 250) {
            throw new SpellException("too many characters defined", this.charCount_);
        }
        return this.findChar(c, true);
    }

    public void defineRecoding(char c, int n) throws SpellException {
        CProps cProps = this.findChar(n, true);
        this.addAlias(cProps, c);
    }

    public boolean isWordChar(char c) {
        CProps cProps = this.findChar(c, false);
        return cProps != null && (cProps.flags & 4) == 0;
    }

    public boolean isWordStart(char c) {
        CProps cProps = this.findChar(c, false);
        return cProps != null && (cProps.flags & 5) == 0;
    }

    public boolean isWordEnd(char c) {
        CProps cProps = this.findChar(c, false);
        return cProps != null && (cProps.flags & 6) == 0;
    }

    public void setInitial(byte by) {
        this.getChar((byte)by).flags = (byte)(this.getChar((byte)by).flags & 0xFFFFFFFE);
    }

    public void setFinal(byte by) {
        this.getChar((byte)by).flags = (byte)(this.getChar((byte)by).flags & 0xFFFFFFFD);
    }

    public static byte capType(CharSequence charSequence, int n, int n2) {
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            char c = charSequence.charAt(n + i);
            if (Character.isUpperCase(c)) {
                ++n3;
                if (bl) {
                    ++n5;
                }
            }
            boolean bl2 = bl = !Character.isLetter(c);
            if (!bl) continue;
            --n4;
        }
        if (n3 == n4) {
            return 2;
        }
        if (n3 != 0) {
            return n3 == n5 ? (byte)1 : 3;
        }
        return 0;
    }

    public void addCloseCharacter(byte by, byte by2, byte by3) {
        CProps cProps = this.getChar(by);
        int n = cProps.closeFriends == null ? 0 : cProps.closeFriends.length;
        byte[] byArray = new byte[n + 2];
        if (n > 0) {
            System.arraycopy(cProps.closeFriends, 0, byArray, 0, n);
        }
        cProps.closeFriends = byArray;
        cProps.closeFriends[n] = by2;
        cProps.closeFriends[n + 1] = by3;
    }

    public int charCloseness(byte by, byte by2, int n) {
        CProps cProps = this.getChar(by);
        if (cProps == null) {
            return n;
        }
        byte[] byArray = cProps.closeFriends;
        if (byArray != null) {
            for (int i = byArray.length - 2; i >= 0; i -= 2) {
                if (byArray[i] != by2) continue;
                return byArray[i + 1];
            }
        }
        return n;
    }

    public void load(DataReader dataReader) throws SpellException {
        for (int i = 0; i < 256; ++i) {
            CProps cProps;
            char c = (char)dataReader.getInt(2);
            if (c == '\u0000' && i > 0) continue;
            byte by = dataReader.getByte();
            if (by == -1 || by == -2) {
                this.charTable_[by & 0xFF] = cProps = new CProps(c, by);
            } else {
                cProps = this.defineWordChar(c);
            }
            cProps.flags = dataReader.getByte();
            int n = dataReader.getInt(4);
            if (n > 0) {
                cProps.closeFriends = dataReader.getBytes(n);
            }
            int n2 = dataReader.getInt(2);
            MRule mRule = null;
            for (int j = 0; j < n2; ++j) {
                int n3 = dataReader.getInt(4);
                MRule mRule2 = new MRule(null);
                mRule2.data = dataReader.getBytes(n3);
                if (mRule == null) {
                    cProps.mistRules = mRule2;
                } else {
                    mRule.next = mRule2;
                }
                mRule = mRule2;
            }
        }
    }

    protected CProps getChar(byte by) {
        return this.charTable_[by & 0xFF];
    }

    protected CProps findChar(int n, boolean bl) {
        int n2 = n & 0xFF;
        CProps cProps = this.charHash_[n2];
        while (cProps != null) {
            if (cProps.xvalue == n) {
                return cProps.alias != null ? cProps.alias : cProps;
            }
            cProps = cProps.next;
        }
        if (bl) {
            cProps = new CProps((char)n, (byte)this.charCount_++);
            cProps.next = this.charHash_[n2];
            this.charHash_[n2] = cProps;
            this.charTable_[cProps.code & 0xFF] = cProps;
        }
        return cProps;
    }

    protected void addAlias(CProps cProps, int n) {
        int n2 = n & 0xFF;
        CProps cProps2 = new CProps((char)n, cProps.code);
        cProps2.alias = cProps;
        cProps2.next = this.charHash_[n2];
        this.charHash_[n2] = cProps2;
    }

    protected static class MRule {
        byte[] data;
        public MRule next;
        static final int FIRST_ITEM = 0;
        static final byte MATCH_START = -1;
        static final byte MATCH_END = -2;

        public MRule(MRule mRule) {
            this.next = mRule;
        }

        public MRule(byte[] byArray, MRule mRule) {
            this.next = mRule;
            this.data = new byte[byArray.length + 2];
            this.data[0] = 0;
            this.data[1] = (byte)byArray.length;
            System.arraycopy(byArray, 0, this.data, 2, byArray.length);
        }

        final int itemCount() {
            return this.data[0];
        }

        final int matchedChars() {
            int n = 0;
            int n2 = this.itemSize(0);
            while (--n2 >= 0) {
                if (this.data[2 + n2] == -1 || this.data[2 + n2] == -2) continue;
                ++n;
            }
            return n;
        }

        final int itemCost(int n) {
            return this.data[n];
        }

        final int itemSize(int n) {
            return this.data[n + 1];
        }

        final int itemNext(int n) {
            return n + 2 + this.data[n + 1];
        }

        final byte itemCode(int n, int n2) {
            return this.data[n + 2 + n2];
        }

        final boolean itemEquals(int n, byte[] byArray) {
            if (this.itemSize(n) != byArray.length) {
                return false;
            }
            int n2 = byArray.length;
            while (--n2 >= 0) {
                if (this.itemCode(n, n2) == byArray[n2]) continue;
                return false;
            }
            return true;
        }

        void addItem(byte[] byArray, int n) {
            int n2;
            int n3 = this.itemNext(0);
            int n4 = this.itemCount();
            while (--n4 > 0) {
                if (this.itemEquals(n3, byArray)) {
                    return;
                }
                n3 = this.itemNext(n3);
            }
            byte[] byArray2 = new byte[this.data.length + byArray.length + 2];
            int n5 = 0;
            for (n2 = 0; n2 < this.data.length; ++n2) {
                byArray2[n5++] = this.data[n2];
            }
            byArray2[0] = (byte)(byArray2[0] + 1);
            byArray2[n5++] = (byte)n;
            byArray2[n5++] = (byte)byArray.length;
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray2[n5++] = byArray[n2];
            }
            this.data = byArray2;
        }

        boolean matches(byte[] byArray, int n, int n2) {
            int n3 = n;
            int n4 = 2 + this.data[1];
            for (int i = 2; i < n4; ++i) {
                if (this.data[i] == -1) {
                    if (n <= 0) continue;
                    return false;
                }
                if (this.data[i] == -2) {
                    if (n3 >= n2) continue;
                    return false;
                }
                if (n3 >= n2 || this.data[i] != byArray[n3]) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
    }

    protected static class CProps {
        public char xvalue;
        public byte code;
        public byte flags = 0;
        public byte[] closeFriends;
        public MRule mistRules;
        public CProps next;
        public CProps alias;

        CProps(char c, byte by) {
            this.xvalue = c;
            this.code = by;
        }
    }
}

