/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.ui.JSpellComponent;
import azcheck.ui.JTextAutoSpellCheck;
import azcheck.ui.JTextSource;
import azcheck.ui.SpellControl;
import azcheck.ui.TextSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class JSpellDialog
extends JDialog
implements ActionListener {
    JSpellComponent component_;
    static JSpellDialog StaticDialog = null;
    public static final int TOP_OUT = -2;
    public static final int TOP_IN = -1;
    public static final int CENTER = 0;
    public static final int BOTTOM_IN = 1;
    public static final int BOTTOM_OUT = 2;
    public static final int LEFTS_OUT = -2;
    public static final int LEFTS_IN = -1;
    public static final int RIGHTS_IN = 1;
    public static final int RIGHTS_OUT = 2;

    public JSpellDialog(JFrame jFrame, JTextComponent jTextComponent, String string, String string2) throws Exception {
        this(jFrame, (TextSource)new JTextSource(jTextComponent), string, string2, true);
    }

    public JSpellDialog(JFrame jFrame, TextSource textSource, String string, String string2, boolean bl) throws Exception {
        super(jFrame, JSpellComponent.lmsg("Spell-Checker"), bl);
        JSpellComponent jSpellComponent = new JSpellComponent(textSource, string);
        this.setComponent(jSpellComponent);
        jSpellComponent.setPersonalDictionary("%L%.tdi");
        jSpellComponent.loadPrefs();
        if (string2 != null) {
            jSpellComponent.selectDictionary(string2);
        }
    }

    public JSpellDialog(JDialog jDialog, TextSource textSource, String string, String string2, boolean bl) throws Exception {
        super(jDialog, JSpellComponent.lmsg("Spell-Checker"), bl);
        JSpellComponent jSpellComponent = new JSpellComponent(textSource, string);
        this.setComponent(jSpellComponent);
        jSpellComponent.setPersonalDictionary("%L%.tdi");
        jSpellComponent.loadPrefs();
        if (string2 != null) {
            jSpellComponent.selectDictionary(string2);
        }
    }

    public static boolean check(JTextComponent jTextComponent, String string, boolean bl) throws Exception {
        JSpellDialog.initStaticChecker(jTextComponent, string);
        int n = jTextComponent.getSelectionStart();
        int n2 = jTextComponent.getSelectionEnd();
        jTextComponent.setCaretPosition(0);
        JTextSource jTextSource = new JTextSource(jTextComponent);
        StaticDialog.setSource(jTextSource);
        if (JSpellDialog.StaticDialog.getSize().width == 0) {
            JSpellDialog.place(StaticDialog, jTextComponent, 2, -1);
        }
        StaticDialog.popup(true, bl);
        jTextComponent.select(n, n2);
        SpellControl spellControl = StaticDialog.getChecker();
        spellControl.savePersonalDictionaries();
        JSpellComponent jSpellComponent = StaticDialog.getComponent();
        jSpellComponent.savePrefs();
        return jSpellComponent.isDoneButtonClicked();
    }

    public static JTextAutoSpellCheck enableAutoCheck(JTextComponent jTextComponent, String string) throws Exception {
        JTextAutoSpellCheck jTextAutoSpellCheck = null;
        JSpellDialog.initStaticChecker(jTextComponent, string);
        JTextAutoSpellCheck.stopChecking(jTextComponent);
        jTextAutoSpellCheck = new JTextAutoSpellCheck(jTextComponent, StaticDialog.getChecker(), string, true);
        return jTextAutoSpellCheck;
    }

    public static void disableAutoCheck(JTextComponent jTextComponent) {
        try {
            JSpellDialog.initStaticChecker(jTextComponent, null);
            JTextAutoSpellCheck.stopChecking(jTextComponent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(StaticDialog, "** Error: " + exception);
            exception.printStackTrace();
        }
    }

    public static JSpellDialog getStaticDialog() {
        return StaticDialog;
    }

    public static JSpellComponent getStaticComponent() {
        if (StaticDialog != null) {
            return StaticDialog.getComponent();
        }
        return null;
    }

    public static SpellControl getStaticChecker() {
        if (StaticDialog != null) {
            return StaticDialog.getComponent().getChecker();
        }
        return null;
    }

    static void loadPrefrences() {
        if (StaticDialog != null) {
            JSpellComponent jSpellComponent = StaticDialog.getComponent();
            jSpellComponent.loadPrefs();
        }
    }

    static void initStaticChecker(JTextComponent jTextComponent, String string) throws Exception {
        if (jTextComponent == null) {
            throw new IllegalArgumentException("null Text Component");
        }
        if (StaticDialog == null) {
            JDialog jDialog;
            String string2;
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, jTextComponent);
            String string3 = string2 = string == null ? "en" : string;
            StaticDialog = jFrame != null ? new JSpellDialog(jFrame, null, null, string2, true) : ((jDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, jTextComponent)) != null ? new JSpellDialog(jDialog, null, null, string2, true) : new JSpellDialog(new JFrame(), null, null, string2, true));
        }
        if (string == null) {
            StaticDialog.getComponent().selectDictionary();
        } else {
            StaticDialog.getComponent().selectDictionary(string);
        }
    }

    public TextSource getSource() {
        return this.getComponent().getSource();
    }

    public void setSource(TextSource textSource) {
        this.getComponent().setSource(textSource);
    }

    public void setSource(JTextComponent jTextComponent) {
        this.getComponent().setSource(new JTextSource(jTextComponent));
    }

    public JSpellComponent getComponent() {
        return this.component_;
    }

    public SpellControl getChecker() {
        return this.getComponent().getChecker();
    }

    void setComponent(JSpellComponent jSpellComponent) {
        this.component_ = jSpellComponent;
        this.component_.addActionListener(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.component_, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                try {
                    JSpellDialog.this.component_.done();
                    JSpellDialog.this.popup(false, false);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(JSpellDialog.this, "** Error: " + exception);
                }
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JSpellDialog.this.component_.done();
                    JSpellDialog.this.popup(false, false);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(JSpellDialog.this, "** Error: " + exception);
                }
            }
        };
        this.getRootPane().getActionMap().put("close", abstractAction);
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(87, n), "close");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "close");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("spell_done")) {
            this.popup(false, false);
        }
    }

    public void popup(boolean bl, boolean bl2) {
        if (bl) {
            int n = 0;
            try {
                this.component_.setAutoDismiss(bl2);
                this.component_.setDoneButtonClicked(false);
                n = this.component_.check();
            }
            catch (Exception exception) {
                this.component_.status("** Error: " + exception);
                exception.printStackTrace();
            }
            if (n != 0 || !bl2) {
                this.pack();
                super.setVisible(true);
                this.toFront();
            }
        } else {
            super.setVisible(false);
            this.dispose();
        }
    }

    public static void place(Window window, Component component, int n, int n2) {
        Dimension dimension = component.getToolkit().getScreenSize();
        window.pack();
        Dimension dimension2 = window.getSize();
        Window window2 = (Window)SwingUtilities.getAncestorOfClass(Window.class, window);
        Rectangle rectangle = window2.getBounds();
        int n3 = rectangle.x;
        switch (n) {
            case -2: {
                n3 = rectangle.x - dimension2.width;
                break;
            }
            case -1: {
                n3 = rectangle.x;
                break;
            }
            case 0: {
                n3 = rectangle.x + (rectangle.width - dimension2.width) / 2;
                break;
            }
            case 1: {
                n3 = rectangle.x + rectangle.width - dimension2.width;
                break;
            }
            case 2: {
                n3 = rectangle.x + rectangle.width;
            }
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 + dimension2.width > dimension.width) {
            n3 = dimension.width - dimension2.width;
        }
        int n4 = rectangle.y;
        switch (n2) {
            case -2: {
                n4 = rectangle.y - dimension2.height;
                break;
            }
            case -1: {
                n4 = rectangle.y;
                break;
            }
            case 0: {
                n4 = rectangle.y + (rectangle.height - dimension2.height) / 2;
                break;
            }
            case 1: {
                n4 = rectangle.y + rectangle.height - dimension2.height;
                break;
            }
            case 2: {
                n4 = rectangle.y + rectangle.height;
            }
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 + dimension2.height > dimension.height) {
            n4 = dimension.height - dimension2.height;
        }
        window.setLocation(n3, n4);
    }
}

