/*
 * Decompiled with CFR 0.152.
 */
package azcheck.util;

import azcheck.util.DataReader;

public class CoreReader
implements DataReader {
    byte[] data_;
    int ptr_;

    public CoreReader(byte[] byArray) {
        this.data_ = byArray;
        this.ptr_ = 0;
    }

    public byte[] getData() {
        return this.data_;
    }

    public void seek(int n) {
        this.ptr_ = n;
    }

    public void skip(int n) {
        this.ptr_ += n;
    }

    public byte getByte() {
        return this.data_[this.ptr_++];
    }

    public int getInt(int n) {
        int n2 = this.data_[this.ptr_++] & 0xFF;
        if (n > 1) {
            n2 += (this.data_[this.ptr_++] & 0xFF) << 8;
        }
        if (n > 2) {
            n2 += (this.data_[this.ptr_++] & 0xFF) << 16;
        }
        if (n > 3) {
            n2 += (this.data_[this.ptr_++] & 0xFF) << 24;
        }
        return n2;
    }

    public int[] getIntArray(int n, int n2) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt(n2);
        }
        return nArray;
    }

    public int getInt() {
        return this.getInt(4);
    }

    public int getVarInt() {
        throw new RuntimeException("not implemented");
    }

    public byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.data_, this.ptr_, byArray, 0, n);
        this.ptr_ += n;
        return byArray;
    }

    public String getString() {
        int n = this.getInt(4);
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.getInt(2);
        }
        return new String(cArray);
    }

    public int sortedArrayFind(byte by, int n) {
        int n2 = this.ptr_;
        int n3 = this.ptr_ + n;
        int n4 = this.ptr_;
        this.ptr_ = n3;
        if (n == 1) {
            return this.data_[n4] == by ? 0 : -1;
        }
        while (n2 < n3) {
            int n5 = (n2 + n3) / 2;
            if (this.data_[n5] == by) {
                return n5 - n4;
            }
            if (this.data_[n5] > by) {
                n3 = n5;
                continue;
            }
            n2 = n5 + 1;
        }
        return -1;
    }
}

