/*
 * Decompiled with CFR 0.152.
 */
package com.appframework;

import azcheck.engine.SpellException;
import azcheck.engine.Suggestions;
import azcheck.ui.JSpellDialog;
import azcheck.ui.SpellControl;
import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.ViewHTMLTextPane;
import com.appframework.components.htmleditor.ViewSourceFrame;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.utils.OS;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.ActionReply;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.itemview.itemviewer.ItemViewer;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.regex.Matcher;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.apache.log4j.Logger;

public class SCMouseListener
extends MouseAdapter {
    private static Logger logger = Logger.getLogger(SCMouseListener.class);
    private JTextComponent target = null;
    private String word;
    private DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
    private boolean isRTSpellCheckenabled = (Boolean)this.dataStoreSettings.getCheckSpellingAsYouType().getValue();

    public void mousePressed(MouseEvent e) {
        if (!OS.isDoubleClick(e)) {
            if (!e.isPopupTrigger()) {
                this.word = null;
            }
            this.doPopup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.doPopup(e);
    }

    private void doPopup(MouseEvent e) {
        if (e.isPopupTrigger() && !e.isConsumed()) {
            Window window;
            String selectedText;
            JMenuItem item;
            GWPopupMenu popup = new GWPopupMenu();
            SpellControl spellControl = JSpellDialog.getStaticChecker();
            Suggestions suggestions = null;
            this.selectWordAtCursor(e);
            boolean isEditable = this.target.isEditable();
            if (isEditable && spellControl != null) {
                try {
                    int error;
                    if (this.word != null && (error = spellControl.checkWord(this.word)) != 0) {
                        switch (error) {
                            case 4: {
                                item = new JMenuItem(StringResources.DUPLICATE_WORD);
                                popup.add(item);
                                break;
                            }
                            case 5: {
                                item = new JMenuItem(StringResources.PUNCTUATION_PROBLEM);
                                popup.add(item);
                                break;
                            }
                            case 3: {
                                item = new JMenuItem(StringResources.WORD_SHOULD_BE_CAPITALIZED);
                                popup.add(item);
                            }
                            case 2: {
                                suggestions = spellControl.getSuggestions(this.word);
                                int suggestCount = suggestions.getCount();
                                if (suggestCount > 0) {
                                    ActionListener menuListener = new ActionListener(){

                                        public void actionPerformed(ActionEvent event) {
                                            String newWord = event.getActionCommand();
                                            SCMouseListener.this.target.replaceSelection(newWord);
                                        }
                                    };
                                    for (int c = 0; c < suggestCount; ++c) {
                                        String suggestion = suggestions.getSuggestion(c);
                                        item = new JMenuItem(suggestion);
                                        item.addActionListener(menuListener);
                                        popup.add(item);
                                    }
                                    popup.addSeparator();
                                }
                                item = new JMenuItem(StringResources.LEARN_WORD);
                                ActionListener learnWordListener = new ActionListener(){

                                    public void actionPerformed(ActionEvent event) {
                                        SpellControl spellControl = JSpellDialog.getStaticChecker();
                                        try {
                                            spellControl.add(SCMouseListener.this.word);
                                            spellControl.savePersonalDictionaries();
                                            SCMouseListener.this.target.replaceSelection(SCMouseListener.this.word);
                                        }
                                        catch (Exception e) {
                                            logger.debug((Object)("Error: " + e));
                                            e.printStackTrace();
                                        }
                                    }
                                };
                                item.addActionListener(learnWordListener);
                                popup.add(item);
                                item = new JMenuItem(StringResources.IGNORE_WORD);
                                ActionListener ignoreWordListener = new ActionListener(){

                                    public void actionPerformed(ActionEvent event) {
                                        SpellControl spellControl = JSpellDialog.getStaticChecker();
                                        try {
                                            spellControl.ignoreAll(SCMouseListener.this.word);
                                            SCMouseListener.this.target.replaceSelection(SCMouseListener.this.word);
                                        }
                                        catch (SpellException e) {
                                            logger.debug((Object)("Error: " + (Object)((Object)e)));
                                            e.printStackTrace();
                                        }
                                    }
                                };
                                item.addActionListener(ignoreWordListener);
                                popup.add(item);
                            }
                        }
                    }
                    JMenuItem spellCheck = MenuItemFactory.createCkeckBoxMenuItem(StringResources.ACTION_RT_SPELL_CHECKER);
                    if (this.isRTSpellCheckenabled) {
                        spellCheck.setSelected(true);
                    }
                    ActionListener rtSpellCheckListener = new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            if (SCMouseListener.this.target != null) {
                                if (SCMouseListener.this.isRTSpellCheckenabled) {
                                    JSpellDialog.disableAutoCheck((JTextComponent)SCMouseListener.this.target);
                                    SCMouseListener.this.isRTSpellCheckenabled = false;
                                } else {
                                    try {
                                        JSpellDialog.enableAutoCheck((JTextComponent)SCMouseListener.this.target, (String)OS.getDictLanguage());
                                        SCMouseListener.this.isRTSpellCheckenabled = true;
                                    }
                                    catch (Exception e) {
                                        try {
                                            JSpellDialog.enableAutoCheck((JTextComponent)SCMouseListener.this.target, (String)String.format("%s-%s", Locale.US.getLanguage(), Locale.US.getCountry()));
                                        }
                                        catch (Exception e1) {
                                            logger.error((Object)e1);
                                            logger.debug((Object)e1, (Throwable)e1);
                                        }
                                    }
                                }
                            }
                        }
                    };
                    spellCheck.addActionListener(rtSpellCheckListener);
                    popup.add(spellCheck);
                    popup.addSeparator();
                }
                catch (SpellException ex) {
                    // empty catch block
                }
            }
            boolean isSelected = (selectedText = this.target.getSelectedText()) != null && selectedText.length() > 0;
            item = new JMenuItem(StringResources.ACTION_CUT);
            ActionListener cutListener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    SCMouseListener.this.target.cut();
                }
            };
            item.setEnabled(isEditable && isSelected);
            item.addActionListener(cutListener);
            popup.add(item);
            item = new JMenuItem(StringResources.ACTION_COPY);
            ActionListener copyListener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    SCMouseListener.this.target.copy();
                }
            };
            item.addActionListener(copyListener);
            item.setEnabled(isSelected);
            popup.add(item);
            item = new JMenuItem(StringResources.ACTION_PASTE);
            ActionListener pasteListener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    SCMouseListener.this.target.paste();
                }
            };
            item.addActionListener(pasteListener);
            item.setEnabled(isEditable);
            popup.add(item);
            if (this.target instanceof HTMLTextPane && (window = SwingUtilities.getWindowAncestor(this.target)) instanceof ApplicationFrame) {
                ApplicationFrame appFrame = (ApplicationFrame)window;
                if (appFrame instanceof FrameOpen) {
                    ActionReply actionReply = (ActionReply)appFrame.getAppActionList().getAction(ActionKey.REPLY);
                    item = new JMenuItem(StringResources.REPLY);
                    item.addActionListener(actionReply);
                    item.setEnabled(true);
                    popup.add(item);
                }
                popup.add(new JSeparator());
                item = new JMenuItem(StringResources.VIEW_SOURCE);
                ActionListener viewSourceListener = new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        ViewSourceFrame.display(((ViewHTMLTextPane)SCMouseListener.this.target).getStyledText());
                    }
                };
                item.addActionListener(viewSourceListener);
                item.setEnabled(true);
                popup.add(item);
                ItemViewer viewer = (ItemViewer)SwingUtilities.getAncestorOfClass(ItemViewer.class, this.target);
                if (viewer != null) {
                    popup.add(new JSeparator());
                    popup.add(viewer.getCharsetMenu());
                }
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    private void selectWordAtCursor(MouseEvent e) {
        try {
            Component comp = e.getComponent();
            if (comp instanceof JTextComponent) {
                int oldEnd;
                this.target = (JTextComponent)comp;
                int oldStart = this.target.getSelectionStart();
                if (oldStart == (oldEnd = this.target.getSelectionEnd()) || this.word != null) {
                    String text;
                    String trimmedText;
                    boolean isEmpty;
                    int offs = this.target.viewToModel(e.getPoint());
                    int begOffs = Utilities.getWordStart(this.target, offs);
                    int endOffs = Utilities.getWordEnd(this.target, offs);
                    Document document = this.target.getDocument();
                    int linkBegOffs = begOffs;
                    int linkEndOffs = endOffs;
                    while (linkBegOffs > 0 && !Character.isWhitespace(document.getText(linkBegOffs - 1, 1).charAt(0)) && document.getText(linkBegOffs - 1, 1).charAt(0) != '\u00a0') {
                        linkBegOffs = Utilities.getWordStart(this.target, linkBegOffs - 1);
                    }
                    while (linkEndOffs < document.getLength() && !Character.isWhitespace(document.getText(linkEndOffs, 1).charAt(0)) && document.getText(linkEndOffs, 1).charAt(0) != '\u00a0') {
                        linkEndOffs = Utilities.getWordEnd(this.target, linkEndOffs);
                    }
                    String textToCheckForLink = document.getText(linkBegOffs, linkEndOffs - linkBegOffs);
                    Matcher m = HTMLUtils.PATTERN_HYPERLINK.matcher(textToCheckForLink);
                    if (m.find()) {
                        begOffs = linkBegOffs;
                        endOffs = linkEndOffs;
                    }
                    if (isEmpty = "".equals(trimmedText = (text = document.getText(begOffs, endOffs - begOffs)).trim())) {
                        this.word = null;
                        this.target.setSelectionStart(endOffs);
                        this.target.setSelectionEnd(endOffs);
                    } else {
                        this.target.setCaretPosition(begOffs);
                        this.target.moveCaretPosition(endOffs);
                        this.word = this.target.getSelectedText();
                    }
                }
            }
        }
        catch (BadLocationException bl) {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            lookAndFeel.provideErrorFeedback(this.target);
        }
    }
}

