/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton;

import java.awt.Color;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class SmartFilter
extends RGBImageFilter {
    public static final String PANEL_BACKGROUND = "Panel.background";
    private Container parent;
    private double filterWeight = 0.7;

    public SmartFilter(double filterWeight) {
        if (filterWeight > 1.0) {
            filterWeight = 1.0;
        } else if (filterWeight < 0.0) {
            filterWeight = 0.0;
        }
        this.filterWeight = filterWeight;
        this.canFilterIndexColorModel = true;
    }

    public static Image createDisabledImage(JComponent component, ImageIcon i) {
        SmartFilter filter = new SmartFilter(0.7);
        filter.parent = component.getParent();
        FilteredImageSource prod = new FilteredImageSource(i.getImage().getSource(), filter);
        Image filteredImage = Toolkit.getDefaultToolkit().createImage(prod);
        return filteredImage;
    }

    public int filterRGB(int x, int y, int rgb) {
        if (rgb >= 0) {
            return 0;
        }
        int red = rgb & 0xFF0000;
        red >>= 16;
        int green = rgb & 0xFF00;
        green >>= 8;
        int blue = rgb & 0xFF;
        Color color = null;
        if (this.parent != null) {
            color = this.parent.getBackground();
        }
        if (color == null) {
            color = UIManager.getColor(PANEL_BACKGROUND);
        }
        int r = (int)((double)red * (1.0 - this.filterWeight) + (double)color.getRed() * this.filterWeight);
        int g = (int)((double)green * (1.0 - this.filterWeight) + (double)color.getGreen() * this.filterWeight);
        int b = (int)((double)blue * (1.0 - this.filterWeight) + (double)color.getBlue() * this.filterWeight);
        return new Color(r, g, b).getRGB();
    }
}

