/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton;

import com.appframework.AppAction;
import com.appframework.components.customizedbutton.SmartFilter;
import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ToolBarColorButton
extends ToolBarButton {
    private static final Logger logger = Logger.getLogger(ToolBarColorButton.class);
    private Color labelColor = null;
    private boolean isBorderPaintedValue = true;
    private String roundState = "both";
    public static final String ROUND_LEFT = "left";
    public static final String ROUND_RIGHT = "right";
    public static final String ROUND_BOTH = "both";
    public static final String ROUND_NONE = "none";

    public ToolBarColorButton() {
    }

    public ToolBarColorButton(AppAction a) {
        super(a);
        this.setOpaque(false);
    }

    public ToolBarColorButton(AppAction a, String theRoundState) {
        super(a);
        this.setOpaque(false);
        this.roundState = theRoundState;
    }

    public String getName() {
        return super.getName() != null ? super.getName() : (String)this.getAction().getValue("Name");
    }

    public void setRoundState(String theRoundState) {
        this.roundState = theRoundState;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.updateDisableIcon();
    }

    public void setIcon(Icon newIcon) {
        super.setIcon(newIcon);
        this.updateDisableIcon();
    }

    public String getRoundState() {
        return this.roundState;
    }

    public void updateUI() {
        super.updateUI();
        this.getModel().setPressed(false);
        this.getModel().setRollover(false);
    }

    public void paint(Graphics g) {
        if (this.skinnableDelegate.isSkinabilityEnabled()) {
            this.setContentAreaFilled(false);
            this.setBorder(null);
            if (this.getModel().isRollover() || this.isAlwaysPressed()) {
                this.setForeground((Color)this.getClientProperty((Object)SkinProperty.HIGHLIGHTED_TEXT_COLOR));
            } else {
                this.setForeground((Color)this.getClientProperty((Object)SkinProperty.TOOLBAR_TEXT_COLOR));
            }
            if (this.isEnabled() && (this.getModel().isRollover() || this.isAlwaysPressed())) {
                UIUtils.paintGradient(g, this, this.roundState, this.isBorderPaintedValue, this.getModel().isPressed() || this.isAlwaysPressed());
            }
        }
        super.paint(g);
    }

    private void updateDisableIcon() {
        if (this.getIcon() != null) {
            this.setDisabledIcon(new ImageIcon(SmartFilter.createDisabledImage(this, (ImageIcon)this.getIcon())));
        }
    }
}

