/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton;

import com.appframework.AppAction;
import com.appframework.CustomizableToolBarComponent;
import com.appframework.components.GWBorder;
import com.appframework.components.customizedbutton.ActionDisabler;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableToggleButton;
import com.novell.gw.jclient.bl.om.options.ToolBarOptions;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ToolBarToggleButton
extends SkinnableToggleButton
implements CustomizableToolBarComponent {
    private static Logger logger = Logger.getLogger(ToolBarToggleButton.class);
    private Insets insets = new Insets(4, 5, 4, 5);
    private String displayText;
    private boolean showTextLabel = true;
    private boolean alwaysPressed = false;
    private boolean previewMode = false;
    private boolean disabledMode = false;

    public ToolBarToggleButton(ImageIcon theImageIcon) {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_BORDER_COLOR, ComponentProperty.BACKGROUND);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.TOOLBAR_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SELECTED_TOOLBAR_BTN_BACKROUND_COLOR, ComponentProperty.CUSTOM);
        this.setModel(new ToolBarToggleButtonModel());
        this.setIcon(theImageIcon);
        this.init();
    }

    public void setAlwaysPressed(boolean b) {
        this.alwaysPressed = b;
        this.getModel().setSelected(false);
        this.repaint();
    }

    public boolean isAlwaysPressed() {
        return this.alwaysPressed;
    }

    public ToolBarToggleButton(Action a) {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_BORDER_COLOR, ComponentProperty.BACKGROUND);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.TOOLBAR_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.SELECTED_TOOLBAR_BTN_BACKROUND_COLOR, ComponentProperty.CUSTOM);
        this.displayText = (String)a.getValue("Name");
        this.setModel(new ToolBarToggleButtonModel());
        this.setAction(a);
        this.init();
    }

    public ButtonGroup getGroup() {
        return ((ToolBarToggleButtonModel)this.getModel()).getGroup();
    }

    protected void init() {
        this.setOpaque(false);
        this.getModel().setArmed(true);
        this.setFocusable(false);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.addMouseListener(new ButtonMouseAdapter());
        this.addChangeListener(new ButtonChangeListener());
        this.setBorder(GWBorder.NO_BORDER);
        this.setMargin(this.insets);
        this.setActionCommand("sdsads");
    }

    public void setEnabled(boolean b) {
        if (this.previewMode && !b) {
            return;
        }
        if (this.disabledMode && b) {
            return;
        }
        super.setEnabled(b);
        this.getModel().setArmed(false);
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.setBorderPainted(!GWBorder.NO_BORDER.equals(border));
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setMargin(Insets m) {
        super.setMargin(m);
        this.insets = m;
    }

    public void changeComponentStyle(ToolBarOptions.Style style) {
        UIUtils.changeToolbarButtonStyle(this, this.displayText, style, this.showTextLabel);
        this.setOpaque(false);
    }

    public void setPreviewMode(boolean b) {
        if (this.disabledMode) {
            throw new IllegalStateException("control is in disabled mode");
        }
        this.previewMode = b;
        if (b) {
            this.changeAction(new ActionDisabler(this.getAction()));
            this.setEnabled(true);
        } else {
            Action action = this.getAction();
            if (action instanceof ActionDisabler) {
                this.changeAction(((ActionDisabler)action).getOriginalAction());
            }
        }
    }

    public boolean isPreviewMode() {
        return this.previewMode;
    }

    private void changeAction(Action newAction) {
        String text = this.getText();
        this.setAction(newAction);
        this.setText(text);
    }

    public ActionKey getDefaultActionName() {
        ActionKey name;
        if (this.getAction() instanceof AppAction) {
            name = ((AppAction)this.getAction()).getActionKey();
        } else if (this.getAction() instanceof ActionDisabler) {
            name = ((AppAction)((ActionDisabler)this.getAction()).getOriginalAction()).getActionKey();
        } else {
            throw new AssertionError((Object)("Unexpected action class encountered: " + this.getAction().getClass().getName()));
        }
        if (name == null) {
            logger.warn((Object)"name is null");
        }
        return name;
    }

    public void addDefaultActionListener(ActionListener actionListener) {
        this.addActionListener(actionListener);
    }

    public void setShowTextLabel(boolean b) {
        this.showTextLabel = b;
    }

    public boolean showTextLabel() {
        return this.showTextLabel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ToolBarToggleButton)) {
            return false;
        }
        ToolBarToggleButton button = (ToolBarToggleButton)obj;
        if (button.getAction() == null) {
            return super.equals(obj);
        }
        return button.getAction().equals(this.getAction());
    }

    public int hashCode() {
        if (this.getAction() == null) {
            return super.hashCode();
        }
        int result = 17;
        result = 37 * result + this.getAction().hashCode();
        return result;
    }

    public boolean isDisabledMode() {
        return this.disabledMode;
    }

    public void setDisabledMode(boolean disabled) {
        if (this.previewMode) {
            throw new IllegalStateException("control is in preview mode");
        }
        this.disabledMode = disabled;
        if (disabled) {
            this.changeAction(new ActionDisabler(this.getAction()));
            this.setEnabled(false);
        } else {
            Action action = this.getAction();
            if (action instanceof ActionDisabler) {
                this.changeAction(((ActionDisabler)action).getOriginalAction());
            }
        }
    }

    static class ToolBarToggleButtonModel
    extends JToggleButton.ToggleButtonModel {
        ToolBarToggleButtonModel() {
        }

        public boolean isSelected() {
            if (this.getGroup() != null) {
                return this.getGroup().isSelected(this);
            }
            return (this.stateMask & 2) != 0;
        }

        public void setSelected(boolean b) {
            ButtonGroup group = this.getGroup();
            if (group != null) {
                group.setSelected(this, b);
                b = group.isSelected(this);
            } else if (this.isSelected() == b) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }
    }

    class ButtonChangeListener
    implements ChangeListener {
        ButtonChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (ToolBarToggleButton.this.isSelected()) {
                ToolBarToggleButton.this.setBorder(GWBorder.LOWERED_BORDER);
            } else {
                ToolBarToggleButton.this.setBorder(GWBorder.NO_BORDER);
            }
        }
    }

    class ButtonMouseAdapter
    extends MouseAdapter {
        ButtonMouseAdapter() {
        }

        public void mouseEntered(MouseEvent e) {
            ToolBarToggleButton.this.getModel().setArmed(false);
            if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                return;
            }
            ToolBarToggleButton.this.setBorder(GWBorder.RAISED_BORDER);
        }

        public void mouseExited(MouseEvent e) {
            ToolBarToggleButton.this.getModel().setArmed(true);
            if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                return;
            }
            ToolBarToggleButton.this.setBorder(GWBorder.NO_BORDER);
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                    return;
                }
                ToolBarToggleButton.this.setBorder(GWBorder.LOWERED_BORDER);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                return;
            }
            ToolBarToggleButton b = ToolBarToggleButton.this;
            if (0 <= e.getX() && e.getX() < b.getSize().width && 0 <= e.getY() && e.getY() < b.getSize().height) {
                ((JComponent)b).setBorder(GWBorder.RAISED_BORDER);
            } else {
                ((JComponent)b).setBorder(GWBorder.NO_BORDER);
            }
        }
    }
}

