/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.utils.OS;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;

public class HTMLConstants {
    private static final int DEFAULT_FONT_SIZE = 10;
    public static final int MODE_INITIAL = -1;
    public static final int MODE_HTML_VIEW = 1;
    public static final int MODE_RTF_TEXT_VIEW = 2;
    public static final int MODE_RTF_TEXT_EDIT = 3;
    public static final int DEFAULT_COMPOSER_ZOOM_FACTOR = 100;
    public static final int DEFAULT_VIEWER_ZOOM_FACTOR = 120;
    public static final int MIN_ZOOM_FACTOR = 50;
    public static final int MAX_ZOOM_FACTOR = 500;
    public static final int ZOOM_STEP = 20;
    public static final int MARGIN_LEFT_DEFAULT = 5;
    public static final int MARGIN_RIGHT_DEFAULT = 5;
    public static final int MARGIN_TOP_DEFAULT = 5;
    public static final int MARGIN_BOTTOM_DEFAULT = 5;

    public static String getDefaultFontName(int theMode) {
        MachineSettings.TextOption textOption = OptionManager.getInstance().getTextOption();
        String fontName = null;
        if (theMode == 1) {
            fontName = textOption.getDefaultComposeHTMLFont();
        } else if (theMode == 3) {
            fontName = textOption.getDefaultComposePlainTextFont();
        } else if (theMode == 2) {
            fontName = textOption.getDefaultReadPlainTextFont();
        }
        if (fontName == null || fontName.trim().length() == 0) {
            fontName = PLAFChanger.getFontName();
        }
        return fontName;
    }

    public static String getDefaultFontName(int theMode, boolean isEditable) {
        return HTMLConstants.getDefaultFontName(theMode);
    }

    public static Integer getDefaultFontSizeFromOptions(int theMode) {
        MachineSettings.TextOption textOption = OptionManager.getInstance().getTextOption();
        Integer fontSize = null;
        if (theMode == 1) {
            fontSize = textOption.getDefaultComposeHTMLFontSize();
        } else if (theMode == 3) {
            fontSize = textOption.getDefaultComposePlainTextFontSize();
        } else if (theMode == 2) {
            fontSize = textOption.getDefaultReadPlainTextFontSize();
        }
        return fontSize;
    }

    public static int getDefaultFontSize(int theMode) {
        Integer fontSize = HTMLConstants.getDefaultFontSizeFromOptions(theMode);
        if (fontSize == null || fontSize == 0) {
            int defaultFontSize = PLAFChanger.getFontSize();
            if (!OS.isMacOS() && !PLAFChanger.isAsianLang()) {
                defaultFontSize = 10;
            }
            fontSize = new Integer(defaultFontSize);
        }
        return fontSize;
    }

    public static int getDefaultFontSize(int theMode, boolean isEditable) {
        return HTMLConstants.getDefaultFontSize(theMode);
    }
}

