/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.BrowserType;
import com.appframework.components.htmleditor.GWBrowserFactory;
import com.appframework.components.htmleditor.GWMozillaBrowser;
import com.appframework.components.htmleditor.HTMLExternalTextViewerController;
import com.appframework.components.htmleditor.HTMLTextViewer;
import com.appframework.components.htmleditor.HTMLViewer;
import com.appframework.components.htmleditor.ProxyConfiguration;
import com.appframework.components.htmleditor.SimpleHTMLViewer;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.GWClient;
import com.webrenderer.swing.event.BrowserListener;
import com.webrenderer.swing.event.NetworkAdapter;
import com.webrenderer.swing.event.NetworkEvent;
import com.webrenderer.swing.event.NetworkListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.security.InvalidParameterException;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class HTMLExternalTextViewer
extends HTMLViewer
implements MVCView {
    private static Logger logger = Logger.getLogger(HTMLExternalTextViewer.class);
    private static final int MIN_ZOOM_STEPS = -5;
    private static final int MAX_ZOOM_STEPS = 5;
    private static final String BROWSER = "Browser";
    private static final String MESSAGE_VIEWER = "Message Viewer";
    private GWMozillaBrowser browser;
    private HTMLTextViewer simpleMessageViewer;
    private int mode = -1;
    private int currentZoom = 0;
    private CardLayout cardLayout;
    private MVCController controller;

    public HTMLExternalTextViewer(MVCController theParentController) {
        this.controller = new HTMLExternalTextViewerController(this, theParentController);
        this.setFocusable(false);
        this.buildUI(this.controller);
    }

    private void buildUI(MVCController theParentController) {
        this.browser = GWBrowserFactory.getBrowser(theParentController, BrowserType.CONTENT_VIEWER);
        this.browser.addNetworkListener((NetworkListener)new MozillaBrowserDocumentLoadListener());
        this.simpleMessageViewer = new HTMLTextViewer();
        this.simpleMessageViewer.setMode(2);
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
    }

    public void addBrowserHyperlinkListener(BrowserListener theListener) {
        this.browser.addBrowserListener(theListener);
    }

    public void addRTFViewerMouseListeners(MouseListener theMouseListener, MouseMotionListener theMMListener) {
        this.simpleMessageViewer.getTextComponent().addMouseListener(theMouseListener);
        this.simpleMessageViewer.getTextComponent().addMouseMotionListener(theMMListener);
    }

    public void setMode(int theMode) {
        if (theMode == 2 && this.mode != 2) {
            logger.debug((Object)"Set RTF view mode");
            this.mode = theMode;
            if (this.browser.isVisible()) {
                ((Component)this.browser).setVisible(false);
            }
            if (!this.contains(this.simpleMessageViewer)) {
                this.add((Component)this.simpleMessageViewer, MESSAGE_VIEWER);
            }
            this.cardLayout.show(this, MESSAGE_VIEWER);
        } else if (theMode == 1 && this.mode != 1) {
            logger.debug((Object)"Set HTML view mode");
            this.mode = theMode;
            if (!this.contains(this.browser)) {
                this.add((Component)this.browser, BROWSER);
            }
            this.cardLayout.show(this, BROWSER);
        }
    }

    private boolean contains(Component theComponent) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (component != theComponent) continue;
            return true;
        }
        return false;
    }

    public int getMode() {
        return this.mode;
    }

    public void setPage(URL theURL) {
        if (this.mode != 1) {
            throw new InvalidParameterException("Invalid mode: [" + this.mode + ']');
        }
        logger.debug((Object)("Set HTML page: [" + theURL + ']'));
        this.browser.setPage(theURL);
    }

    public void setDragEnabled(boolean isEnabled) {
        if (this.mode == 2) {
            this.simpleMessageViewer.setDragEnabled(isEnabled);
        }
    }

    public void setCaretPosition(int thePosition) {
        if (this.mode == 2) {
            this.simpleMessageViewer.setCaretPosition(thePosition);
        }
    }

    public void setPlainText(String thePlainText) {
        if (this.mode == 2) {
            logger.debug((Object)"Set RTF plain test");
            this.simpleMessageViewer.setPlainText(thePlainText);
        } else if (this.mode == 1) {
            logger.debug((Object)"Set HTML plain test");
            this.setStyledText(UIUtils.wrapIntoHTML(thePlainText));
        } else {
            throw new RuntimeException("Invalid mode: [" + this.mode + ']');
        }
    }

    public void setStyledText(String theStyledText) {
        if (this.mode == 2) {
            logger.debug((Object)"Set RTF text");
            this.simpleMessageViewer.setStyledText(theStyledText);
        } else if (this.mode == 1) {
            logger.debug((Object)"Set HTML text");
            this.browser.setStyledText(theStyledText);
        } else {
            throw new RuntimeException("Invalid mode: [" + this.mode + ']');
        }
    }

    public void clear() {
        if (this.mode == 2) {
            this.simpleMessageViewer.clear();
        } else if (this.mode == 1) {
            this.browser.clear();
        } else {
            throw new RuntimeException("Invalid mode: [" + this.mode + ']');
        }
    }

    public JTextComponent getTextComponent() {
        if (this.mode == 2 || this.mode == 3) {
            return this.simpleMessageViewer.getTextComponent();
        }
        throw new RuntimeException("Invalid component state. Use external brawser: [" + GWClient.USE_EXTERNAL_HTML_VIEWER() + "], " + "mode: [" + this.mode + ']');
    }

    public void zoom(boolean isZoomIn) {
        if (this.mode == 2) {
            this.simpleMessageViewer.zoom(isZoomIn);
        } else if (this.mode == 1) {
            if (isZoomIn && this.currentZoom < 5) {
                this.browser.increaseTextZoom();
                ++this.currentZoom;
            } else if (!isZoomIn && this.currentZoom > -5) {
                this.browser.decreaseTextZoom();
                --this.currentZoom;
            }
        } else {
            throw new RuntimeException("Invalid mode: [" + this.mode + ']');
        }
    }

    public void resetZoom() {
        if (this.mode == 2) {
            this.simpleMessageViewer.resetZoom();
        } else if (this.mode == 1) {
            if (this.currentZoom > 0) {
                while (this.currentZoom > 0) {
                    this.browser.decreaseTextZoom();
                    --this.currentZoom;
                }
            } else if (this.currentZoom < 0) {
                while (this.currentZoom < 0) {
                    this.browser.increaseTextZoom();
                    ++this.currentZoom;
                }
            }
        } else {
            throw new RuntimeException("Invalid mode: [" + this.mode + ']');
        }
    }

    private SimpleHTMLViewer getSimpleHTMLViewer() {
        if (this.mode == 2) {
            return this.simpleMessageViewer;
        }
        if (this.mode == 1) {
            return this.browser;
        }
        throw new RuntimeException("Invalid mode: [" + this.mode + ']');
    }

    public void print(boolean showPrintSetupDialog) {
        this.getSimpleHTMLViewer().print(showPrintSetupDialog);
    }

    public boolean isJavascriptEnabled() {
        return this.getSimpleHTMLViewer().isJavascriptEnabled();
    }

    public void setJavascriptEnabled(boolean enabled) {
        this.getSimpleHTMLViewer().setJavascriptEnabled(enabled);
    }

    public boolean canGoBack() {
        return this.getSimpleHTMLViewer().canGoBack();
    }

    public boolean canGoForward() {
        return this.getSimpleHTMLViewer().canGoForward();
    }

    public void goBack() {
        this.getSimpleHTMLViewer().goBack();
    }

    public void goForward() {
        this.getSimpleHTMLViewer().goForward();
    }

    public void reload() {
        this.getSimpleHTMLViewer().reload();
    }

    public void setProxyConfiguration(ProxyConfiguration configuration) {
        this.getSimpleHTMLViewer().setProxyConfiguration(configuration);
    }

    public void setLoadPopupWindowInBrowser(boolean flag) {
        this.getSimpleHTMLViewer().setLoadPopupWindowInBrowser(flag);
    }

    public void refreshTabs() {
        if (this.mode == 2) {
            this.browser.setVisible(true);
            this.browser.setVisible(false);
        }
    }

    public Component getBrowser() {
        return this.browser.getBrowser().getComponent();
    }

    public void setController(MVCController theController) {
    }

    public MVCController getController() {
        return null;
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return null;
    }

    public void enableImages(boolean enable) {
        this.browser.enableImages(enable);
    }

    public String getSelectedText() {
        return this.getSimpleHTMLViewer().getSelectedText();
    }

    public void release() {
        GWBrowserFactory.releaseBrowser(this.browser);
    }

    private class MozillaBrowserDocumentLoadListener
    extends NetworkAdapter {
        private MozillaBrowserDocumentLoadListener() {
        }

        public void onDocumentComplete(NetworkEvent e) {
            HTMLExternalTextViewer.this.browser.setMargins(5, 5, 5, 5);
        }
    }
}

