/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

class HistoryTracker {
    private static final int NO_POSITION = -1;
    private List<URL> history = new ArrayList<URL>();
    private int position = -1;

    HistoryTracker() {
    }

    public void urlLoaded(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        if (this.position == -1) {
            this.addUrlToHistory(url);
        } else if (!url.equals(this.history.get(this.position))) {
            if (this.position > 0 && url.equals(this.history.get(this.position - 1))) {
                --this.position;
            } else if (this.position < this.history.size() - 1 && url.equals(this.history.get(this.position + 1))) {
                ++this.position;
            } else {
                this.addUrlToHistory(url);
            }
        }
    }

    private void addUrlToHistory(URL url) {
        try {
            URL clone = new URL(url.toExternalForm());
            if (this.position == -1) {
                this.history.add(clone);
                this.position = 0;
            } else {
                while (this.position < this.history.size() - 1) {
                    this.history.remove(this.history.size() - 1);
                }
                this.history.add(clone);
                ++this.position;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canGetPreviousUrl() {
        return this.position > 0 && this.position < this.history.size();
    }

    public boolean canGetNextUrl() {
        return this.position >= 0 && this.position < this.history.size() - 1;
    }

    public URL getPreviousUrl() {
        if (!this.canGetPreviousUrl()) {
            throw new IllegalStateException("Can not go back");
        }
        if (this.position == -1) {
            throw new IllegalStateException("position was not set yet");
        }
        if (this.position >= this.history.size()) {
            throw new IllegalStateException("position is illegal");
        }
        return this.history.get(this.position - 1);
    }

    public URL getNextUrl() {
        if (!this.canGetNextUrl()) {
            throw new IllegalStateException("Can not go forward");
        }
        if (this.position == -1) {
            throw new IllegalStateException("position was not set yet");
        }
        if (this.position >= this.history.size()) {
            throw new IllegalStateException("position is illegal");
        }
        return this.history.get(this.position + 1);
    }

    public URL getCurrentUrl() {
        if (this.position == -1) {
            throw new IllegalStateException("position was not set yet");
        }
        if (this.position >= this.history.size()) {
            throw new IllegalStateException("position is illegal");
        }
        return this.history.get(this.position);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HistoryTracker[");
        builder.append("position = ");
        builder.append(this.position);
        builder.append("; Entries: ");
        for (URL url : this.history) {
            builder.append(url.toExternalForm());
            builder.append(", ");
        }
        builder.append(']');
        return builder.toString();
    }
}

