/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.RTFUtils;

public class RTFFontTableEntry {
    public static final String TAG = "f";
    public static final String PREFIX = "\\f";
    private int num = -1;
    private String fontfamily = null;
    private int charset = -1;
    private int prq = -1;
    private String panose = null;
    private String nontaggedname = null;
    private String fontname = null;
    private String fontaltname = null;
    private String fontemb = null;
    private String fonttype = null;
    private String fontfname = null;
    private String codepage = null;
    private boolean ok = false;
    private String result = "";

    public RTFFontTableEntry(String txt) {
        this.parse(txt);
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public String getFontfamily() {
        return this.fontfamily;
    }

    public void setFontfamily(String fontfamily) {
        this.fontfamily = fontfamily;
    }

    public int getCharset() {
        return this.charset;
    }

    public void setCharset(int charset) {
        this.charset = charset;
    }

    public int getPrq() {
        return this.prq;
    }

    public void setPrq(int prq) {
        this.prq = prq;
    }

    public String getPanose() {
        return this.panose;
    }

    public void setPanose(String panose) {
        this.panose = panose;
    }

    public String getNontaggedname() {
        return this.nontaggedname;
    }

    public void setNontaggedname(String nontaggedname) {
        this.nontaggedname = nontaggedname;
    }

    public String getFontname() {
        return this.fontname;
    }

    public void setFontname(String fontname) {
        this.fontname = fontname;
    }

    public String getFontaltname() {
        return this.fontaltname;
    }

    public void setFontaltname(String fontaltname) {
        this.fontaltname = fontaltname;
    }

    public String getFontemb() {
        return this.fontemb;
    }

    public void setFontemb(String fontemb) {
        this.fontemb = fontemb;
    }

    public String getFonttype() {
        return this.fonttype;
    }

    public void setFonttype(String fonttype) {
        this.fonttype = fonttype;
    }

    public String getFontfname() {
        return this.fontfname;
    }

    public void setFontfname(String fontfname) {
        this.fontfname = fontfname;
    }

    public String getCodepage() {
        return this.codepage;
    }

    public void setCodepage(String codepage) {
        this.codepage = codepage;
    }

    public boolean isOk() {
        return this.ok;
    }

    public String getResult() {
        return this.result;
    }

    private void parse(String txt) {
        if (txt == null || txt.length() < 1) {
            this.result = "Null or empty input string [" + txt + ']';
            return;
        }
        if (!txt.startsWith("{\\f")) {
            this.result = "Missing START bracket [" + txt + ']';
            return;
        }
        if (!txt.endsWith(";}")) {
            this.result = "Missing closing bracket [" + txt + ']';
            return;
        }
        StringBuffer sb = new StringBuffer(txt.substring(1, txt.length() - ";}".length()));
        boolean slashFound = false;
        boolean parseTag = false;
        boolean newTagFound = false;
        int id = 0;
        while (sb.length() > 0 && id < sb.length()) {
            char c = sb.charAt(id);
            if (c == '\\') {
                slashFound = true;
            } else if (c == 'f') {
                if (slashFound) {
                    parseTag = true;
                }
            } else if (c == '*') {
                if (slashFound) {
                    newTagFound = true;
                    slashFound = false;
                }
            } else if (c == '{') {
                int subGroupId = id;
                while (id < sb.length() && sb.charAt(id++) != '}') {
                }
                String subgroup = sb.substring(subGroupId, id);
                RTFFontTableEntry.parseSubgroup(subgroup);
                sb.delete(subGroupId, id);
                id = subGroupId;
            } else if (newTagFound && c == 'p') {
                if (sb.substring(id).startsWith("panose")) {
                    this.panose = "";
                    newTagFound = false;
                    slashFound = false;
                    parseTag = false;
                }
            } else {
                String tag;
                int tagStart;
                if (parseTag) {
                    String value;
                    char cc;
                    tagStart = id;
                    while (++id < sb.length() && (cc = sb.charAt(id)) != '\\' && cc != ' ') {
                    }
                    tag = sb.substring(tagStart, id);
                    if (RTFUtils.isNumber(tag)) {
                        if (this.num == -1) {
                            this.num = Integer.parseInt(tag);
                        }
                    } else if ("nil".equals(tag) || "roman".equals(tag) || "swiss".equals(tag) || "tech".equals(tag) || "modern".equals(tag) || "script".equals(tag) || "decor".equals(tag) || "bidi".equals(tag)) {
                        if (this.fontfamily == null) {
                            this.fontfamily = tag;
                        }
                    } else if (tag.startsWith("charset")) {
                        value = tag.substring("charset".length());
                        if (RTFUtils.isNumber(value) && this.charset == -1) {
                            this.charset = Integer.parseInt(value);
                        }
                    } else if (tag.startsWith("prq")) {
                        value = tag.substring("prq".length());
                        if (RTFUtils.isNumber(value) && this.prq == -1) {
                            this.prq = Integer.parseInt(value);
                        }
                    } else if ("tnil".equals(tag) || "ttruetype".equals(tag)) {
                        if (this.fonttype == null) {
                            this.fonttype = tag;
                        }
                    } else if (newTagFound && "name".equals(tag)) {
                        if (this.nontaggedname == null) {
                            this.nontaggedname = tag.substring("name".length() + 1);
                        }
                        newTagFound = false;
                    }
                    slashFound = false;
                    parseTag = false;
                    continue;
                }
                tagStart = id + 1;
                while (id < sb.length() && sb.charAt(id++) != '\\') {
                }
                tag = sb.substring(tagStart, id);
                if (this.fontname != null) continue;
                this.fontname = tag;
                continue;
            }
            ++id;
        }
        this.ok = true;
    }

    private static void parseSubgroup(String s) {
        System.out.println(s);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Font #").append(this.num).append(":\n");
        sb.append("\tcharset: ").append(this.charset).append('\n');
        sb.append("\tfamily: ").append(this.fontfamily).append('\n');
        sb.append("\tprq: ").append(this.prq).append('\n');
        sb.append("\tname: ").append(this.fontname).append('\n');
        return sb.toString();
    }
}

