/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.RTFFontTable;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RTFUtils {
    private static Logger logger = Logger.getLogger(RTFUtils.class);
    private static RTFUtils instance = new RTFUtils();
    public static final String RTF_STYLESHEET_GROUP = "stylesheet";
    public static final String RTF_COLORTBL_GROUP = "colortbl";
    public static final String RTF_FILETBL_GROUP = "filetbl";
    public static final String RTF_FONTTBL_GROUP = "fonttbl";
    public static final String RTF_DEFF_KEYWORD = "deff";
    public static final String EMPTY_RTF = "{\\rtf1\\ansi}";

    public static int indexOfKeyword(String theRTFText, String theKeyword) {
        int result = -1;
        int firstIndex = theRTFText.indexOf('\\' + theKeyword);
        if (firstIndex > 0 && theRTFText.charAt(firstIndex - 1) != '\\') {
            result = firstIndex;
        }
        return result;
    }

    public static int indexOfGroupBegin(String theRTFText, String theGroupName) {
        return theRTFText.indexOf("{\\" + theGroupName);
    }

    public static int indexOfGroupEnd(String theRTFText, String theGroupName) {
        int currChar;
        int beginIndex = RTFUtils.indexOfGroupBegin(theRTFText, theGroupName);
        if (beginIndex == -1) {
            return beginIndex;
        }
        int currentIndex = beginIndex + theGroupName.length() + 2;
        StringReader reader = new StringReader(theRTFText.substring(currentIndex));
        int level = 1;
        do {
            try {
                currChar = reader.read();
                ++currentIndex;
                switch (currChar) {
                    case 123: {
                        ++level;
                        break;
                    }
                    case 125: {
                        if (--level != 0) break;
                        return currentIndex - 1;
                    }
                }
            }
            catch (IOException e) {
                break;
            }
        } while (currChar != -1);
        return -1;
    }

    public static String getGroupWiseRTFStyleDefinition(int theComposeFontSize) {
        return "{\\fs" + theComposeFontSize * 2 + " GroupWiseView;}";
    }

    public static String getGroupWiseRTFStyleInStylesheet(int theComposeFontSize) {
        return "{\\stylesheet" + RTFUtils.getGroupWiseRTFStyleDefinition(theComposeFontSize) + '}';
    }

    public static String insertGWStyleDefinition(String theRTFText, int theComposeFontSize) {
        String result = theRTFText;
        logger.debug((Object)("result: " + result));
        int index = RTFUtils.indexOfGroupBegin(theRTFText, RTF_STYLESHEET_GROUP);
        if (index > 0) {
            index = index + RTF_STYLESHEET_GROUP.length() + 2;
            result = RTFUtils.insertString(theRTFText, index, RTFUtils.getGroupWiseRTFStyleDefinition(theComposeFontSize));
        } else {
            index = RTFUtils.indexOfGroupEnd(theRTFText, RTF_COLORTBL_GROUP);
            if (index > 0) {
                result = RTFUtils.insertString(theRTFText, index + 1, RTFUtils.getGroupWiseRTFStyleInStylesheet(theComposeFontSize));
            } else {
                index = RTFUtils.indexOfGroupEnd(theRTFText, RTF_FILETBL_GROUP);
                if (index > 0) {
                    result = RTFUtils.insertString(theRTFText, index + 1, RTFUtils.getGroupWiseRTFStyleInStylesheet(theComposeFontSize));
                } else {
                    index = RTFUtils.indexOfGroupEnd(theRTFText, RTF_FONTTBL_GROUP);
                    if (index > 0) {
                        result = RTFUtils.insertString(theRTFText, index + 1, RTFUtils.getGroupWiseRTFStyleInStylesheet(theComposeFontSize));
                    }
                }
            }
        }
        if (RTFUtils.indexOfKeyword(result, RTF_DEFF_KEYWORD) < 0) {
            logger.debug((Object)("index: " + index));
            logger.debug((Object)("result: " + result));
            index = RTFUtils.indexOfGroupBegin(theRTFText, RTF_FONTTBL_GROUP);
            if (index > 0) {
                int defaultFontIndex = 0;
                RTFFontTable fontTable = RTFUtils.parseFontTable(result);
                if (fontTable != null) {
                    String defaultFontName = HTMLConstants.getDefaultFontName(3);
                    List fontIDs = fontTable.getFontIDsByFontName(defaultFontName);
                    if (fontIDs == null) {
                        defaultFontName = HTMLConstants.getDefaultFontName(1);
                        fontIDs = fontTable.getFontIDsByFontName(defaultFontName);
                    }
                    if (!fontIDs.isEmpty()) {
                        defaultFontIndex = (Integer)fontIDs.get(0);
                    }
                }
                result = RTFUtils.insertString(result, index, "\\deff" + defaultFontIndex);
            }
        }
        return result;
    }

    public static String insertString(String theSourceString, int thePosition, String theInsertString) {
        if (thePosition < 0 || thePosition > theSourceString.length()) {
            throw new IllegalArgumentException("Incorrect index: [" + thePosition + ']');
        }
        StringBuffer result = new StringBuffer();
        result.append(theSourceString.substring(0, thePosition));
        result.append(theInsertString);
        result.append(theSourceString.substring(thePosition));
        return result.toString();
    }

    public static boolean isNumber(String txt) {
        try {
            Integer.parseInt(txt);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static RTFFontTable parseFontTable(String theRTF) {
        RTFFontTable result = null;
        int begin = RTFUtils.indexOfGroupBegin(theRTF, RTF_FONTTBL_GROUP);
        int end = RTFUtils.indexOfGroupEnd(theRTF, RTF_FONTTBL_GROUP);
        if (begin > 0 && end > begin) {
            result = new RTFFontTable(theRTF.substring(begin, end + 1));
        }
        return result;
    }

    public static String getRtfSignature(String theSignature, String message, boolean insertInTheEnd) {
        int fontSize = HTMLConstants.getDefaultFontSize(3);
        String signature = theSignature.replaceAll("\n", "\\\\par ") + "\\par";
        if (message.length() == 0) {
            return signature;
        }
        int index = message.lastIndexOf("}");
        StringBuffer sbMessage = new StringBuffer(message);
        if (index > 0) {
            signature = "\\fs" + 2 * fontSize + " \\par\\par " + signature;
            String number = RTFUtils.insertFontToMessage(sbMessage);
            if (insertInTheEnd) {
                index = sbMessage.lastIndexOf("}");
                sbMessage.insert(index - 1, "{" + (number != null ? "\\f" + number + " " : "") + signature + "}");
            } else {
                index = sbMessage.indexOf("\\par\n>>>");
                if (index < 0) {
                    index = sbMessage.lastIndexOf("}");
                }
                sbMessage.insert(index, "{" + (number != null ? "\\f" + number + " " : "") + signature + "}");
            }
        }
        return sbMessage.toString();
    }

    private static String insertFontToMessage(StringBuffer sbMessage) {
        String fontName = HTMLConstants.getDefaultFontName(3);
        Pattern p = Pattern.compile(RTF_FONTTBL_GROUP);
        Matcher m = p.matcher(sbMessage);
        int maxNumberOfFont = -1;
        if (m.find()) {
            int startIndex = m.start();
            p = Pattern.compile("}");
            m = p.matcher(sbMessage.substring(startIndex));
            if (m.find()) {
                int endIndex = startIndex + m.start();
                p = Pattern.compile("f\\d+");
                m = p.matcher(sbMessage.substring(startIndex, endIndex));
                while (m.find()) {
                    maxNumberOfFont = Math.max(Integer.valueOf(m.group().substring(1)), maxNumberOfFont);
                }
                sbMessage.insert(endIndex, "\\f" + (maxNumberOfFont + 1) + "\\fnil " + fontName + ";");
            }
        }
        return Integer.toString(maxNumberOfFont + 1);
    }
}

