/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.apache.log4j.Logger;

public class ScaledView
extends BoxView {
    private static Logger logger = Logger.getLogger(ScaledView.class);

    public ScaledView(Element elem, int axis) {
        super(elem, axis);
    }

    public double getZoomFactor() {
        Double scale = (Double)this.getDocument().getProperty("ZOOM_FACTOR");
        if (scale != null) {
            return scale;
        }
        return 1.0;
    }

    private boolean isZoomEnabled() {
        return Double.doubleToLongBits(1.0) != Double.doubleToLongBits(this.getZoomFactor());
    }

    public void paint(Graphics g, Shape allocation) {
        if (this.isZoomEnabled()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            double zoomFactor = this.getZoomFactor();
            AffineTransform old = g2d.getTransform();
            g2d.scale(zoomFactor, zoomFactor);
            super.paint(g2d, allocation);
            g2d.setTransform(old);
        } else {
            super.paint(g, allocation);
        }
    }

    public float getMinimumSpan(int axis) {
        if (this.isZoomEnabled()) {
            float f = super.getMinimumSpan(axis);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }
        return super.getMinimumSpan(axis);
    }

    public float getMaximumSpan(int axis) {
        if (this.isZoomEnabled()) {
            float f = super.getMaximumSpan(axis);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }
        return super.getMaximumSpan(axis);
    }

    public float getPreferredSpan(int axis) {
        if (this.isZoomEnabled()) {
            float f = super.getPreferredSpan(axis);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }
        return super.getPreferredSpan(axis);
    }

    protected void layout(int width, int height) {
        if (this.isZoomEnabled()) {
            super.layout(new Double((double)width / this.getZoomFactor()).intValue(), new Double((double)height * this.getZoomFactor()).intValue());
        } else {
            super.layout(width, height);
        }
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        if (this.isZoomEnabled()) {
            double zoomFactor = this.getZoomFactor();
            Rectangle alloc = a.getBounds();
            Shape s = super.modelToView(pos, alloc, b);
            alloc = s.getBounds();
            alloc.x = (int)((double)alloc.x * zoomFactor);
            alloc.y = (int)((double)alloc.y * zoomFactor);
            alloc.width = (int)((double)alloc.width * zoomFactor);
            alloc.height = (int)((double)alloc.height * zoomFactor);
            return alloc;
        }
        return super.modelToView(pos, a, b);
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        if (this.isZoomEnabled()) {
            double zoomFactor = this.getZoomFactor();
            Rectangle alloc = a.getBounds();
            x = (float)((double)x / zoomFactor);
            y = (float)((double)y / zoomFactor);
            alloc.x = (int)((double)alloc.x / zoomFactor);
            alloc.y = (int)((double)alloc.y / zoomFactor);
            alloc.width = (int)((double)alloc.width / zoomFactor);
            alloc.height = (int)((double)alloc.height / zoomFactor);
            return super.viewToModel(x, y, alloc, bias);
        }
        return super.viewToModel(x, y, a, bias);
    }
}

