/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor.hyperlink;

import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.RTFUtils;
import com.appframework.components.htmleditor.hyperlink.LinkParser;
import com.appframework.utils.Utils;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.options.OptionManager;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.log4j.Logger;

public class HTMLUtils {
    private static Logger logger = Logger.getLogger(HTMLUtils.class);
    private static char BROKEN_HYPHEN = (char)8209;
    private static final String PATTERN_HTTP_PROTOCOL = "((([Hh][Tt])|([Ff]))[Tt][Pp]([Ss])?://)";
    private static final String PATTERN_MAILTO_PROTOCOL = "([Mm][Aa][Ii][Ll][Tt][Oo]:)";
    private static final String URL_RESERVED_CHARACTERS = ";/?:@=&";
    private static final String PATTERN_USER = "([\\$A-Za-z0-9_\\.\\-\u2011~]+)";
    private static final String PATTERN_PASSWORD = String.format("((:[^\\s%s]*?)?)", ";/?:@=&");
    private static final String PATTERN_HOSTNAME = "([A-Za-z0-9_\\-\\$\u2011~!]+(\\.[A-Za-z0-9_\\-\\$\u2011~!]+)*)";
    private static final String PATTERN_MAIL_HOSTNAME = "([A-Za-z0-9_\\-\\$\u2011~!]+\\.(\\.[A-Za-z0-9_\\-\\$\u2011~!]+)*)";
    private static final String PATTERN_HTTP_HOSTNAME = "(((([Ww][Ww][Ww])|([Ff][Tt][Pp]))\\.)[A-Za-z0-9_\\-\\$\u2011~!]+(\\.[A-Za-z0-9_\\-\\$\u2011~!]+)*)";
    private static final String PATTERN_PORT = "(:\\d{1,5})";
    private static final String PATTERN_PATH = "(((/|\\\\)[A-Za-z0-9_()\\.,\\-:" + BROKEN_HYPHEN + "\\$\u2011~\\%!]*)*)";
    private static final String PATTERN_NAME = "([A-Za-z0-9_\\.\\-\\$]+)";
    private static final String PATTERN_VALUE = "([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*)";
    private static final String PATTERN_REGULAR_QUERY = "((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)|(((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)(\\&(([A-Za-z0-9_\\.\\-\\$]+)=)*([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+))";
    private static final String PATTERN_QUERY_WITH_ADDITIONAL_PUNCTUATION = "([A-Za-z0-9_,\\.\\-\\$/\\?%]+)";
    private static final String PATTERN_QUERY_WITH_ADDITIONAL_PUNCTUATION_AND_REGULAR_QUERY = "(([A-Za-z0-9_,\\.\\-\\$/\\?%]+)(((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)|(((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)(\\&(([A-Za-z0-9_\\.\\-\\$]+)=)*([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+))*))";
    private static final String PATTERN_QUERY_STRING = "(((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)|(((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)(\\&(([A-Za-z0-9_\\.\\-\\$]+)=)*([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+))|(([A-Za-z0-9_,\\.\\-\\$/\\?%]+)(((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)|(((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)(\\&(([A-Za-z0-9_\\.\\-\\$]+)=)*([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+))*)))";
    private static final String PATTERN_WWW_LINK = "((([\\$A-Za-z0-9_\\.\\-\u2011~]+)" + PATTERN_PASSWORD + "@)?" + "(((([Ww][Ww][Ww])|([Ff][Tt][Pp]))\\.)[A-Za-z0-9_\\-\\$\u2011~!]+(\\.[A-Za-z0-9_\\-\\$\u2011~!]+)*)" + "(:\\d{1,5})" + '?' + PATTERN_PATH + "?(\\#" + "([A-Za-z0-9_\\.\\-\\$]+)" + ")?(\\?" + "(((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)|(((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)(\\&(([A-Za-z0-9_\\.\\-\\$]+)=)*([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+))|(([A-Za-z0-9_,\\.\\-\\$/\\?%]+)(((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)|(((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)(\\&(([A-Za-z0-9_\\.\\-\\$]+)=)*([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+))*)))" + "?)?)";
    private static final String PATTERN_HTTP_LINK = PATTERN_WWW_LINK + "|(" + "((([Hh][Tt])|([Ff]))[Tt][Pp]([Ss])?://)" + '(' + "([\\$A-Za-z0-9_\\.\\-\u2011~]+)" + PATTERN_PASSWORD + "@)?" + "([A-Za-z0-9_\\-\\$\u2011~!]+(\\.[A-Za-z0-9_\\-\\$\u2011~!]+)*)" + "(:\\d{1,5})" + '?' + PATTERN_PATH + "?(\\#" + "([A-Za-z0-9_\\.\\-\\$]+)" + ")?(\\?" + "(((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)|(((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)(\\&(([A-Za-z0-9_\\.\\-\\$]+)=)*([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+))|(([A-Za-z0-9_,\\.\\-\\$/\\?%]+)(((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)|(((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))*)(\\&(([A-Za-z0-9_\\.\\-\\$]+)=)*([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,\\|]*))+))*)))" + "?)?)";
    private static final String PATTERN_EMAIL = "((([\\$A-Za-z0-9_\\.\\-\u2011~]+)" + PATTERN_PASSWORD + "@)" + "([A-Za-z0-9_\\-\\$\u2011~!]+\\.(\\.[A-Za-z0-9_\\-\\$\u2011~!]+)*)" + "(:\\d{1,5})" + '?' + PATTERN_PATH + "?)";
    private static final String PATTERN_EMAIL_LIST = '(' + PATTERN_EMAIL + "((\\,|\\;)" + PATTERN_EMAIL + ")*)";
    private static final String PATTERN_MAIL_LINK = "(([Mm][Aa][Ii][Ll][Tt][Oo]:)?" + PATTERN_EMAIL_LIST + "([\\S&&[^<>]]*))";
    private static final String PATTERN_LINK = '(' + PATTERN_HTTP_LINK + ")|(" + PATTERN_MAIL_LINK + ')';
    private static final Pattern MAIL_REGEX = Pattern.compile(PATTERN_EMAIL);
    public static final Pattern PATTERN_HYPERLINK = Pattern.compile(PATTERN_LINK);
    private static final Pattern PATTERN_DIGITS_ONLY = Pattern.compile("(\\d+)");
    private static final Pattern PATTERN_DIGITS_AS_PREFIX = Pattern.compile("(\\d+)(.+)");

    public static boolean isMailLink(String link) {
        return MAIL_REGEX.matcher(link).matches();
    }

    static String normalizeTextToHTML(String theString) {
        return HTMLUtils.normalizeTextToHTML(theString, true);
    }

    public static String normalizeTextToHTML(String theString, boolean bReplaceSpacesWithNBSP) {
        String result = theString.replaceAll("&", "&amp;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        result = result.replaceAll("\"", "&quot;");
        if (bReplaceSpacesWithNBSP) {
            result = result.replaceAll("  ", "&nbsp; ");
            result = result.replaceAll("  ", "&nbsp; ");
            result = result.replaceAll("&nbsp; &nbsp;", "&nbsp;&nbsp;&nbsp;");
        }
        return result;
    }

    static String replaceSpaces(String theString) {
        String ex = "\\ {2,}";
        Pattern p = Pattern.compile(ex);
        Matcher m = p.matcher(theString);
        StringBuffer result = new StringBuffer();
        int startIndex = 0;
        while (m.find()) {
            int i = m.start();
            result.append(theString.substring(startIndex, i));
            result.append(HTMLUtils.addNbsp(m.group().length()));
            startIndex = m.end();
        }
        result.append(theString.substring(startIndex, theString.length()));
        return result.toString();
    }

    private static String addNbsp(int count) {
        String result = " ";
        for (int i = 1; i < count; ++i) {
            result = result + "&nbsp;";
        }
        return result;
    }

    static String replaceEOLs(String theText) {
        if (theText == null || theText.length() == 0) {
            return theText;
        }
        String string = theText;
        int index = string.indexOf(10);
        StringBuffer result = new StringBuffer();
        if (index == -1) {
            return string;
        }
        while (index >= 0) {
            result.append(string.substring(0, index));
            result.append("<BR>");
            string = string.substring(index + 1);
            index = string.indexOf(10);
        }
        result.append(string);
        return result.toString();
    }

    public static HTML.Tag getNameAttribute(Element theRoot) {
        if (theRoot == null) {
            return null;
        }
        AttributeSet attr = theRoot.getAttributes();
        Object nameAttribute = attr.getAttribute(StyleConstants.NameAttribute);
        HTML.Tag name = nameAttribute instanceof HTML.Tag ? (HTML.Tag)nameAttribute : null;
        return name;
    }

    public static String replaceTags(String theHTML, String theOldTagName, String theNewTagName) {
        String oldPatern = "(?i)" + theOldTagName;
        String oldTag = "<(\\s*)" + oldPatern;
        String newTag = '<' + theNewTagName;
        String result = theHTML = theHTML.replaceAll(oldTag, newTag);
        oldTag = "<(\\s*)/(\\s*)" + oldPatern + "(\\s*)>";
        newTag = "</" + theNewTagName + '>';
        result = result.replaceAll(oldTag, newTag);
        return result;
    }

    public static String fixSpacesBTWUTFCharCodes(String theHTML) {
        StringBuffer result = new StringBuffer();
        String exp = "(\\s{0,})&#(\\d{3,4});(\\s{0,})";
        Pattern pattern = Pattern.compile(exp);
        Matcher matcher = pattern.matcher(theHTML);
        boolean found = false;
        int idx = 0;
        while (matcher.find()) {
            String str = matcher.group();
            String replaced = str.replaceAll("\\s", "&#32;");
            result.append(theHTML.substring(idx, matcher.start()));
            result.append(replaced);
            idx = matcher.end();
            found = true;
        }
        if (found) {
            result.append(theHTML.substring(idx, theHTML.length()));
            return result.toString();
        }
        return theHTML;
    }

    public static String encodeInUTF(String value) {
        StringBuffer sb = new StringBuffer(2 * value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c < ' ' || c > '\u007f') {
                sb.append('&');
                sb.append('#');
                sb.append(String.valueOf((int)c));
                sb.append(';');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String fixChars(String theText) {
        return theText.replace('\u2011', '-');
    }

    private static StringBuffer readFile(String filePath, String charsetName) throws IOException {
        Charset charset = Charset.forName(charsetName);
        InputStreamReader isoIn = new InputStreamReader((InputStream)new FileInputStream(filePath), charset);
        StringBuffer result = HTMLUtils.readStream(isoIn);
        isoIn.close();
        return result;
    }

    public static void removeEscapeChars(URL theURL) {
        try {
            String filePath = theURL.getPath();
            String defCharset = "ISO-8859-15";
            StringBuffer input = HTMLUtils.readFile(filePath, defCharset);
            input = HTMLUtils.checkPageEncoding(input, filePath, defCharset);
            StringBuffer output = new StringBuffer();
            char[] ch = input.toString().toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                char c = ch[i];
                if (c == '\u0000' || c == '\ufffd') continue;
                output.append(c);
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8");
            writer.write(output.toString());
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
    }

    private static StringBuffer checkPageEncoding(StringBuffer input, String filePath, String defCharset) throws IOException {
        int index;
        String inputStr = input.toString();
        if (inputStr.length() > 3) {
            switch (inputStr.charAt(0)) {
                case '\u00ef': {
                    if (inputStr.charAt(1) != '\u00bb' || inputStr.charAt(2) != '\u00bf') break;
                    return HTMLUtils.readFile(filePath, "UTF-8");
                }
                case '\u00fe': {
                    if (inputStr.charAt(1) != '\u00ff') break;
                    return HTMLUtils.readFile(filePath, "UTF-16BE");
                }
                case '\u00ff': {
                    if (inputStr.charAt(1) != '\u00fe') break;
                    return HTMLUtils.readFile(filePath, "UTF-16LE");
                }
            }
        }
        if ((index = inputStr.toLowerCase().indexOf("body")) == -1) {
            return input;
        }
        String searchText = input.toString().substring(0, index);
        for (String charsetName : Charset.availableCharsets().keySet()) {
            boolean utf16Match = charsetName.matches("(?i)utf.*16");
            boolean defCharsetMatch = charsetName.matches(defCharset);
            boolean searchMatch = searchText.matches("(?i)(?s).*\\<META[^\\<\\>]*" + charsetName + "[^\\<\\>]*\\>.*");
            if (defCharsetMatch || utf16Match || !searchMatch) continue;
            return HTMLUtils.readFile(filePath, charsetName);
        }
        return input;
    }

    private static StringBuffer readStream(InputStreamReader in) throws IOException {
        StringBuffer result = new StringBuffer();
        char[] cbuf = new char[1024];
        int n = 0;
        while ((n = in.read(cbuf)) > 0) {
            result.append(cbuf, 0, n);
        }
        return result;
    }

    public static String getEmptyHTML() {
        return "<html><body></body></html>";
    }

    public static String getEmptyPlainText() {
        return "";
    }

    public static String getPlainText(JTextPane tp) {
        return HTMLUtils.getPlainText(tp.getDocument());
    }

    public static String getPlainText(Document theDocument) {
        String text = "";
        try {
            text = theDocument.getText(0, theDocument.getLength());
        }
        catch (BadLocationException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return text;
    }

    public static String getStyledText(JTextPane theTextPane) {
        String result = "";
        try {
            Document document = theTextPane.getDocument();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int length = document.getLength();
            if (length == 0) {
                logger.debug((Object)"document length is 0 > returning empty string");
                return result;
            }
            EditorKit editorKit = theTextPane.getEditorKit();
            editorKit.write(baos, document, 0, length);
            result = baos.toString();
            baos.close();
            if (editorKit instanceof RTFEditorKit) {
                result = RTFUtils.insertGWStyleDefinition(result, HTMLConstants.getDefaultFontSize(3));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to read document from editor kit [" + theTextPane.getEditorKit().getClass() + "]: " + e));
            logger.debug((Object)e, (Throwable)e);
        }
        return result;
    }

    public static void setDefaultFont(JTextPane theTextPane, String theFontName, int theFontSize) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontSize(attr, theFontSize);
        StyleConstants.setFontFamily(attr, theFontName);
        HTMLUtils.setCharacterAttributes(theTextPane, attr, false);
    }

    private static void setCharacterAttributes(JEditorPane editor, AttributeSet attr, boolean replace) {
        StyledEditorKit k = (StyledEditorKit)editor.getEditorKit();
        MutableAttributeSet inputAttributes = k.getInputAttributes();
        if (replace) {
            inputAttributes.removeAttributes(inputAttributes);
        }
        inputAttributes.addAttributes(attr);
    }

    public static String getCSSFontStyleFromFont(String css, Font theFont) {
        String result = HTMLUtils.setAttribute(css, CSS.Attribute.FONT_FAMILY, theFont.getFamily());
        result = HTMLUtils.setAttribute(result, CSS.Attribute.FONT_SIZE, Integer.toString(theFont.getSize()));
        result = theFont.isBold() ? HTMLUtils.setAttribute(result, CSS.Attribute.FONT_WEIGHT, "bold") : HTMLUtils.removeAttribute(result, CSS.Attribute.FONT_WEIGHT);
        result = theFont.isItalic() ? HTMLUtils.setAttribute(result, CSS.Attribute.FONT_STYLE, "italic") : HTMLUtils.removeAttribute(result, CSS.Attribute.FONT_STYLE);
        return result;
    }

    public static boolean isDefaultComposeHTML() {
        MachineSettings.TextOption textOption = OptionManager.getInstance().getTextOption();
        boolean isHTML = textOption.isDefaultComposeHTML();
        return isHTML && !textOption.isHTMLDisallowed();
    }

    private static void copyRTF2HTMLDocumentContent(DefaultStyledDocument theRTFDocument, HTMLDocument theHtmlDocument, StyledEditorKit editorKit) {
        HTMLUtils.copyRTFParagraphs(theRTFDocument.getDefaultRootElement(), theRTFDocument, theHtmlDocument, editorKit);
    }

    private static void copyHTML2RTFDocumentContent(HTMLDocument theHtmlDocument, DefaultStyledDocument theRTFDocument, StyledEditorKit editorKit) {
        HTMLUtils.copyHTMLParagraphs(theHtmlDocument.getDefaultRootElement(), theHtmlDocument, theRTFDocument, false, editorKit);
    }

    public static void copyRTFParagraphs(Element defaultRootElement, DefaultStyledDocument theRTFDoc, DefaultStyledDocument theHTMLDoc, StyledEditorKit editorKit) {
        int elementCount = defaultRootElement.getElementCount();
        for (int i = 0; i < elementCount; ++i) {
            Element element = defaultRootElement.getElement(i);
            if (element.getName().equals("content")) {
                try {
                    int startOffset = element.getStartOffset();
                    String text = theRTFDoc.getText(startOffset, element.getEndOffset() - element.getStartOffset());
                    logger.debug((Object)("element name: [" + element.getName() + "] " + "element content: [" + text + ']'));
                    logger.debug((Object)("element - " + element));
                    if (element.getStartOffset() >= theRTFDoc.getLength()) continue;
                    theHTMLDoc.insertString(theHTMLDoc.getLength(), text, HTMLUtils.copyFontAttributes(editorKit.getInputAttributes(), element.getAttributes()));
                }
                catch (BadLocationException e1) {
                    logger.error((Object)e1);
                    logger.debug((Object)e1, (Throwable)e1);
                }
            } else {
                logger.debug((Object)("--- ignoring element: [" + element.getName() + ']'));
            }
            HTMLUtils.copyRTFParagraphs(element, theRTFDoc, theHTMLDoc, editorKit);
        }
    }

    private static String getElementText(Element theElement) {
        String result = "";
        try {
            result = theElement.getDocument().getText(theElement.getStartOffset(), theElement.getEndOffset() - theElement.getStartOffset());
        }
        catch (BadLocationException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return result;
    }

    public static void copyHTMLParagraphs(Element theElement, DefaultStyledDocument theHTMLDocument, DefaultStyledDocument theRTFDocument, boolean inHTMLBody, StyledEditorKit editorKit) {
        int elementCount = theElement.getElementCount();
        for (int i = 0; i < elementCount; ++i) {
            Element element = theElement.getElement(i);
            if (element.getName().equals(HTML.Tag.BODY.toString())) {
                inHTMLBody = true;
            }
            try {
                if (element.getName().equals(HTML.Tag.CONTENT.toString()) && inHTMLBody) {
                    int startOffset = element.getStartOffset();
                    String text = theHTMLDocument.getText(startOffset, element.getEndOffset() - element.getStartOffset());
                    logger.debug((Object)("--- writing element: [" + element.getName() + "] " + "content: [" + text + ']'));
                    if (element.getStartOffset() >= theHTMLDocument.getLength()) continue;
                    theRTFDocument.insertString(theRTFDocument.getLength(), text, HTMLUtils.copyFontAttributes(editorKit.getInputAttributes(), element.getAttributes()));
                } else if (element.getName().equals(HTML.Tag.BR.toString()) && inHTMLBody) {
                    theRTFDocument.insertString(theRTFDocument.getLength(), Utils.LINE_SEPARATOR, HTMLUtils.copyFontAttributes(editorKit.getInputAttributes(), element.getAttributes()));
                } else {
                    logger.debug((Object)("--- ignoring element: [" + element.getName() + "] " + "content: [" + HTMLUtils.getElementText(element) + ']'));
                }
            }
            catch (BadLocationException e1) {
                logger.error((Object)e1);
                logger.debug((Object)e1, (Throwable)e1);
            }
            HTMLUtils.copyHTMLParagraphs(element, theHTMLDocument, theRTFDocument, inHTMLBody, editorKit);
        }
    }

    private static AttributeSet copyFontAttributes(AttributeSet inputAttributes, AttributeSet oldAttributes) {
        MutableAttributeSet newAttributes = (MutableAttributeSet)inputAttributes.copyAttributes();
        StyleConstants.setBold(newAttributes, StyleConstants.isBold(oldAttributes));
        StyleConstants.setItalic(newAttributes, StyleConstants.isItalic(oldAttributes));
        StyleConstants.setUnderline(newAttributes, StyleConstants.isUnderline(oldAttributes));
        StyleConstants.setFontFamily(newAttributes, StyleConstants.getFontFamily(oldAttributes));
        StyleConstants.setFontSize(newAttributes, StyleConstants.getFontSize(oldAttributes));
        if (oldAttributes.isDefined(StyleConstants.Foreground)) {
            StyleConstants.setForeground(newAttributes, StyleConstants.getForeground(oldAttributes));
        } else {
            newAttributes.removeAttribute(StyleConstants.Foreground);
        }
        return newAttributes;
    }

    public static void convertDocument(int oldMode, Document oldDocument, int newMode, Document newDocument, StyledEditorKit editorKit) {
        if (newMode == 1) {
            HTMLUtils.copyRTF2HTMLDocumentContent((DefaultStyledDocument)oldDocument, (HTMLDocument)newDocument, editorKit);
        } else {
            HTMLUtils.copyHTML2RTFDocumentContent((HTMLDocument)oldDocument, (DefaultStyledDocument)newDocument, editorKit);
        }
    }

    public static String setAttribute(String theCSS, CSS.Attribute theAttribute, String theNewValue) {
        Style body;
        StyleSheet ss = new StyleSheet();
        if (theCSS != null && theCSS.length() != 0) {
            ss.addRule("body {" + theCSS + '}');
            body = ss.getStyle("body");
        } else {
            ss.addRule("body {}");
            body = ss.getStyle("body");
        }
        if (body.getAttribute(theAttribute) != null) {
            body.removeAttribute(theAttribute);
        }
        body.addAttribute(theAttribute, theNewValue);
        String theNewCSS = "";
        Enumeration<?> attributeNames = body.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object o = attributeNames.nextElement();
            if (!(o instanceof CSS.Attribute)) continue;
            theNewCSS = theNewCSS + o.toString() + ": ";
            theNewCSS = theNewCSS + body.getAttribute(o) + "; ";
        }
        return theNewCSS;
    }

    public static Object getAttribute(String theCSS, CSS.Attribute theAttribute) {
        Style body;
        StyleSheet ss = new StyleSheet();
        if (theCSS != null && theCSS.length() != 0) {
            ss.addRule("body {" + theCSS + '}');
            body = ss.getStyle("body");
        } else {
            ss.addRule("body {}");
            body = ss.getStyle("body");
        }
        return body.getAttribute(theAttribute);
    }

    public static String removeAttribute(String theCSS, CSS.Attribute theAttribute) {
        Style body;
        StyleSheet ss = new StyleSheet();
        if (theCSS != null && theCSS.length() != 0) {
            ss.addRule("body {" + theCSS + '}');
            body = ss.getStyle("body");
        } else {
            ss.addRule("body {}");
            body = ss.getStyle("body");
        }
        if (body.getAttribute(theAttribute) != null) {
            body.removeAttribute(theAttribute);
        }
        String theNewCSS = "";
        Enumeration<?> attributeNames = body.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object o = attributeNames.nextElement();
            if (!(o instanceof CSS.Attribute)) continue;
            theNewCSS = theNewCSS + o.toString() + ": ";
            theNewCSS = theNewCSS + body.getAttribute(o) + "; ";
        }
        return theNewCSS;
    }

    public static String checkAndUpdateMarginAttribute(String theCSS, CSS.Attribute attributeName, int theNewValue) {
        Object attributeValue = HTMLUtils.getAttribute(theCSS, attributeName);
        if (attributeValue == null) {
            return HTMLUtils.setAttribute(theCSS, attributeName, Integer.toString(theNewValue) + "px");
        }
        String attributeValueString = attributeValue.toString();
        if (attributeValueString.length() < 3 || !"px".equals(attributeValueString.substring(attributeValueString.length() - 2, attributeValueString.length()))) {
            return theCSS;
        }
        int theOldValue = Integer.parseInt(attributeValueString.substring(0, attributeValueString.length() - 2));
        if (theOldValue < theNewValue) {
            return HTMLUtils.setAttribute(theCSS, attributeName, Integer.toString(theNewValue) + "px");
        }
        return theCSS;
    }

    public static void correctSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        String sizeString;
        if (t == HTML.Tag.HR && a.getAttributeCount() > 0 && (sizeString = (String)a.getAttribute(HTML.Attribute.SIZE)) != null) {
            logger.debug((Object)("HR tag with SIZE attribute \"" + sizeString + "\" found..."));
            Matcher matcher = PATTERN_DIGITS_ONLY.matcher(sizeString);
            if (!matcher.matches()) {
                logger.debug((Object)"non-digits present in the attribute value...");
                matcher = PATTERN_DIGITS_AS_PREFIX.matcher(sizeString);
                if (matcher.matches()) {
                    sizeString = matcher.group(1);
                    logger.debug((Object)("...new corrected value: \"" + sizeString + '\"'));
                    a.addAttribute(HTML.Attribute.SIZE, sizeString);
                } else {
                    logger.debug((Object)("...removing incorrect value: \"" + sizeString + '\"'));
                    a.removeAttribute(HTML.Attribute.SIZE);
                }
            }
        }
    }

    public static String normalizeSignatureForHTML(String theSignature) {
        theSignature = LinkParser.createLinkedText(theSignature);
        String font = HTMLConstants.getDefaultFontName(1);
        int size = HTMLConstants.getDefaultFontSize(1);
        String valueToInsert = "<font face=\"" + font + "\" STYLE=\"font-size: " + size + "pt\"><br>" + HTMLUtils.encodeInUTF(theSignature.replaceAll("\n", "<br>")) + "<br>" + "<br></font>";
        return valueToInsert;
    }
}

