/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor.hyperlink;

import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.components.htmleditor.hyperlink.Link;
import com.appframework.components.htmleditor.hyperlink.LinkFinderResult;
import org.apache.log4j.Logger;

public class LinkFinder {
    private static Logger logger = Logger.getLogger(LinkFinder.class);
    private static final String MAIL_ENTRY = "@";
    private static final String[] ENTRIES = new String[]{"@", "https://", "http://", "news://", "gopher://", "wais://", "ftp://", "www.", "ftp."};
    private static final String[] DELIMETERS = new String[]{"<", ">", "\n", "\t", " ", ";", "*"};

    public static LinkFinderResult getLinks(String theSource) {
        String text = theSource;
        LinkFinderResult result = new LinkFinderResult();
        for (int i = 0; i < ENTRIES.length; ++i) {
            String entry = ENTRIES[i];
            int beginIndex = LinkFinder.getStartIndex(theSource, entry, 0);
            if (beginIndex < 0) continue;
            String prefix = text.substring(0, beginIndex);
            result.add(LinkFinder.getLinks(prefix));
            text = text.substring(beginIndex);
            int endIndex = LinkFinder.getLinkEnd(text, 0);
            String linkString = text.substring(0, endIndex);
            Link link = LinkFinder.getLinkForString(linkString);
            result.addLink(link);
            text = text.substring(endIndex);
            result.add(LinkFinder.getLinks(text));
            break;
        }
        if (result.getLinks().isEmpty()) {
            result.addPrefix(theSource);
        }
        return result;
    }

    private static int getStartIndex(String theSource, String theEntry, int startIndex) {
        int result = -1;
        int index = theSource.indexOf(theEntry, startIndex);
        if (index >= 0) {
            result = theEntry.equalsIgnoreCase(MAIL_ENTRY) ? (HTMLUtils.isMailLink(theSource.substring(index = LinkFinder.getMailStart(theSource, index))) ? index : -1) : index;
        }
        return result;
    }

    private static int getMailStart(String theSource, int maxIndex) {
        int result = -1;
        String text = theSource.substring(0, maxIndex);
        for (int i = 0; i < DELIMETERS.length; ++i) {
            String delimeter = DELIMETERS[i];
            int tmp = text.lastIndexOf(delimeter);
            if (tmp < 0 || tmp <= result || tmp >= theSource.length()) continue;
            result = tmp;
        }
        return result >= 0 ? result + 1 : 0;
    }

    private static int getLinkEnd(String theSource, int startIndex) {
        int result = theSource.substring(startIndex, theSource.length()).length();
        for (int i = 0; i < DELIMETERS.length; ++i) {
            String delimeter = DELIMETERS[i];
            int tmp = theSource.indexOf(delimeter, startIndex);
            if (tmp < 0 || tmp >= result) continue;
            result = tmp;
        }
        return result;
    }

    public static Link getLinkForString(String theLinkString) {
        Link result = new Link();
        StringBuffer insertLink = new StringBuffer();
        if (theLinkString.indexOf("mailto:") >= 0 || theLinkString.indexOf("https://") >= 0 || theLinkString.indexOf("http://") >= 0 || theLinkString.indexOf("ftp://") >= 0 || theLinkString.indexOf("news://") >= 0 || theLinkString.indexOf("gopher://") >= 0 || theLinkString.indexOf("wais://") >= 0) {
            insertLink.append("<a href=\"");
            result.setNameWithProtocol(theLinkString);
        } else if (HTMLUtils.isMailLink(theLinkString)) {
            result.setNameWithProtocol("mailto:" + theLinkString);
            insertLink.append("<a href=\"mailto:");
        } else if (theLinkString.indexOf("www.") >= 0) {
            insertLink.append("<a href=\"http://");
            result.setNameWithProtocol("http://" + theLinkString);
        } else if (theLinkString.indexOf("ftp.") >= 0) {
            insertLink.append("<a href=\"ftp://");
            result.setNameWithProtocol("ftp://" + theLinkString);
        } else {
            insertLink.append("<a href=\"http://");
            result.setNameWithProtocol("http://" + theLinkString);
        }
        insertLink.append(theLinkString);
        insertLink.append("\">");
        insertLink.append(theLinkString);
        insertLink.append("</a>");
        result.setName(theLinkString);
        result.setValue(insertLink.toString());
        return result;
    }
}

