/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor.ui;

import com.appframework.components.htmleditor.ui.BasicDropTargetListener_CLONE;
import com.appframework.components.htmleditor.ui.BasicTransferable_CLONE;
import com.appframework.components.htmleditor.ui.DragRecognitionSupport_CLONE;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.im.InputContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.apache.log4j.Logger;
import sun.awt.AppContext;
import sun.swing.DefaultLookup;

public abstract class BasicTextUI_CLONE
extends TextUI
implements ViewFactory {
    private static final EditorKit defaultKit = new DefaultEditorKit();
    transient JTextComponent editor;
    transient boolean painted = false;
    transient RootView rootView = new RootView();
    transient UpdateHandler updateHandler = new UpdateHandler();
    private static final TransferHandler defaultTransferHandler = new TextTransferHandler();
    private static DropTargetListener defaultDropTargetListener = null;
    private final DragListener dragListener = BasicTextUI_CLONE.getDragListener();
    private static final Position.Bias[] discardBias = new Position.Bias[1];

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected String getKeymapName() {
        String nm = this.getClass().getName();
        int index = nm.lastIndexOf(46);
        if (index >= 0) {
            nm = nm.substring(index + 1, nm.length());
        }
        return nm;
    }

    protected Keymap createKeymap() {
        String nm = this.getKeymapName();
        Keymap map = JTextComponent.getKeymap(nm);
        if (map == null) {
            Keymap parent = JTextComponent.getKeymap("default");
            map = JTextComponent.addKeymap(nm, parent);
            String prefix = this.getPropertyPrefix();
            Object o = DefaultLookup.get(this.editor, this, prefix + ".keyBindings");
            if (o != null && o instanceof JTextComponent.KeyBinding[]) {
                JTextComponent.KeyBinding[] bindings = (JTextComponent.KeyBinding[])o;
                JTextComponent.loadKeymap(map, bindings, this.getComponent().getActions());
            }
        }
        return map;
    }

    protected void propertyChange(PropertyChangeEvent evt) {
    }

    protected abstract String getPropertyPrefix();

    protected void installDefaults() {
        Insets margin;
        Border b;
        Color dfg;
        Color sfg;
        Color s;
        Color color;
        Color fg;
        Color bg;
        String prefix = this.getPropertyPrefix();
        Font f = this.editor.getFont();
        if (f == null || f instanceof UIResource) {
            this.editor.setFont(UIManager.getFont(prefix + ".font"));
        }
        if ((bg = this.editor.getBackground()) == null || bg instanceof UIResource) {
            this.editor.setBackground(UIManager.getColor(prefix + ".background"));
        }
        if ((fg = this.editor.getForeground()) == null || fg instanceof UIResource) {
            this.editor.setForeground(UIManager.getColor(prefix + ".foreground"));
        }
        if ((color = this.editor.getCaretColor()) == null || color instanceof UIResource) {
            this.editor.setCaretColor(UIManager.getColor(prefix + ".caretForeground"));
        }
        if ((s = this.editor.getSelectionColor()) == null || s instanceof UIResource) {
            this.editor.setSelectionColor(UIManager.getColor(prefix + ".selectionBackground"));
        }
        if ((sfg = this.editor.getSelectedTextColor()) == null || sfg instanceof UIResource) {
            this.editor.setSelectedTextColor(UIManager.getColor(prefix + ".selectionForeground"));
        }
        if ((dfg = this.editor.getDisabledTextColor()) == null || dfg instanceof UIResource) {
            this.editor.setDisabledTextColor(UIManager.getColor(prefix + ".inactiveForeground"));
        }
        if ((b = this.editor.getBorder()) == null || b instanceof UIResource) {
            this.editor.setBorder(UIManager.getBorder(prefix + ".border"));
        }
        if ((margin = this.editor.getMargin()) == null || margin instanceof UIResource) {
            this.editor.setMargin(UIManager.getInsets(prefix + ".margin"));
        }
    }

    private void installDefaults2() {
        DropTarget dropTarget;
        TransferHandler th;
        Highlighter highlighter;
        this.editor.addMouseListener(this.dragListener);
        this.editor.addMouseMotionListener(this.dragListener);
        String prefix = this.getPropertyPrefix();
        Caret caret = this.editor.getCaret();
        if (caret == null || caret instanceof UIResource) {
            caret = this.createCaret();
            this.editor.setCaret(caret);
            int rate = DefaultLookup.getInt(this.getComponent(), this, prefix + ".caretBlinkRate", 500);
            caret.setBlinkRate(rate);
        }
        if ((highlighter = this.editor.getHighlighter()) == null || highlighter instanceof UIResource) {
            this.editor.setHighlighter(this.createHighlighter());
        }
        if ((th = this.editor.getTransferHandler()) == null || th instanceof UIResource) {
            this.editor.setTransferHandler(this.getTransferHandler());
        }
        if ((dropTarget = this.editor.getDropTarget()) instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TextDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tmle) {
                // empty catch block
            }
        }
    }

    protected void uninstallDefaults() {
        this.editor.removeMouseListener(this.dragListener);
        this.editor.removeMouseMotionListener(this.dragListener);
        if (this.editor.getCaretColor() instanceof UIResource) {
            this.editor.setCaretColor(null);
        }
        if (this.editor.getSelectionColor() instanceof UIResource) {
            this.editor.setSelectionColor(null);
        }
        if (this.editor.getDisabledTextColor() instanceof UIResource) {
            this.editor.setDisabledTextColor(null);
        }
        if (this.editor.getSelectedTextColor() instanceof UIResource) {
            this.editor.setSelectedTextColor(null);
        }
        if (this.editor.getBorder() instanceof UIResource) {
            this.editor.setBorder(null);
        }
        if (this.editor.getMargin() instanceof UIResource) {
            this.editor.setMargin(null);
        }
        if (this.editor.getCaret() instanceof UIResource) {
            this.editor.setCaret(null);
        }
        if (this.editor.getHighlighter() instanceof UIResource) {
            this.editor.setHighlighter(null);
        }
        if (this.editor.getTransferHandler() instanceof UIResource) {
            this.editor.setTransferHandler(null);
        }
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installKeyboardActions() {
        ActionMap map;
        this.editor.setKeymap(this.createKeymap());
        InputMap km = this.getInputMap();
        if (km != null) {
            SwingUtilities.replaceUIInputMap(this.editor, 0, km);
        }
        if ((map = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.editor, map);
        }
        this.updateFocusAcceleratorBinding(false);
    }

    InputMap getInputMap() {
        InputMapUIResource map = new InputMapUIResource();
        InputMap shared = (InputMap)DefaultLookup.get(this.editor, this, this.getPropertyPrefix() + ".focusInputMap");
        if (shared != null) {
            map.setParent(shared);
        }
        return map;
    }

    void updateFocusAcceleratorBinding(boolean changed) {
        char accelerator = this.editor.getFocusAccelerator();
        if (changed || accelerator != '\u0000') {
            InputMap km = SwingUtilities.getUIInputMap(this.editor, 2);
            if (km == null && accelerator != '\u0000') {
                km = new ComponentInputMapUIResource(this.editor);
                SwingUtilities.replaceUIInputMap(this.editor, 2, km);
                ActionMap am = this.getActionMap();
                SwingUtilities.replaceUIActionMap(this.editor, am);
            }
            if (km != null) {
                km.clear();
                if (accelerator != '\u0000') {
                    km.put(KeyStroke.getKeyStroke((int)accelerator, 8), "requestFocus");
                }
            }
        }
    }

    void updateFocusTraversalKeys() {
        EditorKit editorKit = this.getEditorKit(this.editor);
        if (editorKit != null && editorKit instanceof DefaultEditorKit) {
            Set<AWTKeyStroke> storedForwardTraversalKeys = this.editor.getFocusTraversalKeys(0);
            Set<AWTKeyStroke> storedBackwardTraversalKeys = this.editor.getFocusTraversalKeys(1);
            HashSet<AWTKeyStroke> forwardTraversalKeys = new HashSet<AWTKeyStroke>(storedForwardTraversalKeys);
            HashSet<AWTKeyStroke> backwardTraversalKeys = new HashSet<AWTKeyStroke>(storedBackwardTraversalKeys);
            if (this.editor.isEditable()) {
                forwardTraversalKeys.remove(KeyStroke.getKeyStroke(9, 0));
                backwardTraversalKeys.remove(KeyStroke.getKeyStroke(9, 1));
            } else {
                forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
                backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
            }
            LookAndFeel.installProperty(this.editor, "focusTraversalKeysForward", forwardTraversalKeys);
            LookAndFeel.installProperty(this.editor, "focusTraversalKeysBackward", backwardTraversalKeys);
        }
    }

    TransferHandler getTransferHandler() {
        return defaultTransferHandler;
    }

    ActionMap getActionMap() {
        Action obj;
        String mapName = this.getPropertyPrefix() + ".actionMap";
        ActionMap map = (ActionMap)UIManager.get(mapName);
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put(mapName, map);
        }
        ActionMapUIResource componentMap = new ActionMapUIResource();
        componentMap.put("requestFocus", new FocusAction());
        if (this.getEditorKit(this.editor) instanceof DefaultEditorKit && map != null && (obj = map.get("insert-break")) != null && obj instanceof DefaultEditorKit.InsertBreakAction) {
            TextActionWrapper action = new TextActionWrapper((TextAction)obj);
            componentMap.put(action.getValue("Name"), action);
        }
        if (map != null) {
            componentMap.setParent(map);
        }
        return componentMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        for (Action a : this.editor.getActions()) {
            map.put(a.getValue("Name"), a);
        }
        map.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        map.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        map.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return map;
    }

    protected void uninstallKeyboardActions() {
        this.editor.setKeymap(null);
        SwingUtilities.replaceUIInputMap(this.editor, 2, null);
        SwingUtilities.replaceUIActionMap(this.editor, null);
    }

    protected void paintBackground(Graphics g) {
        g.setColor(this.editor.getBackground());
        g.fillRect(0, 0, this.editor.getWidth(), this.editor.getHeight());
    }

    protected final JTextComponent getComponent() {
        return this.editor;
    }

    protected void modelChanged() {
        ViewFactory f = this.rootView.getViewFactory();
        Document doc = this.editor.getDocument();
        Element elem = doc.getDefaultRootElement();
        this.setView(f.create(elem));
    }

    protected final void setView(View v) {
        this.rootView.setView(v);
        this.painted = false;
        this.editor.revalidate();
        this.editor.repaint();
    }

    protected void paintSafely(Graphics g) {
        Rectangle alloc;
        this.painted = true;
        Highlighter highlighter = this.editor.getHighlighter();
        Caret caret = this.editor.getCaret();
        if (this.editor.isOpaque()) {
            this.paintBackground(g);
        }
        if (highlighter != null) {
            highlighter.paint(g);
        }
        if ((alloc = this.getVisibleEditorRect()) != null) {
            this.rootView.paint(g, alloc);
        }
        if (caret != null) {
            caret.paint(g);
        }
    }

    public void installUI(JComponent c) {
        if (c instanceof JTextComponent) {
            this.editor = (JTextComponent)c;
            this.installDefaults();
            this.installDefaults2();
            LookAndFeel.installProperty(this.editor, "opaque", Boolean.TRUE);
            LookAndFeel.installProperty(this.editor, "autoscrolls", Boolean.TRUE);
            this.editor.addPropertyChangeListener(this.updateHandler);
            Document doc = this.editor.getDocument();
            if (doc == null) {
                this.editor.setDocument(this.getEditorKit(this.editor).createDefaultDocument());
            } else {
                doc.addDocumentListener(this.updateHandler);
                this.modelChanged();
            }
            this.installListeners();
            this.installKeyboardActions();
            LayoutManager oldLayout = this.editor.getLayout();
            if (oldLayout == null || oldLayout instanceof UIResource) {
                this.editor.setLayout(this.updateHandler);
            }
        } else {
            throw new Error("TextUI needs JTextComponent");
        }
    }

    public void uninstallUI(JComponent c) {
        this.editor.removePropertyChangeListener(this.updateHandler);
        this.editor.getDocument().removeDocumentListener(this.updateHandler);
        this.painted = false;
        this.uninstallDefaults();
        this.rootView.setView(null);
        c.removeAll();
        LayoutManager lm = c.getLayout();
        if (lm instanceof UIResource) {
            c.setLayout(null);
        }
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.editor = null;
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics g, JComponent c) {
        if (this.rootView.getViewCount() > 0 && this.rootView.getView(0) != null) {
            Document doc = this.editor.getDocument();
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readLock();
            }
            try {
                this.paintSafely(g);
            }
            finally {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readUnlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize(JComponent c) {
        Document doc = this.editor.getDocument();
        Insets i = c.getInsets();
        Dimension d = c.getSize();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            if (d.width > i.left + i.right && d.height > i.top + i.bottom) {
                this.rootView.setSize(d.width - i.left - i.right, d.height - i.top - i.bottom);
            } else if (d.width == 0 && d.height == 0) {
                this.rootView.setSize(2.1474836E9f, 2.1474836E9f);
            }
            d.width = (int)Math.min((long)this.rootView.getPreferredSpan(0) + (long)i.left + (long)i.right, Integer.MAX_VALUE);
            d.height = (int)Math.min((long)this.rootView.getPreferredSpan(1) + (long)i.top + (long)i.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize(JComponent c) {
        Document doc = this.editor.getDocument();
        Insets i = c.getInsets();
        Dimension d = new Dimension();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            d.width = (int)this.rootView.getMinimumSpan(0) + i.left + i.right;
            d.height = (int)this.rootView.getMinimumSpan(1) + i.top + i.bottom;
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize(JComponent c) {
        Document doc = this.editor.getDocument();
        Insets i = c.getInsets();
        Dimension d = new Dimension();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            d.width = (int)Math.min((long)this.rootView.getMaximumSpan(0) + (long)i.left + (long)i.right, Integer.MAX_VALUE);
            d.height = (int)Math.min((long)this.rootView.getMaximumSpan(1) + (long)i.top + (long)i.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return d;
    }

    protected Rectangle getVisibleEditorRect() {
        Rectangle alloc = this.editor.getBounds();
        if (alloc.width > 0 && alloc.height > 0) {
            alloc.y = 0;
            alloc.x = 0;
            Insets insets = this.editor.getInsets();
            alloc.x += insets.left;
            alloc.y += insets.top;
            alloc.width -= insets.left + insets.right;
            alloc.height -= insets.top + insets.bottom;
            return alloc;
        }
        return null;
    }

    public Rectangle modelToView(JTextComponent tc, int pos) throws BadLocationException {
        return this.modelToView(tc, pos, Position.Bias.Forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle modelToView(JTextComponent tc, int pos, Position.Bias bias) throws BadLocationException {
        Document doc = this.editor.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            Rectangle alloc = this.getVisibleEditorRect();
            if (alloc != null) {
                this.rootView.setSize(alloc.width, alloc.height);
                Shape s = this.rootView.modelToView(pos, alloc, bias);
                if (s != null) {
                    Rectangle rectangle = s.getBounds();
                    return rectangle;
                }
            }
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return null;
    }

    public int viewToModel(JTextComponent tc, Point pt) {
        return this.viewToModel(tc, pt, discardBias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(JTextComponent tc, Point pt, Position.Bias[] biasReturn) {
        int offs = -1;
        Document doc = this.editor.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            Rectangle alloc = this.getVisibleEditorRect();
            if (alloc != null) {
                this.rootView.setSize(alloc.width, alloc.height);
                offs = this.rootView.viewToModel(pt.x, pt.y, alloc, biasReturn);
            }
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return offs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        Document doc = this.editor.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            if (this.painted) {
                Rectangle alloc = this.getVisibleEditorRect();
                if (alloc != null) {
                    this.rootView.setSize(alloc.width, alloc.height);
                }
                int n = this.rootView.getNextVisualPositionFrom(pos, b, alloc, direction, biasRet);
                return n;
            }
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        return -1;
    }

    public void damageRange(JTextComponent tc, int p0, int p1) {
        this.damageRange(tc, p0, p1, Position.Bias.Forward, Position.Bias.Backward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damageRange(JTextComponent t, int p0, int p1, Position.Bias p0Bias, Position.Bias p1Bias) {
        Rectangle alloc;
        if (this.painted && (alloc = this.getVisibleEditorRect()) != null) {
            Document doc = t.getDocument();
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readLock();
            }
            try {
                this.rootView.setSize(alloc.width, alloc.height);
                Shape toDamage = this.rootView.modelToView(p0, p0Bias, p1, p1Bias, alloc);
                Rectangle rect = toDamage instanceof Rectangle ? (Rectangle)toDamage : toDamage.getBounds();
                this.editor.repaint(rect.x, rect.y, rect.width, rect.height);
            }
            catch (BadLocationException e) {
            }
            finally {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readUnlock();
                }
            }
        }
    }

    public EditorKit getEditorKit(JTextComponent tc) {
        return defaultKit;
    }

    public View getRootView(JTextComponent tc) {
        return this.rootView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipText(JTextComponent t, Point pt) {
        if (!this.painted) {
            return null;
        }
        Document doc = this.editor.getDocument();
        String tt = null;
        Rectangle alloc = this.getVisibleEditorRect();
        if (alloc != null) {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readLock();
            }
            try {
                tt = this.rootView.getToolTipText(pt.x, pt.y, alloc);
            }
            finally {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readUnlock();
                }
            }
        }
        return tt;
    }

    public View create(Element elem) {
        return null;
    }

    public View create(Element elem, int p0, int p1) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DragListener getDragListener() {
        Class<DragListener> clazz = DragListener.class;
        synchronized (DragListener.class) {
            DragListener listener = (DragListener)AppContext.getAppContext().get(DragListener.class);
            if (listener == null) {
                listener = new DragListener();
                AppContext.getAppContext().put(DragListener.class, listener);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return listener;
        }
    }

    static class TextTransferHandler
    extends TransferHandler
    implements UIResource {
        private static final Logger logger = Logger.getLogger(TextTransferHandler.class);
        private JTextComponent exportComp;
        private boolean shouldRemove;
        private int p0;
        private int p1;

        TextTransferHandler() {
        }

        protected DataFlavor getImportFlavor(DataFlavor[] flavors, String contentType) {
            DataFlavor plainFlavor = null;
            DataFlavor refFlavor = null;
            DataFlavor stringFlavor = null;
            for (DataFlavor flavor : flavors) {
                String mime = flavor.getMimeType();
                if (mime.startsWith(contentType)) {
                    return flavor;
                }
                if (plainFlavor == null && mime.startsWith("text/plain")) {
                    plainFlavor = flavor;
                    continue;
                }
                if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavor.getRepresentationClass() == String.class) {
                    refFlavor = flavor;
                    continue;
                }
                if (stringFlavor != null || !flavor.equals(DataFlavor.stringFlavor)) continue;
                stringFlavor = flavor;
            }
            if (plainFlavor != null) {
                return plainFlavor;
            }
            if (refFlavor != null) {
                return refFlavor;
            }
            if (stringFlavor != null) {
                return stringFlavor;
            }
            return null;
        }

        protected DataFlavor getImportFlavor(DataFlavor[] flavors, JTextComponent c) {
            DataFlavor plainFlavor = null;
            DataFlavor refFlavor = null;
            DataFlavor stringFlavor = null;
            if (c instanceof JEditorPane) {
                for (DataFlavor flavor : flavors) {
                    String mime = flavor.getMimeType();
                    if (mime.startsWith(((JEditorPane)c).getEditorKit().getContentType())) {
                        if (this.isTranferFromMozilla(flavors)) {
                            if (mime.startsWith("text/html")) continue;
                            return flavor;
                        }
                        return flavor;
                    }
                    if (plainFlavor == null && mime.startsWith("text/plain")) {
                        plainFlavor = flavor;
                        continue;
                    }
                    if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavor.getRepresentationClass() == String.class) {
                        refFlavor = flavor;
                        continue;
                    }
                    if (stringFlavor != null || !flavor.equals(DataFlavor.stringFlavor)) continue;
                    stringFlavor = flavor;
                }
                if (plainFlavor != null) {
                    return plainFlavor;
                }
                if (refFlavor != null) {
                    return refFlavor;
                }
                if (stringFlavor != null) {
                    return stringFlavor;
                }
                return null;
            }
            for (int i = 0; i < flavors.length; ++i) {
                String mime = flavors[i].getMimeType();
                if (mime.startsWith("text/plain")) {
                    return flavors[i];
                }
                if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == String.class) {
                    refFlavor = flavors[i];
                    continue;
                }
                if (stringFlavor != null || !flavors[i].equals(DataFlavor.stringFlavor)) continue;
                stringFlavor = flavors[i];
            }
            if (refFlavor != null) {
                return refFlavor;
            }
            if (stringFlavor != null) {
                return stringFlavor;
            }
            return null;
        }

        protected void handleReaderImport(Reader in, JTextComponent c, boolean useRead) throws BadLocationException, IOException {
            if (useRead) {
                int startPosition = c.getSelectionStart();
                int endPosition = c.getSelectionEnd();
                int length = endPosition - startPosition;
                EditorKit kit = c.getUI().getEditorKit(c);
                Document doc = c.getDocument();
                if (length > 0) {
                    doc.remove(startPosition, length);
                }
                kit.read(in, doc, startPosition);
            } else {
                int nch;
                char[] buff = new char[1024];
                boolean lastWasCR = false;
                StringBuffer sbuff = null;
                while ((nch = in.read(buff, 0, buff.length)) != -1) {
                    if (sbuff == null) {
                        sbuff = new StringBuffer(nch);
                    }
                    int last = 0;
                    block5: for (int counter = 0; counter < nch; ++counter) {
                        switch (buff[counter]) {
                            case '\r': {
                                if (lastWasCR) {
                                    if (counter == 0) {
                                        sbuff.append('\n');
                                        continue block5;
                                    }
                                    buff[counter - 1] = 10;
                                    continue block5;
                                }
                                lastWasCR = true;
                                continue block5;
                            }
                            case '\n': {
                                if (!lastWasCR) continue block5;
                                if (counter > last + 1) {
                                    sbuff.append(buff, last, counter - last - 1);
                                }
                                lastWasCR = false;
                                last = counter;
                                continue block5;
                            }
                            default: {
                                if (!lastWasCR) continue block5;
                                if (counter == 0) {
                                    sbuff.append('\n');
                                } else {
                                    buff[counter - 1] = 10;
                                }
                                lastWasCR = false;
                            }
                        }
                    }
                    if (last >= nch) continue;
                    if (lastWasCR) {
                        if (last >= nch - 1) continue;
                        sbuff.append(buff, last, nch - last - 1);
                        continue;
                    }
                    sbuff.append(buff, last, nch - last);
                }
                if (lastWasCR) {
                    sbuff.append('\n');
                }
                c.replaceSelection(sbuff != null ? sbuff.toString() : "");
            }
        }

        public int getSourceActions(JComponent c) {
            if (c instanceof JPasswordField && c.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
                return 0;
            }
            return ((JTextComponent)c).isEditable() ? 3 : 1;
        }

        protected Transferable createTransferable(JComponent comp) {
            this.exportComp = (JTextComponent)comp;
            this.shouldRemove = true;
            this.p0 = this.exportComp.getSelectionStart();
            this.p1 = this.exportComp.getSelectionEnd();
            return this.p0 != this.p1 ? new TextTransferable(this.exportComp, this.p0, this.p1) : null;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            if (this.shouldRemove && action == 2) {
                TextTransferable t = (TextTransferable)data;
                t.removeText();
            }
            this.exportComp = null;
        }

        public boolean importData(JComponent comp, Transferable t) {
            JTextComponent c = (JTextComponent)comp;
            if (c == this.exportComp && c.getCaretPosition() >= this.p0 && c.getCaretPosition() <= this.p1) {
                this.shouldRemove = false;
                return true;
            }
            boolean imported = false;
            DataFlavor importFlavor = this.getImportFlavor(t.getTransferDataFlavors(), c);
            if (importFlavor != null) {
                try {
                    InputContext ic;
                    JEditorPane ep;
                    boolean useRead = false;
                    if (comp instanceof JEditorPane && !(ep = (JEditorPane)comp).getContentType().startsWith("text/plain") && importFlavor.getMimeType().startsWith(ep.getContentType())) {
                        boolean bl = useRead = !this.isTranferFromMozilla(t.getTransferDataFlavors());
                    }
                    if ((ic = c.getInputContext()) != null) {
                        ic.endComposition();
                    }
                    Reader r = importFlavor.getReaderForText(t);
                    this.handleReaderImport(r, c, useRead);
                    imported = true;
                }
                catch (UnsupportedFlavorException ufe) {
                }
                catch (BadLocationException ble) {
                }
                catch (IOException ioe) {
                    return this.lastTryToImportData(c, t);
                }
            }
            return imported;
        }

        private boolean lastTryToImportData(JTextComponent component, Transferable transferable) {
            boolean result = false;
            DataFlavor importFlavor = this.getImportFlavor(transferable.getTransferDataFlavors(), "text/plain");
            try {
                Reader reader = importFlavor.getReaderForText(transferable);
                this.handleReaderImport(reader, component, false);
                result = true;
            }
            catch (BadLocationException e) {
            }
            catch (IOException e) {
            }
            catch (UnsupportedFlavorException e) {
                // empty catch block
            }
            return result;
        }

        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            JTextComponent c = (JTextComponent)comp;
            if (!c.isEditable() || !c.isEnabled()) {
                return false;
            }
            return this.getImportFlavor(flavors, c) != null;
        }

        boolean isTranferFromMozilla(DataFlavor[] dataFlavors) {
            for (DataFlavor dataFlavor : dataFlavors) {
                if (!dataFlavor.getSubType().contains("_moz_") && !dataFlavor.getSubType().contains("-moz-")) continue;
                return true;
            }
            return false;
        }

        static class TextTransferable
        extends BasicTransferable_CLONE {
            Position p0;
            Position p1;
            String mimeType;
            String richText;
            JTextComponent c;

            TextTransferable(JTextComponent c, int start, int end) {
                super(null, null);
                this.c = c;
                Document doc = c.getDocument();
                try {
                    this.p0 = doc.createPosition(start);
                    this.p1 = doc.createPosition(end);
                    this.plainData = c.getSelectedText();
                    if (c instanceof JEditorPane) {
                        JEditorPane ep = (JEditorPane)c;
                        this.mimeType = ep.getContentType();
                        if (this.mimeType.startsWith("text/plain")) {
                            return;
                        }
                        StringWriter sw = new StringWriter(this.p1.getOffset() - this.p0.getOffset());
                        ep.getEditorKit().write(sw, doc, this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                        if (this.mimeType.startsWith("text/html")) {
                            this.htmlData = sw.toString();
                        } else {
                            this.richText = sw.toString();
                        }
                    }
                }
                catch (BadLocationException ble) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }

            void removeText() {
                if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                    try {
                        Document doc = this.c.getDocument();
                        doc.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }

            protected DataFlavor[] getRicherFlavors() {
                if (this.richText == null) {
                    return null;
                }
                try {
                    DataFlavor[] flavors = new DataFlavor[]{new DataFlavor(this.mimeType + ";class=java.lang.String"), new DataFlavor(this.mimeType + ";class=java.io.Reader"), new DataFlavor(this.mimeType + ";class=java.io.InputStream;charset=unicode")};
                    return flavors;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }

            protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.richText == null) {
                    return null;
                }
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return this.richText;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(this.richText);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new StringBufferInputStream(this.richText);
                }
                throw new UnsupportedFlavorException(flavor);
            }
        }
    }

    static class TextDropTargetListener
    extends BasicDropTargetListener_CLONE {
        int dot;
        int mark;
        boolean visible;

        TextDropTargetListener() {
        }

        protected void saveComponentState(JComponent comp) {
            JTextComponent c = (JTextComponent)comp;
            Caret caret = c.getCaret();
            this.dot = caret.getDot();
            this.mark = caret.getMark();
            this.visible = caret instanceof DefaultCaret ? ((DefaultCaret)caret).isActive() : caret.isVisible();
            caret.setVisible(true);
        }

        protected void restoreComponentState(JComponent comp) {
            JTextComponent c = (JTextComponent)comp;
            Caret caret = c.getCaret();
            caret.setDot(this.mark);
            caret.moveDot(this.dot);
            caret.setVisible(this.visible);
        }

        protected void restoreComponentStateForDrop(JComponent comp) {
            JTextComponent c = (JTextComponent)comp;
            Caret caret = c.getCaret();
            caret.setVisible(this.visible);
        }

        protected void updateInsertionLocation(JComponent comp, Point p) {
            if (comp != null) {
                JTextComponent c = (JTextComponent)comp;
                c.setCaretPosition(c.viewToModel(p));
            }
        }
    }

    static class DragListener
    extends MouseInputAdapter
    implements DragRecognitionSupport_CLONE.BeforeDrag {
        private boolean dragStarted;

        DragListener() {
        }

        public void dragStarting(MouseEvent me) {
            this.dragStarted = true;
        }

        public void mousePressed(MouseEvent e) {
            JTextComponent c = (JTextComponent)e.getSource();
            if (c.getDragEnabled()) {
                this.dragStarted = false;
                if (this.isDragPossible(e) && DragRecognitionSupport_CLONE.mousePressed(e)) {
                    e.consume();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            JTextComponent c = (JTextComponent)e.getSource();
            if (c.getDragEnabled()) {
                if (this.dragStarted) {
                    e.consume();
                }
                DragRecognitionSupport_CLONE.mouseReleased(e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            JTextComponent c = (JTextComponent)e.getSource();
            if (c.getDragEnabled() && (this.dragStarted || DragRecognitionSupport_CLONE.mouseDragged(e, this))) {
                e.consume();
            }
        }

        protected boolean isDragPossible(MouseEvent e) {
            int mark;
            Caret caret;
            int dot;
            JTextComponent c = (JTextComponent)e.getSource();
            if (c.isEnabled() && (dot = (caret = c.getCaret()).getDot()) != (mark = caret.getMark())) {
                Point p = new Point(e.getX(), e.getY());
                int pos = c.viewToModel(p);
                int p0 = Math.min(dot, mark);
                int p1 = Math.max(dot, mark);
                if (pos >= p0 && pos < p1) {
                    return true;
                }
            }
            return false;
        }
    }

    class FocusAction
    extends AbstractAction {
        FocusAction() {
        }

        public void actionPerformed(ActionEvent e) {
            BasicTextUI_CLONE.this.editor.requestFocus();
        }

        public boolean isEnabled() {
            return BasicTextUI_CLONE.this.editor.isEditable();
        }
    }

    class TextActionWrapper
    extends TextAction {
        TextAction action;

        public TextActionWrapper(TextAction action) {
            super((String)action.getValue("Name"));
            this.action = null;
            this.action = action;
        }

        public void actionPerformed(ActionEvent e) {
            this.action.actionPerformed(e);
        }

        public boolean isEnabled() {
            return BasicTextUI_CLONE.this.editor == null || BasicTextUI_CLONE.this.editor.isEditable() ? this.action.isEnabled() : false;
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    LayoutManager2,
    UIResource {
        private Hashtable constraints;
        private boolean i18nView = false;

        UpdateHandler() {
        }

        public final void propertyChange(PropertyChangeEvent evt) {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            String propertyName = evt.getPropertyName();
            if (oldValue instanceof Document || newValue instanceof Document) {
                if (oldValue != null) {
                    ((Document)oldValue).removeDocumentListener(this);
                    this.i18nView = false;
                }
                if (newValue != null) {
                    ((Document)newValue).addDocumentListener(this);
                    if ("document" == propertyName) {
                        BasicTextUI_CLONE.this.setView(null);
                        BasicTextUI_CLONE.this.propertyChange(evt);
                        BasicTextUI_CLONE.this.modelChanged();
                        return;
                    }
                }
                BasicTextUI_CLONE.this.modelChanged();
            }
            if ("focusAccelerator" == propertyName) {
                BasicTextUI_CLONE.this.updateFocusAcceleratorBinding(true);
            } else if ("componentOrientation" == propertyName) {
                BasicTextUI_CLONE.this.modelChanged();
            } else if ("font" == propertyName) {
                BasicTextUI_CLONE.this.modelChanged();
            } else if ("transferHandler" == propertyName) {
                DropTarget dropTarget = BasicTextUI_CLONE.this.editor.getDropTarget();
                if (dropTarget instanceof UIResource) {
                    if (defaultDropTargetListener == null) {
                        defaultDropTargetListener = new TextDropTargetListener();
                    }
                    try {
                        dropTarget.addDropTargetListener(defaultDropTargetListener);
                    }
                    catch (TooManyListenersException tmle) {}
                }
            } else if ("editable" == propertyName) {
                BasicTextUI_CLONE.this.modelChanged();
            }
            BasicTextUI_CLONE.this.propertyChange(evt);
        }

        public final void insertUpdate(DocumentEvent e) {
            Boolean i18nFlag;
            Document doc = e.getDocument();
            Object o = doc.getProperty("i18n");
            if (o instanceof Boolean && (i18nFlag = (Boolean)o) != this.i18nView) {
                this.i18nView = i18nFlag;
                BasicTextUI_CLONE.this.modelChanged();
                return;
            }
            Rectangle alloc = BasicTextUI_CLONE.this.painted ? BasicTextUI_CLONE.this.getVisibleEditorRect() : null;
            BasicTextUI_CLONE.this.rootView.insertUpdate(e, alloc, BasicTextUI_CLONE.this.rootView.getViewFactory());
        }

        public final void removeUpdate(DocumentEvent e) {
            Rectangle alloc = BasicTextUI_CLONE.this.painted ? BasicTextUI_CLONE.this.getVisibleEditorRect() : null;
            BasicTextUI_CLONE.this.rootView.removeUpdate(e, alloc, BasicTextUI_CLONE.this.rootView.getViewFactory());
        }

        public final void changedUpdate(DocumentEvent e) {
            Rectangle alloc = BasicTextUI_CLONE.this.painted ? BasicTextUI_CLONE.this.getVisibleEditorRect() : null;
            BasicTextUI_CLONE.this.rootView.changedUpdate(e, alloc, BasicTextUI_CLONE.this.rootView.getViewFactory());
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
            if (this.constraints != null) {
                this.constraints.remove(comp);
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container parent) {
            Rectangle alloc;
            if (this.constraints != null && !this.constraints.isEmpty() && (alloc = BasicTextUI_CLONE.this.getVisibleEditorRect()) != null) {
                Document doc = BasicTextUI_CLONE.this.editor.getDocument();
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readLock();
                }
                try {
                    BasicTextUI_CLONE.this.rootView.setSize(alloc.width, alloc.height);
                    Enumeration components = this.constraints.keys();
                    while (components.hasMoreElements()) {
                        Component comp = (Component)components.nextElement();
                        View v = (View)this.constraints.get(comp);
                        Shape ca = this.calculateViewPosition(alloc, v);
                        if (ca == null) continue;
                        Rectangle compAlloc = ca instanceof Rectangle ? (Rectangle)ca : ca.getBounds();
                        comp.setBounds(compAlloc);
                    }
                }
                finally {
                    if (doc instanceof AbstractDocument) {
                        ((AbstractDocument)doc).readUnlock();
                    }
                }
            }
        }

        Shape calculateViewPosition(Shape alloc, View v) {
            int pos = v.getStartOffset();
            View child = null;
            View parent = BasicTextUI_CLONE.this.rootView;
            while (parent != null && parent != v) {
                int index = ((View)parent).getViewIndex(pos, Position.Bias.Forward);
                alloc = ((View)parent).getChildAllocation(index, alloc);
                child = ((View)parent).getView(index);
                parent = child;
            }
            return child != null ? alloc : null;
        }

        public void addLayoutComponent(Component comp, Object constraint) {
            if (constraint instanceof View) {
                if (this.constraints == null) {
                    this.constraints = new Hashtable(7);
                }
                this.constraints.put(comp, constraint);
            }
        }

        public Dimension maximumLayoutSize(Container target) {
            return null;
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        public void invalidateLayout(Container target) {
        }
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
        }

        void setView(View v) {
            View oldView = this.view;
            this.view = null;
            if (oldView != null) {
                oldView.setParent(null);
            }
            if (v != null) {
                v.setParent(this);
            }
            this.view = v;
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int axis) {
            if (this.view != null) {
                return this.view.getPreferredSpan(axis);
            }
            return 10.0f;
        }

        public float getMinimumSpan(int axis) {
            if (this.view != null) {
                return this.view.getMinimumSpan(axis);
            }
            return 10.0f;
        }

        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        public void preferenceChanged(View child, boolean width, boolean height) {
            BasicTextUI_CLONE.this.editor.revalidate();
        }

        public float getAlignment(int axis) {
            if (this.view != null) {
                return this.view.getAlignment(axis);
            }
            return 0.0f;
        }

        public void paint(Graphics g, Shape allocation) {
            if (this.view != null) {
                Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
                this.setSize(alloc.width, alloc.height);
                this.view.paint(g, allocation);
            }
        }

        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewIndex(int pos, Position.Bias b) {
            return 0;
        }

        public Shape getChildAllocation(int index, Shape a) {
            return a;
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(pos, a, b);
            }
            return null;
        }

        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(p0, b0, p1, b1, a);
            }
            return null;
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            if (this.view != null) {
                int retValue = this.view.viewToModel(x, y, a, bias);
                return retValue;
            }
            return -1;
        }

        public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
            if (this.view != null) {
                int nextPos = this.view.getNextVisualPositionFrom(pos, b, a, direction, biasRet);
                if (nextPos != -1) {
                    pos = nextPos;
                } else {
                    biasRet[0] = b;
                }
            }
            return pos;
        }

        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.insertUpdate(e, a, f);
            }
        }

        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.removeUpdate(e, a, f);
            }
        }

        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.changedUpdate(e, a, f);
            }
        }

        public Document getDocument() {
            return BasicTextUI_CLONE.this.editor.getDocument();
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return BasicTextUI_CLONE.this.editor.getDocument().getDefaultRootElement();
        }

        public View breakView(int axis, float len, Shape a) {
            throw new Error("Can't break root view");
        }

        public int getResizeWeight(int axis) {
            if (this.view != null) {
                return this.view.getResizeWeight(axis);
            }
            return 0;
        }

        public void setSize(float width, float height) {
            if (this.view != null) {
                this.view.setSize(width, height);
            }
        }

        public Container getContainer() {
            return BasicTextUI_CLONE.this.editor;
        }

        public ViewFactory getViewFactory() {
            EditorKit kit = BasicTextUI_CLONE.this.getEditorKit(BasicTextUI_CLONE.this.editor);
            ViewFactory f = kit.getViewFactory();
            if (f != null) {
                return f;
            }
            return BasicTextUI_CLONE.this;
        }
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }
}

